/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.ml.rtw.kb;

import edu.cmu.ml.rtw.kb.KbManipulation;
import edu.cmu.ml.rtw.kb.RTWListValue;
import edu.cmu.ml.rtw.kb.RTWStringValue;
import edu.cmu.ml.rtw.kb.RTWValue;
import edu.cmu.ml.rtw.util.files.FileUtility;
import java.io.File;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KbManipulationTest {
    static String kbDir = "kbtestdir";

    @Before
    public void oneTimeSetUp() {
        File f = new File(kbDir);
        if (f.exists()) {
            throw new RuntimeException("test dir for kb already exists: " + kbDir);
        }
        try {
            FileUtility.copyDirectory((File)new File("data/empty_kb"), (File)f);
        }
        catch (IOException e) {
            throw new RuntimeException("error copying empty kb dir: " + e.toString());
        }
        KbManipulation.setTheoKBdir("kbtestdir");
    }

    @After
    public void oneTimeTearDown() {
        File f = new File(kbDir);
        FileUtility.deleteDirectory((File)f);
    }

    @Test
    public void testNormalizeEntityName() {
        Assert.assertTrue((boolean)KbManipulation.normalizeEntityName("Carnegie Mellon University").equals("carnegie_mellon_university"));
        Assert.assertTrue((boolean)KbManipulation.normalizeEntityName("Carnegie Mellon , University").equals("carnegie_mellon___university"));
    }

    @Test
    public void testCreateEntity() {
        KbManipulation.createEntity("bob");
        RTWValue v = KbManipulation.getValue("generalizations", "bob");
        Assert.assertTrue((boolean)(v instanceof RTWListValue));
        RTWListValue lv = (RTWListValue)v;
        Assert.assertTrue((lv.getVal().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)lv.getVal().get(0).asString().equals("everything"));
        RTWValue everythingSpecs = KbManipulation.getValue("specializations", "everything");
        Assert.assertTrue((boolean)(everythingSpecs instanceof RTWListValue));
        RTWListValue lv2 = (RTWListValue)everythingSpecs;
        Assert.assertTrue((lv2.getVal().size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)lv2.getVal().contains(new RTWStringValue("bob")));
    }

    @Test
    public void testAddValueAndHasSlotValue() {
        KbManipulation.addValue("literalString", "bob", new RTWStringValue("BoB"), false);
        RTWValue v = KbManipulation.getValue("literalString", "bob");
        Assert.assertNotNull((Object)v);
        Assert.assertTrue((boolean)(v instanceof RTWListValue));
        RTWListValue lv = (RTWListValue)v;
        Assert.assertTrue((lv.getVal().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)lv.getVal().get(0).asString().equals("BoB"));
        Assert.assertTrue((boolean)KbManipulation.hasSlotValue("literalString", "bob", new RTWStringValue("BoB")));
        Assert.assertTrue((!KbManipulation.hasSlotValue("literalString", "bob", new RTWStringValue("bob")) ? 1 : 0) != 0);
        Assert.assertTrue((!KbManipulation.hasSlotValue("literalString", "bob", new RTWStringValue("BOB")) ? 1 : 0) != 0);
    }

    @Test(expected=RuntimeException.class)
    public void testPutValueOnMultivaluedSlot() {
        KbManipulation.putValue("literalString", "bob", new RTWStringValue("BoB"), false);
    }

    @Test(expected=RuntimeException.class)
    public void testAddValueOnSingleValuedSlot() {
        KbManipulation.addValue("whenToCache", "literalstring", new RTWStringValue("foo"), false);
    }
}

