/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.ml.rtw.kb;

import edu.cmu.ml.rtw.kb.RTWIntegerValue;
import edu.cmu.ml.rtw.kb.RTWListValue;
import edu.cmu.ml.rtw.kb.RTWRealValue;
import edu.cmu.ml.rtw.kb.RTWStringValue;
import edu.cmu.ml.rtw.kb.RTWValue;
import edu.cmu.ml.rtw.kb.XmlDocumentCacheEntry;
import edu.cmu.ml.rtw.util.Cache;
import edu.cmu.ml.rtw.util.LRUCache;
import edu.cmu.ml.rtw.util.Pair;
import edu.cmu.ml.rtw.util.XmlUtility;
import edu.cmu.ml.rtw.util.files.FileUtility;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KbManipulation {
    private static String theoKBdir = null;
    static final int maxCacheCapacity = 10000;
    private static Cache<String, XmlDocumentCacheEntry> docCache = new LRUCache<String, XmlDocumentCacheEntry>(10000);
    static final Logger log = Logger.getLogger(KbManipulation.class);

    public static String normalizeEntityName(String s) {
        char[] r;
        int rIndex = 0;
        int sIndex = 0;
        if (Character.isDigit(s.charAt(0))) {
            r = new char[s.length() + 1];
            r[0] = 110;
            ++rIndex;
        } else {
            r = new char[s.length()];
        }
        while (sIndex < s.length()) {
            r[rIndex] = !Character.isLetterOrDigit(s.charAt(sIndex)) ? 95 : (Character.isUpperCase(s.charAt(sIndex)) ? Character.toLowerCase(s.charAt(sIndex)) : s.charAt(sIndex));
            ++rIndex;
            ++sIndex;
        }
        String result = new String(r);
        if (result.length() > 58) {
            return result.substring(0, 58);
        }
        return result;
    }

    private static void subIndex(String root, BufferedWriter indexFile) throws IOException {
        RTWValue specValue = KbManipulation.getValue("specializations", root);
        if (specValue instanceof RTWListValue) {
            RTWListValue listValue = (RTWListValue)specValue;
            List<RTWValue> list = listValue.getVal();
            indexFile.write("<ul>");
            indexFile.newLine();
            for (int i = 0; i < list.size(); ++i) {
                String elementToBeAdded = list.get(i).asString();
                if (elementToBeAdded.equals("NO_THEO_VALUE")) continue;
                indexFile.write("<li><a href=\"" + KbManipulation.getFileName(elementToBeAdded) + "\">" + elementToBeAdded + "</a>");
                indexFile.newLine();
                KbManipulation.subIndex(elementToBeAdded, indexFile);
            }
            indexFile.write("</ul>");
        }
    }

    public static void createIndex(String root) throws IOException {
        String indexFileName = theoKBdir + "/index.html";
        BufferedWriter indexFile = new BufferedWriter(new FileWriter(indexFileName, false));
        if (root.equalsIgnoreCase("everything")) {
            indexFile.write("<html>");
            indexFile.newLine();
            indexFile.write("<body>");
            indexFile.newLine();
            indexFile.write("<h2>Hierarchy below " + root + "</h2>");
            indexFile.newLine();
            indexFile.write("<ul>");
            indexFile.newLine();
        }
        indexFile.write("<li><a href=\"" + KbManipulation.getFileName(root) + "\">" + root + "</a>");
        indexFile.newLine();
        KbManipulation.subIndex(root, indexFile);
        if (root.equalsIgnoreCase("everything")) {
            indexFile.write("<br>");
            indexFile.newLine();
            indexFile.write("</body>");
            indexFile.newLine();
            indexFile.write("</html>");
            indexFile.newLine();
            System.out.println("index.html created");
        }
        indexFile.close();
    }

    private static String typeOfValue(String value) {
        if (value.matches("[-]\\d+,\\d")) {
            return "in";
        }
        if (value.matches("-?\\d*\\.+\\d*E?-?\\+?\\d*")) {
            return "r";
        }
        if (value.matches("[\\p{Punct}\\w]*")) {
            return "s";
        }
        return "s";
    }

    private static String getFileName(String entity) {
        String a = entity.toLowerCase().substring(0, 1);
        String b = entity.length() > 1 ? entity.toLowerCase().substring(1, 2) : "blank";
        String c = entity.length() > 2 ? entity.toLowerCase().substring(2, 3) : "blank";
        if (entity.toLowerCase().equals("aux")) {
            entity = "___aux";
        } else if (entity.toLowerCase().equals("prn")) {
            entity = "___prn";
        } else if (entity.toLowerCase().equals("con")) {
            entity = "___con";
        } else if (entity.toLowerCase().equals("nul")) {
            entity = "___nul";
        }
        return String.format("%s/%s/%s/%s.xml", a, b, c, entity.toLowerCase());
    }

    public static void addSourceOrConfidence(String entity, String sourceOrProbabilities, String sourceOrConfValue, RTWValue slotValue, boolean addInverse) {
        String inverseSlot;
        String slot;
        RTWValue maintainInverse;
        String[] entityPath;
        String entityName;
        if (!(sourceOrProbabilities.equals("source") || sourceOrProbabilities.equals("probabilities") || sourceOrProbabilities.equals("probability"))) {
            throw new RuntimeException("invalid parameter passed to addSourceOrConfidence: " + sourceOrProbabilities);
        }
        if (sourceOrConfValue.equals(null)) {
            sourceOrConfValue = "NO_THEO_VALUE";
        }
        if (entity.charAt(0) == '(') {
            entity = entity.substring(1, entity.length() - 1);
        }
        boolean settingCandidateVal = false;
        if (entity.endsWith(" candidateValues")) {
            settingCandidateVal = true;
        }
        if (!KbManipulation.doesEntityExist(entityName = (entityPath = entity.split(" "))[0])) {
            KbManipulation.createEntity(entityName);
        }
        Document xmlDoc = KbManipulation.loadEntity(theoKBdir + "/" + KbManipulation.getFileName(entityName));
        String currentSlot = null;
        Element currentRoot = xmlDoc.getDocumentElement();
        int sub = 1;
        while (sub < entityPath.length) {
            boolean foundCurrentSlot = false;
            NodeList slots = currentRoot.getChildNodes();
            currentSlot = entityPath[sub];
            for (int slotNum = 0; slotNum < slots.getLength(); ++slotNum) {
                Element slotNode;
                Element currentNode;
                String currentNodeName;
                if (!slots.item(slotNum).getNodeName().equalsIgnoreCase("slot") || !(currentNodeName = (currentNode = XmlUtility.getChildByName("name", slotNode = (Element)slots.item(slotNum))).getFirstChild().getNodeValue()).equals(currentSlot)) continue;
                ++sub;
                currentRoot = slotNode;
                foundCurrentSlot = true;
                break;
            }
            if (foundCurrentSlot) continue;
            throw new RuntimeException("Did not find slot in addSourceOrConfidence");
        }
        String entityAux = null;
        if (entityPath.length > 1) {
            entityAux = "(" + entityPath[0];
            for (int i = 1; i < entityPath.length - 1; ++i) {
                entityAux = entityAux + " " + entityPath[i];
            }
            entityAux = entityAux + ")";
        } else {
            entityAux = entity;
        }
        int position = -1;
        String nrOfValues = KbManipulation.getValue("nrOfValues", currentSlot).asString();
        if (nrOfValues.equals("1") || nrOfValues.equals("NO_THEO_VALUE")) {
            RTWValue v = KbManipulation.getValue(currentSlot, entityAux);
            if (!v.equals(slotValue)) {
                throw new RuntimeException("tried to add source or confidence to value that wasn't there");
            }
            position = 0;
        } else {
            List<RTWValue> gens = ((RTWListValue)KbManipulation.getValue(currentSlot, entityAux)).getVal();
            position = gens.indexOf(slotValue);
            if (position == -1) {
                throw new RuntimeException("tried to add source or confidence to value that wasn't there: " + slotValue.toXml() + "\t" + currentSlot + "\t" + entityAux);
            }
        }
        boolean found = false;
        NodeList slots = currentRoot.getChildNodes();
        for (int slotNum = 0; slotNum < slots.getLength(); ++slotNum) {
            Node valueTypeNode;
            Node valueTypeNode2;
            Node listNode;
            Element slotNode;
            Element nameNode;
            String currentSlotName;
            if (!slots.item(slotNum).getNodeName().equalsIgnoreCase("slot") || !(currentSlotName = (nameNode = XmlUtility.getChildByName("name", slotNode = (Element)slots.item(slotNum))).getFirstChild().getNodeValue()).equals(sourceOrProbabilities)) continue;
            found = true;
            Element valNode = XmlUtility.getChildByName("val", slotNode);
            Element firstListNode = XmlUtility.getChildByName("l", valNode);
            int numChildren = XmlUtility.numElementChildren(firstListNode);
            if (numChildren > position) {
                if (settingCandidateVal || sourceOrProbabilities.equals("source")) {
                    listNode = XmlUtility.getNthElementChild(firstListNode, position);
                    Node typeNode = XmlUtility.getFirstElementChild(listNode);
                    Node textNode = typeNode.getFirstChild();
                    if (textNode.getNodeValue().equalsIgnoreCase("NO_THEO_VALUE") || !settingCandidateVal && nrOfValues.equals("1")) {
                        textNode.setNodeValue(sourceOrConfValue);
                        break;
                    }
                    if (!sourceOrProbabilities.equals("probabilities") && KbManipulation.hasSourceValue(currentSlotName, entity, sourceOrConfValue, position)) continue;
                    listNode.appendChild(xmlDoc.createElement(KbManipulation.typeOfValue(sourceOrConfValue)));
                    Node valueTypeNode3 = listNode.getLastChild();
                    valueTypeNode3.appendChild(xmlDoc.createTextNode(sourceOrConfValue));
                    break;
                }
                Node typeNode = XmlUtility.getFirstElementChild(firstListNode);
                Node textNode = typeNode.getFirstChild();
                if (textNode.getNodeValue().equalsIgnoreCase("NO_THEO_VALUE") || sourceOrProbabilities.equals("probability")) {
                    textNode.setNodeValue(sourceOrConfValue);
                    break;
                }
                if (!sourceOrProbabilities.equals("probability") && KbManipulation.hasSourceValue(currentSlotName, entity, sourceOrConfValue, position)) continue;
                firstListNode.appendChild(xmlDoc.createElement(KbManipulation.typeOfValue(sourceOrConfValue)));
                valueTypeNode2 = firstListNode.getLastChild();
                valueTypeNode2.appendChild(xmlDoc.createTextNode(sourceOrConfValue));
                break;
            }
            if (settingCandidateVal || sourceOrProbabilities.equals("source")) {
                for (int i = numChildren; i < position; ++i) {
                    firstListNode.appendChild(xmlDoc.createElement("l"));
                    Node listNode2 = firstListNode.getLastChild();
                    listNode2.appendChild(xmlDoc.createElement("s"));
                    valueTypeNode2 = listNode2.getLastChild();
                    valueTypeNode2.appendChild(xmlDoc.createTextNode("NO_THEO_VALUE"));
                }
                firstListNode.appendChild(xmlDoc.createElement("l"));
                listNode = firstListNode.getLastChild();
                listNode.appendChild(xmlDoc.createElement(KbManipulation.typeOfValue(sourceOrConfValue)));
                valueTypeNode = listNode.getLastChild();
                valueTypeNode.appendChild(xmlDoc.createTextNode(sourceOrConfValue));
                continue;
            }
            for (int i = numChildren; i < position; ++i) {
                firstListNode.appendChild(xmlDoc.createElement("s"));
                valueTypeNode = firstListNode.getLastChild();
                valueTypeNode.appendChild(xmlDoc.createTextNode("NO_THEO_VALUE"));
            }
            firstListNode.appendChild(xmlDoc.createElement(KbManipulation.typeOfValue(sourceOrConfValue)));
            Node valueTypeNode4 = firstListNode.getLastChild();
            valueTypeNode4.appendChild(xmlDoc.createTextNode(sourceOrConfValue));
        }
        if (!found) {
            currentRoot.appendChild(xmlDoc.createElement("slot"));
            Node newSlot = currentRoot.getLastChild();
            newSlot.appendChild(xmlDoc.createElement("name"));
            Node nameNode = newSlot.getLastChild();
            nameNode.appendChild(xmlDoc.createTextNode(sourceOrProbabilities));
            newSlot.appendChild(xmlDoc.createElement("val"));
            Node valNode = newSlot.getLastChild();
            valNode.appendChild(xmlDoc.createElement("l"));
            Node firstListNode = valNode.getFirstChild();
            if (settingCandidateVal || sourceOrProbabilities.equals("source")) {
                firstListNode.appendChild(xmlDoc.createElement("l"));
                Node listNode = firstListNode.getLastChild();
                listNode.appendChild(xmlDoc.createElement(KbManipulation.typeOfValue(sourceOrConfValue)));
                Node valueTypeNode = listNode.getLastChild();
                valueTypeNode.appendChild(xmlDoc.createTextNode(sourceOrConfValue));
            } else {
                firstListNode.appendChild(xmlDoc.createElement(KbManipulation.typeOfValue(sourceOrConfValue)));
                Node valueTypeNode = firstListNode.getLastChild();
                valueTypeNode.appendChild(xmlDoc.createTextNode(sourceOrConfValue));
            }
        }
        KbManipulation.saveEntity(theoKBdir + "/" + KbManipulation.getFileName(entityName), xmlDoc);
        if (!KbManipulation.doesEntityExist(sourceOrProbabilities)) {
            KbManipulation.createEntity(sourceOrProbabilities);
        }
        if (addInverse && entityPath.length == 2 && (maintainInverse = KbManipulation.getValue("maintainInverse", slot = entityPath[entityPath.length - 1])).asString().equals("true") && !(inverseSlot = ((RTWStringValue)KbManipulation.getValue("inverse", slot)).asString()).equals("NO_THEO_VALUE")) {
            String inverseEntity = "(" + slotValue.asString() + " " + inverseSlot + ")";
            String inverseSourceOrConfValue = sourceOrProbabilities.equals("source") ? sourceOrConfValue + "-inverse" : sourceOrConfValue;
            if (!inverseSlot.equals("NO_THEO_VALUE") && !inverseSlot.equals(slot)) {
                KbManipulation.addSourceOrConfidence(inverseEntity, sourceOrProbabilities, inverseSourceOrConfValue, new RTWStringValue(entityName), false);
            }
        }
    }

    private static Node addSlot(Document xmlDoc, String currentSlot, Node currentRoot, RTWValue valueList, boolean insideList) {
        currentRoot.appendChild(xmlDoc.createElement("slot"));
        Node newSlot = currentRoot.getLastChild();
        newSlot.appendChild(xmlDoc.createElement("name"));
        Node nameNode = newSlot.getLastChild();
        nameNode.appendChild(xmlDoc.createTextNode(currentSlot));
        newSlot.appendChild(xmlDoc.createElement("val"));
        Node valNode = newSlot.getLastChild();
        if (insideList) {
            valNode.appendChild(xmlDoc.createElement("l"));
            valNode = valNode.getFirstChild();
        }
        KbManipulation.addRTWValue(xmlDoc, valNode, valueList);
        return newSlot;
    }

    private static void addRTWValue(Document xmlDoc, Node valueNode, RTWValue val) {
        if (!(val instanceof RTWListValue)) {
            valueNode.appendChild(xmlDoc.createElement(val.getTypeString()));
            Node valueTypeNode = valueNode.getLastChild();
            valueTypeNode.appendChild(xmlDoc.createTextNode(val.asString()));
        } else {
            RTWListValue lv = (RTWListValue)val;
            valueNode.appendChild(xmlDoc.createElement("l"));
            Node listNode = valueNode.getLastChild();
            for (int i = 0; i < lv.getVal().size(); ++i) {
                RTWValue subval = lv.getVal().get(i);
                KbManipulation.addRTWValue(xmlDoc, listNode, subval);
            }
        }
    }

    public static RTWValue parseRTWValue(Node valueNode) {
        String name = valueNode.getNodeName();
        if (name.equals("s")) {
            return new RTWStringValue(valueNode.getFirstChild().getNodeValue());
        }
        if (name.equals("in")) {
            return new RTWIntegerValue(Integer.parseInt(valueNode.getFirstChild().getNodeValue()));
        }
        if (name.equals("r")) {
            return new RTWRealValue(Double.parseDouble(valueNode.getFirstChild().getNodeValue()));
        }
        RTWListValue resultList = new RTWListValue();
        for (int z = 0; z < valueNode.getChildNodes().getLength(); ++z) {
            if (valueNode.getChildNodes().item(z).getNodeType() != 1) continue;
            resultList.addValue(KbManipulation.parseRTWValue(valueNode.getChildNodes().item(z)));
        }
        return resultList;
    }

    private static Element findSubslot(String entity) {
        Document xmlDoc;
        Node currentRoot;
        String[] entityPath;
        String entityName;
        if (entity.charAt(0) == '(') {
            entity = entity.substring(1, entity.length() - 1);
        }
        if (!KbManipulation.doesEntityExist(entityName = (entityPath = entity.split(" "))[0])) {
            KbManipulation.createEntity(entityName);
        }
        if ((currentRoot = KbManipulation.findOrCreateParentSlot(entityPath, xmlDoc = KbManipulation.loadEntity(theoKBdir + "/" + KbManipulation.getFileName(entityName)), xmlDoc.getDocumentElement(), false)) != null) {
            return (Element)currentRoot;
        }
        return null;
    }

    public static List<String> getSourceOrProbabilityValues(String slot, String entity, int position) {
        ArrayList<String> valuesList;
        block9: {
            NodeList sources;
            Element list;
            int i;
            block8: {
                if (position < 0) {
                    throw new RuntimeException("Error: position must be 0 or greater: " + position);
                }
                valuesList = new ArrayList<String>();
                if (entity.charAt(0) == '(') {
                    entity = entity.substring(1, entity.length() - 1);
                }
                String[] entityPath = entity.split(" ");
                String entityName = entityPath[0];
                String filename = theoKBdir + "/" + KbManipulation.getFileName(entityName);
                if (!KbManipulation.doesEntityExist(entityName)) {
                    KbManipulation.createEntity(entityName);
                }
                Document xmlDoc = KbManipulation.loadEntity(filename);
                Element currentNode = xmlDoc.getDocumentElement();
                String[] entityListPath = new String[entityPath.length + 1];
                for (int j = 0; j < entityPath.length; ++j) {
                    entityListPath[j] = entityPath[j];
                }
                entityListPath[entityPath.length] = slot;
                for (int path = 1; path < entityListPath.length; ++path) {
                    boolean found = false;
                    NodeList slots = currentNode.getElementsByTagName("slot");
                    for (i = 0; i < slots.getLength(); ++i) {
                        Element subSlots = (Element)slots.item(i);
                        NodeList names = subSlots.getElementsByTagName("name");
                        Node name = names.item(0);
                        if (!name.getTextContent().equals(entityListPath[path])) continue;
                        currentNode = subSlots;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    valuesList.add("NO_THEO_VALUE");
                    return valuesList;
                }
                NodeList valLists = currentNode.getElementsByTagName("l");
                list = (Element)valLists.item(position + 1);
                if (!slot.equals("source")) break block8;
                sources = list.getElementsByTagName("s");
                for (i = 0; i < sources.getLength(); ++i) {
                    valuesList.add(sources.item(i).getTextContent());
                }
                break block9;
            }
            if (!slot.equals("probabilities")) break block9;
            sources = list.getElementsByTagName("r");
            for (i = 0; i < sources.getLength(); ++i) {
                valuesList.add(sources.item(i).getTextContent());
            }
        }
        return valuesList;
    }

    public static RTWValue getValue(String slot, String entity) {
        Element root;
        String[] entityPath;
        String entityName;
        if (entity.charAt(0) == '(') {
            entity = entity.substring(1, entity.length() - 1);
        }
        if (!KbManipulation.doesEntityExist(entityName = (entityPath = entity.split(" "))[0])) {
            KbManipulation.createEntity(entityName);
        }
        if ((root = KbManipulation.findSubslot(entity)) == null) {
            return new RTWStringValue("NO_THEO_VALUE");
        }
        NodeList slots = root.getChildNodes();
        for (int slotNum = 0; slotNum < slots.getLength(); ++slotNum) {
            Element slotNode;
            Element nameNode;
            String s;
            if (!slots.item(slotNum).getNodeName().equalsIgnoreCase("slot") || !(s = (nameNode = XmlUtility.getChildByName("name", slotNode = (Element)slots.item(slotNum))).getFirstChild().getNodeValue()).equals(slot)) continue;
            Element valNode = XmlUtility.getChildByName("val", slotNode);
            if (!valNode.hasChildNodes()) break;
            Node valFirstChild = XmlUtility.getFirstElementChild(valNode);
            return KbManipulation.parseRTWValue(valFirstChild);
        }
        return new RTWStringValue("NO_THEO_VALUE");
    }

    public static List<String> getSlots(String entity) {
        Element root;
        String[] entityPath;
        String entityName;
        ArrayList<String> slotList = new ArrayList<String>();
        if (entity.charAt(0) == '(') {
            entity = entity.substring(1, entity.length() - 1);
        }
        if (!KbManipulation.doesEntityExist(entityName = (entityPath = entity.split(" "))[0])) {
            KbManipulation.createEntity(entityName);
        }
        if ((root = KbManipulation.findSubslot(entity)) == null) {
            return slotList;
        }
        NodeList slots = root.getChildNodes();
        for (int slotNum = 0; slotNum < slots.getLength(); ++slotNum) {
            if (!slots.item(slotNum).getNodeName().equalsIgnoreCase("slot")) continue;
            Element slotNode = (Element)slots.item(slotNum);
            Element nameNode = XmlUtility.getChildByName("name", slotNode);
            String s = nameNode.getFirstChild().getNodeValue();
            slotList.add(s);
        }
        return slotList;
    }

    public static List<String> getSourceValue(String entity, int position) {
        Element root;
        String[] entityPath;
        String entityName;
        if (position < 0) {
            throw new RuntimeException("Error: position must be 0 or greater: " + position);
        }
        ArrayList<String> valuesList = new ArrayList<String>();
        String slot = "source";
        if (entity.charAt(0) == '(') {
            entity = entity.substring(1, entity.length() - 1);
        }
        if (!KbManipulation.doesEntityExist(entityName = (entityPath = entity.split(" "))[0])) {
            KbManipulation.createEntity(entityName);
        }
        if ((root = KbManipulation.findSubslot(entity)) == null) {
            valuesList.add("NO_THEO_VALUE");
            return valuesList;
        }
        NodeList slots = root.getChildNodes();
        boolean found = false;
        for (int slotNum = 0; slotNum < slots.getLength(); ++slotNum) {
            Element valNode;
            Node listNode;
            Element slotNode;
            Element nameNode;
            String s;
            if (!slots.item(slotNum).getNodeName().equalsIgnoreCase("slot") || !(s = (nameNode = XmlUtility.getChildByName("name", slotNode = (Element)slots.item(slotNum))).getFirstChild().getNodeValue()).equals(slot) || !(listNode = XmlUtility.getFirstElementChild(valNode = XmlUtility.getChildByName("val", slotNode))).getNodeName().matches("l")) continue;
            int numChildren = XmlUtility.numElementChildren(listNode);
            if (position >= numChildren) break;
            found = true;
            listNode = XmlUtility.getNthElementChild(listNode, position);
            for (int i = 0; i < listNode.getChildNodes().getLength(); ++i) {
                if (listNode.getChildNodes().item(i).getNodeType() != 1) continue;
                Node typeNode = listNode.getChildNodes().item(i);
                valuesList.add(typeNode.getFirstChild().getNodeValue());
            }
            break;
        }
        if (found) {
            return valuesList;
        }
        valuesList.clear();
        valuesList.add("NO_THEO_VALUE");
        return valuesList;
    }

    public static void removeSlotValue(String entity, String slot, RTWValue value) {
        Element root;
        String[] entityPath;
        String entityName;
        if (entity.charAt(0) == '(') {
            entity = entity.substring(1, entity.length() - 1);
        }
        if (!KbManipulation.doesEntityExist(entityName = (entityPath = entity.split(" "))[0])) {
            KbManipulation.createEntity(entityName);
        }
        if ((root = KbManipulation.findSubslot(entity)) == null) {
            throw new RuntimeException("Could not find sub slot:" + entity);
        }
        Document xmlDoc = root.getOwnerDocument();
        NodeList slots = root.getChildNodes();
        String nrOfValues = KbManipulation.getValue("nrOfValues", slot).asString();
        for (int slotNum = 0; slotNum < slots.getLength(); ++slotNum) {
            Element valNode;
            Element slotNode;
            Element nameNode;
            String slotName;
            if (!slots.item(slotNum).getNodeName().equals("slot") || !(slotName = (nameNode = XmlUtility.getChildByName("name", slotNode = (Element)slots.item(slotNum))).getFirstChild().getNodeValue()).equals(slot) || !(valNode = XmlUtility.getChildByName("val", slotNode)).hasChildNodes()) continue;
            Node firstChildNode = valNode;
            if (!nrOfValues.equals("1")) {
                firstChildNode = XmlUtility.getFirstElementChild(firstChildNode);
            }
            for (int z = 0; z < firstChildNode.getChildNodes().getLength(); ++z) {
                RTWValue v;
                Node typeNode;
                if (firstChildNode.getChildNodes().item(z).getNodeType() != 1 || !firstChildNode.getChildNodes().item(z).getNodeName().matches("s|in|r|l") || (typeNode = firstChildNode.getChildNodes().item(z)).getChildNodes().getLength() <= 0 || !(v = KbManipulation.parseRTWValue(typeNode)).equals(value)) continue;
                firstChildNode.removeChild(typeNode);
                if (firstChildNode.getChildNodes().getLength() < 1) {
                    firstChildNode.appendChild(xmlDoc.createElement("s"));
                    typeNode = firstChildNode.getFirstChild();
                    firstChildNode.appendChild(xmlDoc.createTextNode("\n"));
                    typeNode.appendChild(xmlDoc.createTextNode("NO_THEO_VALUE"));
                }
                KbManipulation.saveEntity(theoKBdir + "/" + KbManipulation.getFileName(entity), xmlDoc);
                return;
            }
            System.out.println("The value " + value.toXml() + " does not exist in the slot " + slot + " of entity " + entity + "!  Thus, will not be removed");
            break;
        }
    }

    public static boolean doesEntityExist(String entity) {
        String filename = theoKBdir + "/" + KbManipulation.getFileName(entity);
        if (docCache.get(filename) != null) {
            return true;
        }
        File docFile = new File(theoKBdir + "/" + KbManipulation.getFileName(entity));
        return docFile.exists();
    }

    public static void removeSourceOrConfValue(String entity, RTWValue value, String sourceOrProbability) {
        Element root;
        String[] entityPath;
        String entityName;
        String slot = sourceOrProbability;
        if (entity.charAt(0) == '(') {
            entity = entity.substring(1, entity.length() - 1);
        }
        if (!KbManipulation.doesEntityExist(entityName = (entityPath = entity.split(" "))[0])) {
            KbManipulation.createEntity(entityName);
        }
        if ((root = KbManipulation.findSubslot(entityName)) == null) {
            throw new RuntimeException("Could not find sub slot:" + entityName);
        }
        Document xmlDoc = root.getOwnerDocument();
        NodeList slots = root.getChildNodes();
        RTWListValue gens = (RTWListValue)KbManipulation.getValue("generalizations", entityName);
        int position = gens.getVal().indexOf(value);
        if (position != -1) {
            for (int slotNum = 0; slotNum < slots.getLength(); ++slotNum) {
                Node listNode;
                int numChildren;
                Element slotNode;
                Element currentNode;
                String s;
                if (!slots.item(slotNum).getNodeName().equalsIgnoreCase("slot") || !(s = (currentNode = XmlUtility.getChildByName("name", slotNode = (Element)slots.item(slotNum))).getFirstChild().getNodeValue()).equals(slot)) continue;
                Element valNode = XmlUtility.getChildByName("val", slotNode);
                Node typeNode = XmlUtility.getFirstElementChild(valNode);
                if (typeNode.getNodeName().matches("s|in|r")) {
                    if (!typeNode.hasChildNodes()) continue;
                    Node valueNode = typeNode.getFirstChild();
                    if (valueNode.getNodeValue().equalsIgnoreCase(value.asString())) {
                        valNode.removeChild(typeNode.getNextSibling());
                        valNode.removeChild(typeNode);
                        if (valNode.getChildNodes().getLength() >= 1) break;
                        valNode.appendChild(xmlDoc.createElement("s"));
                        typeNode = valNode.getFirstChild();
                        valNode.appendChild(xmlDoc.createTextNode("\n"));
                        typeNode.appendChild(xmlDoc.createTextNode("NO_THEO_VALUE"));
                        break;
                    }
                    System.out.println("The value " + value + " does not exist in the slot " + slot + " of entity " + entity + "! Thus, will not be removed");
                    continue;
                }
                if (typeNode.getNodeName().matches("l") && (numChildren = XmlUtility.numElementChildren(listNode = typeNode)) >= position) {
                    listNode.removeChild(XmlUtility.getNthElementChild(listNode, position).getNextSibling());
                    listNode.removeChild(XmlUtility.getNthElementChild(listNode, position));
                    break;
                }
                System.out.println("The value " + value + " does not exist in the slot " + slot + " of entity " + entity + "!  Thus, will not be removed");
                break;
            }
        }
        KbManipulation.saveEntity(theoKBdir + "/" + KbManipulation.getFileName(entityName), xmlDoc);
    }

    public static void saveEntity(String filename, Document xmlDoc) {
        try {
            if (xmlDoc == null) {
                System.out.println("Entity does not exist and will not be saved");
            } else {
                Pair<String, XmlDocumentCacheEntry> removed = docCache.put(filename, new XmlDocumentCacheEntry(xmlDoc, System.currentTimeMillis()), true);
                if (removed != null) {
                    String path = removed.getLeft().substring(0, removed.getLeft().lastIndexOf("/"));
                    File dir = new File(path);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    DOMSource source = new DOMSource(removed.getRight().getDoc());
                    StreamResult result = new StreamResult(new FileOutputStream(removed.getLeft()));
                    TransformerFactory transFactory = TransformerFactory.newInstance();
                    Transformer transformer = transFactory.newTransformer();
                    transformer.transform(source, result);
                    result.getOutputStream().close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void saveAllDirtyEntitiesInCache() {
        try {
            for (Pair<String, XmlDocumentCacheEntry> p : docCache.getAllDirty()) {
                String path = p.getLeft().substring(0, p.getLeft().lastIndexOf("/"));
                File dir = new File(path);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                DOMSource source = new DOMSource(p.getRight().getDoc());
                StreamResult result = new StreamResult(new FileOutputStream(p.getLeft()));
                TransformerFactory transFactory = TransformerFactory.newInstance();
                Transformer transformer = transFactory.newTransformer();
                transformer.transform(source, result);
                result.getOutputStream().close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static Document createEntity(String entity) {
        if (entity.equals("NO_THEO_VALUE")) {
            return null;
        }
        if (KbManipulation.doesEntityExist(entity)) {
            System.out.println("The file " + theoKBdir + "/" + KbManipulation.getFileName(entity) + " defining the " + entity + " entity already exists and will not be created");
            return null;
        }
        String filename = theoKBdir + "/" + KbManipulation.getFileName(entity);
        String path = filename.substring(0, filename.lastIndexOf("/"));
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document newXmlDoc = builder.newDocument();
            newXmlDoc.appendChild(newXmlDoc.createElement("entity"));
            Element root = newXmlDoc.getDocumentElement();
            ProcessingInstruction xmlstylesheet = newXmlDoc.createProcessingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"../../../displayWithSubslots.xsl\"");
            newXmlDoc.insertBefore(xmlstylesheet, root);
            root.appendChild(newXmlDoc.createTextNode("\n"));
            root.appendChild(newXmlDoc.createElement("entityName"));
            root.getLastChild().appendChild(newXmlDoc.createTextNode(entity));
            root.appendChild(newXmlDoc.createElement("slot"));
            Node newSlot = root.getLastChild();
            newSlot.appendChild(newXmlDoc.createElement("name"));
            Node nameNode = newSlot.getLastChild();
            nameNode.appendChild(newXmlDoc.createTextNode("generalizations"));
            newSlot.appendChild(newXmlDoc.createElement("val"));
            Node valNode = newSlot.getLastChild();
            valNode.appendChild(newXmlDoc.createElement("l"));
            Node listNode = valNode.getLastChild();
            listNode.appendChild(newXmlDoc.createElement("s"));
            Node typeNode = listNode.getLastChild();
            String generalizationName = entity.equalsIgnoreCase("everything") ? "NO_THEO_VALUE" : "everything";
            typeNode.appendChild(newXmlDoc.createTextNode(generalizationName));
            KbManipulation.saveEntity(filename, newXmlDoc);
            if (generalizationName.equalsIgnoreCase("everything")) {
                KbManipulation.addValue("specializations", generalizationName, new RTWStringValue(entity), false);
            }
            return newXmlDoc;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isAncestor(String ancestor, String entity) {
        if (!ancestor.equalsIgnoreCase("everything") && !entity.equalsIgnoreCase("everything")) {
            RTWListValue generalizationList = (RTWListValue)KbManipulation.getValue("generalizations", entity);
            for (RTWValue v : generalizationList.getVal()) {
                if (!v.asString().equalsIgnoreCase(ancestor)) continue;
                return true;
            }
            for (int i = 0; i < generalizationList.getVal().size(); ++i) {
                if (!KbManipulation.isAncestor(ancestor, ((RTWStringValue)generalizationList.getVal().get(i)).getVal())) continue;
                return true;
            }
        }
        return false;
    }

    public static void eliminateAncestorsGeneralizations(String entity) {
        RTWListValue generalizationList = (RTWListValue)KbManipulation.getValue("generalizations", entity);
        if (generalizationList.getVal().size() > 1) {
            for (int i = 0; i < generalizationList.getVal().size(); ++i) {
                for (int j = 0; j < generalizationList.getVal().size(); ++j) {
                    if (generalizationList.getVal().get(i).equals(generalizationList.getVal().get(j)) || !KbManipulation.isAncestor(generalizationList.getVal().get(i).asString(), generalizationList.getVal().get(j).asString()) || KbManipulation.hasSourceValue("source", entity, "NELLDefinition", i)) continue;
                    KbManipulation.removeSourceOrConfValue(entity, generalizationList.getVal().get(i), "source");
                    KbManipulation.removeSourceOrConfValue(entity, generalizationList.getVal().get(i), "probability");
                    KbManipulation.removeSlotValue(entity, "generalizations", generalizationList.getVal().get(i));
                    KbManipulation.removeSlotValue(((RTWStringValue)generalizationList.getVal().get(i)).getVal(), "specializations", new RTWStringValue(entity));
                }
            }
        }
    }

    public static boolean hasSlotValue(String slot, String entity, RTWValue value) {
        RTWValue v = KbManipulation.getValue(slot, entity);
        if (v instanceof RTWListValue) {
            RTWListValue lv = (RTWListValue)v;
            for (int i = 0; i < lv.getVal().size(); ++i) {
                if (!value.equals(lv.getVal().get(i))) continue;
                return true;
            }
            return false;
        }
        return v.equals(value);
    }

    public static boolean hasSourceValue(String slot, String entity, String value, int position) {
        if (position < 0) {
            throw new RuntimeException("Error: position must be 0 or greater: " + position);
        }
        List<String> list = KbManipulation.getSourceValue(entity, position);
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null || !list.get(i).equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public static void addValue(String slot, String entity, RTWValue valueList, boolean addInverse) {
        String nrOfValues;
        String entityAux = entity;
        if (entity.charAt(0) == '(') {
            entity = entity.substring(1, entity.length() - 1);
        }
        if ((nrOfValues = KbManipulation.getValue("nrOfValues", slot).asString()).equals("1") || nrOfValues.equals("NO_THEO_VALUE")) {
            throw new RuntimeException("Cannot call addValue on slot: " + slot);
        }
        String[] entityPath = entity.split(" ");
        String entityName = entityPath[0];
        if (entityName.equalsIgnoreCase("NO_THEO_VALUE")) {
            return;
        }
        if (!(valueList instanceof RTWListValue) && valueList.asString().equals("NO_THEO_VALUE")) {
            return;
        }
        if (KbManipulation.hasSlotValue(slot, entity, valueList)) {
            return;
        }
        if (valueList == null) {
            throw new RuntimeException("null valuelist");
        }
        if ((slot.equalsIgnoreCase("specializations") || slot.equalsIgnoreCase("generalizations")) && entityName.equalsIgnoreCase(valueList.asString())) {
            return;
        }
        if (!KbManipulation.doesEntityExist(entityName)) {
            KbManipulation.createEntity(entityName);
        }
        String filename = theoKBdir + "/" + KbManipulation.getFileName(entityName);
        Document xmlDoc = KbManipulation.loadEntity(filename);
        Node currentRoot = KbManipulation.findOrCreateParentSlot(entityPath, xmlDoc, xmlDoc.getDocumentElement(), true);
        NodeList slots = currentRoot.getChildNodes();
        boolean found = false;
        for (int i = 0; i < slots.getLength(); ++i) {
            Node typeNode;
            Element slotNode;
            Element nameNode;
            String s;
            if (!slots.item(i).getNodeName().equals("slot") || !(s = (nameNode = XmlUtility.getChildByName("name", slotNode = (Element)slots.item(i))).getFirstChild().getNodeValue()).equals(slot)) continue;
            found = true;
            Element valNode = XmlUtility.getChildByName("val", slotNode);
            if (!valNode.hasChildNodes()) continue;
            Node listNode = XmlUtility.getFirstElementChild(valNode);
            if (!listNode.getNodeName().equals("l")) {
                valNode.removeChild(listNode);
                valNode.appendChild(xmlDoc.createElement("l"));
                listNode = valNode.getFirstChild();
            }
            if ((typeNode = XmlUtility.getFirstElementChild(listNode)) != null && typeNode.getFirstChild().getNodeValue() != null && typeNode.getFirstChild().getNodeValue().equalsIgnoreCase("NO_THEO_VALUE") && !KbManipulation.hasSourceValue("source", "(" + entityAux + " " + slot + ")", "NELLDefinition", 0)) {
                listNode.removeChild(typeNode);
            }
            KbManipulation.addRTWValue(xmlDoc, listNode, valueList);
        }
        if (!found) {
            KbManipulation.addSlot(xmlDoc, slot, currentRoot, valueList, true);
        }
        KbManipulation.saveEntity(filename, xmlDoc);
        if (slot.equalsIgnoreCase("generalizations")) {
            KbManipulation.addValue("specializations", valueList.asString(), new RTWStringValue(entityName), false);
            if (!entityName.equalsIgnoreCase("everything")) {
                KbManipulation.removeSlotValue(entityName, slot, new RTWStringValue("everything"));
            }
            if (!KbManipulation.hasSourceValue("source", "(" + entityName + " " + slot + ")", "NELLDefinition", 0)) {
                KbManipulation.eliminateAncestorsGeneralizations(entityName);
                KbManipulation.removeSlotValue("everything", "specializations", new RTWStringValue(entityName));
            }
        }
        if (!KbManipulation.doesEntityExist(slot)) {
            KbManipulation.createEntity(slot);
        }
        if (addInverse) {
            if (slot.equals("candidateValues")) {
                String inverseSlot;
                String s = entityPath[entityPath.length - 1];
                RTWValue maintainInverse = KbManipulation.getValue("maintainInverse", s);
                if (maintainInverse.asString().equals("true") && !(inverseSlot = KbManipulation.getValue("inverse", s).asString()).equals("NO_THEO_VALUE") && !inverseSlot.equals(s)) {
                    String invEnt = valueList.asString() + " " + inverseSlot;
                    KbManipulation.addValue(slot, invEnt, new RTWStringValue(entityPath[0]), false);
                }
            } else {
                String inverseSlot;
                RTWValue maintainInverse = KbManipulation.getValue("maintainInverse", slot);
                if (maintainInverse.asString().equals("true") && !(inverseSlot = KbManipulation.getValue("inverse", slot).asString()).equals("NO_THEO_VALUE") && !inverseSlot.equals(slot)) {
                    String inverseNrOfValues = KbManipulation.getValue("nrOfValues", inverseSlot).asString();
                    if (inverseNrOfValues.equals("1")) {
                        KbManipulation.putValue(inverseSlot, valueList.asString(), new RTWStringValue(entity), false);
                    } else {
                        KbManipulation.addValue(inverseSlot, valueList.asString(), new RTWStringValue(entity), false);
                    }
                }
            }
        }
    }

    public static void putValue(String slot, String entity, RTWValue valueList, boolean putInverse) {
        String inverseSlot;
        RTWValue maintainInverse;
        String nrOfValues;
        if ((slot.equalsIgnoreCase("specializations") || slot.equalsIgnoreCase("generalizations")) && entity.equalsIgnoreCase(valueList.asString())) {
            return;
        }
        if (valueList == null) {
            valueList = new RTWStringValue("NO_THEO_VALUE");
        }
        if (entity.charAt(0) == '(') {
            entity = entity.substring(1, entity.length() - 1);
        }
        if (!(nrOfValues = KbManipulation.getValue("nrOfValues", slot).asString()).equals("1")) {
            throw new RuntimeException("Cannot call putValue on slot: " + slot);
        }
        String[] entityPath = entity.split(" ");
        String entityName = entityPath[0];
        if (!KbManipulation.doesEntityExist(entityName)) {
            KbManipulation.createEntity(entityName);
        }
        Document xmlDoc = KbManipulation.loadEntity(theoKBdir + "/" + KbManipulation.getFileName(entityName));
        Node currentRoot = KbManipulation.findOrCreateParentSlot(entityPath, xmlDoc, xmlDoc.getDocumentElement(), true);
        NodeList slots = currentRoot.getChildNodes();
        boolean found = false;
        for (int slotNum = 0; slotNum < slots.getLength(); ++slotNum) {
            Element slotNode;
            Element nameNode;
            if (!slots.item(slotNum).getNodeName().equalsIgnoreCase("slot") || !(nameNode = XmlUtility.getChildByName("name", slotNode = (Element)slots.item(slotNum))).getFirstChild().getNodeValue().equalsIgnoreCase(slot)) continue;
            found = true;
            Element valueNode = XmlUtility.getChildByName("val", slotNode);
            Node nodeAfter = valueNode.getNextSibling();
            slotNode.removeChild(valueNode);
            slotNode.insertBefore(xmlDoc.createElement("val"), nodeAfter);
            Element valNode = XmlUtility.getChildByName("val", slotNode);
            KbManipulation.addRTWValue(xmlDoc, valNode, valueList);
        }
        if (!found) {
            KbManipulation.addSlot(xmlDoc, slot, currentRoot, valueList, false);
        }
        KbManipulation.saveEntity(theoKBdir + "/" + KbManipulation.getFileName(entityName), xmlDoc);
        if (!KbManipulation.doesEntityExist(slot)) {
            KbManipulation.createEntity(slot);
        }
        if (putInverse && (maintainInverse = KbManipulation.getValue("maintainInverse", slot)).asString().equals("true") && !(inverseSlot = KbManipulation.getValue("inverse", slot).asString()).equals("NO_THEO_VALUE") && !inverseSlot.equals(slot)) {
            String inverseNrOfValues = KbManipulation.getValue("nrOfValues", inverseSlot).asString();
            if (inverseNrOfValues.equals("1")) {
                KbManipulation.putValue(inverseSlot, valueList.asString(), new RTWStringValue(entity), false);
            } else {
                KbManipulation.addValue(inverseSlot, valueList.asString(), new RTWStringValue(entity), false);
            }
        }
    }

    private static Node findOrCreateParentSlot(String[] entityPath, Document xmlDoc, Node currentRoot, boolean createIfNotFound) {
        int sub = 1;
        boolean foundParentSlots = false;
        while (sub < entityPath.length) {
            foundParentSlots = false;
            NodeList slots = currentRoot.getChildNodes();
            String currentSlot = entityPath[sub].toString();
            for (int slotNum = 0; slotNum < slots.getLength(); ++slotNum) {
                Element slotNode;
                Element nameNode;
                if (!slots.item(slotNum).getNodeName().equalsIgnoreCase("slot") || !(nameNode = XmlUtility.getChildByName("name", slotNode = (Element)slots.item(slotNum))).getFirstChild().getNodeValue().equalsIgnoreCase(currentSlot)) continue;
                ++sub;
                currentRoot = slotNode;
                foundParentSlots = true;
                break;
            }
            if (foundParentSlots) continue;
            if (createIfNotFound) {
                currentRoot = KbManipulation.addSlot(xmlDoc, currentSlot, currentRoot, new RTWStringValue("NO_THEO_VALUE"), false);
                ++sub;
                continue;
            }
            return null;
        }
        return currentRoot;
    }

    public static Document loadEntity(String filename) {
        Document doc = null;
        File docFile = new File(filename);
        XmlDocumentCacheEntry dce = docCache.get(filename);
        if (dce != null) {
            return dce.getDoc();
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(docFile);
            Pair<String, XmlDocumentCacheEntry> removed = docCache.put(filename, new XmlDocumentCacheEntry(doc, System.currentTimeMillis()), false);
            if (removed != null) {
                String path = removed.getLeft().substring(0, removed.getLeft().lastIndexOf("/"));
                File dir = new File(path);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                DOMSource source = new DOMSource(removed.getRight().getDoc());
                StreamResult result = new StreamResult(new FileOutputStream(removed.getLeft()));
                TransformerFactory transFactory = TransformerFactory.newInstance();
                Transformer transformer = transFactory.newTransformer();
                transformer.transform(source, result);
                result.getOutputStream().close();
            }
        }
        catch (IOException e) {
            log.error((Object)e);
            log.error((Object)("Can't find the file to load the Entity: " + filename));
            System.exit(-1);
        }
        catch (Exception e) {
            log.error((Object)e);
            log.error((Object)("Problem parsing the entity xml file: " + filename));
            System.exit(-1);
        }
        return doc;
    }

    public static void main(String[] args) throws IOException {
        FileUtility.deleteDirectory((File)new File("c:/tmp"));
        try {
            FileUtility.copyDirectory((File)new File("c:/dev/OntologyLearner/data/initial_kb"), (File)new File("c:/tmp"));
        }
        catch (IOException e) {
            // empty catch block
        }
        KbManipulation.setTheoKBdir("c:/tmp");
        System.out.println(KbManipulation.getValue("nrOfValues", "acquiredBy").toXml());
        RTWValue categories = KbManipulation.getValue("specializations", "rtwCategory");
        KbManipulation.removeSlotValue("rtwCategory", "specializations", new RTWStringValue("sport"));
    }

    public static String getTheoKBdir() {
        return theoKBdir;
    }

    public static void setTheoKBdir(String theoKBdir) {
        if (!theoKBdir.equals(KbManipulation.theoKBdir)) {
            KbManipulation.theoKBdir = theoKBdir;
            docCache = new LRUCache<String, XmlDocumentCacheEntry>(10000);
        }
    }
}

