/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.ml.rtw.kb;

import edu.cmu.ml.rtw.kb.KbManipulation;
import edu.cmu.ml.rtw.kb.RTWListValue;
import edu.cmu.ml.rtw.kb.RTWPutValueCommand;
import edu.cmu.ml.rtw.kb.RTWStringValue;
import edu.cmu.ml.rtw.kb.RTWValue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class KBfromTextFile {
    private static Logger log = Logger.getLogger(KBfromTextFile.class);

    public static Document loadTheoCommands(String filename) {
        Document doc = null;
        File docFile = new File(filename);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(docFile);
        }
        catch (IOException e) {
            System.out.println("Can't find the file to load: " + filename);
            System.out.println(e);
        }
        catch (Exception e) {
            System.out.print("Problem parsing the entity xml file.");
            System.out.println(e);
        }
        return doc;
    }

    public static void kbFromRTWPutValueTheoCommands(String theocmdsPath) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(theocmdsPath));
            int count = 0;
            while ((line = br.readLine()) != null) {
                RTWValue value;
                String normalizedValue;
                if (!line.startsWith("<command>")) continue;
                if (count % 1000 == 0) {
                    System.gc();
                    long totalMemory = Runtime.getRuntime().totalMemory() / 1048756L;
                    long usedMemory = totalMemory - Runtime.getRuntime().freeMemory() / 1048756L;
                    log.info((Object)("file: " + theocmdsPath + "\tline: " + count + " (JVM Total:" + totalMemory + "MB, Used:" + usedMemory + "MB)"));
                }
                ++count;
                RTWPutValueCommand command = new RTWPutValueCommand(line);
                String literalString = command.getEntity().get(0);
                String entityName = KbManipulation.normalizeEntityName(command.getEntity().get(0));
                for (int i = 1; i < command.getEntity().size(); ++i) {
                    entityName = entityName + " " + command.getEntity().get(i);
                }
                if (command.getEntity().size() > 1) {
                    entityName = "(" + entityName + ")";
                }
                String sourceString = command.getSourceName() + "-Iter:" + command.getIteration() + "-" + command.getSourceDate() + "-" + command.getComment();
                String normalizedEntityName = KbManipulation.normalizeEntityName(literalString);
                if (command.getSlot().equals("candidateValues") && entityName.endsWith(" generalizations)")) {
                    String cand = "(" + normalizedEntityName + " generalizations)";
                    KBfromTextFile.createEntityCandVal(cand, literalString, command.getValue(), String.valueOf(command.getProbability()), sourceString);
                    normalizedValue = KbManipulation.normalizeEntityName(command.getValue().asString());
                    String specEntity = "(" + normalizedValue + " specializations)";
                    KbManipulation.addValue("candidateValues", specEntity, new RTWStringValue(normalizedEntityName), false);
                    continue;
                }
                if (!command.getSlot().equals("extractionPatterns") && !command.getSlot().equals("learnedPrologRules")) {
                    if (KbManipulation.getValue("NELLStatic", normalizedEntityName).asString().equals("true")) continue;
                    normalizedValue = KbManipulation.normalizeEntityName(command.getValue().asString());
                    value = new RTWStringValue(normalizedValue);
                    if (!KbManipulation.hasSlotValue("literalString", normalizedEntityName, new RTWStringValue(literalString))) {
                        KbManipulation.addValue("literalString", normalizedEntityName, new RTWStringValue(literalString), false);
                    }
                    if (!KbManipulation.hasSlotValue("literalString", normalizedValue, command.getValue())) {
                        KbManipulation.addValue("literalString", normalizedValue, command.getValue(), false);
                    }
                } else {
                    value = command.getValue();
                }
                String nrOfValues = KbManipulation.getValue("nrOfValues", command.getSlot()).asString();
                if (nrOfValues.equals("1")) {
                    KbManipulation.putValue(command.getSlot(), entityName, value, true);
                } else {
                    KbManipulation.addValue(command.getSlot(), entityName, value, true);
                }
                if (!KbManipulation.hasSlotValue(command.getSlot(), entityName, value)) continue;
                String ent = entityName.startsWith("(") ? entityName.replace(")", "") + " " + command.getSlot() + ")" : "(" + entityName + " " + command.getSlot() + ")";
                KbManipulation.addSourceOrConfidence(ent, "source", sourceString, value, true);
                if (command.getSlot().equals("candidateValues")) {
                    KbManipulation.addSourceOrConfidence(ent, "probabilities", String.valueOf(command.getProbability()), value, true);
                    continue;
                }
                KbManipulation.addSourceOrConfidence(ent, "probability", String.valueOf(command.getProbability()), value, true);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    private static void createEntityCandVal(String candidate, String literalString, RTWValue generalizationValue, String confidence, String sourceValue) {
        KbManipulation.addValue("candidateValues", candidate, generalizationValue, false);
        KbManipulation.addValue("literalString", KbManipulation.normalizeEntityName(literalString), new RTWStringValue(literalString), false);
        RTWListValue gens = (RTWListValue)KbManipulation.getValue("candidateValues", candidate);
        int position = gens.getVal().indexOf(generalizationValue);
        if (position > -1 && !KbManipulation.hasSourceValue("source", candidate.replace(')', ' ') + "candidateValues)", sourceValue, position)) {
            KbManipulation.addSourceOrConfidence(candidate.replace(')', ' ') + "candidateValues)", "source", sourceValue, generalizationValue, false);
            KbManipulation.addSourceOrConfidence(candidate.replace(')', ' ') + "candidateValues)", "probabilities", confidence, generalizationValue, false);
        }
    }
}

