/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.ml.rtw.course;

import edu.cmu.ml.rtw.kb.KbManipulation;
import edu.cmu.ml.rtw.kb.RTWIntegerValue;
import edu.cmu.ml.rtw.kb.RTWListValue;
import edu.cmu.ml.rtw.kb.RTWRealValue;
import edu.cmu.ml.rtw.kb.RTWStringValue;
import edu.cmu.ml.rtw.kb.RTWValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TheoKB {
    static boolean initialized = false;

    private static RTWValue justGetValueKB(String slot, String entity) {
        List<RTWValue> valAsList;
        if (!TheoKB.isEntityKB(entity)) {
            return new RTWStringValue("NO_THEO_VALUE");
        }
        RTWValue val = KbManipulation.getValue(slot, entity);
        if (val.getTypeString().equals("l") && (valAsList = ((RTWListValue)val).getVal()).size() == 1 && valAsList.get(0).getTypeString().equals("s") && valAsList.get(0).asString().equals("NO_THEO_VALUE")) {
            throw new RuntimeException("Internal Error: Something returned NO_THE_VALUE as a list");
        }
        return val;
    }

    public static void initializeTheo() {
        if (initialized) {
            throw new RuntimeException("initializeTheo has already been called");
        }
        initialized = true;
    }

    public static void useKB(String kbDirectory) {
        if (kbDirectory.contains("http://")) {
            throw new RuntimeException("The Java code does not currently support accessing KBs over HTTP");
        }
        KbManipulation.setTheoKBdir(kbDirectory);
        RTWValue val = TheoKB.getValueKB("NELLStatic", "everything");
        if (val.getTypeString() != "l" || !((RTWListValue)val).getVal().get(0).asString().equals("true")) {
            throw new RuntimeException("'" + kbDirectory + "' does not appear to be a valid KB");
        }
    }

    public static boolean isEntityKB(String entity) {
        if (!initialized) {
            throw new RuntimeException("initializeTheo needs to have been called");
        }
        if (entity.charAt(0) == '(') {
            entity = entity.substring(1, entity.length() - 1);
        }
        String[] entityPath = entity.split(" ");
        String entityName = entityPath[0];
        return KbManipulation.doesEntityExist(entityName);
    }

    public static RTWValue getValueKB(String slot, String entity) {
        RTWValue val = TheoKB.justGetValueKB(slot, entity);
        if (val.getTypeString().equals("s") && val.asString().equals("NO_THEO_VALUE")) {
            return val;
        }
        RTWListValue l = new RTWListValue();
        l.addValue(val);
        String subentity = entity + " " + slot;
        val = TheoKB.justGetValueKB("probability", subentity);
        if (val.getTypeString().equals("s") && val.asString().equals("NO_THEO_VALUE")) {
            l.addValue(new RTWIntegerValue(-1));
        } else {
            l.addValue(val);
        }
        val = TheoKB.justGetValueKB("source", subentity);
        if (val.getTypeString().equals("s") && val.asString().equals("NO_THEO_VALUE")) {
            l.addValue(new RTWIntegerValue(-1));
        } else {
            l.addValue(val);
        }
        return l;
    }

    public static List<String> getEntitySlotsKB(String entity) {
        if (!TheoKB.isEntityKB(entity)) {
            new ArrayList();
        }
        return KbManipulation.getSlots(entity);
    }

    public static String RTWValueToString(RTWValue val) {
        String str = "";
        if (val.getTypeString().equals("in")) {
            int i = (int)((RTWIntegerValue)val).getVal();
            str = str + i;
        } else if (val.getTypeString().equals("r")) {
            double d = ((RTWRealValue)val).getVal();
            str = str + d;
        } else if (val.getTypeString().equals("s")) {
            String s;
            str = s = ((RTWStringValue)val).getVal();
        } else if (val.getTypeString().equals("l")) {
            List<RTWValue> l = ((RTWListValue)val).getVal();
            boolean first = true;
            str = "{";
            Iterator<RTWValue> it = l.iterator();
            while (it.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    str = str + " ";
                }
                str = str + TheoKB.RTWValueToString(it.next());
            }
            str = str + "}";
        }
        return str;
    }

    private static String printEntity(String entity, int curDepth, int maxDepth, List<String> slotsToPrint) {
        if (!TheoKB.isEntityKB(entity)) {
            return "";
        }
        String indent = "";
        for (int i = 0; i < curDepth; ++i) {
            indent = indent + "  ";
        }
        String str = "";
        if (curDepth == 1) {
            str = str + entity + ":\n";
        }
        if (curDepth <= maxDepth) {
            List<String> slotList = TheoKB.getEntitySlotsKB(entity);
            for (String slot : slotList) {
                if ((!slotsToPrint.isEmpty() || slot == "specializations") && !slotsToPrint.contains(slot)) continue;
                RTWValue val = TheoKB.getValueKB(slot, entity);
                String valStr = val.getTypeString().equals("l") ? TheoKB.RTWValueToString(((RTWListValue)val).getVal().get(0)) : TheoKB.RTWValueToString(val);
                str = str + indent + slot + " = " + valStr + "\n";
                if (curDepth >= maxDepth) continue;
                str = str + TheoKB.printEntity(entity + " " + slot, curDepth + 1, maxDepth, slotsToPrint);
            }
        }
        return str;
    }

    public static String printEntity(String entity) {
        return TheoKB.printEntity(entity, 1);
    }

    public static String printEntity(String entity, int maxDepth) {
        ArrayList<String> slotsToPrint = new ArrayList<String>();
        return TheoKB.printEntity(entity, maxDepth, slotsToPrint);
    }

    public static String printEntity(String entity, int maxDepth, List<String> slotsToPrint) {
        return TheoKB.printEntity(entity, 1, maxDepth, slotsToPrint);
    }

    private static String printHierarchy(String entity, int curDepth, List<String> slotsToPrint) {
        if (!TheoKB.isEntityKB(entity)) {
            return "";
        }
        String indent = "";
        for (int i = 1; i < curDepth; ++i) {
            indent = indent + "  ";
        }
        String str = "";
        str = str + indent + entity + "\n";
        RTWListValue specializations = new RTWListValue();
        List<String> slotList = TheoKB.getEntitySlotsKB(entity);
        for (String slot : slotList) {
            RTWValue val = TheoKB.getValueKB(slot, entity);
            if (slot.equals("specializations")) {
                if (val.getTypeString() != "l") {
                    throw new RuntimeException("KB corruption detected: getValueKB should have returned the specializations slot of " + entity + " as a list, but instead returned " + TheoKB.RTWValueToString(val));
                }
                specializations = (RTWListValue)((RTWListValue)val).getVal().get(0);
            }
            if (!slotsToPrint.contains(slot)) continue;
            String valStr = val.getTypeString().equals("l") ? TheoKB.RTWValueToString(((RTWListValue)val).getVal().get(0)) : TheoKB.RTWValueToString(val);
            str = str + indent + "    | " + slot + " = " + valStr + "\n";
        }
        List<RTWValue> specList = specializations.getVal();
        for (RTWValue specVal : specList) {
            if (specVal.getTypeString().equals("s")) {
                String specialization = ((RTWStringValue)specVal).getVal();
                str = str + TheoKB.printHierarchy(specialization, curDepth + 1, slotsToPrint);
                continue;
            }
            throw new RuntimeException("KB corruption detected: non-string element encountered in the list of specializations of " + entity + ": " + TheoKB.RTWValueToString(specVal));
        }
        return str;
    }

    public static String printHierarchy(String root, List<String> slotsToPrint) {
        return TheoKB.printHierarchy(root, 1, slotsToPrint);
    }

    public static String printHierarchy(String root) {
        ArrayList<String> slotsToPrint = new ArrayList<String>();
        return TheoKB.printHierarchy(root, slotsToPrint);
    }
}

