/* -*- c-basic-offset:4; -*- */

#include <stdlib.h>
#include <stdio.h>
#include <alloca.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <omp.h>

#define COUNT    200*1000*1000


void counting() {
    int cur = 0;
    int counter = 0;

    //#pragma omp parallel for
    //#pragma omp parallel for reduction(+:counter)
    for (cur = 0; cur < COUNT; cur++ ) {
        //#pragma omp atomic
        counter++;
    }
    printf(" %i \n", counter);
}

int main(int argc, char *argv[])
{
    const int threadCounts[] = {1, 2, 4, 8};
    int threadIndex = 0;

    for (threadIndex = 0 ; threadIndex < sizeof(threadCounts)/sizeof(int) ; threadIndex++) {
        int threadCount = threadCounts[threadIndex];
        if ( threadCount >  sysconf(_SC_NPROCESSORS_ONLN) ) {
            break;
        }

        struct timespec start;
        struct timespec end;

        
        // start time
        clock_gettime(CLOCK_REALTIME, &start);
        omp_set_num_threads(threadCount);

        counting();

        printf("Measure %2i threads : ", threadCount);

        // end time
        clock_gettime(CLOCK_REALTIME, &end);

        long start_time = start.tv_sec * 1000*1000*1000 + start.tv_nsec;
        long end_time = end.tv_sec * 1000*1000*1000 + end.tv_nsec;
        long ealpsed = (end_time - start_time) / (1000*1000);

        printf(" %li us.\n", ealpsed);
    }

    return 0;
}
