/* -*- c-basic-offset:4; -*- */

#include <stdio.h>
#include <omp.h>

static inline int fib(int n) {
    if ( n <= 2 ) {
        return 1;
    } else {
        return fib(n-2) + fib(n-1);
    }
}

int main(int argc, char *argv[])
{
    const int COUNT = 8;
    int i = 0;
    
    omp_set_num_threads(2);

    //#pragma omp parallel for
    //#pragma omp parallel for schedule(dynamic)
    for ( i = 0; i < COUNT; i++ ) {
        if ( i < COUNT/2 ) {
            printf("fib = %i\n", fib(30));
        } else {
            printf("fib = %i\n", fib(42));
        }
    }

    return 0;
}
