/* -*- c-basic-offset:4; -*- */

#include <stdlib.h>
#include <stdio.h>
#include <alloca.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <omp.h>

#define COUNTERS        8
#define CACHELINE_SIZE 64
#define COUNT          100*1000*1000


void increment(int count, int **counters) {
    int cur = 0;

#pragma omp parallel for
    for (cur = 0; cur < count; cur++ ) {
        int *counter = counters[cur];

        int i;
        for ( i = 0; i < COUNT ; i++ ) {
            (*counter)++;
        }
    }
}

int main(int argc, char *argv[])
{
    const int threadCounts[] = {1, 2, 4, 8};
    int *counterPool     = NULL; 
    
    // allocate memory
    if ( posix_memalign((void**)&counterPool, CACHELINE_SIZE, COUNTERS*CACHELINE_SIZE) ) {
        perror("Cannot allocate memory");
        exit(-1);
    }


    int threadIndex = 0;
    for (threadIndex = 0 ; threadIndex < sizeof(threadCounts)/sizeof(int) ; threadIndex++) {
        int threadCount = threadCounts[threadIndex];
        if ( threadCount >  sysconf(_SC_NPROCESSORS_ONLN) ) {
            break;
        }

        int **counters = (int**)malloc(sizeof(int**)*COUNTERS);
        struct timespec start;
        struct timespec end;

        printf("Measure %2i threads : ", threadCount);
        
        // start time
        clock_gettime(CLOCK_REALTIME, &start);
        omp_set_num_threads(threadCount);
        int i;
        for ( i = 0 ; i < COUNTERS ; i++ ) {
            char *ptr = (char*)counterPool;
            counters[i] =  (int*)&ptr[i*CACHELINE_SIZE];
        }
        increment(COUNTERS, counters);

        // end time
        clock_gettime(CLOCK_REALTIME, &end);

        long start_time = start.tv_sec * 1000*1000*1000 + start.tv_nsec;
        long end_time = end.tv_sec * 1000*1000*1000 + end.tv_nsec;
        long ealpsed = (end_time - start_time) / (1000*1000);

        printf(" %li us.\n", ealpsed);
        
        // cleanup
        free(counters); counters=NULL;
    }

    // cleanup memory
    free(counterPool); counterPool = NULL;

    return 0;
}
