function [gx,gy] = smoothgradient(img, sigma)
%
% [gx,gy] = smoothgradient(img, sigma)
%  
%  Similar to Matlab's gradient command but uses Gaussian derivative
%  filters instead of simple finite-differencing.
%
% ------------
% Andrew Stein
%

if(nargin == 1)
    sigma = 1;
end

if(isa(img, 'uint8'))
    img = double(img);
end

% create gaussian and derivative of gaussian filters:
x = [-ceil(3*sigma):ceil(3*sigma)];
normalization = (1/(sqrt(2*pi)*sigma));
g = normalization*exp(-x.^2 / (2*sigma^2));
dg = -x/(sigma^2) .* exp(-(x.^2)/(2*sigma^2)) * normalization;

if(size(img,3)==1)
    gx = conv2(conv2(img, dg, 'same'), g', 'same');
    gy = conv2(conv2(img, dg', 'same'), g, 'same');
     
else
    for(i=1:size(img,3))
        gx(:,:,i) = conv2(conv2(img(:,:,i), dg, 'same'), g', 'same');
        gy(:,:,i) = conv2(conv2(img(:,:,i), dg', 'same'), g, 'same');
    end
    
end

% if only one ouput argument, return gradient magnitude
if(nargout==1)
    gx = sqrt( gx.^2 + gy.^2);
end

