function g = myGaussian(sigma, K)
%
% g = myGaussian(sigma, K)
% 
% Creates a Gaussian with specified sigma suitable for filtering an image.
% The returned vector will have length 2*round(K*sigma)+1 (so the length is
% odd and the peak of the Gaussian is at the center element).
% K defaults to 3 if unspecified.
%
% ------------
% Andrew Stein
%

if(nargin<2)
    K = 3;
end

halfwidth = round(K*sigma);
x = [-halfwidth:halfwidth];

g = exp(-.5*x.^2 / (sigma*sigma));
g = g/sum(g);