function [h, c] = DrawFeatures(x,y,s, color)
%
% [h, c] = DrawFeatures(x,y,s, color)
% [h, c] = DrawFeatures(interest_points_struct, color)
%
% ------------
% Andrew Stein
%

DRAW_SQUARES = true;
descriptor_samples = 17;
% patch_size_multiplier = 5;
patch_size_multiplier = (descriptor_samples-1)/2;


if(nargin < 3)
    if(nargin == 1)
        color = 'random';
    else
        color = y;
    end
    
    int_pts = x;
    x = [int_pts.x];
    y = [int_pts.y];
    s = [int_pts.scale];
    if(isfield(int_pts, 'angle'))
        angle = [int_pts.angle];
    else
        DRAW_SQUARES = false;
        angle = [];
    end
    
else
    if(nargin==3)
        color = 'random';
    end
    DRAW_SQUARES = false;
    angle = [];
end

h = [];
color_list = 'rgbcmy';

if(strcmp(color, 'random'))
    %c = .5+0.5*rand(1,3);
    c = color_list(ceil(6*rand(1,length(x))));
else
    if(length(color)>1)
        c = color;
    else
        c = repmat(color, [1 length(x)]);
    end
end
    
if(DRAW_SQUARES)    
    x = x(:); y = y(:); s = s(:); angle = angle(:);
    halfwidth = s*patch_size_multiplier;
    xrect = [-halfwidth halfwidth halfwidth -halfwidth];
    yrect = [-halfwidth -halfwidth halfwidth halfwidth];
    cosAngle = cos(angle)*ones(1,4);
    sinAngle = sin(angle)*ones(1,4);
    xrect_rot = cosAngle.*xrect + sinAngle.*yrect + x*ones(1,4);
    yrect_rot = -sinAngle.*xrect + cosAngle.*yrect + y*ones(1,4);
    
    % make the rectangles closed:
    xrect_rot = xrect_rot(:,[1:end 1]);
    yrect_rot = yrect_rot(:,[1:end 1]);
    
    h = plot(xrect_rot', yrect_rot');%, 'LineWidth', 1.5);
    for(i=1:length(h))
        set(h(i), 'Color', c(:,i));
    end
    
    h = h';
end

for(i=1:length(x))
       
    h(end+1) = plot(x(i),y(i), 'x', 'MarkerSize', 8, 'LineWidth', 1.5, 'Color', c(:,i));
   
    if(~DRAW_SQUARES)
        h(end+1) = rectangle('Position', [x(i)-3*s(i), y(i)-3*s(i), 6*s(i), 6*s(i)], ...
            'Curvature', [1 1], 'EdgeColor', c(:,i), 'LineWidth', 1.5);
    end
    
end

% Code to draw orientation arrows for each interest point:
 if(~isempty(angle))
     h = [h 0 0];
     h((end-1):end) = quiver(x, y, 10*cos(-angle), 10*sin(-angle), 0); % the neg. angle is crucial!
 end

% %Code to also label each interest point with it's number to allow
% %comparison between images:
% h_text = text(x, y, num2str([1:length(x)]'), 'FontSize', 14);
% for(i=1:length(h_text))
%     set(h_text(i), 'Color', c(:,i));
% end
% h = [h h_text'];