function [g,xgrid,ygrid] = CreateGaussianMask(mask_size, sigma)
%
% [g,xgrid,ygrid] = CreateGaussianMask(<mask_size>, sigma)
%
%  Simply creates a mask_size-by-mask_size gaussian with specified standard
%  deviation, sigma, to be used as a weighting mask.  The mask_size must be
%  odd.  The center position of the mask will be exactly one.
% 
%  If only one argument is provided, it is assumed to be sigma.  The mask
%  size is then chosen to cover -3*sigma to 3*sigma.
%
%  Note that this is much faster than using the more general Matlab
%  function, fspecial, to create the same thing.
%
% ------------
% Andrew Stein
%

if(nargin==1)
    sigma = mask_size;
    mask_size = 2*ceil(3*sigma)+1;
elseif(mod(mask_size,2)==0)
    error('Size of the gaussian mask should be odd!')
end

[xgrid,ygrid] = meshgrid(-(mask_size-1)/2 : (mask_size-1)/2);

g = exp(-(xgrid.^2+ygrid.^2)/(2*sigma^2));
    