function [Fp, Fpp] = ComputeDerivatives_3D(F, dx, dy, dz)
%
% [Fp, Fpp] = ComputeDerivatives_3D(F, dx, dy, dz)
%
%  Given a 3x3x3 neighborhood of data, compute the x, y, and z first
%  derivatives and return them as Fp = [ Fx Fy Fz ]'
%  Also compute all the second derivatives and return them as the 3x3
%  symmetric matrix, 
%            | Fxx Fxy Fxz |
%      Fpp = | Fxy Fyy Fyz |
%            | Fxz Fyz Fzz |
%
%  dx, dy, dz (each should be a 2-vector) specify the spacing of the data points along each 
%  dimension.  (Default is that dx=dy=dz=1)
%

%  -------------------------------------
%  Andrew Stein, last modified 3/21/2005
%

% if(ndims(F) ~= 3 | ~all(size(F)==[3 3 3])) 
%     error('F must be a 3x3x3 cube of data!')
% end

if(nargin==1)
    dx = [1 1]; dy = [1 1]; dz = [1 1];
end

sum_dx = dx(1)+dx(2);
sum_dy = dy(1)+dy(2);
sum_dz = dz(1)+dy(2);

% Vector of x,y,z first derivatives:
Fp = [(F(17)-F(11))/sum_dx; (F(15)-F(13))/sum_dy; (F(23)-F(5))/sum_dz];

if(nargout==2 | nargout==0)
    % Second derivatives:
    Fxx = (F(17) - 2*F(14) + F(11))/(dx(1)*dx(2));
    Fyy = (F(15) - 2*F(14) + F(13))/(dy(1)*dy(2));
    Fzz = (F(23) - 2*F(14) + F(5) )/(dz(1)*dz(2));
    
    Fxy = (F(18)-F(16)-F(12)+F(10))/(sum_dx*sum_dy);
    Fxz = (F(26)-F(8) -F(20)+F(2) )/(sum_dx*sum_dz);
    Fyz = (F(24)-F(6) -F(22)+F(4) )/(sum_dy*sum_dz);
    
    Fpp = [Fxx Fxy Fxz; Fxy Fyy Fyz; Fxz Fyz Fzz];
end