/************************************
 * util.c
 * 
 * Has all functions to obtain identity of server and general purpose functions, like getdate and getfilelen.
 ************************************/

#include "util.h"

char *getnext(int argc, char **argv, int *i) {
  if (*i == argc-1) {
    fprintf(stderr,"option %s requires an argument",argv[*i]);
    exit(1);
  }
  return argv[++(*i)];
}

char *getdate() {
  static char date[1000];
  time_t t = time(NULL);
  struct tm *tm = gmtime(&t);
  strftime(date, 1000, "%a, %d %b %Y %H:%M:%S GMT", tm);
  return date;
}

const char *getservername() {
  return "mini-webserver/1.0 (Unix)";
}

// changed to close, not Close because justin can't capitalize
const char *getkeepalive(int keepalive) {
  return keepalive ? "Keep-Alive" : "close";
}

int getfilelen(FILE *fp) {
  int filelen;
  fseek( fp, 0, SEEK_END );
  filelen = ftell( fp );
  rewind( fp );
  return filelen;
}

char *strappend(char *str1, int *str1len, char *str2, int str2len) {
  char *temp = str1;
  str1 = (char*)malloc(*str1len + str2len + 1);
  if (temp != NULL) {
    /* we may assume that str1 is a string, and fix str1len accordingly */
    strcpy(str1, temp);
    while (str1[*str1len] != 0 && (*str1len) >= 0) (*str1len)--;
    str1[*str1len] = 0;
    // shouldn't have to change str
//    memcpy(str1, temp, *str1len);
    free(temp);
  }
  memcpy(str1 + *str1len, str2, str2len);
  if (*str1len + str2len > 0 && str1[*str1len + str2len] != '\0') str1[*str1len + str2len] = '\0';
  /* *str1len += str2len; */
  *str1len = strlen(str1);
  return str1;
}

char *strstrip(char *str, int *slen, int stripcount) {
  char *temp;
  if (str == NULL) return NULL;
  temp = (char*)malloc(*slen-stripcount+1);
  memcpy(temp, str+stripcount, *slen-stripcount+1);
  temp[*slen-stripcount] = '\0';
  /* *slen = *slen-stripcount+1; */
  *slen = strlen(temp);
  free(str);
  return temp;
}


void printerror(const char *file, int line) {
  if (errno == 0) return;
  printf("(%s,%d) ", file, line);
  switch (errno) {
    case EINTR:  printf("error EINTR: call was interrupted\n"); break;
    case EAGAIN: printf("error EAGAIN or EWOULDBLOCK: no data available\n"); break;
    case EIO:    printf("error EIO: I/O error\n"); break;
    case EISDIR: printf("error EISDIR: fd is a dir\n"); break;
    case EBADF:  printf("error EBADF: fd is invalid\n"); break;
    case EINVAL: printf("error EINVAL: fd is unreadable\n"); break;
    case EFAULT: printf("error EFAULT: buf is outside address space\n"); break;
    case ENOMEM: printf("error ENOMEM: unable to allocate\n"); break;
    case ENOTSOCK: printf("error ENOTSOCK: not a socket\n"); break;
    case EOPNOTSUPP: printf("error EOPNOTSUPP: socket doesn't support listen\n"); break;
    case ECONNRESET: printf("error ECONNRESET: connection reset by peer\n"); break;
    case EADDRINUSE: printf("error EADDRINUSE: address already in use\n"); break;
    default: printf("unknown error: %d\n", errno); break;
  }
}

// note: path has root as a prefix
int validate_path(char *root, char *path) {
  // basically iterate through the path, make sure we never go above the root
  int i = strlen(root);
  char *temp = path+i;
  char *next;
  struct stat s;
  int retval;

  if (debug) printf("validating path...\n");

  do {
    next = strchr(temp+1, '/');
    // temporarily end the string here
    *temp = '\0';
    if (debug) printf("statting %s\n", path);
    retval = lstat(path, &s);
    // put it back
    *temp = '/';

    if (retval == -1) {
      if (debug) printf("Error: couldn't stat\n");
      return 404;
    }

    if (S_ISLNK(s.st_mode)) {
      if (debug) printf("Error: Will not follow symlinks.\n");
      return 403;
    }

    // if the next dir is the special ".." *and* the current dir is the root, disallow
    if ((next-temp) == 3 && *(temp+1) == '.' && *(temp+2) == '.' && 
      s.st_dev == rootstat.st_dev && s.st_ino == rootstat.st_ino) {
      if (debug) printf("Error: path may not leave root\n");
      return 403;
    }

    temp = next;
  } while (next != NULL);

  if (debug) printf("path looks okay\n");
  return 200;

}

// tokenizes the string, returns a pointer to the delimiter found
char *strdiv(char **strp, const char *delims) {
  int i = 0, j = 0;
  char *str = *strp;
  while (str[i] != 0) {
    for (j = 0; delims[j] != 0; j++) {
      if (str[i] == delims[j]) {
        str[i] = 0;
        *strp += i+1;
        return (char*)(delims+j);
      }
    }
    i++;
  }
  return NULL;
}
