/************************************
 * uri.c
 * 
 * 
 ************************************/

/* 
has to deal with
http://host/path
converting %XX to char(XX)
*/

#include <ctype.h>
#include <string.h>
#include <stdio.h>
#include "globals.h"

char hextoint(char h) {
  if (h >= '0' && h <= '9') return h-'0';
  else return (int)(toupper(h)-'A');
}

char tochar(char *hex) {
  if (debug) printf("%c%c\n", *hex, *(hex+1));
  return (hextoint(hex[0])<<4)+hextoint(hex[1]);
}

int unescape(char *str) {
  int i;
  int len = strlen(str);
  for (i = 0; str[i] != 0; i++) {
    if (str[i] == '%') {
      if (i+1 == len) return 0;
      if (str[i+1] == '%') {
        memmove(str+i+1, str+i+2, len-i-1);
        len -= 1;
      }
      else {
        if (i+2 == len) return 0;
        if (isxdigit(str[i+1]) && isxdigit(str[i+2])) {
          str[i] = tochar(str+i+1);
          memmove(str+i+1, str+i+3, len-i-2); 
          len -= 2;
        } else {
          return 0;
        }
      }
    }
  }
  return 1;
}

/* writes content-type into contenttype; expects content type to be at least 40 chars */
void getcontenttype(char *uri, char *contenttype) {
  char *ext = rindex(uri, '.');
  char *type = "text/html";
  /* Justin's suggestions for mime types:
  .htm .html   text/html
  .txt         text/plain
  .xml         text/xml
  .css         text/css
  .png         image/png
  .gif         image/gif
  .jpg .jpeg   image/jpeg
  .tif .tiff   image/tiff
  .tar         application/tar
  .zip         application/zip
  .ps          application/postscript
  .pdf         application/pdf
  .mpg .mpeg   video/mpeg
  */
  if (ext == NULL || strcmp(ext, ".htm") == 0 || strcmp(ext, ".html") == 0) 
    type = "text/html";
  else if (strcmp(ext, ".txt") == 0) 
    type = "text/plain";
  else if (strcmp(ext, ".xml") == 0) 
    type = "text/xml";
  else if (strcmp(ext, ".css") == 0) 
    type = "text/css";
  else if (strcmp(ext, ".png") == 0) 
    type = "image/png";
  else if (strcmp(ext, ".jpg") == 0 || strcmp(ext, ".jpeg") == 0)
    type = "image/jpeg";
  else if (strcmp(ext, ".tif") == 0 || strcmp(ext, ".tiff") == 0)
    type = "image/tiff";
  else if (strcmp(ext, ".tar") == 0)
    type = "application/tar";
  else if (strcmp(ext, ".zip") == 0)
    type = "application/zip";
  else if (strcmp(ext, ".ps") == 0)
    type = "application/postscript";
  else if (strcmp(ext, ".pdf") == 0)
    type = "application/pdf";
  else if (strcmp(ext, ".mpg") == 0 || strcmp(ext, ".mpeg") == 0)
    type = "video/mpeg";
  else 
    type = "text/html";
  strcpy(contenttype, type);
}