#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <netinet/in.h>
#include <errno.h>
#include <string.h>

#include "clients.h"
#include "util.h"
#include "client_read.h"
#include "client_write.h"
#include "globals.h"
#include "init.h"

int port = 8000;
char *rootpath = "./www";
int sslport = 8001;
int debug = 0;
int extracredit = 0;

void startserver();

struct clientnode *clients = NULL;
SSL_CTX* g_ssl_context = NULL;
struct stat rootstat;


int main(int argc, char **argv) {
  int i,j;
  for (i = 1; i < argc; i++) {
    if (strcmp(argv[i],"-p") == 0) {
      port     = atoi(getnext(argc,argv,&i));
    } else if (strcmp(argv[i],"-root") == 0) {
      rootpath =      getnext(argc,argv,&i);
      /* make sure the rootpath doesn't end with / */
      for (j = strlen(rootpath)-1; j >= 0 && rootpath[j] == '/'; j--) {
        rootpath[j] = '\0';
      }
    } else if (strcmp(argv[i],"-sslport") == 0) {
      sslport  = atoi(getnext(argc,argv,&i));
    } else if (strcmp(argv[i],"-debug") == 0) {
      debug = 1;
    } else if (strcmp(argv[i],"-extracredit") == 0 || strcmp(argv[i],"-ec") == 0) {
      extracredit = 1;
    } else {
      fprintf(stderr,"Invalid option %s\n",argv[i]);
      return 1;
    }
  }

  if (debug) {
    printf("port = %d\n",port);
    printf("rootpath = %s\n",rootpath);
    printf("sslport = %d\n",sslport);
    printf("debug = %d\n",debug);
    printf("extracredit = %d\n",extracredit);
  }

  if (stat(rootpath, &rootstat) == -1 || !S_ISDIR(rootstat.st_mode)) {
    fprintf(stderr, "Cannot stat root: %s\n", rootpath);
    exit(1);
  }

  startserver();

  return 0;
}

void startserver() {
  int serverfd=0, serversslfd=0;
  struct clientnode *curr, *next;
  fd_set readfds;
  struct timeval timeout = {0,0};
  int maxfd;
  int retval;
  time_t now;

  serverfd = init_insecure(port);
  serversslfd = init_secure(sslport);

  while(1) {
    maxfd = getreadfds(&readfds, serverfd, serversslfd, clients);

    timeout.tv_sec = 0;
    timeout.tv_usec = 0;

    retval = select(maxfd + 1, &readfds, NULL, NULL, &timeout);

    if (retval != -1) {
      if (FD_ISSET(serverfd, &readfds)) accept_connection(serverfd);
      if (FD_ISSET(serversslfd, &readfds)) ssl_accept_connection(serversslfd);
      /* iterate through the clients, process as necessary */
      curr = clients;
      while (curr != NULL) {
        next = curr->next;
        now = time(NULL);
        if (now-curr->data.lastseen <= TIMEOUT && curr->data.reqlen < MAXHEADERLEN) {
          /* also process_client if there's requests pending */
          if (FD_ISSET(curr->data.fd, &readfds)) curr->data.readpending = 1;
  //        if (curr->data.readpending == 1 || curr->data.reqlen > 0) {
          if (curr->data.readpending == 1) {
            if (debug) printf("client %d, read pending %d, reqlen %d\n", curr->data.fd, curr->data.readpending, curr->data.reqlen);
            // a rough estimate
            curr->data.lastseen = time(NULL);
            process_client(curr);
          }
        } else {
          timeout_client(curr);
        }
        curr = next;
      }
    } else {
      if (debug) printerror(__FILE__,__LINE__);
      fprintf(stderr, "Fatal error: select encountered error (%d)\n", errno);
      exit(1);
    }
  }

  if (g_ssl_context != NULL) {
    ssl_destroy_context(g_ssl_context);
  }
}
