
#include "init.h"
#include "util.h"

int init_insecure(int port) {
  int serverfd; 
  struct sockaddr_in srv;
  int optval;

  serverfd = socket(AF_INET, SOCK_STREAM, 0);
  if (serverfd == -1) {
	fprintf(stderr, "Fatal Error: creating socket");
    exit(1);
  }

  // allow us to immediately reuse the port
  optval = 1;
  setsockopt( serverfd, SOL_SOCKET, SO_REUSEADDR, (const void *)&optval, sizeof(int) );

  srv.sin_family = AF_INET;
  srv.sin_port = htons(port);
  srv.sin_addr.s_addr = htonl(INADDR_ANY);
  if (bind(serverfd, (struct sockaddr*) &srv, sizeof(srv)) < 0) {
    fprintf(stderr, "Fatal Error: Couldn't bind port\n");
	  exit(1);
  }
  if (debug) printf("bound port\n");

  if (listen(serverfd, 5) < 0) {
    fprintf(stderr, "Fatal Error: couldn't listen on socket");
    exit(1);
  }
  if (debug) printf("listening, fd = %d\n", serverfd);
  if (debug) printerror(__FILE__,__LINE__);

  return serverfd;
}

int init_secure(int port) {
  int fd;

  SSL_load_error_strings();
  SSL_library_init();

  g_ssl_context = ssl_initialize_context( SERVER_KEYFILE, SERVER_KEYFILE );

  fd = init_insecure(port);
/*
  if (fcntl(fd, F_SETFL, O_NONBLOCK) <= 0) {
    if (debug) printerror(__FILE__,__LINE__);
    printf("fatal error: setting ssl port non-blocking\n");
    exit(1);
  }
*/

  return fd;
}
