#ifndef __CLIENTS_H_
#define __CLIENTS_H_

#include "util.h"

#define MAXLEN 1024

struct clientdata {
  int                 fd;
  struct sockaddr_in  sock;
  int                 socklen;
  char*               requests;
  int                 reqlen;
  int                 readpending;

  int                 isSSL;
  SSL*                ssl_connection;
  SSL_CTX*            ssl_context;
  BIO*                ssl_client_bio;
  time_t              lastseen;
};

struct clientnode {
  struct clientnode*  next;
  struct clientdata   data;
};

struct requestinfo {
  int                 requesttype;
  int                 responsetype;
  int                 httpversion11;
  char*               host;
  char*               URI;
  char                contenttype[100];
  char*               content;
  char*               relpath;
  int                 contentlength;
  int                 keepalive;
};

extern struct clientnode *clients;

struct clientnode*   accept_connection     (int serverfd);
struct clientnode*   ssl_accept_connection (int serversslfd);
int                  write_client          (struct clientdata *client, char *buf, int len);
void                 close_client          (struct clientdata *client);
void                 process_client        (struct clientnode *client);
void                 timeout_client        (struct clientnode *client);
/* returns one of CLOSED, CLOSE, STILL_ALIVE */
int                  serve_client          (struct clientdata *client);
struct clientnode*   new_clientnode        ();
void                 delete_clientnode     (struct clientnode *client);
struct requestinfo*  new_requestinfo       ();
void                 delete_requestinfo    (struct requestinfo *request);

void                 client_add            (struct clientnode **root, struct clientnode *node);
int                  client_remove         (struct clientnode **root, struct clientnode *node);
int                  getmaxfd              (struct clientnode *root);
int                  getreadfds            (fd_set *readfds, int serverfd, int serversslfd, struct clientnode *root);


#define REQUEST_UNFIN     0
#define REQUEST_UNSUP     1
#define REQUEST_GET       2
#define REQUEST_HEAD      3
#define REQUEST_MALFORMED 5 
#define REQUEST_BADVERSION 6

#define CLOSED      1
#define CLOSE       2
#define STILL_ALIVE 3

#endif
