/************************************
 * client_write.c
 * 
 * Contains all different success/error pages that could be sent back and does the writing back to the client.
 ************************************/

#include "clients.h"
#include "client_write.h"

int loadcontent(struct requestinfo *request);
int serve_page_reason(struct clientdata *client, struct requestinfo *request);

int serve_page(struct clientdata *client, struct requestinfo *request) {
  int retval;

  strcpy(request->contenttype, "text/html");
  /* convert URI from URI to a page (use the host to convert http://host/blah to a path
    * but if host doesn't exist in metainfo, serve up something?? serve up what? */
       
  if (!unescape(request->URI)) {
    if (debug) fprintf(stderr, "Malformed URI\n");
    request->responsetype = 400;
    retval = serve_page_reason(client, request);
    /* can't recover from a malformed URI */
    retval = CLOSE;
  } else {
    request->relpath = (char*)malloc(strlen(request->URI)+1);
    strcpy(request->relpath, request->URI);
    if (debug) printf("relpath is %s\n", request->relpath);
    getcontenttype(request->relpath, request->contenttype);
    request->responsetype = loadcontent(request);
    retval = serve_page_reason(client, request);
  }

  return retval;
}

int serve_page_error(struct clientdata *client, struct requestinfo *request) {
  if (serve_page_reason(client, request) == CLOSED) return CLOSED;
  return CLOSE;
}

int serve_page_reason(struct clientdata *client, struct requestinfo *request) {
  char header[10000];
  int j = 0;
  int sendcontent = 1;

  if (request->responsetype != 200) {
    request->content = (char*)malloc(1000);
    strcpy(request->content,get_error_string(request->responsetype));
    request->contentlength = strlen(request->content);
  }

  // TODO: i believe justin now always wants content-length to be the same as GET

  if (request->requesttype == REQUEST_HEAD) {
    sendcontent = 0;
  }


  j  = sprintf(header    , "HTTP/1.1 %d %s\r\n", request->responsetype, get_reason_string(request->responsetype));
  j += sprintf(header + j, "Date: %s\r\n", getdate());
  j += sprintf(header + j, "Server: %s\r\n", getservername());
  j += sprintf(header + j, "Content-Length: %d\r\n", request->contentlength);
  j += sprintf(header + j, "Connection: %s\r\n", getkeepalive(request->keepalive));
  j += sprintf(header + j, "Content-Type: %s\r\n", request->contenttype);
  j += sprintf(header + j, "\r\n");

  if (write_client(client, header, j) == -1) {
    if (debug) printerror(__FILE__,__LINE__);
    return CLOSED;
  }

  if (sendcontent) {
    if (write_client(client, request->content, request->contentlength) == -1) {
      if (debug) printerror(__FILE__,__LINE__);
      return CLOSED;
    }
  }

  return STILL_ALIVE;
  
}

int loadcontent(struct requestinfo *request) {
  char *path = (char*)malloc(strlen(request->relpath)+strlen(rootpath)+20);
  char temp[MAXLEN];
  int len, count = 0;
  FILE *fp = NULL;
  int errorval = 200;
  int filelen = 0;
  struct stat s;
  request->content = NULL;
  request->contentlength = 0;

  path[0] = '\0';
  
  strcat(path, rootpath);
  //prepend a / if necessary
  if (strlen(request->relpath) > 0 && request->relpath[0] != '/') strcat(path, "/");
  strcat(path, request->relpath);
  if (debug) printf("path is %s\n",path);

  errorval = validate_path(rootpath, path);

  // if we're still good
  if (errorval == 200) {
    if (stat(path, &s) == -1) {
      if (debug) printf("couldn't stat file\n");
      errorval = 404;
    }
  
    // if it's just a file, open it
    if (S_ISREG(s.st_mode)) {
      fp = fopen(path, "rb");
    } else {
      if (debug) printf("path isn't a file\n");
      errorval = 404;
    }

    if (fp == NULL) {
      if (debug) printf("couldn't open file\n");
      errorval = 404;
    } else {
      filelen = request->contentlength = s.st_size;
      request->content = (char*)calloc(filelen+10, sizeof(char));
      do {
        len = fread( temp, sizeof(char), MAXLEN, fp);
        if (len == -1) {
          /* Unrecoverable error */
          errorval = 404;
        }
        memcpy(request->content+count, temp, len);
        count += len;
      } while (!feof(fp) && errorval == 200);
      fclose(fp);
    }
  }
  free(path);
  return errorval;
}

char *get_error_string(int reason) {
  switch(reason) {
    case 200: return ""; /* here the content of the page should be sent back */
    case 400: return "<h1>400 Bad Request</h1>\n<p>Client sent a malformed HTTP/1.1 request\n";
    case 403: return "<h1>403 Forbidden</h1>\n<p>The URL you have requested cannot be accessed.\n";
    case 404: return "<h1>404 Not Found</h1>\n<p>The page requested could not be found.  Please check that the file exists and that you have appropriate permissions.\n";
    case 500: return "<h1>500 Internal Server Error</h1>\n<p>The server has encountered an error.  Please check the error logs.\n";
    case 501: return "<h1>501 Not Implemented</h1>\n<p>This server only implements GET and HEAD requests.\n";
    case 505: return "<h1>505 HTTP Version Not Supported</h1>\n<p>This server only supports HTTP/1.1 requests.\n";
  }
  return "";
}

char *get_reason_string(int reason) {
  switch(reason) {
    case 200: return "OK";
    case 400: return "Bad Request";
    case 403: return "Forbidden";
    case 404: return "Not Found";
    case 500: return "Internal Server Error";
    case 501: return "Not Implemented";
    case 505: return "HTTP Version Not Supported";
  }
  return "Unknown";
}
