/*******************************************
 * client_read.c
 * 
 * Contains all functions to read from a client data stream
 *******************************************/

#include "client_read.h"

int getclientrequest(struct clientdata *client) {
  int len;
  char temp[MAXLEN];

  if (!client->isSSL) {
    len = read(client->fd, temp, MAXLEN);
  } else {
    if (debug) printf("bio read\n");
    len = BIO_read(client->ssl_client_bio, temp, MAXLEN);
  }
  // len is -1 or 0 on error (0 if EOF was reached)
  if (len > 0) {
    client->requests = strappend(client->requests, &(client->reqlen), temp, len);
  } else {
    if (debug) printerror(__FILE__,__LINE__);
    if (debug && client->isSSL) {
      switch(SSL_get_error(client->ssl_connection,len)){
        case SSL_ERROR_NONE:
        break;
        default:
        if (debug) printf("ssl error %d\n",len);
      }
    }
    /* there's nothing else we can do, the socket was closed under us. */
    return CLOSED;
  }

  if (debug) {
    printf("\n----------------\ngot request[%d] %d:\n",client->fd, client->reqlen);
    printf("%s",client->requests);
  }

  return STILL_ALIVE;

}

int loadheader(struct clientdata *client, struct requestinfo *request) {
  int len;
  char *token, *method, *uri, *httpver, *name, *value, *curr, *headerend;
  request->httpversion11 = 0;
  request->keepalive = 0;
  request->requesttype = REQUEST_UNFIN;
  /* if this is a full header, process it and return the result */
  headerend = strstr(client->requests, "\r\n\r\n");
  curr = client->requests;
  if (headerend != NULL) {
    // METHOD URI HTTPVERSION\r\n
    // EXPECT(METHOD)
    method = curr;
    // EXPECT(' ')
    token = strdiv(&curr, " \r\n");
    if (debug) printf("method is *%s*\n", method);
    if (token == NULL || *token != ' ') return request->requesttype = REQUEST_MALFORMED;
    if (method == NULL || strlen(method) == 0) return request->requesttype = REQUEST_MALFORMED;
    
    // EXPECT(URI)
    uri = curr;
    // EXPECT(' ')
    token = strdiv(&curr, " \r\n");
    if (debug) printf("uri is *%s*\n", uri);
    if (token == NULL || *token != ' ') return request->requesttype = REQUEST_MALFORMED;
    if (uri == NULL || strlen(uri) == 0) return request->requesttype = REQUEST_MALFORMED;

    // EXPECT(HTTPVERSION)
    httpver = curr;
    // EXPECT(\r)
    token = strdiv(&curr, " \r\n");
    if (debug) printf("httpver is *%s*\n", httpver);
    if (token == NULL || *token != '\r') return request->requesttype = REQUEST_MALFORMED;
    if (httpver == NULL || strlen(httpver) == 0) return request->requesttype = REQUEST_MALFORMED;
    // EXPECT(\n)
    if (*curr != '\n') return REQUEST_MALFORMED;
    curr++;
    
    if (debug) printf("method is %s, uri is %s, ver is %s\n", method, uri, httpver);

    if (strcmp(method, "GET") == 0) request->requesttype = REQUEST_GET;
    else if (strcmp(method, "HEAD") == 0) request->requesttype = REQUEST_HEAD;
    else return request->requesttype = REQUEST_UNSUP; // MAYBE

    request->URI = (char*)malloc(strlen(uri)+1);
    strcpy(request->URI, uri);

    if (strcmp(httpver, "HTTP/1.1") == 0) request->httpversion11 = 1;
    else return request->requesttype = REQUEST_BADVERSION;

    while(1) {
      // Name: Value\r\n OR \r\n
      // EXPECT(Name)
      name = curr;
      token = strdiv(&curr, ":\r\n");
      if (token == NULL) return request->requesttype = REQUEST_MALFORMED;
      // we have hope that this is the end of the header
      // EXPECT(name = "" && \r)
      if (name != NULL && strlen(name) == 0 && *token == '\r') {
        if (*curr != '\n') return request->requesttype = REQUEST_MALFORMED;
        if (debug) printf("**end of header**\n"); 
        len = (int)(headerend+4-client->requests);
        client->requests = strstrip(client->requests, &(client->reqlen), len);
        break;
      } 

      // else EXPECT(:)
      if (*token != ':') return request->requesttype = REQUEST_MALFORMED;
      // EXPECT(' ')
      if (*curr != ' ') return request->requesttype = REQUEST_MALFORMED;
      curr++;

      // EXPECT(Value)
      value = curr;
      token = strdiv(&curr, "\r\n");
      if (token == NULL || *token != '\r') return request->requesttype = REQUEST_MALFORMED;
      // EXPECT('\n')
      if (*curr != '\n') return request->requesttype = REQUEST_MALFORMED;
      curr++;

      if (strcmp(name, "Connection") == 0) {
        request->keepalive = (strcasecmp(value, "keep-alive")==0);
        if (debug) printf("keepalive is %d\n", request->keepalive);
      }
      if (strcmp(name, "Host") == 0) {
        request->host = (char*)malloc(strlen(value)+1);
        strcpy(request->host,value);
      }

      if (debug) printf("(%s,%s)\n", name, value);
    }
  } 
  return request->requesttype;
}