functor MLtonParallelSyncVar (signature WAITERS = sig
                                type 'a t
                                val none : 'a t
                                val map : ('a B.t -> work) -> t -> work list
                                val add : 'a t * 'a B.t -> 'a t
                              end) :> MLTON_PARALLEL_SYNCVAR 
  where type void = MLtonParallelBasic.void =
struct

  structure B = MLtonParallelBasic
  type void = B.void

  datatype 'a state =
      Waiting of t
    | Done of 'a

  type 'a t = int ref * 'a state ref

  val init = _import "Parallel_lockInit": int ref -> unit;
  val lock = _import "Parallel_lockTake": int ref -> unit;
  val unlock = _import "Parallel_lockRelease": int ref -> unit;

  fun empty () = 
      let
        val r = ref 0
      in
        init r;
        (r, ref (Waiting W.none))
      end

  fun write ((r, v), a) =
      case !v
       of Done _ => raise B.Parallel "two writes to sync var!"
        | Waiting _ =>
          let 
            (* First take the lock *)
            val () = lock r
            (* Now read the wait list *)
            val w = case !v 
                     of Waiting w => w
                      | Done _ => raise B.Parallel "async write to sync var!"
            val () = v := Done a
            val () = unlock r
          in
            (* Add readers to the queue *)
            (* XXX should use enableWork, not add/suspend *)

            B.suspend (fn _ => let in
                                 W.map (fn k => fn () => B.resume (k, a)) w
                               end)
(*
            app (fn k => ignore (B.addWork (fn () => B.resume (k, a)))) readers;
            B.return ()
*)
          end

  fun read (r, v) = 
      case !v 
       (* Do the easy case first *)
       of Done a => a
        (* Synchronization required... *)
        | Waiting _ =>
          let 
            (* Take the lock *)
            val () = lock r
          in
            (* Read again *)
            case !v
             of Done a => 
                (unlock r; a)
              | Waiting w =>
                B.suspend (fn k => (v := Waiting (W.add (k, w)); unlock r; []))
          end

end
