#include <stdio.h>
#include "seplog.h"

typedef struct list {
  struct list *n;
  struct list *b;
  int data;
} List;
typedef List *Listp;

Listp reverse(Listp l);
void print(Listp hd);

int main() {
  /* Static list elements */
  List a, b, c, d;

  /* Set up links */
  a.n = &b; b.n = &c; c.n = &d; d.n = 0;
  d.b = &c; c.b = &b; b.b = &a; a.b = 0;
  a.data = 1; b.data = 2; c.data = 3; d.data = 4;

  Listp hd = &a;
  print(hd);
  hd = reverse(hd);
  print(hd);

  return 0;
}

int simple() {
  int x = 3;

  if( x > 0 )
    x = -x;
  else
    x = x + 2;

  return x;
}

Listp create(int n) {
  Listp hd = 0, temp;

  while( n > 0 ) {
    temp = malloc(sizeof(List));
    temp->n = hd;
    temp->b = 0;
    if( hd !=  0 )
      hd->b = temp;
    hd = temp;
  }

  return hd;
}

Listp create2(int n) {
  Listp hd = 0, temp;

  while( n > 0 ) {
    temp = malloc(sizeof(List));
    temp->n = hd;
    if( hd != 0 )
      hd->b = temp;
    hd = temp;
  }
  if( hd != 0 )
    hd->b = 0;
  return hd;
}

void traverse(Listp l) {
  tassume("<?k:nat,?p:addr> dll(?k,null,l,?p,null)");
  
  while(l != 0)
    l = l->n;

  return;
}

Listp reverse(Listp l) {
  tassume("<?k:nat,?p:addr> dll(?k,null,l,?p,null)");

  Listp curr = l, prev = 0, next;
  while( curr != 0 ) {
    next = curr->n;
    curr->n = prev;
    if(prev != 0)
      prev->b = curr;
    prev = curr;
    curr = next;
  }
  if( prev != 0 )
    prev->b = 0;

  return prev;
}

Listp reverse2(Listp l) {
  tassume("<?k:nat,?p:addr> dll(?k,null,l,?p,null)");

  Listp curr = l, prev = 0, next;
  while( curr != 0 ) {
    next = curr->n;
    curr->n = prev;
    if(prev != 0)
      prev->b = curr;
    prev = curr;
    curr = next;
    prev->b = 0;
  }

  return prev;
}

Listp reverse2_bad(Listp l) {
  tassume("<?k:nat,?p:addr> dll(?k,null,l,?p,null)");

  Listp curr = l, prev = 0, next;
  while( curr != 0 ) {
    next = curr->n;
    curr->n = prev;
    if(prev != 0)
      prev->b = curr;
    prev = curr;
    curr = next;
    prev->b = 0;
    curr->b = 0;
  }

  return prev;
}

Listp reverse_badsafe(Listp l) {
  tassume("<?k:nat,?p:addr> dll(?k,null,l,?p,null)");

  Listp curr = l, prev = 0, next;
  while( curr != 0 ) {
    next = curr->n;
    curr->n = prev;
    if(prev != 0)
      prev->b = curr;
    prev = curr;
    /* curr = next; */
  }
  if( prev != 0 )
    prev->b = 0;

  return prev;
}

Listp reverse_bad(Listp l) {
  tassume("<?k:nat,?p:addr> dll(?k,null,l,?p,null)");

  Listp curr = l, prev = 0, next;
  while( curr != 0 ) {
    next = curr->n;
    curr->n = prev;
    /* if(prev != 0) */
      prev->b = curr;
    prev = curr;
    curr = next;
  }
  /*  if( prev != 0 ) */
    prev->b = 0;

  return prev;
}

Listp reverse_annot(Listp l) {
  tassume("<?k:nat,?p:addr> dll(?k,null,l,?p,null)");

  Listp curr = l, prev = 0, next;
  while( curr != 0 ) {
    tannot("<?k:nat, ?k2:nat,?s:addr,?r:addr,?p:addr> dll(?k,?s,prev,?r,null) * dll(?k2,prev,curr,?p,null) & curr <> null");
    next = curr->n;
    curr->n = prev;
    if(prev != 0)
      prev->b = curr;
    prev = curr;
    curr = next;
  }
  if( prev != 0 )
    prev->b = 0;

  return prev;
}

int eq(Listp l1, Listp l2, Listp l3) {
  tassume("<?k1:nat,?end1:addr,?k2:nat,?k3:nat,?end2:addr,?end3:addr> dll(?k1,null,l1,?end1,null) * dll(?k2,null,l2,?end2,null) * dll(?k3,null,l3,?end3,null)");
  int t1, t2;
  Listp hd = l1, n1;
  Listp prev = 0;

  while(l1 != 0) {
    if( l2 != 0 ) {
      t1 = l1->data;
      t2 = l2->data;
      if( t1 != t2 )
	return 0;
    }
    else return 0;
    if( l3 != 0 ) {
      t1 = l2->data;
      t2 = l3->data;
      if( t1 != t2 )
	return 0;
    }
    else return 0;
    l1 = l1->n;
    l2 = l2->n;
    l3 = l3->n;
  }
  return 1;
}

/* Should be unsafe since the precondition is missing a list. */
int eq_bad(Listp l1, Listp l2, Listp l3) {
  tassume("<?k1:nat,?end1:addr,?k2:nat,?k3:nat,?end2:addr,?end3:addr> dll(?k1,null,l1,?end1,null) * dll(?k2,null,l2,?end2,null)");
  int t1, t2;
  Listp hd = l1, n1;
  Listp prev = 0;

  while(l1 != 0) {
    if( l2 != 0 ) {
      t1 = l1->data;
      t2 = l2->data;
      if( t1 != t2 )
	return 0;
    }
    else return 0;
    if( l3 != 0 ) {
      t1 = l2->data;
      t2 = l3->data;
      if( t1 != t2 )
	return 0;
    }
    else return 0;
    l1 = l1->n;
    l2 = l2->n;
    l3 = l3->n;
  }
  return 1;
}

/* Fail to check pointer l3. */
int eq_bad2(Listp l1, Listp l2, Listp l3) {
  tassume("<?k1:nat,?end1:addr,?k2:nat,?k3:nat,?end2:addr,?end3:addr> dll(?k1,null,l1,?end1,null) * dll(?k2,null,l2,?end2,null) * dll(?k3,null,l3,?end3,null)");
  int t1, t2;
  Listp hd = l1, n1;
  Listp prev = 0;

  while(l1 != 0) {
    if( l2 != 0 ) {
      t1 = l1->data;
      t2 = l2->data;
      if( t1 != t2 )
	return 0;
    }
    else return 0;
    /*    if( l3 != 0 ) {*/
      t1 = l2->data;
      t2 = l3->data;
      if( t1 != t2 )
	return 0;
      /*    }
	    else return 0;*/
    l1 = l1->n;
    l2 = l2->n;
    l3 = l3->n;
  }
  return 1;
}

void below(Listp hd, int v) {
  tassume("<?k:nat, ?end:addr> dll(?k,null,hd,?end,null)");

  Listp next = 0, prev = 0;
  int tmp;
  while( hd != 0 ) {
    tmp = hd->data;
    if( tmp >= v ) {
      prev = hd->b;
      next = hd->n;
      /* remove this node */
      if( prev != 0 )
	prev->n = next;
      if( next != 0 )
	next->b = prev;
      free(hd);
      hd = next;
      next = 0;
      prev = 0;
      /* equivalent to:
	 hd->p->n = hd->n;
	 hd->n->p = hd->p; */
    }
    else
      hd = hd->n;
  }
  return;
}

void below_bad(Listp hd, int v) {
  tassume("<?k:nat, ?end:addr> dll(?k,null,hd,?end,null)");

  Listp next = 0, prev = 0;
  int tmp;
  while( hd != 0 ) {
    tmp = hd->data;
    if( tmp >= v ) {
      prev = hd->b;
      next = hd->n;
      /* remove this node */
      if( prev != 0 )
	prev->n = next;
      if( next != 0 )
	next->b = prev;
      hd = next;
      free(hd);
      next = 0;
      prev = 0;
      /* equivalent to:
	 hd->p->n = hd->n;
	 hd->n->p = hd->p; */
    }
    else
      hd = hd->n;
  }
  return;
}

void below2(Listp hd, int v) {
  tassume("<?k:nat, ?end:addr> dll(?k,null,hd,?end,null)");

  Listp next, prev;
  int tmp;
  while( hd != 0 ) {
    tmp = hd->data;
    if( tmp >= v ) {
      prev = hd->b;
      next = hd->n;
      /* remove this node */
      if( prev != 0 )
	prev->n = next;
      if( next != 0 )
	next->b = prev;
      free(hd);
      hd = next;
      /* equivalent to:
	 hd->p->n = hd->n;
	 hd->n->p = hd->p; */
    }
    else
      hd = hd->n;
  }
  return;
}

void partition(Listp hd, int v) {
  tassume("<?k:nat, ?end:addr> dll(?k,null,hd,?end,null)");

  Listp next = 0, prev = 0;
  int tmp;
  Listp curr = hd, less = 0, more = 0;

  hd = 0;
  while( curr != 0 ) {
    tmp = curr->data;
    if( tmp >= v ) {
      /* add to more */
      next = curr->n;
      curr->n = more;
      if( more != 0 )
	more->b = curr;
      more = curr;
      more->b = 0;
      curr = next;
    }
    else {
      /* add to less */
      next = curr->n;
      curr->n = less;
      if( less != 0 )
	less->b = curr;
      less = curr;
      less->b = 0;
      curr = next;
    }
    if( curr != 0 )
      curr->b = 0;
  }

  return;
}

void partition_lv(Listp hd, int v) {
  tassume("<?k:nat, ?end:addr> dll(?k,null,hd,?end,null)");

  Listp next = 0, prev = 0;
  int tmp;
  Listp curr = hd, less = 0, more = 0;

  hd = 0;
  while( curr != 0 ) {
    tmp = curr->data;
    if( tmp >= v ) {
      /* add to more */
      next = curr->n;
      curr->n = more;
      if( more != 0 )
	more->b = curr;
      more = curr;
      more->b = 0;
      curr = next;
    }
    else {
      /* add to less */
      next = curr->n;
      curr->n = less;
      if( less != 0 )
	less->b = curr;
      less = curr;
      less->b = 0;
      curr = next;
    }
    if( curr != 0 )
      curr->b = 0;
    next = 0;
  }

  return;
}

void print(Listp hd) {
  while( hd != 0 ) {
    printf("%d ",hd->data);
    hd = hd->n;
  }
  printf("\n");
  return;
}
