
import java.util.Vector;
import java.util.HashMap;
import javax.vecmath.*;

/**
 * Tubulin sets up a filament-like scenerio, where there is one type of Subunit
 * with a single Conformation and Domain and two binding sites. The initial
 * number of Subunits, and the binding and breaking times control the assembly
 * of Actin
 * 
 * @author Tiequan Zhang
 * @version 1.3
 *  
 */
public class Tubulin {
    

    //Initial number of Subunits are set here.
    private static int numSubunits = Test.numSubunits;

    private static int bsID = 0; //BindingSite ID

    private static int domainID = 0; //Domain ID

    private static int stID = 0; //SubunitType ID

    private static int suID = 0; //SubunitID

    //binding and breaking rates are set here:
    private double bindTime = Test.bindTime; //average time for a binding event

    private double breakTime = Test.breakTime; //average time for a breaking

    // event

//    private double fastbindtime = Test.fastbindtime; //not applicable in an

    // this simulation

    //private static double radius = Test.subunitRadius;

    private static Simulation sim;

    private static Solution soln;

    private static Vector assemblies;
    private static HashMap bindingPartner = new HashMap();

    /**
     * Constructs an Tubulin Simulation.
     *  
     */
    private static Vector bindingSiteTypes = new Vector();
    
    private static Vector subunitTypes = new Vector();
    
    public Tubulin() {
        soln = new Solution();
        initAssembly();

        double[] bindBreak = new double[3];
        bindBreak[0] = bindTime;
        bindBreak[1] = breakTime;
        bindBreak[2] = 0;
        
        double[] noBindBreak = new double[3];
        noBindBreak[0] = 99999999999999.0;
        noBindBreak[1] = 0.00000000000001;
        noBindBreak[2] = 99999999999999.0;

        HashMap bstaHashMap = new HashMap();
        bstaHashMap.put(new String("bsta"), noBindBreak);
        bstaHashMap.put(new String("bstb"), bindBreak);

        HashMap bstbHashMap = new HashMap();
        bstbHashMap.put(new String("bsta"), bindBreak);
        bstbHashMap.put(new String("bstb"),  noBindBreak);

        HashMap bondTime = new HashMap();
        bondTime.put(new String("bsta"), bstaHashMap);
        bondTime.put(new String("bstb"), bstaHashMap);

        HashMap conftimes = new HashMap();

        sim = new Simulation(soln, assemblies, 0.0, bondTime, conftimes,
                bindingPartner);
        
        sim.storeBindingSiteTypes(bindingSiteTypes);
        sim.storeSubunitTypes(subunitTypes);
    }
    public Tubulin(String xml) {
        
        soln = new Solution();
        XMLParser test = new XMLParser(Test.mode);
        assemblies = new Vector();
        test.setBindingSiteTypes();
        test.setAssemblies(assemblies, soln);
        test.setTransitionTime(soln, assemblies);
     
        sim = test.sim;
    }

    /**
     * Returns Simulation of Tubulin
     * 
     * @return Simulation
     */
    public static Simulation getSim() {
        return sim;
    }

    /**
     * 
     * Creates all Subunits with appropriate bsID, domainID, ConformationID and
     * stID. Adds all Assembly to Vector Assemblies
     *  
     */
    private static void initAssembly() {
        assemblies = new Vector();

        //Creates two BindingSiteType objects with ID 0 and 1
        double[] tolerances = { 0.2, 0.1, 0.1 };
        Vector partnersa = new Vector();
        Vector partnersb = new Vector();
        partnersa.add("bstb");
        BindingSiteType bsta = new BindingSiteType(tolerances, "bsta",
                partnersa);
        bsta.setBindingAngle("bstb", -0.21821085074178506);
        
        partnersb.add("bsta");
        BindingSiteType bstb = new BindingSiteType(tolerances, "bstb",
                partnersb);
        bstb.setBindingAngle("bsta", -0.21821085074178506);
        bindingPartner.put("bsta", partnersa);
        bindingPartner.put("bstb", partnersb);

        
        bindingSiteTypes.add(bsta);
        bindingSiteTypes.add(bstb);
        
        //The radius of a sphere is 0.08, and the center( half of the distance
        // from tip to base)
        //of a cone is 0.05, 13 subunit will form a turn
        /*Vector3d posD1 = new Vector3d(-0.12624512 * 0.102 / 0.13,
                0.03101886 * 0.1 / 0.13, 0);*///get from radius
        Vector3d posD1=new Vector3d(-0.9905386338461536*Test.bindingSiteHeight,0.23860661538461538*Test.bindingSiteHeight,0*Test.bindingSiteHeight);
      
        Quat4d orD1 = new Quat4d(0, 0, 0.6170062, 0.7869583);

        Vector3d posD2 = new Vector3d(0.9711163076923075*Test.bindingSiteHeight,0.24337874769230765*Test.bindingSiteHeight,0*Test.bindingSiteHeight);
        
        Quat4d orD2 = new Quat4d(0, 0, -0.6170062, 0.7869583);
        boolean subunitTypeNotSeen=true;
        double subunitRadius=Test.subunitToBS*Test.bindingSiteHeight;
        
        //loop for making subunittypes
        Vector subts = new Vector();
        for (int i = 0; i < numSubunits; i++) {
            String asmname = "assem" + i;
            BindingSite bsa = new BindingSite(bsta, bsID++, domainID, suID,
                    asmname, posD1, orD1,"bsa");
            BindingSite bsb = new BindingSite(bstb, bsID++, domainID, suID,
                    asmname, posD2, orD2, "bsb");
            bsa.colorYellow();
            bsb.colorGreen();
            /**
             * Adds two BindingSites of one Subunit to Vector bss to create
             * Conformation
             */
            Vector bss = new Vector();
            bss.add(bsa);
            bss.add(bsb);

            /**
             * Adds one Conformation of a Subunit to Vector confs to create
             * Domain
             */
            Vector confs = new Vector();
            Conformation conf = new Conformation(bss, 6.6, "subt1only");
            confs.add(conf);

            /**
             * Adds one Domain of a Subunit to Vector Confsets to create
             * SubunitType
             */
            Domain dom = new Domain("only", confs, new Vector3d(), domainID,
                    conf);
            Vector doms = new Vector();
            doms.add(dom);
            
            SubunitType subType = new SubunitType(doms, "only", soln, 3.4,subunitRadius );
           
            subType.storeUpVec(new Vector3d(1,1,1));
            if (subunitTypeNotSeen) {
                subunitTypes.add(subType);
                subunitTypeNotSeen = false;
            }
            

            /**
             * set initial position, rotation, velocity, and rotational velocity
             */
            Vector3d sPos = new Vector3d(0, 0, 0);
            Quat4d sRot = new Quat4d(0.0, 0.0, 0.0, 1.0);
            Vector3d sVel = new Vector3d();
            Quat4d srVel = new Quat4d(0.0, 0.0, 0.0, 1.0);

            Subunit subunit = new Subunit(subType, doms, soln, suID++, sPos, sRot,
                    sVel, srVel);
            Vector assemblySubunits = new Vector();
            assemblySubunits.add(subunit);
            Assembly asm = new Assembly(assemblySubunits, asmname);

            assemblies.add(asm);
        }

    }

}