
import java.applet.Applet;
import javax.swing.*;
import java.util.Random;

/**
 * Test class starts self-simulation simulation and lists important parameters.
 * 
 * @author Rori Rohlfs
 * @author Tiequan Zhang
 * @author Blake Sweeney
 * @version 1.3
 */
public class Test extends Applet {
    //for diffsion model
    static boolean diffusionEnabled = false;

    //only sample breaking event for bonds not involving a loop
    static boolean noLoopOnly = false;

    //Allow multimers bind with monomers only
    static boolean bindMonomerOnly = false;

    //  For filament assembly, allow mutlimers break off only monomer
    static boolean breakOnlyEnds = false;

    //For virus,tetrahedron,cube assembly, when an FormbondEvent is processed
    // and other possible bindings could occur, those new formed bonds will
    // become pink-colored
    static boolean displayFastBinding = false;

    //Show the box on the border of the simulation panel
    static boolean showBorder = true;

    //simulator panel background color option, for better print
    static boolean grey = false;

    //output system state at some intervals
    static boolean stepPrint = true;

    //display the simulation scene or run it on background and exit when
    // simulation is done
    static boolean displaySim = true;

    //use the dislog panel to set up the parameters or use the default values
    static boolean loadDialogEnabled = false;

    //enable conformational switching event sampling
    static boolean csAllowed = false;

    //use XML template to start the simulation or not
    static boolean xmlInput = false;

    static double bindTime = 1; //average time for a binding event

    static double breakTime = 0.01; //0.001average time for a breaking event

    static double bindTimeC = 1;//average time for binding pentamer and

    // pentamer in virus assembly
    static double breakTimeC = 10000;//average time for breaking bond between

    // pentamer and pentamer in virus assembly
    //  average time for a binging event when unbinding breaks a loop
    //not in use right now
    static double fastbindtime = 1e-10;

    //Conformation switching rate
    static double bindToNoneTime = 1.0;

    static double noneToBindTime = 1.0;

    static double binSize = 0.05 * 0.1;

    static double tipScale = 0.13 / 0.08;

    static double distanceTolerance = 0.005;

    //This ratio should be <=0.5
    static double subunitToBS = 0.5;

    static float bindingSiteHeight = 0.10f;

    //Default debugging level
    static int debuggingLevel = 1000;

    static int events_per_printout = 1000;

    static int sizeOfSubunit = 1;

    static int numSubunits = 100;

    //for T=7 usage
    static int pentamerNumber = 120;

    static int hexamerNumber = 600;

    //Number of steps run in a simulation
    static int iterations_per_run = 5000;

    static int[] outputSize;

    //  Maximum allowed assembly size
    static int maxLength = 180;

    // Maximum size for which distribution statistics are printed
    static int maxSize = 12;

    static String mode = "xmlinput";

    //  actin,tubulin,tetrahedron,cube or virus,tseven,tthree
    //static String simChoice = "dodecahedron";
    //    static String simChoice = "cube";
    //static String simChoice = "tsevensimple";
    //static String simChoice = "virus";
    //    static String simChoice = "tthree";

    static String simChoice = "tetrahedron";

    //static String simChoice = "tubulin";
    //static String simChoice = "actin";
    static Random rand;

    /**
     * main method to start the simulator
     */
    public static void main(String args[]) {

        /**
         * If user doesn't specify any parameter , program will not give any
         * debugging information by default. The larger the debuggingLevel is ,
         * the less important the debugging information will be. DebuggingLevel
         * will be used in Debug.java
         */
        //specify the amount of what sizes of reactants will be displyed for
        // analysis
        outputSize = new int[maxSize];
        for (int i = 0; i < maxSize; i++) {
            outputSize[i] = i + 1;
        }

        rand = new Random(1);
        if (args.length == 0)

        {
            System.out
                    .println("Usage: java Test Simulation_Graphics_Enabled(0/1) Dialog_enabled(0/1) [XML input file]");
            System.exit(0);
        } else if (args.length == 1) {
            loadDialogEnabled = false;
            xmlInput = false;
            if (Integer.parseInt(args[0]) == 0) {
                displaySim = false;
            } else {
                displaySim = true;

            }

        } else if (args.length == 2) {
            xmlInput = false;
            if (Integer.parseInt(args[0]) == 0) {
                displaySim = false;
            } else {
                displaySim = true;
            }
            if (Integer.parseInt(args[1]) == 0) {
                loadDialogEnabled = false;
            } else {
                loadDialogEnabled = true;
            }
        } else if (args.length == 3) {
            xmlInput = true;
            mode = args[2];
            loadDialogEnabled = false;
            if (Integer.parseInt(args[0]) == 0) {
                displaySim = false;
            } else {
                displaySim = true;
            }
        }

        if (loadDialogEnabled) {
            LoadDialog load = new LoadDialog();
        } else {
            MainFrame m = new MainFrame("Self-assembly Simulation (Dessa 1.3)");
            m.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
            m.pack();
            m.setVisible(true);

        }

    }
}