
import java.util.Vector;
import java.util.HashMap;
import javax.vecmath.*;

/**
 * Dodecahedron sets up a viral truncated-Icosahedron-like Simulation, where
 * there is one type of Subunit with a single Conformation and Domain and three
 * binding sites arranged at angles of 120, 120, and 109 degrees apart (allowing
 * an Dodecahedron-shaped superstructure). The initial number of Subunits, and
 * the binding and breaking times control the assembly of Dodecahedron
 * 
 * @author Tiequan Zhang
 * @author Rori Rohlfs
 * @version 1.3
 */

public class TThree{
    private static Simulation sim;

    private static Solution soln;

    private static Vector assemblies;

    private static int bsid = 0; //BindingSite ID

    private static int domainID = 0; //Domain ID

    private static int stid = 0; //SubunitType ID
    private static double subunitRadius=Test.subunitToBS*Test.bindingSiteHeight;
//private static double subRadius=0.08;
 private static int suid = 0; //Subunit ID

    //binding and breaking rates set here:
    //average time for a binding event between two compatible BindingSites
    private double bindTime = Test.bindTime;

    //average time for a breaking event between two compatible BindingSites
    private double breakTime = Test.breakTime;

    //  average time for enabling binding ability
    private double bindToNoneTime = Test.bindToNoneTime;

    //  average time for disabling binding ability
    private double noneToBindTime = Test.noneToBindTime;

    //average time for a bonding event between two compatible BindingSites,
    //positioned to bind, in the same Assembly
    private double fastbindTime = Test.fastbindtime;

    private double bindTimeC = Test.bindTimeC;

    private double breakTimeC = Test.breakTimeC;

    //Initial number of Subunits are set here.
    private static int numSubunits = Test.numSubunits;

    private static HashMap bindingPartner = new HashMap();

    
    private static Vector bindingSiteTypes = new Vector();

    private static Vector subunitTypes = new Vector();

    
    
    public TThree() {
    	
        soln = new Solution();
        initAssembly();

        //now need to use "last" simulation constructor so it works
        double[] bindBreak1 = new double[3];
        bindBreak1[0] = bindTime;
        bindBreak1[1] = breakTime;
        bindBreak1[2] = fastbindTime;
        /*double[] bindBreak2 = new double[3];
        bindBreak2[0] = bindTime;
        bindBreak2[1] = breakTime;
        bindBreak2[2] = fastbindTime;
        double[] bindBreak3 = new double[3];
        bindBreak3[0] = bindTime;
        bindBreak3[1] = breakTime;
        bindBreak3[2] = fastbindTime;*/
        double[] noBindBreak = new double[3];
        noBindBreak[0] = 99999999999999.0;
        noBindBreak[1] = 0.00000000000001;
        noBindBreak[2] = 99999999999999.0;

        HashMap bst1ahash = new HashMap();
        bst1ahash.put(new String("bst1b"), bindBreak1);
        HashMap bst1bhash = new HashMap();
        bst1bhash.put(new String("bst1a"), bindBreak1);
        HashMap bst1chash = new HashMap();
        bst1chash.put(new String("bst2c"), bindBreak1);
        
        HashMap bst2ahash = new HashMap();
        bst2ahash.put(new String("bst3b"), bindBreak1);
        HashMap bst2bhash = new HashMap();
        bst2bhash.put(new String("bst3a"), bindBreak1);
        HashMap bst2chash = new HashMap();
        bst2chash.put(new String("bst1c"), bindBreak1);
        
        HashMap bst3ahash = new HashMap();
        bst3ahash.put(new String("bst2b"), bindBreak1);
        HashMap bst3bhash = new HashMap();
        bst3bhash.put(new String("bst2a"), bindBreak1);
        HashMap bst3chash = new HashMap();
        bst3chash.put(new String("bst3c"), bindBreak1);
        
        
        
       

        HashMap bondtimes = new HashMap();
        bondtimes.put(new String("bst1a"), bst1ahash);
        bondtimes.put(new String("bst1b"), bst1bhash);
        bondtimes.put(new String("bst1c"), bst1chash);

        bondtimes.put(new String("bst2a"), bst2ahash);
        bondtimes.put(new String("bst2b"), bst2bhash);
        bondtimes.put(new String("bst2c"), bst2chash);

        bondtimes.put(new String("bst3a"), bst3ahash);
        bondtimes.put(new String("bst3b"), bst3bhash);
        bondtimes.put(new String("bst3c"), bst3chash);

        HashMap bsMap = new HashMap(), noneMap = new HashMap();
        bsMap.put("none", new Double(bindToNoneTime));
        noneMap.put("bs", new Double(noneToBindTime));

        HashMap conftimes = new HashMap();
        conftimes.put("bs", bsMap);
        conftimes.put("none", noneMap);
       

        sim = new Simulation(soln, assemblies, 0.0, bondtimes, conftimes,
                bindingPartner);
        sim.storeBindingSiteTypes(bindingSiteTypes);
        sim.storeSubunitTypes(subunitTypes);
    }
    public TThree(String xml) {
        
        soln = new Solution();

        XMLParser test = new XMLParser(Test.mode);
        assemblies = new Vector();
        test.setBindingSiteTypes();
        test.setAssemblies(assemblies, soln);
        test.setTransitionTime(soln, assemblies);
     
        sim = test.sim;
        
    }
    /**
     * Returns Simulation of Dodecahedron
     * 
     * @return Simulation
     *  
     */
    public static Simulation getSim() {
        return sim;
    }

    /**
     * Creates all Subunits with appropriate bsID, domainID, ConformationID and
     * stID. Adds all Assemblies to Vector assemblies (which is later used in
     * the Simulation construction)
     */
    private static void initAssembly() {
        assemblies = new Vector();

        //bindingsitetype definitions
        double[] tolerances = { 0.2, 0.1, 0.1 };
        
        
        
        
        Vector partners1a = new Vector();
        Vector partners1b = new Vector();
        Vector partners1c = new Vector();
        Vector partners2a = new Vector();
        Vector partners2b = new Vector();
        Vector partners2c = new Vector();
        Vector partners3a = new Vector();
        Vector partners3b = new Vector();
        Vector partners3c = new Vector();
        
        
        partners1a.add("bst1b");
        
        partners1b.add("bst1a");
        partners1c.add("bst2c");
        partners2a.add("bst3b");
        partners2b.add("bst3a");
        partners2c.add("bst1c");
        partners3a.add("bst2b");
        partners3b.add("bst2a");
        partners3c.add("bst3c");
       
        bindingPartner.put("bst1a",partners1a);
        bindingPartner.put("bst1b",partners1b);
        bindingPartner.put("bst1c",partners1c);
        bindingPartner.put("bst2a",partners2a);
        bindingPartner.put("bst2b",partners2b);
        bindingPartner.put("bst2c",partners2c);
        bindingPartner.put("bst3a",partners3a);
        bindingPartner.put("bst3b",partners3b);
        bindingPartner.put("bst3c",partners3c);
        BindingSiteType bst1a = new BindingSiteType(tolerances, "bst1a",
                partners1a);
        bst1a.setBindingAngle("bst1b", 0.7317400039255287);
        
        BindingSiteType bst1b = new BindingSiteType(tolerances, "bst1b",
                partners1b);
        bst1b.setBindingAngle("bst1a", 0.731740039255291);
        
        BindingSiteType bst1c = new BindingSiteType(tolerances, "bst1c",
                partners1c);
        bst1c.setBindingAngle("bst2c", -2.1707759346337347);
        
        BindingSiteType bst2a = new BindingSiteType(tolerances, "bst2a",
                partners2a);
        bst2a.setBindingAngle("bst3b", 0.5880026035475673);
        
        BindingSiteType bst2b = new BindingSiteType(tolerances, "bst2b",
                partners2b);
        bst2b.setBindingAngle("bst3a", 0.5880026035475673);
        
        BindingSiteType bst2c = new BindingSiteType(tolerances, "bst2c",
                partners2c);
        bst2c.setBindingAngle("bst1c", -2.1707759346337347);
        
        BindingSiteType bst3a = new BindingSiteType(tolerances, "bst3a",
                partners3a);
        bst3a.setBindingAngle("bst2b", 0.5880026035475673);
        
        BindingSiteType bst3b = new BindingSiteType(tolerances, "bst3b",
                partners3b);       
        bst3b.setBindingAngle("bst2a", 0.5880026035475673);
                
        BindingSiteType bst3c = new BindingSiteType(tolerances, "bst3c",
                partners3c);
        bst3c.setBindingAngle("bst3c", -2.0944486642723037);
        
        
       

        bindingSiteTypes.add(bst1a);
        bindingSiteTypes.add(bst1b);
        bindingSiteTypes.add(bst1c);

        bindingSiteTypes.add(bst2a);
        bindingSiteTypes.add(bst2b);
        bindingSiteTypes.add(bst2c);

        bindingSiteTypes.add(bst3a);
        bindingSiteTypes.add(bst3b);
        bindingSiteTypes.add(bst3c);

        Vector3d position1a = new Vector3d(-Math.sin(0.3 * Math.PI) * Test.bindingSiteHeight, -Math
                .cos(0.3 * Math.PI) * Test.bindingSiteHeight, 0.0* Test.bindingSiteHeight);
       
        AxisAngle4d AxisAngle1a = new AxisAngle4d(0.0, 0.0, 1.0, 0.7*Math.PI);
        Quat4d rotation1a = new Quat4d();
        rotation1a.set(AxisAngle1a);
        
        Vector3d position1b = new Vector3d(Math.sin(0.3 * Math.PI) * Test.bindingSiteHeight, -Math
                .cos(0.3 * Math.PI) * Test.bindingSiteHeight, 0.0* Test.bindingSiteHeight);
        
        AxisAngle4d axisAngle1b = new AxisAngle4d(0.0, 0.0, 1.0, -0.7* Math.PI);
        Quat4d rotation1b = new Quat4d();
        rotation1b.set(axisAngle1b);
        
        
      
        Vector3d position1c = new Vector3d(0* Test.bindingSiteHeight,0.7946460767341719* Test.bindingSiteHeight, 0.6070729879767247* Test.bindingSiteHeight);
          
          AxisAngle4d axisAngle1c = new AxisAngle4d(1.0, 0.0, 0.0, Math.acos(0.7946460767341719));
                          Quat4d rotation1c = new Quat4d();
        rotation1c.set(axisAngle1c);
                
        
        
        
   Vector3d position2a = new Vector3d(-Math.sin(120/180.0*0.5 * Math.PI) * Test.bindingSiteHeight, -Math
                .cos(120/180.0*0.5 * Math.PI) * Test.bindingSiteHeight, 0.0* Test.bindingSiteHeight);
       
        AxisAngle4d axisAngle2a = new AxisAngle4d(0.0, 0.0, 1.0, (1-120/360.0)*Math.PI);

        Quat4d rotation2a = new Quat4d();
        rotation2a.set(axisAngle2a);
        
         
        Vector3d position2b = new Vector3d(Math.sin(120/180.0*0.5 * Math.PI) * Test.bindingSiteHeight, -Math
                .cos(120/180.0*0.5 * Math.PI) * Test.bindingSiteHeight, 0.0* Test.bindingSiteHeight);
        
        AxisAngle4d axisAngle2b = new AxisAngle4d(0.0, 0.0, 1.0, (120/360.0-1)*Math.PI);
        Quat4d rotation2b = new Quat4d();
        rotation2b.set(axisAngle2b);
       
      
        Vector3d position2c = new Vector3d(0* Test.bindingSiteHeight,1* Test.bindingSiteHeight, 0* Test.bindingSiteHeight);
        AxisAngle4d axisAngle2c = new AxisAngle4d(1.0, 0.0, 0.0, 0);
        Quat4d rotation2c = new Quat4d();
        rotation2c.set(axisAngle2c);
     
        Vector3d position3a = new Vector3d(-Math.sin(120/180.0*0.5 * Math.PI)* Test.bindingSiteHeight, -Math
                .cos(120/180.0*0.5 * Math.PI) * Test.bindingSiteHeight, 0.0* Test.bindingSiteHeight);
       
        AxisAngle4d axisAngle3a = new AxisAngle4d(0.0, 0.0, 1.0, (1-120/360.0)*Math.PI);
        
        Quat4d rotation3a = new Quat4d();
        rotation3a.set(axisAngle3a);
      
        Vector3d position3b = new Vector3d(Math.sin(120/180.0*0.5 * Math.PI) * Test.bindingSiteHeight, -Math
                .cos(120/180.0*0.5 * Math.PI) * Test.bindingSiteHeight, 0.0* Test.bindingSiteHeight);
        
        AxisAngle4d axisAngle3b = new AxisAngle4d(0.0, 0.0, 1.0, (120/360.0-1)*Math.PI);
        
        Quat4d rotation3b = new Quat4d();
        rotation3b.set(axisAngle3b);
        
      
    
        Vector3d position3c = new Vector3d(0* Test.bindingSiteHeight,0.934162489392838* Test.bindingSiteHeight, .35684792757051993575* Test.bindingSiteHeight);
        AxisAngle4d axisAngle3c = new AxisAngle4d(1.0, 0.0, 0.0, Math.acos(0.934162489392838));
        
        Quat4d rotation3c = new Quat4d();
        rotation3c.set(axisAngle3c);
  
        
//loop for making subunittypes
        
        boolean subunitTypeNotSeen = true;
        
        for (int i = 0; i < numSubunits/3; i++) {
            String asmname1 = "assem" + 3*i;
            String asmname2 = "assem" + (3*i+1);
            String asmname3 = "assem" + (3*i+2);
            BindingSite bs1a = new BindingSite(bst1a, bsid++, domainID, suid,
                    asmname1, position1a, rotation1a,  "bs1a");
            BindingSite bs1b = new BindingSite(bst1b, bsid++, domainID, suid,
                    asmname1, position1b, rotation1b, "bs1b");
            BindingSite bs1c = new BindingSite(bst1c, bsid++, domainID, suid,
                    asmname1, position1c, rotation1c, "bs1c");
            suid++;
            BindingSite bs2a = new BindingSite(bst2a, bsid++, domainID, suid,
                    asmname2, position2a, rotation2a, "bs2a");
            BindingSite bs2b = new BindingSite(bst2b, bsid++, domainID, suid,
                    asmname2, position2b, rotation2b, "bs2b");
            BindingSite bs2c = new BindingSite(bst2c, bsid++, domainID, suid,
                    asmname2, position2c, rotation2c, "bs2c");
            suid++;
            BindingSite bs3a = new BindingSite(bst3a, bsid++, domainID, suid,
                    asmname3, position3a, rotation3a, "bs3a");
            BindingSite bs3b = new BindingSite(bst3b, bsid++, domainID, suid,
                    asmname3, position3b, rotation3b, "bs3b");
            BindingSite bs3c = new BindingSite(bst3c, bsid++, domainID, suid,
                    asmname3, position3c, rotation3c, "bs3c");
         suid = suid -2;
            
          
            
            
            bs1b.colorBlue();
            bs1a.colorYellow();
            bs2a.colorYellow();
            bs2b.colorBlue();
            //bs2c.colorBlue();
            bs3b.colorBlue();
            bs3a.colorYellow();
           

            Vector bss1 = new Vector();
            Vector bss2 = new Vector();
            Vector bss3 = new Vector();
            bss1.add(bs1a);
            bss1.add(bs1b);
            bss1.add(bs1c);
            bss2.add(bs2a);
            bss2.add(bs2b);
            bss2.add(bs2c);
            bss3.add(bs3a);
            bss3.add(bs3b);
            bss3.add(bs3c);
            /**
             * Adds one Conformation of a Subunit to Vector confs to create
             * Domain
             */
            Vector confs1 = new Vector(); //vector of conformations for the 1
            // domain
            Conformation bsConf1 = new Conformation(bss1, 6.6, "bs");
            Conformation nonBsConf1 = new Conformation(new Vector(), 6.6, "none");
            confs1.add(bsConf1);
            confs1.add(nonBsConf1);

            /**
             * Adds one Domain of a Subunit to Vector Confsets to create
             * SubunitType
             */
            Domain dom1 = new Domain("only", confs1, new Vector3d(), domainID,
                    bsConf1);
            if (Test.csAllowed) {
                dom1 = new Domain("only", confs1, new Vector3d(), domainID,
                        nonBsConf1);
            }
            Vector doms1 = new Vector();
            doms1.add(dom1);
            SubunitType subt1 = new SubunitType(doms1, "only1", soln, 3.4, subunitRadius);
            subt1.storeUpVec(new Vector3d(1,1,1));

            /**
             * set initial position, rotation, velocity, and rotational velocity
             */
            Vector3d sPos = new Vector3d();
            Quat4d sRot = new Quat4d(0.0, 0.0, 0.0, 1.0);
            Vector3d sVel = new Vector3d();
            Quat4d srVel = new Quat4d(0.0, 0.0, 0.0, 1.0);

            Subunit subunit1 = new Subunit(subt1, doms1, soln, suid++, sPos, sRot,
                    sVel, srVel);
            Vector asmsubs1 = new Vector();
            asmsubs1.add(subunit1);
            Assembly asm1 = new Assembly(asmsubs1, asmname1);
            
            Vector confs2 = new Vector(); //vector of conformations for the 1
            // domain
            Conformation bsConf2 = new Conformation(bss2, 6.6, "bs");
            Conformation nonBsConf2 = new Conformation(new Vector(), 6.6, "none");
            confs2.add(bsConf2);
            confs2.add(nonBsConf2);

            /**
             * Adds one Domain of a Subunit to Vector Confsets to create
             * SubunitType
             */
            Domain dom2 = new Domain("only", confs2, new Vector3d(), domainID,
                    bsConf2);
            if (Test.csAllowed) {
                dom2 = new Domain("only", confs2, new Vector3d(), domainID,
                        nonBsConf2);
            }
            Vector doms2 = new Vector();
            doms2.add(dom2);
            SubunitType subt2 = new SubunitType(doms2, "only2", soln, 3.4, subunitRadius);
            subt2.storeUpVec(new Vector3d(1,1,1));

            /**
             * set initial position, rotation, velocity, and rotational velocity
             */
            Vector3d sPos2 = new Vector3d();
            Quat4d sRot2 = new Quat4d(0.0, 0.0, 0.0, 1.0);
            Vector3d sVel2 = new Vector3d();
            Quat4d srVel2 = new Quat4d(0.0, 0.0, 0.0, 1.0);

            Subunit subunit2 = new Subunit(subt2, doms2, soln, suid++, sPos2, sRot2,
                    sVel2, srVel2);
            Vector asmsubs2 = new Vector();
            asmsubs2.add(subunit2);
            Assembly asm2 = new Assembly(asmsubs2, asmname2);
            
            
            Vector confs3 = new Vector(); //vector of conformations for the 1
            // domain
            Conformation bsConf3 = new Conformation(bss3, 6.6, "bs");
            Conformation nonBsConf3 = new Conformation(new Vector(), 6.6, "none");
            confs3.add(bsConf3);
            confs3.add(nonBsConf3);

            /**
             * Adds one Domain of a Subunit to Vector Confsets to create
             * SubunitType
             */
            Domain dom3 = new Domain("only", confs3, new Vector3d(), domainID,
                    bsConf3);
            if (Test.csAllowed) {
                dom3 = new Domain("only", confs3, new Vector3d(), domainID,
                        nonBsConf3);
            }
            Vector doms3 = new Vector();
            doms3.add(dom3);
            SubunitType subt3 = new SubunitType(doms3, "only3", soln, 3.4, subunitRadius);
            subt3.storeUpVec(new Vector3d(1,1,1));

            /**
             * set initial position, rotation, velocity, and rotational velocity
             */
            Vector3d sPos3 = new Vector3d();
            Quat4d sRot3 = new Quat4d(0.0, 0.0, 0.0, 1.0);
            Vector3d sVel3 = new Vector3d();
            Quat4d srVel3 = new Quat4d(0.0, 0.0, 0.0, 1.0);

            Subunit subunit3 = new Subunit(subt3, doms3, soln, suid++, sPos3, sRot3,
                    sVel3, srVel3);
            Vector asmsubs3 = new Vector();
            asmsubs3.add(subunit3);
            Assembly asm3 = new Assembly(asmsubs3, asmname3);
            subunit1.colorBlue();
            subunit3.colorYellow();
            
            if(subunitTypeNotSeen)
            {
            	subunitTypes.add(subt1);
            	subunitTypes.add(subt2);
            	subunitTypes.add(subt3);
            	subunitTypeNotSeen = false;
            }
          //  System.out.println("ndjfsj: "+asm1.getName()+ " "+suid);
           assemblies.add(asm1);
          assemblies.add(asm2);
            assemblies.add(asm3);
        }
    }
}