
import java.util.Vector;
import java.util.HashMap;
import javax.vecmath.*;

/**
 * Dodecahedron sets up a viral truncated-Icosahedron-like Simulation, where
 * there is one type of Subunit with a single Conformation and Domain and three
 * binding sites arranged at angles of 120, 120, and 109 degrees apart (allowing
 * an Dodecahedron-shaped superstructure). The initial number of Subunits, and
 * the binding and breaking times control the assembly of Dodecahedron
 * 
 * @author Tiequan Zhang
 * @author Rori Rohlfs
 * @version 1.3
 */

public class TSevenSimple {
    private static Simulation sim;

    private static Solution soln;

    private static Vector assemblies;

    private static int bsid = 0; //BindingSite ID

    private static int domainID = 0; //Domain ID

    private static int stid = 0; //SubunitType ID

    private static double subRadius = 0.08;

 

    private static int suid = 0; //Subunit ID

    //binding and breaking rates set here:
    //average time for a binding event between two compatible BindingSites
    private double bindTime = Test.bindTime;

    //average time for a breaking event between two compatible BindingSites
    private double breakTime = Test.breakTime;

    //  average time for enabling binding ability
    private double bindToNoneTime = Test.bindToNoneTime;

    //  average time for disabling binding ability
    private double noneToBindTime = Test.noneToBindTime;

    //average time for a bonding event between two compatible BindingSites,
    //positioned to bind, in the same Assembly
    private double fastbindTime = Test.fastbindtime;

    private double bindTimeC = Test.bindTimeC;

    private double breakTimeC = Test.breakTimeC;

    //Initial number of Subunits are set here.
    private static int numSubunits = Test.numSubunits;

    private static HashMap bindingPartner = new HashMap();

    private static Vector bindingSiteTypes = new Vector();

    private static Vector subunitTypes = new Vector();

    
    public TSevenSimple() {
        soln = new Solution();
        initAssembly();

        //now need to use "last" simulation constructor so it works
        double[] bindbreak1 = new double[3];
        bindbreak1[0] = bindTime;
        bindbreak1[1] = 1000 * breakTime;
        bindbreak1[2] = fastbindTime;
        double[] bindbreak2 = new double[3];
        bindbreak2[0] = bindTime;
        bindbreak2[1] = 1000 * breakTime;
        bindbreak2[2] = fastbindTime;
        double[] bindbreak3 = new double[3];
        bindbreak3[0] = bindTimeC;
        bindbreak3[1] = breakTimeC;
        bindbreak3[2] = fastbindTime;
        double[] noBindBreak = new double[3];
        noBindBreak[0] = 99999999999999.0;
        noBindBreak[1] = 0.00000000000001;
        noBindBreak[2] = 99999999999999.0;

        HashMap bstpahash = new HashMap();
        bstpahash.put(new String("bstha"), bindbreak1);        
        HashMap bstpbhash = new HashMap();
        bstpbhash.put(new String("bstha"), bindbreak1);
        HashMap bstpchash = new HashMap();
        bstpchash.put(new String("bstha"), bindbreak1);
        HashMap bstpdhash = new HashMap();
        bstpdhash.put(new String("bstha"), bindbreak1);
        HashMap bstpehash = new HashMap();
        bstpehash.put(new String("bstha"), bindbreak1);

        HashMap bsthahash = new HashMap();
        bsthahash.put(new String("bstpa"), bindbreak1);
        bsthahash.put(new String("bstpb"), bindbreak1);
        bsthahash.put(new String("bstpc"), bindbreak1);
        bsthahash.put(new String("bstpd"), bindbreak1);
        bsthahash.put(new String("bstpe"), bindbreak1);

        HashMap bsthbhash = new HashMap();
        bsthbhash.put(new String("bsthf"), bindbreak2);
        HashMap bsthchash = new HashMap();
        bsthchash.put(new String("bsthd"), bindbreak2);
        HashMap bsthdhash = new HashMap();
        bsthdhash.put(new String("bsthc"), bindbreak2);
        HashMap bsthehash = new HashMap();
        bsthehash.put(new String("bsthe"), bindbreak2);
        HashMap bsthfhash = new HashMap();
        bsthfhash.put(new String("bsthb"), bindbreak2);

        HashMap bondtimes = new HashMap();
        bondtimes.put(new String("bstpa"), bstpahash);
        bondtimes.put(new String("bstpb"), bstpbhash);
        bondtimes.put(new String("bstpc"), bstpchash);
        bondtimes.put(new String("bstpd"), bstpdhash);
        bondtimes.put(new String("bstpe"), bstpehash);

        bondtimes.put(new String("bstha"), bsthahash);
        bondtimes.put(new String("bsthb"), bsthbhash);
        bondtimes.put(new String("bsthc"), bsthchash);
        bondtimes.put(new String("bsthd"), bsthdhash);
        bondtimes.put(new String("bsthe"), bsthehash);
        bondtimes.put(new String("bsthf"), bsthfhash);

        HashMap bsMap = new HashMap(), noneMap = new HashMap();
        bsMap.put("none", new Double(bindToNoneTime));
        noneMap.put("bs", new Double(noneToBindTime));

        HashMap conftimes = new HashMap();
        conftimes.put("bs", bsMap);
        conftimes.put("none", noneMap);

        sim = new Simulation(soln, assemblies, 0.0, bondtimes, conftimes,
                bindingPartner);
        sim.storeBindingSiteTypes(bindingSiteTypes);
        sim.storeSubunitTypes(subunitTypes);
    }

    public TSevenSimple(String xml) {

        soln = new Solution();

        XMLParser test = new XMLParser(Test.mode);
        assemblies = new Vector();
        test.setBindingSiteTypes();
        test.setAssemblies(assemblies, soln);
        test.setTransitionTime(soln, assemblies);

        sim = test.sim;

    }

    /**
     * Returns Simulation of Dodecahedron
     * 
     * @return Simulation
     *  
     */
    public static Simulation getSim() {
        return sim;
    }

    /**
     * Creates all Subunits with appropriate bsID, domainID, ConformationID and
     * stID. Adds all Assemblies to Vector assemblies (which is later used in
     * the Simulation construction)
     */
    private static void initAssembly() {
        assemblies = new Vector();

        //bindingsitetype definitions
        double[] tolerances = { 0.2, 0.1, 0.1 };
        Vector partnerspa = new Vector();
        Vector partnerspb = new Vector();
        Vector partnerspc = new Vector();
        Vector partnerspd = new Vector();
        Vector partnerspe = new Vector();

        Vector partnersha = new Vector();
        Vector partnershb = new Vector();
        Vector partnershc = new Vector();
        Vector partnershd = new Vector();
        Vector partnershe = new Vector();
        Vector partnershf = new Vector();

        partnerspa.add("bstha");
        partnerspb.add("bstha");
        partnerspc.add("bstha");
        partnerspd.add("bstha");
        partnerspe.add("bstha");

        partnersha.add("bstpa");
        partnersha.add("bstpb");
        partnersha.add("bstpc");
        partnersha.add("bstpd");
        partnersha.add("bstpe");
        
        partnershb.add("bsthf");
        partnershc.add("bsthd");
        partnershd.add("bsthc");
        partnershe.add("bsthe");
        partnershf.add("bsthb");

        bindingPartner.put("bstpa", partnerspa);
        bindingPartner.put("bstpb", partnerspb);
        bindingPartner.put("bstpc", partnerspc);
        bindingPartner.put("bstpd", partnerspd);
        bindingPartner.put("bstpe", partnerspe);

        bindingPartner.put("bstha", partnersha);
        bindingPartner.put("bsthb", partnershb);
        bindingPartner.put("bsthc", partnershc);
        bindingPartner.put("bsthd", partnershd);
        bindingPartner.put("bsthe", partnershe);
        bindingPartner.put("bsthf", partnershf);

        BindingSiteType bstpa = new BindingSiteType(tolerances, "bstpa",
                partnerspa);
        bstpa.setBindingAngle("bstha", 0.0);
        
        BindingSiteType bstpb = new BindingSiteType(tolerances, "bstpb",
                partnerspb);
        bstpb.setBindingAngle("bstha", -0.569018956430042);
       
        BindingSiteType bstpc = new BindingSiteType(tolerances, "bstpc",
                partnerspc);
        bstpc.setBindingAngle("bstha", -1.5192372955925404);
        
        BindingSiteType bstpd = new BindingSiteType(tolerances, "bstpd",
                partnerspd);
        bstpd.setBindingAngle("bstha", -2.3692666187354705);
        
        BindingSiteType bstpe = new BindingSiteType(tolerances, "bstpe",
                partnerspe);
        bstpe.setBindingAngle("bstha", -2.909911261580998);

        BindingSiteType bstha = new BindingSiteType(tolerances, "bstha",
                partnersha);
        bstha.setBindingAngle("bstpa", 0.0);
        bstha.setBindingAngle("bstpb", -0.569018956430042);
        bstha.setBindingAngle("bstpc", -1.5192372955925404);
        bstha.setBindingAngle("bstpd", -2.3692666187354705);
        bstha.setBindingAngle("bstpe", -2.909911261580998);
        
        BindingSiteType bsthb = new BindingSiteType(tolerances, "bsthb",
                partnershb);
        bsthb.setBindingAngle("bsthf", -0.7317400039255173);
        
        BindingSiteType bsthc = new BindingSiteType(tolerances, "bsthc",
                partnershc);
        bsthc.setBindingAngle("bsthd", 2.173552714753813);
        
        BindingSiteType bsthd = new BindingSiteType(tolerances, "bsthd",
                partnershd);
        bsthd.setBindingAngle("bsthc", 2.173552714753813);
        
        BindingSiteType bsthe = new BindingSiteType(tolerances, "bsthe",
                partnershe);
        bsthe.setBindingAngle("bsthe", 2.2220989408706107);
        
        BindingSiteType bsthf = new BindingSiteType(tolerances, "bsthf",
                partnershf);
        bsthf.setBindingAngle("bsthb", -0.7317400039255294);

        
        bindingSiteTypes.add(bstpa);
        bindingSiteTypes.add(bstpb);
        bindingSiteTypes.add(bstpc);
        bindingSiteTypes.add(bstpd);
        bindingSiteTypes.add(bstpe);

        bindingSiteTypes.add(bstha);
        bindingSiteTypes.add(bsthb);
        bindingSiteTypes.add(bsthc);
        bindingSiteTypes.add(bsthd);
        bindingSiteTypes.add(bsthe);
        bindingSiteTypes.add(bsthf);
        /*
         * Vector3d ta=new Vector3d(1,0,0); Vector3d tb=new
         * Vector3d(-0.5,0.5,0); Vector3d tc=new Vector3d(); tc.cross(ta,tb);
         * Vector3d td=new Vector3d(); td.cross(tb,ta);
         * System.out.println(ta.angle(tb)); System.out.println(tb.angle(ta) +"
         * ssss");
         */
        double myp = 0.38;
        double r = Math.PI / 6;
        AxisAngle4d ax5 = new AxisAngle4d(0, 0, 1.0, Math.PI * 0.4);
        Matrix3d m5 = new Matrix3d();
        m5.set(ax5);

        /**
         * Vector3d posbspa1 = new Vector3d(pcos -Math.sin(0.3 * Math.PI) *
         * subRadius, -Math .cos(0.3 * Math.PI) * subRadius, 0.0);
         */

        double beta = Math.acos(1 / (Math.sqrt(3)) / Math.tan(0.2 * Math.PI));
        Vector3d posbspa1 = new Vector3d(0, -0.5 * myp * Math.cos(beta), -0.5
                * myp * Math.sin(beta));
        Vector3d posbspa2 = new Vector3d();

        m5.transform(posbspa1, posbspa2);
        Vector3d posbspa3 = new Vector3d();
        m5.transform(posbspa2, posbspa3);
        Vector3d posbspa4 = new Vector3d();
        m5.transform(posbspa3, posbspa4);
        Vector3d posbspa5 = new Vector3d();
        m5.transform(posbspa4, posbspa5);

        //tem.negate();
        Vector3d yaxis = new Vector3d(0, 1.0, 0);
        Vector3d temRotationAxis = new Vector3d();
        AxisAngle4d temBsRotation = new AxisAngle4d();
        Vector3d upP = new Vector3d(0, 0, 1.0);
        double temRotationAngle = 0.0;

        temRotationAxis.cross(yaxis, posbspa1);
        temRotationAngle = yaxis.angle(posbspa1);
        temBsRotation.set(temRotationAxis, temRotationAngle);
        Quat4d qpa1 = new Quat4d();
        qpa1.set(temBsRotation);

        temRotationAxis.cross(yaxis, posbspa2);
        temRotationAngle = yaxis.angle(posbspa2);
        temBsRotation.set(temRotationAxis, temRotationAngle);
        Quat4d qpa2 = new Quat4d();
        qpa2.set(temBsRotation);

        temRotationAxis.cross(yaxis, posbspa3);
        temRotationAngle = yaxis.angle(posbspa3);
        temBsRotation.set(temRotationAxis, temRotationAngle);
        Quat4d qpa3 = new Quat4d();
        qpa3.set(temBsRotation);

        temRotationAxis.cross(yaxis, posbspa4);
        temRotationAngle = yaxis.angle(posbspa4);
        temBsRotation.set(temRotationAxis, temRotationAngle);
        Quat4d qpa4 = new Quat4d();
        qpa4.set(temBsRotation);

        temRotationAxis.cross(yaxis, posbspa5);
        temRotationAngle = yaxis.angle(posbspa5);
        temBsRotation.set(temRotationAxis, temRotationAngle);
        Quat4d qpa5 = new Quat4d();
        qpa5.set(temBsRotation);

        Vector3d posbsha = new Vector3d();

        posbsha.scale(-1, posbspa1);
        Vector3d posbshb = new Vector3d();
        posbshb.sub(posbspa5, posbspa1);
        Vector3d posbshf = new Vector3d();
        posbshf.sub(posbspa2, posbspa1);
        Vector3d posbshc = new Vector3d(0.5 * (myp * Math.sqrt(3) / 2 - 0.5),
                0.5 * (myp * 0.5 * Math.cos(beta) - Math.sqrt(3) / 2
                        * Math.cos(beta)),
                0.5 * (myp * 0.5 * Math.sin(beta) - Math.sqrt(3) / 2
                        * Math.sin(beta)));
        posbshc.add(posbsha);

        Vector3d posbshd = new Vector3d(0.5 * (-myp * Math.sqrt(3) / 2 + 0.5),
                0.5 * (myp * 0.5 * Math.cos(beta) - Math.sqrt(3) / 2
                        * Math.cos(beta)),
                0.5 * (myp * 0.5 * Math.sin(beta) - Math.sqrt(3) / 2
                        * Math.sin(beta)));
        posbshd.add(posbsha);

        Vector3d posbshe = new Vector3d(
                0.5 * ((myp * Math.sqrt(3) / 2 - 0.5) * Math.cos(0.4 * Math.PI) - Math
                        .cos(beta)
                        * Math.sin(0.4 * Math.PI)
                        * (0.5 * myp - Math.sqrt(3) / 2)),
                0.5 * ((myp * Math.sqrt(3) / 2 - 0.5) * Math.sin(0.4 * Math.PI) + Math
                        .cos(beta)
                        * Math.cos(0.4 * Math.PI)
                        * (0.5 * myp - Math.sqrt(3) / 2)), 0.5 * (myp * 0.5
                        * Math.sin(beta) - Math.sqrt(3) / 2 * Math.sin(beta)));
        posbshe.add(posbsha);

        temRotationAxis.cross(yaxis, posbsha);
        temRotationAngle = yaxis.angle(posbsha);
        temBsRotation.set(temRotationAxis, temRotationAngle);
        Quat4d qpha = new Quat4d();
        qpha.set(temBsRotation);

        temRotationAxis.cross(yaxis, posbshb);
        temRotationAngle = yaxis.angle(posbshb);
        temBsRotation.set(temRotationAxis, temRotationAngle);
        Quat4d qphb = new Quat4d();
        qphb.set(temBsRotation);
        temRotationAxis.cross(yaxis, posbshc);
        temRotationAngle = yaxis.angle(posbshc);
        temBsRotation.set(temRotationAxis, temRotationAngle);
        Quat4d qphc = new Quat4d();
        qphc.set(temBsRotation);
        temRotationAxis.cross(yaxis, posbshd);
        temRotationAngle = yaxis.angle(posbshd);
        temBsRotation.set(temRotationAxis, temRotationAngle);
        Quat4d qphd = new Quat4d();
        qphd.set(temBsRotation);
        temRotationAxis.cross(yaxis, posbshe);
        temRotationAngle = yaxis.angle(posbshe);
        temBsRotation.set(temRotationAxis, temRotationAngle);
        Quat4d qphe = new Quat4d();
        qphe.set(temBsRotation);
        temRotationAxis.cross(yaxis, posbshf);
        temRotationAngle = yaxis.angle(posbshf);
        temBsRotation.set(temRotationAxis, temRotationAngle);
        Quat4d qphf = new Quat4d();
        qphf.set(temBsRotation);

        int pentamerNumber=Test.pentamerNumber;
        int hexamerNumber=Test.hexamerNumber;
        int assignedNumber=0;
        
      

        boolean subunitTypeNotSeen = true;
for(int i = 0; i <pentamerNumber; i++) {
    String asmname = "assem" + i;
    BindingSite bspa1 = new BindingSite(bstpa, bsid++, domainID, suid,
            asmname, posbspa1, qpa1, "bspa1");
    BindingSite bspa2 = new BindingSite(bstpb, bsid++, domainID, suid,
            asmname, posbspa2, qpa2,  "bspa2");
    BindingSite bspa3 = new BindingSite(bstpc, bsid++, domainID, suid,
            asmname, posbspa3, qpa3,  "bspa3");
    BindingSite bspa4 = new BindingSite(bstpd, bsid++, domainID, suid,
            asmname, posbspa4, qpa4,  "bspa4");
    BindingSite bspa5 = new BindingSite(bstpe, bsid++, domainID, suid,
            asmname, posbspa5, qpa5,  "bspa5");
    bspa1.colorYellow();
    Vector bss1 = new Vector();

    bss1.add(bspa1);
    bss1.add(bspa2);
    bss1.add(bspa3);
    bss1.add(bspa4);
    bss1.add(bspa5);
    Vector confs1 = new Vector(); //vector of conformations for the 1
    // domain
    Conformation bsConf1 = new Conformation(bss1, 6.6, "bs");
    Conformation nonBsConf1 = new Conformation(new Vector(), 6.6,
            "none");
    confs1.add(bsConf1);
    confs1.add(nonBsConf1);

    /**
     * Adds one Domain of a Subunit to Vector Confsets to create
     * SubunitType
     */
    Domain dom1 = new Domain("only", confs1, new Vector3d(), domainID,
            bsConf1);
    if (Test.csAllowed) {
        dom1 = new Domain("only", confs1, new Vector3d(), domainID,
                nonBsConf1);
    }
    Vector doms1 = new Vector();
    doms1.add(dom1);
    SubunitType subt1 = new SubunitType(doms1, "only", soln, 3.4,
            subRadius);
    subt1.storeUpVec(new Vector3d(1,1,1));

    if(subunitTypeNotSeen)
    {
    	subunitTypes.add(subt1);
    	subunitTypeNotSeen = false;
    }
    /**
     * set initial position, rotation, velocity, and rotational velocity
     */
    Vector3d sPos = new Vector3d();
    Quat4d sRot = new Quat4d(0.0, 0.0, 0.0, 1.0);
    Vector3d sVel = new Vector3d();
    Quat4d srVel = new Quat4d(0.0, 0.0, 0.0, 1.0);

    Subunit subunit1 = new Subunit(subt1, doms1, soln, suid++, sPos,
            sRot, sVel, srVel);
    Vector asmsubs1 = new Vector();
    asmsubs1.add(subunit1);
    Assembly asm1 = new Assembly(asmsubs1, asmname);
    
    subunit1.colorBlue();

    assemblies.add(asm1);
    
}

subunitTypeNotSeen = true;
assignedNumber+=pentamerNumber;




for (int i=assignedNumber;i<assignedNumber+hexamerNumber;i++){
    String asmname = "assem" + i;
    BindingSite bsha = new BindingSite(bstha, bsid++, domainID, suid,
            asmname, posbsha, qpha, "bsha");
    BindingSite bshb = new BindingSite(bsthb, bsid++, domainID, suid,
            asmname, posbshb, qphb, "bshb");
    BindingSite bshc = new BindingSite(bsthc, bsid++, domainID, suid,
            asmname, posbshc, qphc, "bshc");
    BindingSite bshd = new BindingSite(bsthd, bsid++, domainID, suid,
            asmname, posbshd, qphd, "bshd");
    BindingSite bshe = new BindingSite(bsthe, bsid++, domainID, suid,
            asmname, posbshe, qphe, "bshe");
    BindingSite bshf = new BindingSite(bsthf, bsid++, domainID, suid,
            asmname, posbshf, qphf, "bshf");
    bsha.colorYellow();
    bshb.colorBlue();
    bshd.colorYellow();
    Vector bss2 = new Vector();

  
    bss2.add(bsha);
    bss2.add(bshb);
    bss2.add(bshc);
    bss2.add(bshd);
    bss2.add(bshe);
    bss2.add(bshf);
    Vector confs2 = new Vector(); //vector of conformations for the 1
    // domain
    Conformation bsConf2 = new Conformation(bss2, 6.6, "bs");
    Conformation nonBsConf2 = new Conformation(new Vector(), 6.6,
            "none");
    confs2.add(bsConf2);
    confs2.add(nonBsConf2);

    /**
     * Adds one Domain of a Subunit to Vector Confsets to create
     * SubunitType
     */
    Domain dom2 = new Domain("only", confs2, new Vector3d(), domainID,
            bsConf2);
    if (Test.csAllowed) {
        dom2 = new Domain("only", confs2, new Vector3d(), domainID,
                nonBsConf2);
    }
    Vector doms2 = new Vector();
    doms2.add(dom2);
    SubunitType subt2 = new SubunitType(doms2, "only2", soln, 3.4,
            subRadius);
    subt2.storeUpVec(new Vector3d(1,1,1));

    if(subunitTypeNotSeen)
    {
    	subunitTypes.add(subt2);
    	subunitTypeNotSeen = false;
    }
    /**
     * set initial position, rotation, velocity, and rotational velocity
     */
    Vector3d sPos2 = new Vector3d();
    Quat4d sRot2 = new Quat4d(0.0, 0.0, 0.0, 1.0);
    Vector3d sVel2 = new Vector3d();
    Quat4d srVel2 = new Quat4d(0.0, 0.0, 0.0, 1.0);

    Subunit subunit2 = new Subunit(subt2, doms2, soln, suid++, sPos2,
            sRot2, sVel2, srVel2);
    Vector asmsubs2 = new Vector();
    asmsubs2.add(subunit2);
    Assembly asm2 = new Assembly(asmsubs2, asmname);

    /**
     * set initial position, rotation, velocity, and rotational velocity
     */
    subunit2.colorYellow();

    //  System.out.println("ndjfsj: "+asm1.getName()+ " "+suid);
    assemblies.add(asm2);
}
        
        
    }
}