
import javax.swing.*;
import com.sun.j3d.utils.geometry.*;

import java.awt.BorderLayout;
import java.awt.GraphicsConfiguration;
import com.sun.j3d.utils.universe.*;
import javax.media.j3d.*;
import javax.vecmath.*;

import java.util.Vector;
import com.sun.j3d.utils.behaviors.mouse.*;
import com.sun.j3d.utils.geometry.Cone;
import java.awt.Color;

/**
 * extends JPanel, displays the current simulation in a panel, allows user to
 * observe the simulation in 3-D space, allows user to use mouse to control the
 * view of simulation
 * 
 * @author Rori Rohlfs
 * @author Tiequan Zhang
 * @author Blake Sweeney
 * @version 1.3
 * 
 *  
 */
public class SimulatorGraphic extends JPanel {

    private Canvas3D canvas3D = null;

    TransformGroup viewT = new TransformGroup();

    private Simulation sim = null;

    private BranchGroup scene = new BranchGroup();

    private double spacing = 1.5;

    public int squareSize = 1;

    Locale locale = null;

    /**
     * Constructs SimulatorGraphic based on sim
     * 
     * @param sim
     *            Simulation
     */
    public SimulatorGraphic(Simulation sim) {
        setLayout(new BorderLayout());
        setOpaque(true);
        /**
         * Finds the preferred GraphicsConfiguration for the system. This object
         * can then be used to create the Canvas3D objet for this system.
         */
        GraphicsConfiguration config = SimpleUniverse
                .getPreferredConfiguration();
        this.sim = sim;

        /**
         * Uses a valid GraphicConfiguration object(config) to create a new
         * Canvas3D object that Java 3D can render into
         */
        canvas3D = new Canvas3D(config);

        /**
         * Adds canvas3D to this container
         */
        add("Center", canvas3D);

        /**
         * Creates a locale, a single ViewingPlatform and a Viewer object
         * associates canvas3D to the Viewer object
         */

        /**
         * Creates a Viewing object and sets the normal viewing distance in the
         * ViewPlatform transform based on the current field of view
         */

        Vector3d viewVector = new Vector3d(0f, 0f, 20f);
        VirtualUniverse universe = new VirtualUniverse();
        locale = new Locale(universe);

        PhysicalBody pBody = new PhysicalBody();
        PhysicalEnvironment environment = new PhysicalEnvironment();
        View view = new View();
        view.addCanvas3D(canvas3D);
        view.setPhysicalBody(pBody);
        view.setPhysicalEnvironment(environment);
        view.setDepthBufferFreezeTransparent(false);

        BranchGroup viewRoot = new BranchGroup();

        viewT.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        viewT.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        Transform3D transformvp = new Transform3D();
        transformvp.set(viewVector);
        viewT.setTransform(transformvp);
        viewRoot.insertChild(viewT, 0);

        ViewPlatform vp = new ViewPlatform();

        view.attachViewPlatform(vp);
        viewT.addChild(vp);
        locale.addBranchGraph(viewRoot);
        makeSG(sim);
    }

    /**
     * Adds every AssemblyGraphic to the scene
     * 
     * @param sim
     *            Simulation is the parameter provided to the constructor
     */
    public void makeSG(Simulation sim) {
        BranchGroup newscene = new BranchGroup();
        newscene.setCapability(BranchGroup.ALLOW_DETACH);
        newscene.setCapability(BranchGroup.ALLOW_CHILDREN_EXTEND);
        newscene.setCapability(Group.ALLOW_CHILDREN_WRITE);

        /**
         * asmbs contains an array of Assembly objects
         */

        Vector asmbs = sim.getAssemblies();

        //grid spacing for initial monomers
        float spacing = 1.5f;
        int numberAssemblies = asmbs.size();
        squareSize = 1;
        while (numberAssemblies > Math.pow(squareSize, 2)) {
            squareSize++;
        }
        squareSize--;
        double x = -spacing * (squareSize / 2.0);
        double y = spacing * (squareSize / 2.0);
        //go through each assembly, adding their graphics
        for (int i = 0; i < asmbs.size(); i++) {
            Assembly curasm = (Assembly) asmbs.elementAt(i);
            AssemblyGraphic bgcurasm = curasm.getAssemblyGraphic();
            Quat4d rot = new Quat4d(0, 0, 0, 1);
            bgcurasm.updateLocation(rot, new Vector3d(x, y, 0.0));
            newscene.addChild(bgcurasm);
            //move x and y for next assembly
            if (x < spacing * (squareSize / 2.0)) {
                x += spacing;
            } else {
                x = -spacing * (squareSize / 2.0);
                y -= spacing;
            }
        }
        float length = (squareSize++) * spacing;
        TransformGroup box = new TransformGroup();
        if (Test.showBorder) {
            addBox(box, length);
            newscene.addChild(box);
        }
        /**
         * add in mouse interaction.
         */
        /**
         * Constructs and initializes a BoundingSphere from a center and radius
         * 200.0
         */
        BoundingSphere mouseBounds = new BoundingSphere(new Point3d(), 200.0);

        Color3f bgColor = new Color3f(Color.GRAY);
        Background bgNode = new Background(bgColor);
        bgNode.setApplicationBounds(mouseBounds);
        if (Test.grey) {
            newscene.addChild(bgNode);
        }

        TransformGroup vpTrans = viewT;

        /**
         * creates rotate behavior, sets a new transformGroup replacing the old
         * one, sets the Behavior's scheduling region to the mouseBounds. adds
         * the child node (myMouseRotate) to newscene list of children
         */
        MouseRotate myMouseRotate = new MouseRotate(MouseBehavior.INVERT_INPUT);
        myMouseRotate.setTransformGroup(vpTrans);
        myMouseRotate.setSchedulingBounds(mouseBounds);
        newscene.addChild(myMouseRotate);

        /**
         * creates translate behavior, sets a new transformGroup replacing the
         * old one, sets the Behavior's scheduling region to the mouseBounds.
         * adds the child node (myMouseTranslate) to newscene list of children
         */
        MouseTranslate myMouseTranslate = new MouseTranslate();
        // MouseBehavior.INVERT_INPUT);
        myMouseTranslate.setTransformGroup(vpTrans);
        myMouseTranslate.setSchedulingBounds(mouseBounds);
        newscene.addChild(myMouseTranslate);

        /**
         * creates zoom behavior, sets a new transformGroup replacing the old
         * one, sets the Behavior's scheduling region to the mouseBounds. adds
         * the child node (myMouseZoom) to newscene list of children
         */
        MouseZoom myMouseZoom = new MouseZoom(MouseBehavior.INVERT_INPUT);
        myMouseZoom.setTransformGroup(vpTrans);
        myMouseZoom.setSchedulingBounds(mouseBounds);
        newscene.addChild(myMouseZoom);

        PointLight lightFront, lightBack;
        Color3f lightColor = new Color3f(1.0f, 1.0f, 1.0f);
        lightFront = new PointLight(lightColor,
                new Point3f(0f, 0f, 2 * length), new Point3f(1f, 0.0f, 0f));
        lightFront.setInfluencingBounds(mouseBounds);
        lightColor = new Color3f(1f, 1f, 1f);
        lightBack = new PointLight(lightColor,
                new Point3f(0f, 0f, -2 * length), new Point3f(1f, 0.0f, 0f));
        lightBack.setInfluencingBounds(mouseBounds);
        AmbientLight lightAmb = new AmbientLight(new Color3f(1f, 1f, 1f));
        lightAmb.setInfluencingBounds(mouseBounds);
        newscene.addChild(lightFront);
        newscene.addChild(lightBack);
        newscene.addChild(lightAmb);
        /**
         * Compiles the source BranchGroup associated with newscene and creates
         * and caches a compiled scene graph, detaches scene from its source
         */
        newscene.compile();
        if (scene != null) {
            scene.detach();
        }
        scene = newscene;
        locale.addBranchGraph(scene);
    }

    public void addBox(Group group, float length) {

        ColorCube axis = new ColorCube(length);
        Appearance app = new Appearance();
        app
                .setPolygonAttributes(new PolygonAttributes(
                        PolygonAttributes.POLYGON_LINE,
                        PolygonAttributes.CULL_NONE, 0));
        axis.setAppearance(app);
        group.addChild(axis);
    }

    /**
     * adds a new Assembly's graphic to the scene
     * 
     * @param asm
     *            Assembly
     */
    public void addAssemblytoGraphic(Assembly asm) {
        int squareLength = ((int) spacing) * squareSize;
        Vector3d t = new Vector3d((sim.getRand() * 2 * squareLength)
                - squareLength, (sim.getRand() * 2 * squareLength)
                - squareLength, (sim.getRand() * 2 * squareLength)
                - squareLength);

        asm.setPos(t);

        Vector a = asm.getSubunits();

        AssemblyGraphic gasm = asm.getAssemblyGraphic();
        gasm.detach();
        scene.addChild(gasm);
    }
    public BranchGroup getScene()
    {
    	return scene;
    }
}

