
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;

/**
 * MainFrame class extends JFrame which is a container used for interactive
 * demonstration of self-assembly simulation
 * 
 * @see Test
 * @author Sue Yi Chew
 * @author Rori Rohlfs
 * @author Blake Sweeney
 * @version 1.3
 *  
 */

public class MainFrame extends JFrame implements ActionListener {

    private Simulation sim;

    private JPanel simulatorPane;

    private SimulatorGraphic simulatorGraph;

    public static JLabel displayText = new JLabel("Nothing Loaded");

    //Used to show how many monomers are left in the simulation
    //static so that it may be modified in simulation.java

    public static JToolBar toolbar = new JToolBar();

    //toolbar is declared static to enable forced painting in simulation.java
    public MainFrame(String title) {
        super(title);

        simulatorPane = (JPanel) createContentPane();

        //super class method
        setContentPane(simulatorPane);

    }

    /**
     * Creates content pane that will replace default content pane of this
     * JFrame
     * 
     * @return Container
     */
    private Container createContentPane() {
        /*
         * Creates a new buffered JPanel, sets the behavior of JPanel
         */
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setOpaque(true);
        contentPane.setLayout(new BorderLayout());
        contentPane.setPreferredSize(new Dimension(600, 600));

        //Initializes the Simulation that will be run here
        //Uses static method getSim(), returns Simulation

        String simChoice = Test.simChoice;
        if (Test.xmlInput) {
        if (simChoice.equals("actin")) {
            //         Creates Actin for actin self-assembly simulation
            Actin t = new Actin("xmlc cdc");
            sim = Actin.getSim();

        } else if (simChoice.equals("tubulin")) {
            // Creates Tubulin for tubulin self-assembly simulation
            Tubulin t = new Tubulin("something");
            sim = Tubulin.getSim();
        } else if (simChoice.equals("virus")) {
            //Creates Icosahedral for virus self-assembly simulation
            Icosahedral t = new Icosahedral("xmlc cdc");
            sim = Icosahedral.getSim();

        } else if (simChoice.equals("cube")) {
            //Creates Cube for cube self-assembly simulation

            Cube t = new Cube("something");
            sim = Cube.getSim();

        } else if (simChoice.equals("tetrahedron")) {
            //Creates Cube for cube self-assembly simulation

            Tetrahedron t = new Tetrahedron("something");
            
            sim = Tetrahedron.getSim();

        }  else if (simChoice.equals("dodecahedron")) {
            //Creates Cube for cube self-assembly simulation

            Dodecahedron t = new Dodecahedron();
            sim = Dodecahedron.getSim();

        } else if (simChoice.equals("tthree")){
        	TThree t = new TThree("something");
        	sim = t.getSim();
        }
        /*else if (simChoice.equals("tseven")) {
            //Creates Cube for cube self-assembly simulation

            TSeven t = new TSeven();
            sim = TSeven.getSim();

        */
     else if (simChoice.equals("tthree")) {
        //Creates Cube for cube self-assembly simulation

        TThree t = new TThree();
        sim = TThree.getSim();

    }
        }
        //without xml template involved
        else {
            if (simChoice.equals("actin")) {
                //         Creates Actin for actin self-assembly simulation
                Actin t = new Actin();
                sim = Actin.getSim();

            } else if (simChoice.equals("tubulin")) {
                // Creates Tubulin for tubulin self-assembly simulation
                Tubulin t = new Tubulin();
                sim = Tubulin.getSim();
            } else if (simChoice.equals("virus")) {
                //Creates Icosahedral for virus self-assembly simulation
                Icosahedral t = new Icosahedral();
                sim = Icosahedral.getSim();

            } else if (simChoice.equals("cube")) {
                //Creates Cube for cube self-assembly simulation

                Cube t = new Cube();
                sim = Cube.getSim();

            } else if (simChoice.equals("tetrahedron")) {
                //Creates Cube for cube self-assembly simulation

                Tetrahedron t = new Tetrahedron();
                sim = Tetrahedron.getSim();

            }  else if (simChoice.equals("dodecahedron")) {
                //Creates Cube for cube self-assembly simulation

                Dodecahedron t = new Dodecahedron();
                sim = Dodecahedron.getSim();

            } else if (simChoice.equals("tsevensimple")) {
                //Creates Cube for cube self-assembly simulation

                TSevenSimple t = new TSevenSimple();
                sim = TSevenSimple.getSim();
            }
            
         else if (simChoice.equals("tthree")) {
            //Creates Cube for cube self-assembly simulation

            TThree t = new TThree();
            sim = TThree.getSim();
            
            
        }
        }
        
        /**
         * returns SimulatorGraphic which extends JPanel
         */
        simulatorGraph = sim.startGraphic();//new SimulatorGraphic(sim);

        if (!Test.displaySim) {
            sim.run();
            System.exit(1);
        }

        JButton runB = new JButton("Run");
        runB.addActionListener(this);
        runB.setActionCommand("run");
        toolbar.add(runB);

        /**
         * creates the "Step" button for debugging , adds it to toolbar, sets
         * the action command for this button
         */
        JButton stepB = new JButton("Step");
        stepB.addActionListener(this);
        stepB.setActionCommand("step");
        toolbar.add(stepB);
        
        
        JButton redrawB = new JButton("redraw");
        redrawB.addActionListener(this);
        redrawB.setActionCommand("redraw");
        toolbar.add(redrawB);
        
        
        JButton writeToFileB = new JButton("write");
        writeToFileB.addActionListener(this);
        writeToFileB.setActionCommand("writeToFile");
        toolbar.add(writeToFileB);
        
        /**
         * Creates a label to show the number of monomers left
         */
        displayText.setText("Monomers: " + sim.numberOfSize(1));
        toolbar.addSeparator();
        toolbar.add(displayText);

        

        
        //add components(simulatorGraph and toolbar) to contentpane container
        contentPane.add(simulatorGraph, BorderLayout.CENTER);
        contentPane.add(toolbar, BorderLayout.SOUTH);

        return contentPane;

    }

    /**
     * Listens to user-input events and execute those events. for example, runs
     * the simulation when the run button is pressed
     * 
     * @param e
     *            ActionEvent, executed by choosing menu items or buttons
     */

    public void actionPerformed(ActionEvent e) {

        if (e.getActionCommand().equals("run")) {
            sim.run();
        } else if (e.getActionCommand().equals("step")) {
            sim.step();
        } else if (e.getActionCommand().equals("printq")) {
            sim.printQ();
        } else if (e.getActionCommand().equals("redraw")) {
        	sim.redraw();
        } else if(e.getActionCommand().equals("writeToFile")){
        	File f = new File("./");
        	JFileChooser jFile = new JFileChooser(f);
        	jFile.setDialogType(JFileChooser.SAVE_DIALOG);
        	jFile.showSaveDialog(this);
        	if(jFile.getSelectedFile() != null)
        	{
        		try{
        			FileWriter fw = new FileWriter(jFile.getSelectedFile().getPath());
        			fw.write("<System type=\"\" reloaded=\"yes\"/>\n");
        			fw.flush();
        			fw.close();

        		}catch(Exception exception)
        		{
        			System.out.println(exception);
        		}
    			XMLParser.writeToXML(sim, jFile.getSelectedFile().getPath());
        	}
        	
        	//System.out.println("file = " + jFile.getSelectedFile().getName());
        }
    }
}

