
import java.util.Vector;
import javax.vecmath.*;
import java.util.HashMap;

/**
 * Domain class holds Conformation information for a Domain in a Subunit
 * 
 * @author Rori Rohlfs
 * @version 1.3
 */
public class Domain {
    Vector myconfs; //set of possible Conformations

    Conformation curconf; //current Conformation for this Domain

    Vector3d mypos = new Vector3d();

    int dmid; //Domain id

    HashMap myNameConfMap = new HashMap();

    /**
     * Constructs a Domain with specified parameters (SubunitType ID, Vector of
     * Conformations, Vector of Positions, Domain id)
     * 
     * @param stname
     *            String, the name of the SubunitType associated with this
     *            Domain
     * @param c
     *            Vector of Conformations
     * @param pos
     *            Vector3D postion of this Domain in the Subunit
     * @param di
     *            Domain id
     */
    public Domain(String stname, Vector c, Vector3d pos, int di) {
        myconfs = c;
        for (int i = 0; i < myconfs.size(); i++) {
            Conformation cur = (Conformation) myconfs.elementAt(i);
            cur.setSubunitType(stname, dmid);
        }
        mypos = pos;
        dmid = di;
        curconf = null;
        //myNameConfMap=null;
    }

    /**
     * Constructs a Domain with specified parameters (SubunitType ID, Vector of
     * Conformations, Vector of Positions, Domain id, current Conformation)
     * 
     * @param stname
     *            String, the name of the SubunitType associated with this
     *            Domain
     * @param c
     *            Vector of Conformations
     * @param pos
     *            Vector3D postion of this Domain in the Subunit
     * @param di
     *            Domain id
     * @param cc
     *            Conformation, current Conformation for this Domain
     */
    public Domain(String stname, Vector c, Vector3d pos, int di, Conformation cc) {
        myconfs = c;
        for (int i = 0; i < myconfs.size(); i++) {
            Conformation cur = (Conformation) myconfs.elementAt(i);
            String confName = cur.getName();
            myNameConfMap.put(confName, cur);
            cur.setSubunitType(stname, dmid);
        }
        mypos = pos;
        dmid = di;
        curconf = cc;
    }

    public HashMap getConfMaps() {
        return myNameConfMap;
    }

    /**
     * Returns vector of Conformations for this Domain
     * 
     * @return Vector of Conformations
     */
    public Vector getConfs() {
        return myconfs;
    }

    /**
     * Returns the position of this Domain in the Subunit
     * 
     * @return Vector3d
     */
    public Vector3d getPos() {
        return mypos;
    }

    /**
     * Changes this Domain's current Conformation to newconf, returns true on
     * success, false on failure
     * 
     * @param newconf
     *            changing this Domain's current Conformation to newconf
     * @return boolean
     */
    public boolean changeConf(Conformation newconf) {
        for (int i = 0; i < myconfs.size(); i++) {
            if (((Conformation) myconfs.get(i)).equals(newconf)) {

                curconf = newconf;
                return true;
            }
        }
        return false;
    }

    /**
     * Returns the current Conformation for this Domain
     * 
     * @return Conformation
     */
    public Conformation getCurConf() {
        return curconf;
    }

    public int getDomainId() {
        return dmid;
    }

    /**
     * Returns a String version of this Domain
     * 
     * @return String
     */
    public String toString() {
        return new String("Domain #" + dmid + "  current Conformation: "
                + curconf.toString());
    }

}