
import java.util.Vector;
import java.util.HashMap;
import javax.vecmath.*;

/**
 * Dodecahedron sets up a viral truncated-Icosahedron-like Simulation, where
 * there is one type of Subunit with a single Conformation and Domain and three
 * binding sites arranged at angles of 120, 120, and 109 degrees apart (allowing
 * an Dodecahedron-shaped superstructure). The initial number of Subunits, and
 * the binding and breaking times control the assembly of Dodecahedron
 * 
 * @author Tiequan Zhang
 * @author Rori Rohlfs
 * @version 1.3
 */

public class Dodecahedron {
    private static Simulation sim;

    private static Solution soln;

    private static Vector assemblies;

    private static int bsid = 0; //BindingSite ID

    private static int domainID = 0; //Domain ID

    private static int stid = 0; //SubunitType ID
    
    private static int suid = 0; //Subunit ID

    //binding and breaking rates set here:
    //average time for a binding event between two compatible BindingSites
    private double bindTime = Test.bindTime;

    //average time for a breaking event between two compatible BindingSites
    private double breakTime = Test.breakTime;

    //  average time for enabling binding ability
    private double bindToNoneTime = Test.bindToNoneTime;

    //  average time for disabling binding ability
    private double noneToBindTime = Test.noneToBindTime;

    //average time for a bonding event between two compatible BindingSites,
    //positioned to bind, in the same Assembly
    private double fastbindTime = Test.fastbindtime;

    private double bindTimeC = Test.bindTimeC;

    private double breakTimeC = Test.breakTimeC;

    //Initial number of Subunits are set here.
    private static int numSubunits = Test.numSubunits;

    private static HashMap bindingPartner = new HashMap();
    
  
    
    private static Vector bindingSiteTypes = new Vector();

    private static Vector subunitTypes = new Vector();

    public Dodecahedron() {
        soln = new Solution();
        initAssembly();

        //now need to use "last" simulation constructor so it works
        double[] bindBreak = new double[3];
        bindBreak[0] = bindTime;
        bindBreak[1] = breakTime;
        bindBreak[2] = fastbindTime;
       /* double[] bindBreak2 = new double[3];
        bindBreak2[0] = bindTime;
        bindBreak2[1] = breakTime;
        bindBreak2[2] = fastbindTime;*/
       
       /* double[] noBindBreak = new double[3];
        noBindBreak[0] = 99999999999999.0;
        noBindBreak[1] = 0.00000000000001;
        noBindBreak[2] = 99999999999999.0;
*/
        HashMap bstHash = new HashMap();
        bstHash.put(new String("bsta"), bindBreak);
        bstHash.put(new String("bstb"), bindBreak);
        bstHash.put(new String("bstc"), bindBreak);
        bstHash.put(new String("bstd"), bindBreak);
        bstHash.put(new String("bste"), bindBreak);

       

        

        HashMap bondtimes = new HashMap();
        bondtimes.put(new String("bsta"), bstHash);
        bondtimes.put(new String("bstb"), bstHash);
        bondtimes.put(new String("bstc"), bstHash);
        bondtimes.put(new String("bstd"), bstHash);
        bondtimes.put(new String("bste"), bstHash);

       

        HashMap bsMap = new HashMap(), noneMap = new HashMap();
        bsMap.put("none", new Double(bindToNoneTime));
        noneMap.put("bs", new Double(noneToBindTime));

        HashMap conftimes = new HashMap();
        conftimes.put("bs", bsMap);
        conftimes.put("none", noneMap);

        sim = new Simulation(soln, assemblies, 0.0, bondtimes, conftimes,
                bindingPartner);
        sim.storeBindingSiteTypes(bindingSiteTypes);
        sim.storeSubunitTypes(subunitTypes);
    }

    /**
     * Returns Simulation of Dodecahedron
     * 
     * @return Simulation
     *  
     */
    public static Simulation getSim() {
        return sim;
    }

    /**
     * Creates all Subunits with appropriate bsID, domainID, ConformationID and
     * stID. Adds all Assemblies to Vector assemblies (which is later used in
     * the Simulation construction)
     */
    private static void initAssembly() {
        assemblies = new Vector();
        double subunitRadius=Test.subunitToBS*Test.bindingSiteHeight;
        boolean subunitTypeNotSeen = true;
        //bindingsitetype definitions
        double[] tolerances = { 0.2, 0.1, 0.1 };
        Vector partnersa = new Vector();
        Vector partnersb = new Vector();
        Vector partnersc = new Vector();
        Vector partnersd = new Vector();
        Vector partnerse = new Vector();
        
        
        partnersa.add("bsta");
        partnersa.add("bstb");        
        partnersa.add("bstc");        
        partnersa.add("bstd");        
        partnersa.add("bste");        
        BindingSiteType bsta = new BindingSiteType(tolerances, "bsta",
                partnersa);                
        bsta.setBindingAngle("bsta", -2.513274122871835);
        bsta.setBindingAngle("bstb", 0.029031543895553326);
        bsta.setBindingAngle("bstc", -0.29135746249232053);
        bsta.setBindingAngle("bstd", -1.1179540661360179);
        bsta.setBindingAngle("bste", -2.0713874074171286);
        
        partnersb.add("bsta");
        partnersb.add("bstb");
        partnersb.add("bstc");
        partnersb.add("bstd");
        partnersb.add("bste");
        BindingSiteType bstb = new BindingSiteType(tolerances, "bstb",
                partnersb);
        bstb.setBindingAngle("bsta", 0.029031543895553326);
        bstb.setBindingAngle("bstb", 2.5713372447604756);
        bstb.setBindingAngle("bstc", 2.250948204275076);
        bstb.setBindingAngle("bstd", 1.42435160063138);
        bstb.setBindingAngle("bste", 0.4709182593502688);
        
        partnersc.add("bsta");
        partnersc.add("bstb");
        partnersc.add("bstc");
        partnersc.add("bstd");
        partnersc.add("bste");        
        BindingSiteType bstc = new BindingSiteType(tolerances, "bstc",
                partnersc);
        bstc.setBindingAngle("bsta", -0.29135746249232053);
        bstc.setBindingAngle("bstb", 2.250948204275076);
        bstc.setBindingAngle("bstc", 1.930559231984712);
        bstc.setBindingAngle("bstd", 1.1039625942434976);
        bstc.setBindingAngle("bste", 0.1505292529623858);
        
        partnersd.add("bsta");
        partnersd.add("bstb");
        partnersd.add("bstc");
        partnersd.add("bstd");
        partnersd.add("bste");        
        BindingSiteType bstd = new BindingSiteType(tolerances, "bstd",
                partnersd);
        bstd.setBindingAngle("bsta", -1.1179540661360179);
        bstd.setBindingAngle("bstb", 1.42435160063138);
        bstd.setBindingAngle("bstc", 1.1039625942434976);    
        bstd.setBindingAngle("bstd", 0.27736602469732147);
        bstd.setBindingAngle("bste", -0.676067350681311);
        
        partnerse.add("bsta");
        partnerse.add("bstb");
        partnerse.add("bstc");
        partnerse.add("bstd");
        partnerse.add("bste");        
        BindingSiteType bste = new BindingSiteType(tolerances, "bste",
                partnerse);
        bste.setBindingAngle("bsta", -2.0713874074171286);
        bste.setBindingAngle("bstb", 0.4709182593502659);
        bste.setBindingAngle("bstc", 0.1505292529623858);
        bste.setBindingAngle("bstd", -0.676067350681311);
        bste.setBindingAngle("bste", -1.6295006578649092);
        
       
        bindingSiteTypes.add(bsta);
        bindingSiteTypes.add(bstb);
        bindingSiteTypes.add(bstc);
        bindingSiteTypes.add(bstd);
        bindingSiteTypes.add(bste);
        
        
        bindingPartner.put("bsta", partnersa);
        bindingPartner.put("bstb", partnersb);
        bindingPartner.put("bstc", partnersc);
        bindingPartner.put("bstd", partnersd);
        bindingPartner.put("bste", partnerse);

         double side=1/(2*Math.sin(Math.PI/5));
         double x1=side*Math.sin(Math.PI*0.4);
         double x2=side*Math.sin(Math.PI*0.2);
         double y1=side*Math.cos(Math.PI*0.4);
         double y2=-side*Math.cos(Math.PI*0.2);
         double height=Math.sqrt(1-(1/(4*Math.sin(Math.PI/5)*Math.sin(Math.PI/5))));

       
        Vector3d posbs1 = new Vector3d(Test.bindingSiteHeight*0,Test.bindingSiteHeight*side,Test.bindingSiteHeight*height);
        AxisAngle4d orbs1a = new AxisAngle4d(1.0, 0.0, 0.0, Math.acos(side));
        Quat4d orbs1 = new Quat4d();
        orbs1.set(orbs1a);
       

        Vector3d posbs2 = new Vector3d(Test.bindingSiteHeight*x1,Test.bindingSiteHeight*y1,Test.bindingSiteHeight*height);
        AxisAngle4d orbs2a = new AxisAngle4d(0.0, 0.0, -1.0, 2.0/5* Math.PI);
        Quat4d orbs2 = new Quat4d();
        orbs2.set(orbs2a);
        orbs2.mul(orbs1);
        //later
        
      
        Vector3d posbs3 = new Vector3d(Test.bindingSiteHeight*x2,Test.bindingSiteHeight*y2,Test.bindingSiteHeight*height);
        AxisAngle4d orbs3a = new AxisAngle4d(0.0, 0.0, -1.0, 2.0/5* Math.PI);
        Quat4d orbs3 = new Quat4d();
        orbs3.set(orbs2a);
        orbs3.mul(orbs2);
        
        
        Vector3d posbs4 = new Vector3d(-Test.bindingSiteHeight*x2,Test.bindingSiteHeight*y2,Test.bindingSiteHeight*height);
        Quat4d orbs4 = new Quat4d();
        orbs4.set(orbs2a);
        orbs4.mul(orbs3);
        
        Vector3d posbs5 = new Vector3d(-Test.bindingSiteHeight*x1,Test.bindingSiteHeight*y1,Test.bindingSiteHeight*height);      
        Quat4d orbs5=new Quat4d();
        orbs5.set(orbs2a);
        orbs5.mul(orbs4);
        Quat4d m=new Quat4d();
        AxisAngle4d orbs = new AxisAngle4d(0.0, 0.0, -1.0, 2.0/5* Math.PI);
        m.set(orbs);

        

//loop for making subunittypes
        for (int i = 0; i < numSubunits; i++) {
            String asmname = "assem" + i;
            BindingSite bsa = new BindingSite(bsta, bsid++, domainID, suid,
                    asmname, posbs1, orbs1, "bsa");
            BindingSite bsb = new BindingSite(bstb, bsid++, domainID, suid,
                    asmname, posbs2, orbs2, "bsb");
            BindingSite bsc = new BindingSite(bstc, bsid++, domainID, suid,
                    asmname, posbs3, orbs3, "bsc");
            BindingSite bsd = new BindingSite(bstd, bsid++, domainID, suid,
                    asmname, posbs4, orbs4, "bsd");
            BindingSite bse = new BindingSite(bste, bsid++, domainID, suid,
                    asmname, posbs5, orbs5, "bse");
           // bsa.colorYellow();
            bsb.colorYellow();
            bsc.colorYellow();
            bsd.colorYellow();
            bse.colorYellow();
           // bsb.colorGreen();
            //bsc.colorBlue();

            Vector bss = new Vector();
            bss.add(bsa);
            bss.add(bsb);
            bss.add(bsc);
            bss.add(bsd);
            bss.add(bse);

            /**
             * Adds one Conformation of a Subunit to Vector confs to create
             * Domain
             */
            Vector confs = new Vector(); //vector of conformations for the 1
            // domain
            Conformation bsConf = new Conformation(bss, 6.6, "bs");
            Conformation nonBsConf = new Conformation(new Vector(), 6.6, "none");
            confs.add(bsConf);
            confs.add(nonBsConf);

            /**
             * Adds one Domain of a Subunit to Vector Confsets to create
             * SubunitType
             */
            Domain dom = new Domain("only", confs, new Vector3d(), domainID,
                    bsConf);
            if (Test.csAllowed) {
                dom = new Domain("only", confs, new Vector3d(), domainID,
                        nonBsConf);
            }
            Vector doms = new Vector();
            doms.add(dom);
            SubunitType subType  = new SubunitType(doms, "only", soln, 3.4, subunitRadius);
            subType.storeUpVec(new Vector3d(1,1,1));
            if (subunitTypeNotSeen) {
                subunitTypes.add(subType);
                
                subunitTypeNotSeen = false;
            }
            /**
             * set initial position, rotation, velocity, and rotational velocity
             */
            Vector3d sPos = new Vector3d();
            Quat4d sRot = new Quat4d(0.0, 0.0, 0.0, 1.0);
            Vector3d sVel = new Vector3d();
            Quat4d srVel = new Quat4d(0.0, 0.0, 0.0, 1.0);

            Subunit subunit = new Subunit(subType, doms, soln, suid++, sPos, sRot,
                    sVel, srVel);
            
            
            Vector assemblySubunits = new Vector();
            assemblySubunits.add(subunit);
            Assembly asm = new Assembly(assemblySubunits, asmname);

            assemblies.add(asm);
        }
    }
}