
import javax.vecmath.*;
import javax.media.j3d.*;

/**
 * 
 * @author Tiequan Zhang
 * @author Peter Kim
 * @version 1.3
 * 
 * This class is used to output different levles of debugging information. It is
 * encourged to use Debug.print(int,String) in other source files instead of
 * System.output.println(String) method.
 */

public class Debug {

    /**
     * Checks if bool is false and print String err
     * 
     * @param level
     *            Int, the importance level of debuggingInfo.
     * @param debuggingInfo
     *            String, the dubugging information that will be printed out.
     *  
     */

    public static void checkFalse(boolean bool, String err) {
        if (bool == false) {
            System.out.println(err);
            System.exit(-1);
        }
    }

    public static void print(int level, String debuggingInfo) {
        if ((level == Test.debuggingLevel) || (level == 0)) {
            System.out.println(debuggingInfo);
        }
    }

    public static Quat4d checkQ4d(Quat4d q, Transform3D t) {

        double[] m1 = new double[16];
        t.get(m1);
        if (Double.isNaN(m1[0])) {
            System.out.print("Debug: transfrom3D");
        }
        double trace = Math.abs(1 + m1[0] + m1[5] + m1[10]);
        double s, x, y, z, w;
        if (trace > 0.000001) {
            s = 2 * Math.sqrt(trace);
            x = (m1[9] - m1[6]) / s;
            y = (m1[2] - m1[8]) / s;
            z = (m1[4] - m1[1]) / s;
            w = 0.25 * s;
        } else {
            if ((m1[0] > m1[5]) && (m1[0] > m1[10])) {
                s = 2 * Math.sqrt(1 + m1[0] - m1[5] - m1[10]);
                x = 0.25 * s;
                y = (m1[4] + m1[1]) / s;
                z = (m1[2] + m1[8]) / s;
                w = (m1[9] - m1[6]) / s;
            } else if (m1[5] > m1[10]) {
                s = 2 * Math.sqrt(1 + m1[5] - m1[0] - m1[10]);
                x = (m1[4] + m1[1]) / s;
                y = 0.25 * s;
                z = (m1[9] + m1[6]) / s;
                w = (m1[2] - m1[8]) / s;
            } else {

                s = 2 * Math.sqrt(1 + m1[10] - m1[0] - m1[5]);
                x = (m1[2] + m1[8]) / s;
                y = (m1[9] + m1[6]) / s;
                z = 0.25 * s;
                w = (m1[4] - m1[1]) / s;
            }
        }

        return new Quat4d(x, y, z, w);

    }

}

