
import java.util.Vector;
import java.util.HashMap;
import javax.vecmath.*;

/**
 * Cube sets up a cube-like Simulation, where there is one type of Subunit with
 * a single Conformation and Domain and three binding sites arranged at angles
 * of pi/2, pi/2, pi/2 apart The initial number of Subunits, and the binding and
 * breaking times control the assembly of Cube
 * 
 * @author Tiequan Zhang
 * @version 1.3
 */

public class Cube {
    private static int numSubunits = Test.numSubunits;
    private static int bsid = 0; //BindingSite ID

    private static int domainID = 0; //Domain ID

    private static int stid = 0; //SubunitType ID

    private static int suid = 0; //Subunit ID

    //binding and breaking rates set here:
    //average time for a binding event between two compatible BindingSites
    private double bindTime = Test.bindTime;

    //average time for a breaking event between two compatible BindingSites
    private double breakTime = Test.breakTime;

    //average time for a bonding event between two compatible BindingSites,
    //positioned to bind, in the same Assembly
    private double fastbindTime = Test.fastbindtime;

    //  average time for enabling binding ability
    private double bindToNoneTime = Test.bindToNoneTime;

    //  average time for disabling binding ability
    private double noneToBindTime = Test.noneToBindTime;

    //Initial number of Subunits are set here.
   

 //   private static double radius = Test.subunitRadius;

    private static HashMap bindingPartner = new HashMap();
    private static Simulation sim;

    private static Solution soln;

    private static Vector assemblies;

    
    private static Vector bindingSiteTypes = new Vector();
    
    private static Vector subunitTypes = new Vector();
    
    
    public Cube() {
        soln = new Solution();
        initAssembly();

        //now need to use "last" simulation constructor so it works
        double[] bindBreak = new double[3];
        bindBreak[0] = bindTime;
        bindBreak[1] = breakTime;
        bindBreak[2] = fastbindTime;
        double[] bindBreak2 = new double[3];
        bindBreak2[0] = bindTime;
        bindBreak2[1] = breakTime;
        bindBreak2[2] = fastbindTime;
        
        double[] noBindBreak = new double[3];
        noBindBreak[0] = 99999999999999.0;
        noBindBreak[1] = 0.00000000000001;
        noBindBreak[2] = 99999999999999.0;

        HashMap bstahash = new HashMap();
        bstahash.put(new String("bstb"), bindBreak);
        bstahash.put(new String("bsta"), noBindBreak);
        bstahash.put(new String("bstc"), noBindBreak);

        HashMap bstbhash = new HashMap();
        bstbhash.put(new String("bsta"), bindBreak);
        bstbhash.put(new String("bstb"), noBindBreak);
        bstbhash.put(new String("bstc"), noBindBreak);

        HashMap bstchash = new HashMap();
        bstchash.put(new String("bsta"),  noBindBreak);
        bstchash.put(new String("bstb"),  noBindBreak);
        bstchash.put(new String("bstc"),  bindBreak);

        HashMap bondtimes = new HashMap();
        bondtimes.put(new String("bsta"), bstahash);
        bondtimes.put(new String("bstb"), bstbhash);
        bondtimes.put(new String("bstc"), bstchash);

        HashMap bsMap = new HashMap(), noneMap = new HashMap();
        bsMap.put("none", new Double(bindToNoneTime));
        noneMap.put("bs", new Double(noneToBindTime));

        HashMap conftimes = new HashMap();
        conftimes.put("bs", bsMap);
        conftimes.put("none", noneMap);

        sim = new Simulation(soln, assemblies, 0.0, bondtimes, conftimes,
                bindingPartner);
        
        sim.storeBindingSiteTypes(bindingSiteTypes);
        sim.storeSubunitTypes(subunitTypes);
    }
    public Cube(String xml) {
        
        soln = new Solution();
        XMLParser test = new XMLParser(Test.mode);
        assemblies = new Vector();
        test.setBindingSiteTypes();
        test.setAssemblies(assemblies, soln);
        test.setTransitionTime(soln, assemblies);
        sim = test.sim;
        
    }

    /**
     * Returns Simulation of Icosahedral
     * 
     * @return Simulation
     *  
     */
    public static Simulation getSim() {
        return sim;
    }

    /**
     * Creates all Subunits with appropriate bsID, domainID, ConformationID and
     * stID. Adds all Assemblies to Vector assemblies (which is later used in
     * the Simulation construction)
     */
    private static void initAssembly() {
        assemblies = new Vector();

        //bindingsitetype definitions
        double[] tolerances = { 0.2, 0.1, 0.1 };
        Vector partnersa = new Vector();
        Vector partnersb = new Vector();
        Vector partnersc = new Vector();
        partnersa.add("bstb");
        BindingSiteType bsta = new BindingSiteType(tolerances, "bsta",
                partnersa);
        bsta.setBindingAngle("bstb", 0.0);
        
        partnersb.add("bsta");
        BindingSiteType bstb = new BindingSiteType(tolerances, "bstb",
                partnersb);
        bstb.setBindingAngle("bsta", 0.0);
        
        partnersc.add("bstc");
        BindingSiteType bstc = new BindingSiteType(tolerances, "bstc",
                partnersc);
        bstc.setBindingAngle("bstc", 0.0);
        
     
        bindingSiteTypes.add(bsta);
        bindingSiteTypes.add(bstb);
        bindingSiteTypes.add(bstc);
        
        bindingPartner.put("bsta", partnersa);
        bindingPartner.put("bstb", partnersb);
        bindingPartner.put("bstc", partnersc);

        AxisAngle4d axisAnglea = new AxisAngle4d(0.0, 0.0, 1.0, 0);
        Quat4d rotationa = new Quat4d();
        rotationa.set(axisAnglea);
        Vector3d positiona = new Vector3d(0.0, 0.1, 0.0);

        AxisAngle4d  axisAngleb = new AxisAngle4d(0.0, 0.0, -1.0, 0.5 * Math.PI);
        Quat4d rotationb = new Quat4d();
        rotationb.set( axisAngleb);
        Vector3d positionb = new Vector3d(0.1, 0.0, 0.0);

        AxisAngle4d axisAnglec = new AxisAngle4d(1.0, 0.0, 0.0, 0.5 * Math.PI);
        Quat4d rotationc = new Quat4d();
        rotationc.set(axisAnglec);
        Vector3d positionc = new Vector3d(0, 0, 0.1);

        //loop for making subunittypes
      //  Vector subts = new Vector();
        double subunitRadius=Test.subunitToBS*Test.bindingSiteHeight;
        boolean subunitTypeNotSeen = true;
        
        for (int i = 0; i < numSubunits; i++) {
            String asmname = "assem" + i;
            BindingSite bsa = new BindingSite(bsta, bsid++, domainID, suid,
                    asmname, positiona, rotationa,"bsa");
            BindingSite bsb = new BindingSite(bstb, bsid++, domainID, suid,
                    asmname, positionb, rotationb,"bsb");
            BindingSite bsc = new BindingSite(bstc, bsid++, domainID, suid,
                    asmname, positionc , rotationc, "bsc");
            bsa.colorYellow();
            bsb.colorGreen();
            bsc.colorBlue();
            /**
             * Adds BindingSites of one Subunit to Vector bss to create
             * Conformation
             */
            Vector bss = new Vector();
            bss.add(bsa);
            bss.add(bsb);
            bss.add(bsc);

            /**
             * Adds one Conformation of a Subunit to Vector confs to create
             * Domain
             */
            Vector confs = new Vector(); //vector of conformations for the 1
            // domain
            Conformation bsConf = new Conformation(bss, 6.6, "bs");
            Conformation nonBsConf = new Conformation(new Vector(), 6.6, "none");
            confs.add(bsConf);
            confs.add(nonBsConf);
            /**
             * Adds one Domain of a Subunit to Vector Confsets to create
             * SubunitType
             */
            Domain dom = new Domain("only", confs, new Vector3d(), domainID,
                    bsConf);
            if (Test.csAllowed) {
                dom = new Domain("only", confs, new Vector3d(), domainID,
                        nonBsConf);
            }
            Vector doms = new Vector();
            doms.add(dom);
            SubunitType subType = new SubunitType(doms, "only", soln, 3.4, subunitRadius);
            
            
            subType.storeUpVec(new Vector3d(1,1,1));
            
            if (subunitTypeNotSeen) {
                subunitTypes.add(subType);
                subunitTypeNotSeen = false;
            }

            /**
             * set initial position, rotation, velocity, and rotational velocity
             */
            Vector3d sPos = new Vector3d();
            Quat4d sRot = new Quat4d(0.0, 0.0, 0.0, 1.0);
            Vector3d sVel = new Vector3d();
            Quat4d srVel = new Quat4d(0.0, 0.0, 0.0, 1.0);

            Subunit subunit = new Subunit(subType, doms, soln, suid++, sPos, sRot,
                    sVel, srVel);
            Vector assemblySubunits = new Vector();
            assemblySubunits.add(subunit);
            Assembly asm = new Assembly(assemblySubunits, asmname);

            assemblies.add(asm);
        }

    }

}