
import java.awt.Color;
import java.util.HashMap;

import com.sun.j3d.utils.geometry.*;

import javax.vecmath.*;
import javax.media.j3d.*;

/**
 * Extends branchgroup to make a conic bindingsite graphic:
 * 
 * BindingSiteGraphic | TransformGroup | cone
 * 
 * @author Rori Rohlfs
 * @author Tiequan Zhang
 * @version 1.3
 */
public class BindingSiteGraphic extends BranchGroup {
    private TransformGroup tg;

  //  final float bsHeight = Test.bindSiteHeight; //hardcoded bindingsite height

    // (for now)
    float bsHeight;

    private Cone bs_cone;

    /**
     * Constructs a default BindingSiteGraphic
     */
    //to be removed
  /*  public BindingSiteGraphic() {
        super();
        this.setCapability(BranchGroup.ALLOW_DETACH);
        this.setCapability(Group.ALLOW_CHILDREN_WRITE);

        //prepare the cone's apperance
        Appearance app = new Appearance();
        ColoringAttributes ca = new ColoringAttributes(1.0f, 0.5f, 0.0f, 1);
        Material mat = new Material();
        mat.setDiffuseColor(0.6f, 0.0f, 0.0f);
        mat.setAmbientColor(0.3f, 0.0f, 0.0f);
        app.setMaterial(mat);
        app.setColoringAttributes(ca);

        //Create a cone with specified radius and height and set its appearance
        //Cone bs_cone = new Cone(0.02f, bsHeight);
        
        bsHeight=0.1f;
        bs_cone = new Cone(0.02f, bsHeight, Primitive.ENABLE_APPEARANCE_MODIFY
                | Primitive.GENERATE_NORMALS_INWARD, app);

        //Make a TransformGroup set appropriate capabilities
        tg = new TransformGroup();
        tg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        tg.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        tg.setCapability(Group.ALLOW_CHILDREN_WRITE);
        tg.setCapability(Group.ALLOW_CHILDREN_READ);

        tg.addChild(bs_cone);
        this.addChild(tg);
    }
*/
    /**
     * Constructs a AssemblyGraphic according to the position and rotation of bs
     */
    public BindingSiteGraphic(BindingSite bs) {
        super();
        this.setCapability(BranchGroup.ALLOW_DETACH);
        this.setCapability(Group.ALLOW_CHILDREN_WRITE);

        //prepare the cone's apperance
        Appearance app = new Appearance();
        ColoringAttributes ca = new ColoringAttributes();
        //below is convenient for colorcoding bindingsites in some simulations
        if ((bs.getID()) % 2 == 0)
            ca = new ColoringAttributes(1.0f, 0.0f, 0.0f, 1);
        else
            ca = new ColoringAttributes(1.0f, 0.5f, 0.0f, 1);

        //prepare the cone's material
        Material mat = new Material();
        //below is convenient for colorcoding bindingsites in some simulations
        if ((bs.getID()) % 2 == 0) {
            mat.setDiffuseColor(0.5f, 0.0f, 0.0f);
            mat.setAmbientColor(0.5f, 0.0f, 0.0f);
        } else {
            mat.setDiffuseColor(0.6f, 0.0f, 0.0f);
            mat.setAmbientColor(0.3f, 0.0f, 0.0f);
        }
        app.setMaterial(mat);
        app.setColoringAttributes(ca);

        bsHeight=bs.bindingSiteHeight;
        Vector3d posSurface =new Vector3d();
     //   double ratio=Test.subunitRadius/(0.5*bsHeight+Test.subunitRadius);
        float bsBase=(float)0.1*bsHeight;
        posSurface.scale(Test.subunitToBS,bs.getPos());
        
        bs_cone = new Cone(bsBase, bsHeight, Primitive.ENABLE_APPEARANCE_MODIFY
                | Primitive.GENERATE_NORMALS, app);

        bs_cone.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
        bs_cone.setCapability(Shape3D.ALLOW_APPEARANCE_OVERRIDE_WRITE);
        bs_cone.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);

        //Makes TransformGroup and sets its properties
        tg = new TransformGroup();
        tg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        tg.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        tg.setCapability(Group.ALLOW_CHILDREN_WRITE);
        //Transform the cone as specified by bs

        Transform3D bs_trans = new Transform3D();
        //new add
        bs_trans.set(posSurface);
        Transform3D bs_rot = new Transform3D();
        bs_rot.set(bs.getRot());
        bs_trans.mul(bs_rot);
        tg.setTransform(bs_trans);
        tg.addChild(bs_cone);
        this.addChild(tg);

    }

    /**
     * Updates this BindingSiteGraphic location as specificed by rot and pos
     * 
     * @param rot
     *            Quat4d the new rotation
     * @param pos
     *            Vector3d the new position
     */
    public void updateLocation(Quat4d rot, Vector3d pos) {
        Transform3D bs_trans = new Transform3D();
        bs_trans.set(pos);
        Transform3D bs_rot = new Transform3D();
        bs_rot.set(rot);
        bs_trans.mul(bs_rot);
        //same as:
        /**
         * Transform3D tem=new Transform3D(rot,pos,1.0); tg.setTransform(tem);
         *  
         */
        tg.setTransform(bs_trans);
    }

    /**
     * Return BindingSiteGraphic as a BranchGroup
     * 
     * @return BranchGroup
     */
    public BranchGroup branchGroup() {
        return (BranchGroup) this;
    }

    /**
     * Gets the Transform3D of this BindingSiteGraphic
     * 
     * @return Transform3D
     */
    public Transform3D getTransform() {
        Transform3D t = new Transform3D();
        tg.getTransform(t);
        return t;
    }

    /**
     * Gets the length of this BindingSite
     * 
     * @return double
     */
    public double length() {
        return (double) bsHeight;
    }

    /**
     * Changes the color of this BindSiteGraphic to Green
     */
    public void colorGreen() {
        ColoringAttributes ca = new ColoringAttributes(0.0f, 0.5f, 1.0f, 1);
        Appearance app = new Appearance();
        Material mat = new Material();
        mat.setDiffuseColor(0.0f, 1.0f, 0.0f);
        mat.setAmbientColor(0.0f, 1.0f, 0.0f);
        app.setMaterial(mat);
        app.setColoringAttributes(ca);
        bs_cone.setAppearance(app);

    }

    public void colorPink() {
        ColoringAttributes ca = new ColoringAttributes(0.0f, 0.5f, 1.0f, 1);
        Appearance app = new Appearance();
        Material mat = new Material();
        mat.setDiffuseColor(1.0f, 0.0f, 1.0f);
        mat.setAmbientColor(1.0f, 0.0f, 1.0f);
        app.setMaterial(mat);
        app.setColoringAttributes(ca);
        bs_cone.setAppearance(app);
    }

    public void colorBlue() {
        ColoringAttributes ca = new ColoringAttributes(0.0f, 0.5f, 1.0f, 1);
        Appearance app = new Appearance();
        Material mat = new Material();
        mat.setDiffuseColor(0.0f, 0.0f, 1.0f);
        mat.setAmbientColor(0.0f, 0.0f, 1.0f);
        app.setMaterial(mat);
        bs_cone.setAppearance(app);
    }

    public void colorYellow() {
        ColoringAttributes ca = new ColoringAttributes(0.0f, 0.5f, 1.0f, 1);
        Appearance app = new Appearance();
        Material mat = new Material();
        mat.setDiffuseColor(1.0f, 1.0f, 0.0f);
        mat.setAmbientColor(1.0f, 1.0f, 0.0f);
        app.setMaterial(mat);
        bs_cone.setAppearance(app);
    }
}