
import javax.vecmath.*;
import javax.media.j3d.*;

/**
 * BindingSite holds information about a specific BindingSite including the
 * BindingSiteType, binding state, partner BindingSite (if bound), ID, Domain
 * ID, Subunit ID, Assembly Name, BindingSiteGraphic, and "up" vector.
 * 
 * The up vector is a unit vector perpendicular to the binding site. It's used
 * to torsionally align two BindingSites in a bond (the Subunits rotate so that
 * the up vectors for the BindingSites are parallel)
 * 
 * @author Rori Rohlfs
 * @version 1.3
 *  
 */

public class BindingSite {
    private BindingSiteType myBSType;

    private boolean bound; //1 when partner is present, 0 otherwise

    private BindingSite partner; //only exists when bound

    private int myID;

    private int myDomainID;

    private int mySubunitID;

    private String myAssemblyName;

    private Vector3d mypos; //position relative to the subunit

    private Quat4d myrot; //rotation relative to the subunit

    private BindingSiteGraphic mygraphic;
    
    private Vector3d myup; //relative to Subunit

    private String myBSName;
    public   float bindingSiteHeight;

    public String myColor=new String();

    /**
     * Constructs a BindingSite with default BindingSiteType, with its ID,
     * domain ID and subunit ID set to -1, set the state of this BindingSite to
     * unbound
     */
    /*public BindingSite() {
        myBSType = new BindingSiteType();
        bound = false;
        partner = null;
        myID = -1;
        myDomainID = -1;
        mySubunitID = -1;
        myAssemblyName = new String();
        mypos = new Vector3d();
        myrot = new Quat4d();
        
        mygraphic = new BindingSiteGraphic();
        bindingSiteHeight=0.1f;
    }*/

    /**
     * Constructs a BindingSite with specified BindingSiteType, ID, domain ID,
     * subunit ID, assembly name, position (relative to the Subunit), rotation
     * (reative to the Subunit), and up vector (relative to the Subunit). A
     * graphic is construced according to the parameters given
     * 
     * @param bst
     *            BindingSiteType
     * @param bsid
     *            int, this BindingSite's ID
     * @param did
     *            int, this BindingSite's Domain's ID
     * @param suid
     *            int, this BindingSite's Subunit's ID
     * @param assemName
     *            String, this BindingSite's Assembly's name
     * @param pos
     *            Vector3d, this BindingSite's position relative to its Subunit
     * @param rot
     *            Quat4d, this BindingSite's rotation relative to its Subunit
     * @param up
     *            Vector, this BindingSite's up vector relative to its Subunit
     */
  /*  public BindingSite(BindingSiteType bst, int bsid, int did, int suid,
            String assemName, Vector3d pos, Quat4d rot, Vector3d up) {
        myBSType = bst;
        bound = false;
        partner = null;
        myID = bsid;
        myDomainID = did;
        mySubunitID = suid;
        myAssemblyName = assemName;
        mypos = pos;
        myrot = rot;
        myup = up;
       // myBSName=bsName;
        
        //new add
        //bindingSiteHeight=(float)(2*(mypos.length()-Test.subunitRadius));
        bindingSiteHeight=(float)mypos.length();
        mygraphic = new BindingSiteGraphic(this);
       
        
    }*/
    public BindingSite(BindingSiteType bst, int bsid, int did, int suid,
            String assemName, Vector3d pos, Quat4d rot, String bsName) {
        myBSType = bst;
        bound = false;
        partner = null;
        myID = bsid;
        myDomainID = did;
        mySubunitID = suid;
        myAssemblyName = assemName;
        mypos = pos;
        myrot = rot;
        myup = new Vector3d(0,0,1);
        myBSName=bsName;
        
        //new add
        //bindingSiteHeight=(float)(2*(mypos.length()-Test.subunitRadius));
        bindingSiteHeight=(float)mypos.length();
        mygraphic = new BindingSiteGraphic(this);
       
        
    }
    
  

    /**
     * Sets the binding state of this and p to bound and adds their partners
     * appropriately. If this or p is already bound, returns false. (true
     * otherwise)
     * 
     * @param p
     *            BindingSite
     * @return boolean
     */
    public boolean bindTo(BindingSite p) {
        if (!bound && !p.bound) {
            //set partners and bound pars
            partner = p;
            bound = true;
            p.bound = true;
            p.partner = this;

            return true;
        }
        return false;
    }

    /**
     * Sets the binding state of this BindingSite and its partner to unbound and
     * removes their partners. If this was not bound to begin with, returns
     * false. (true otherwise)
     * 
     * @return boolean
     */
    public boolean breakBond() {
        if (bound) {
            partner.bound = false;
            partner.partner = null;
            bound = false;
            partner = null;
            
            return true;
        }
        return false;
    }

    

    /**
     * Colors the graphic for this BindingSite green. (Useful for debugging)
     */
    public void colorGreen() {
        mygraphic.colorGreen();
    }

    public void colorYellow() {
        mygraphic.colorYellow();
    }

    public void colorBlue() {
        mygraphic.colorBlue();
    }

    public void colorPink() {
        mygraphic.colorPink();
        myColor=new String("pink");
    }
    /**
     * Accessor method to get the name of the Assembly that this BindingSite is
     * a part of.
     * 
     * @return String
     */
    public String getAssemblyName() {
        return myAssemblyName;
    }
    public String getBSName() {
    	return myBSName;
    }

    /**
     * Accessor method to get this BindingSite's BindingSiteType
     * 
     * @return BindingSiteType
     */
    public BindingSiteType getBST() {
        return myBSType;
    }

   
    public BindingSiteGraphic getGraphic() {
        return mygraphic;
    }
    /**
     * Accessor method to get the ID of this BindingSite
     * 
     * @return int
     */
    public int getID() {
        return myID;
    }
    
    /**
     * Accessor method to get the partner BindingSite bound to this BindingSite.
     * Returns null if this BindingSite is not bound.
     * 
     * @return BindingSite
     */
    public BindingSite getPartner() {
        return partner;
    }
    
    /**
     * Accessor method to get the position of this BindingSite relative to its
     * Subunit
     * 
     * @return Vector3d
     */
    public Vector3d getPos() {
        return mypos;
    }
    /**
     * Accessor method to get the rotation of this BindingSite relative to its
     * Subunit
     * 
     * @return Quat4d
     */
    public Quat4d getRot() {
        return myrot;
    }
    /**
     * Accessor method to get the subunit ID of this BindingSite
     * 
     * @return int
     */
    public int getSubunitID() {
        return mySubunitID;
    }
    public Vector3d getTipPos() {
        /*Vector3d tv = new Vector3d();
        tv.scale(Test.tipScale, mypos);*/

        //return tv;
        return mypos;
    }
   
   
    /**
     * Accessor method to get the Transform of this BindingSite
     * 
     * @return Transform3D
     */
    public Transform3D getTransform() {
        return mygraphic.getTransform();
    }
    /**
     * Accessor method to get the up vector for this BindingSite relative to its
     * Subunit
     * 
     * @return Quat4d
     */
    public Vector3d getUp() {
        return myup;
    }

    /**
     * Accessor method to find out if this BindingSite is bound. Returns true
     * when bound, false when not.
     * 
     * @return boolean
     */
    public boolean isBound() {
        return bound;
    }

    /**
     * Returns true if p and this BindingSites can are of compatible
     * BindingSiteTypes (they can bind, in theory)
     * 
     * @param p
     *            BindingSite
     * @return boolean
     */
    public boolean isCompatibleTo(BindingSite p) {
        BindingSiteType pbst = p.getBST();
        if (myBSType.isCompat(pbst))
            return true;
        return false;
    }
   

    
   

    /**
     * Accessor method to get the BindingSiteGraphic for this BindingSite
     * 
     * @return BindingSiteGraphic
     */
    
   


   
    
    
    /**
     * Accessor method to find the length of this BindingSite
     * 
     * @return double
     */
    public double length() {
        return mygraphic.length();
    }
    /**
     * Mutator method to set the name of the Assembly that this BindingSite is a
     * part of to assemName.
     * 
     * @param assemName
     *            String
     */
    public void setAssemName(String assemName) {
        myAssemblyName = assemName;
    }
    /**
     * Mutator method to set the domain ID of this BindingSite to i
     * 
     * @param i
     *            int
     */
    public void setDomainID(int i) {
        myDomainID = i;
    }
    /**
     * Mutator method to set the ID of this BindingSite to i
     * 
     * @param i
     *            int
     */
   /* public void setID(int i) {
        myID = i;
    }
*/
    /**
     * Mutator method to set the position of this BindingSite relative to its
     * Subunit to pos
     * 
     * @param pos
     *            Vector3d
     */
    public void setPos(Vector3d pos) {
        mypos = pos;
        mygraphic.updateLocation(myrot, mypos);
    }

    /**
     * Mutator method to set the subunit ID of this BindingSite to i
     * 
     * @param i
     *            int
     */
  /*  public void setSubunitID(int i) {
        mySubunitID = i;
    }*/

    /**
     * Returns true if this BindingSit is the same as bs, false otherwise
     * 
     * @param bs
     *            BindingSite
     * @return boolean
     */
    public boolean equals(BindingSite bs) {
        return myID == bs.getID();
    }

    /**
     * Return a string representation of this BindingSite, detailing it's ID,
     * the ID of it's BindingSite, whether this BindingSite is bound, and if so,
     * its partner BindingSite's ID.
     * 
     * @return String
     */
    public String toString() {
        String mystring = new String("BindingSite ID: " + myID
                + "\n mydomain ID: " + myDomainID + "\n my suid: " + mySubunitID
                + "\n myAssemblyName" + myAssemblyName + "\nBindingSiteType Name: "
                + myBSType.getName() + "\nBinding State(true if bound): "
                + bound);
        if (bound) {
            mystring = mystring + "\nPartner BindingSite ID: "
                    + partner.getID();
        }

        return mystring;
    }
}