
import java.util.Vector;
import java.util.HashMap;
import javax.vecmath.*;

/**
 * Actin sets up a filament-like scenerio, where there is one type of Subunit
 * with a single Conformation and Domain and two binding sites on opposite ends.
 * The initial number of Subunits, and the binding and breaking times control
 * the assembly of Actin
 * 
 * @author Rori Rohlfs
 * @author Tiequan Zhang
 * @version 1.3
 *  
 */

public class Actin {

    //  Initial number of Subunits are set here.
    private static int numSubunits = Test.numSubunits;

    private static int bsID = 0; //BindingSite ID

    private static int domainID = 0; //Domain ID

    private static int suID = 0; //SubunitID

    //binding and breaking rates are set here:
    //  average time for a binding event
    private double bindTime = Test.bindTime;

    //average time for a breaking event
    private double breakTime = Test.breakTime;

    //not applicable in an Actin simulation
    // private double fastbindtime = Test.fastbindtime;

    //  average time for enabling binding ability
    private double bindToNoneTime = Test.bindToNoneTime;

    //  average time for disabling binding ability
    private double noneToBindTime = Test.noneToBindTime;

    //To do
    private static double[] tolerances = { 0.2, 0.1, 0.1 };

    //   private static int stID = 0; //SubunitType ID

    // private double energy = 6.6;
    private static Solution soln;

    private static Simulation sim;

    private static Vector assemblies;//all assemblies in simulation

    private static HashMap bindingPartner = new HashMap();

    private static Vector bindingSiteTypes = new Vector();

    private static Vector subunitTypes = new Vector();

    //   private static HashMap bindingRules = new HashMap();

    /**
     * Constructs an Actin Simulation w/o xml.
     *  
     */
    public Actin() {
        soln = new Solution();
        initAssembly();

        double[] bindbreak = new double[3];
        bindbreak[0] = bindTime;
        bindbreak[1] = breakTime;
        bindbreak[2] = 0;

        double[] noBindBreak = new double[3];
        noBindBreak[0] = 99999999999999.0;
        noBindBreak[1] = 0.00000000000001;
        noBindBreak[2] = 99999999999999.0;

        HashMap bstaHashMap = new HashMap();
        bstaHashMap.put(new String("bsta"), noBindBreak);
        bstaHashMap.put(new String("bstb"), bindbreak);

        HashMap bstbHashMap = new HashMap();
        bstbHashMap.put(new String("bsta"), bindbreak);
        bstbHashMap.put(new String("bstb"), noBindBreak);

        HashMap bondTime = new HashMap();
        bondTime.put(new String("bsta"), bstaHashMap);
        bondTime.put(new String("bstb"), bstbHashMap);

        HashMap bsMap = new HashMap(), noneMap = new HashMap();
        bsMap.put("none", new Double(bindToNoneTime));
        noneMap.put("bs", new Double(noneToBindTime));

        HashMap conftimes = new HashMap();
        conftimes.put("bs", bsMap);
        conftimes.put("none", noneMap);

        sim = new Simulation(soln, assemblies, 0.0, bondTime, conftimes,
                bindingPartner);
        sim.storeBindingSiteTypes(bindingSiteTypes);
        sim.storeSubunitTypes(subunitTypes);
    }

    /**
     * Constructs an Actin Simulation based on XML schema.
     * 
     * @param xml
     *            String, differentiate Actin constructor
     *  
     */
    public Actin(String xml) {

        soln = new Solution();
        XMLParser test = new XMLParser(Test.mode);
        assemblies = new Vector();
        test.setBindingSiteTypes();
        test.setAssemblies(assemblies, soln);
        test.setTransitionTime(soln, assemblies);
        sim = test.sim;
    }

    /**
     * Returns Simulation of Actin
     * 
     * @return Simulation
     */
    public static Simulation getSim() {
        return sim;
    }

    /**
     * 
     * Creates all Subunits with appropriate bsID, domainID, ConformationID and
     * stID. Adds all Assembly to Vector Assemblies
     *  
     */
    private static void initAssembly() {
        assemblies = new Vector();

        //Creates BindingSiteType objects for BindingSite a and b

        Vector partnersa = new Vector();
        Vector partnersb = new Vector();
        partnersa.add("bstb");
        partnersb.add("bsta");
        bindingPartner.put("bsta", partnersa);
        bindingPartner.put("bstb", partnersb);

        BindingSiteType bsta = new BindingSiteType(tolerances, "bsta",
                partnersa);
        bsta.setBindingAngle("bstb", 0.0);

        BindingSiteType bstb = new BindingSiteType(tolerances, "bstb",
                partnersb);
        bstb.setBindingAngle("bsta", 0.0);

        bindingSiteTypes.add(bsta);
        bindingSiteTypes.add(bstb);

        //Position of binding site a
        Vector3d positiona = new Vector3d(-Test.bindingSiteHeight * 1,
                Test.bindingSiteHeight * 0.0, Test.bindingSiteHeight * 0.0);
        //Rotates binding site to point to left
        Quat4d rotationa = new Quat4d(0.0, 0.0, -1.0 / Math.pow(2, 1 / 2), -1.0
                / Math.pow(2, 1 / 2));

        //Position of binding site b
        Vector3d positionb = new Vector3d(Test.bindingSiteHeight * 1,
                Test.bindingSiteHeight * 0.0, Test.bindingSiteHeight * 0.0);
        //Rotates binding site to point to right
        Quat4d rotationb = new Quat4d(0.0, 0.0, 1.0 / Math.pow(2, 1 / 2), -1.0
                / Math.pow(2, 1 / 2)); //points right

        //loop for making subunittypes; bsID starts with 0;
        boolean subunitTypeNotSeen = true;
        double subunitRadius = Test.subunitToBS * Test.bindingSiteHeight;
        for (int i = 0; i < numSubunits; i++) {
            String asmname = "" + i;

            BindingSite bsa = new BindingSite(bsta, bsID++, domainID, suID,
                    asmname, positiona, rotationa, "bsa");
            BindingSite bsb = new BindingSite(bstb, bsID++, domainID, suID,
                    asmname, positionb, rotationb, "bsb");
            bsa.colorBlue();
            bsb.colorGreen();
            /**
             * Adds two BindingSites of one Subunit to Vector bss to create
             * Conformation
             */
            Vector bss = new Vector();
            bss.add(bsa);
            bss.add(bsb);

            Conformation bsConf = new Conformation(bss, 6.6, "bs");
            Conformation nonBsConf = new Conformation(new Vector(), 6.6, "none");

            Vector actinConfs = new Vector();
            actinConfs.add(bsConf);
            actinConfs.add(nonBsConf);

            Domain actinDomain = new Domain("ActinDomain", actinConfs,
                    new Vector3d(), domainID, bsConf);
            if (Test.csAllowed) {
                actinDomain = new Domain("ActinDomain", actinConfs,
                        new Vector3d(), domainID, nonBsConf);
            }

            Vector actinDomains = new Vector();
            actinDomains.add(actinDomain);

            SubunitType subType = new SubunitType(actinDomains, "only", soln,
                    3.4, subunitRadius);
            subType.storeUpVec(new Vector3d(0, 0, 1));

            if (subunitTypeNotSeen) {
                subunitTypes.add(subType);
                subunitTypeNotSeen = false;
            }

            /**
             * set initial position, rotation, velocity, and rotational velocity
             */
            Vector3d sPos = new Vector3d();
            Quat4d sRot = new Quat4d(0.0, 0.0, 0.0, 1.0);
            Vector3d sVel = new Vector3d();
            Quat4d srVel = new Quat4d(0.0, 0.0, 0.0, 1.0);

            Subunit subunit = new Subunit(subType, actinDomains, soln, suID++,
                    sPos, sRot, sVel, srVel);

            Vector assemblySubunits = new Vector();
            assemblySubunits.add(subunit);
            Assembly asm = new Assembly(assemblySubunits, asmname);

            assemblies.add(asm);
        }

    }

}