
import java.util.Vector;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Collection;
import java.io.*;
import javax.vecmath.*;

/**
 * Simulation holds all Assembly information and actually runs the queue-based
 * discrete-assembly algorightm
 * 
 * @author Sue Yi Chew
 * @author Rori Rohlfs
 * @author Tiequan Zhang
 * @version 1.0
 *  
 */

public class Simulation {
    int asnum;

    double curtime;

    Solution mysoln;

    private HashMap assemblies;

    private PriorityQueue pq;

    private SimulatorGraphic graphic;

    /* To store average time for different events */
    private HashMap bondTimes; /*
                                * HashMap of HashMap String bstNames | | | | | | | | |
                                * |-> double times[3]. (times[0]-->bindingTime, | |
                                * times[1]-->breakingTime, | |
                                * times[2]-->intraAssemblyBindingTime) | | | |
                                * |__| (Another HashMap, keys are also String
                                * bstNames)
                                */

    private HashMap confTimes; /*
                                * HashMap of HashMap String confNames | | | | | | | | |
                                * |-> double times[1].
                                * (times[0]-->confChangeTime) | | | | | | | |
                                * |__| (Another HashMap, keys are also String
                                * confNames)
                                */


    /**
     * Creates a Simulation with no assemblies/subunits in it. It is not used yet.
     */
    public Simulation() {
        asnum = 0;
        curtime = 0.0;
        mysoln = new Solution();
        assemblies = new HashMap();
        pq = new BinaryHeap();

        //Places initial events in PriorityQueue pq
        prepEventQ();
    }

    /**
     * Creates a Simulation with specified Solution s, Vector of Assemblies a,
     * double current time, and HashMap of bonding times (detailed in private
     * variable definitions), and HashMap of conformation changing times
     * (detailed in private variable definitions)
     * 
     * @param s
     *            Solution the properities of environment in which the
     *            simulation occurs
     * @param initial_Assemblies
     *            Vector of Assemblies to be assembled
     * @param ct
     *            double current time
     * @param bondTimes
     *            HashMap of HashMaps String bstNames | | | | | | | | | |->
     *            double times[4]. (times[0]-->bindingTime, | |
     *            times[1]-->breakingTime, | |
     *            times[2]-->intraAssemblyBindingTime) | | | | |__| (Another
     *            HashMap, keys are also String bstNames)
     * 
     * @param confTimes
     *            HashMap of HashMaps String confNames | | | | | | | | | |->
     *            double times[1]. (times[0]-->confChangeTime) | | | | | | | |
     *            |__| (Another HashMap, keys are also String confNames)
     *  
     */
    public Simulation(Solution s, Vector initial_Assemblies, double ct,
            HashMap bondTimes, HashMap confTimes) {
        asnum = 0;
        mysoln = s;
        assemblies = new HashMap();
        for (int i = 0; i < initial_Assemblies.size(); ++i) {
            addAssembly((Assembly) (initial_Assemblies.get(i)));
        }
        curtime = ct;
        this.bondTimes = bondTimes;
        this.confTimes = confTimes;
        /*
         * confTimes is an empty HashMap bondTimes:"bsta"->HashMap1 HashMap1:
         * "bsta"->Double [3] array:bindTime, breaktime, fastbindtime
         */
        pq = new BinaryHeap();

        //Places initial events in Priority Queue pq based on the end time of an Event, 
        //The Priority Queue is implemented using BinaryHeap
        prepEventQ();
    }

    /**
     * Sample events and placing them in the priority queue, 
     * This method is tested only when initial Assemblies are all monomers 
     */
    private void prepEventQ() {


        Vector assems=new Vector(assemblies.values());
        //System.out.println(assems.size());

        //get new FormBondEvent(s) from initialFreeBss which holds all free BindingSites 
        //from Assembly(s) in assemblies.
        // option 0 will be used for only initialization
        initialize(assems);
    }

    /**
     * Processes the given valid event. That is, all changes on the Simulation caused
     * by ev are carried out and new events are sampled
     * 
     * @param ev
     *            Event
     */
    private void processEvent(Event ev) {
        if (ev instanceof ConfChangeEvent) {
            ConfChangeEvent e = (ConfChangeEvent) ev;
            e.getSubunit().changeConf(e.getDomainID(), e.getNewConf());
            //should add in relax when relavent
        } else if (ev instanceof BreakBondEvent) {
            BreakBondEvent e = (BreakBondEvent) ev;
            Assembly oldasm = (Assembly) assemblies.get((e.getBS())
                    .getAssemName());
            Debug.print(13,oldasm.numSubunits()+"  **********\t"+oldasm.getName());
//In general, splitAssembly will produce a new Assembly with new name method: adding a #
            Assembly newasm = oldasm.splitAssembly(e, asnum);
            //if the splitAssembly makes a new assembly
            if (newasm != null) {
                // add new assembly into HashMap assemblies,
                assemblies.put(newasm.getName(), newasm);
                graphic.addAssemblytoGraphic(newasm);

                // update event's assembly list to reflect what changed i.e.
                // which assemblies to sample from next
            
Debug.print(13,oldasm.numSubunits()+"\t"+ oldasm.getName());
                Debug.print(13,newasm.numSubunits()+"\t"+newasm.getName());
                e.setAssemNamesInvolved(new String[] { oldasm.getName(),
                        newasm.getName() });
                asnum++;
                

            } else {
                Debug.print(13,"here");
            }
        } else if (ev instanceof FormBondEvent) { 
            FormBondEvent e = (FormBondEvent) ev;
            Assembly asm1 = (Assembly) assemblies.get((e.getBS())
                    .getAssemName());
            Assembly asm2 = (Assembly) assemblies.get((e.getPartner())
                    .getAssemName());
            Subunit bsSub = asm1.getSubunit(e.getBS());
            Subunit partnerSub = asm2.getSubunit(e.getPartner());

            Assembly tmp = asm1.bindAssemblies(asm2, e, bsSub, partnerSub);
            if (asm1 != null) {
                Debug.print(8, asm1.getName() + asm1.numSubunits());
            }
            if (asm2 != null) {
                Debug.print(8, "2nd assemL: " + asm2.getName()
                        + asm2.numSubunits());
            }
            if (tmp != null) {
                Debug.print(8, "new assembly: " + tmp.getName());
            }
            //if assemblies couldn't be bound...
            if (tmp != null) {
                //todo how about asm1 and asm2
                //if (tmp!=null)&&(temp.getname() equals asm2 or asm1)
                assemblies.remove((String) asm2.getName());
                addAssembly(tmp);
            }
            //if asm1 and asm2 were different assemblies, remove old assembly
            else if (!(asm1.getName()).equals(asm2.getName())) {
                assemblies.remove((String) asm2.getName());
            }

            //update freesubs (remove relevent bindingsites)

            // Update event's assembly list to know what to sample from next
            ev.setAssemNamesInvolved(new String[] { asm1.getName() });
        } else {
            Debug.print(3, "Error in usage of processEvent() function.");
            System.exit(-1);
        }

        curtime = ev.getEndTime();

    }

    /**
     * Samples new events for the Assemblies named in assems and adds the
     * soonest event for each Assembly named in assems to the priority queue.
     * Assembly given to this method should not have a valid nextEvent.
     * 
     * @param assems
     *            Array of Strings, Assembly names, specifying which Assemblies
     *            to sample new events for.
     */

    /**
     * Returns true if a and b are "close" to each other
     * 
     * @param a
     *            Vector3d
     * @param b
     *            Vector3d
     * @return boolean
     */
    private boolean withinTranslationalBounds(Vector3d a, Vector3d b) {
        Vector3d diff = new Vector3d();
        diff.sub(a, b);

        if (diff.length() < 0.6) {//used 0.6 for icos
            return true;
        }
        return false;
    }

    /**
     * Returns true if a and b are reasonably anti-parallel to each other
     * 
     * @param a
     *            Vector3d
     * @param b
     *            Vector3d
     * @return boolean
     */
    private boolean withinAngularBounds(Vector3d a, Vector3d b) {
        double angle = a.angle(b); //in radians 0 to pi

        if (angle > (4.0 * Math.PI / 5.0)) {
            return true;
        }
        return false;
    }

    /**
     * Returns true if Vector3d a and Vector3d b's up vectors are reasonably
     * parallel
     * 
     * @param a
     *            Vector3d
     * @param b
     *            Vector3d
     * @return boolean
     */
    private boolean withinTorsionalBounds(Vector3d a, Vector3d b) {
        double angle = a.angle(b); //within 0 to pi

        if (angle < (Math.PI / 5.0)) {
            return true;
        }
        return false;
    }

    /**
     * Gets the next Event from the priority queue, processes the Event, relaxes
     * the Assemblies involved and samples new events.
     */
    public void step() {
        //Event priority queue is sorted by endTime
        //printQ();
        Event ev = (Event) pq.remove();
        // printQ();
//validTime of an Assembly is used to find if it is involved in a new Event between  
        //the post time and end time of an Event involved it   
        double[] validTimes = { -1, -1 };

        //todo what array size will be best for capsid
        //assemNames is a String Array of size 2
        String[] assemNames;
        assemNames = ev.getAssemNamesInvolved();

        //check if one or both Assemblies no longer exist, If existing event has a valid time,
        // new Event will be sampled from it
        Assembly asm1 = (Assembly) assemblies.get(assemNames[0]);
        if (assemNames[1] == null) {
            //only one Assembly involved and it no longer exists
            if (asm1 == null) {
                Debug.print(11, (BreakBondEvent) ev + " invalid one_null NA");
                return;
            }
        } else if (assemNames[1] != null) { //two Assemblies involved
            Assembly asm2 = (Assembly) assemblies.get(assemNames[1]);
            //both Assemblies no longer exist
            if (asm1 == null && asm2 == null) {
                Debug.print(11, (FormBondEvent) ev + " invalid both_null NA");
                return;
            }
            //only asm1 no longer exists
            if (asm1 == null && asm2 != null) {
                String a = "bad";
                //sample new events for asm2 before returning
                String[] tmp = { assemNames[1] };
                validTimes[1] = asm2.validTime();
                if (ev.isValid(validTimes)) {
                   // Debug.print(11,"trash "+ev.getPostTime()+" v: "+asm2.validTime());
                    curtime=ev.getEndTime();
                    getNewEvents(tmp);
                    a = "good";
                }
                Debug.print(11, (FormBondEvent) ev + " invalid first_null " + a);
                return;
            }
            //only asm2 no longer exists
            if (asm1 != null && asm2 == null) {
                String a = "bad";
                //sample new events for asm1 before returning
                String[] tmp = { assemNames[0] };
                validTimes[0] = asm1.validTime();
                if (ev.isValid(validTimes)) {
                    curtime=ev.getEndTime();
                    getNewEvents(tmp);
                   // Debug.print(11,"trash: "+tmp[0]);
                    a = "good";
                }
                Debug.print(11, (FormBondEvent) ev + " invalid second_null " + a);
                return;
            }
        }

        //track validTimes
        validTimes[0] = asm1.validTime();
        if (assemNames[1] != null)
            validTimes[1] = ((Assembly) assemblies.get(assemNames[1]))
                    .validTime();

        /**
         * In the case that Assmebly(s) involved in one Event exist,
         * If event is valid, processes it, generates new events for next
         * iteration. else picks another event for an Assembly that is valid(try again)
         *  
         */
        if (ev.isValid(validTimes)) {
            if (ev instanceof FormBondEvent) {
                Debug.print(11, (FormBondEvent) ev + " valid NA NA");
            } else {
                Debug.print(11, (BreakBondEvent) ev + " valid NA NA");
            }
            processEvent(ev);
//  Assembly(s) names in Event ev are update afterprocessEvent
            assemNames = ev.getAssemNamesInvolved();
            /**
             * generates new events for queue based on new current state, only
             * need to update nextEvent for assemblies that were involved in
             * "ev".if only one assembly is involved, second element is null.
             */
            getNewEvents(assemNames);

        }
        //It is tested when only at most two Assemblie(s) are involved
        //One Assembly is invalid, consider the other one in case of FormBondEvent
        else {

            //Consider only maximum two Assmebley(s) in any event
            if (ev instanceof FormBondEvent) {
                if (ev.getPostTime() >= validTimes[0]) {
                    String[] tmp = { assemNames[0] };
                    
                    curtime=ev.getEndTime();
                    getNewEvents(tmp);
                    Debug.print(11, (FormBondEvent) ev
                            + " invalid time second_bad");
                    
                } else if (ev.getPostTime() >= validTimes[1]) {
                    String[] tmp = { assemNames[1] };
                    curtime=ev.getEndTime();
                    getNewEvents(tmp);
                    Debug.print(11, (FormBondEvent) ev
                            + " invalid time first_bad");
                } else {
                  //  Debug.print(11,"trash and"+ev.getPostTime()+" v "+validTimes[0] +"dsf"+validTimes[1]);
                    Debug.print(11, (FormBondEvent) ev
                            + " invalid time both_bad");
                }

            } else if (ev instanceof BreakBondEvent) {
                Debug.print(11, (BreakBondEvent) ev + " invalid time NA");

            } else {
                //Change when future Conformation Event is added
                System.exit(-1);
            }

        }
    }

    /**
     * Runs this simulation by calling step() repeatedly until a certain number
     * of events have been processed. User can hardcode his number here and
     * print the intermediate result to files
     */
    public void run() {
        int iterations_per_run = 1000; //USER SHOULD MODIFY IF DESIRED
        int events_per_printout = 100; //USER SHOULD MODIFY IF DESIRED
        int i = 0;
        //Debug.print(15,"Type Assem_a Assem_b BS_a BS_b Post End Duration
        // Valid Rsn1 Rsn2");
        while (!pq.isEmpty() && i < iterations_per_run) {
          // Debug.print(16,i+" "+myprintAssemblies("re"));
            this.step();
         if (i % events_per_printout == 0) {
           Debug.print(16,i+" "+myprintAssemblies("re"));
         }
           //print the number of Subunits in each Assembly to file
              //printAssemblies("result_" + i);
         // }
           //if ((i>180000) &&(i%100==0)) {
             //  printAssemblies("result_" + i);
           //}
            this.step();
           
            i++;
        }
    }

    /**
     * Puts Assembly a in a HashMap by using its name as the key
     * 
     * @param a
     *            Assembly
     */
    private void addAssembly(Assembly a) {
        assemblies.put(a.getName(), a);
    }

    /*
     * Returns an random number from the exponential distribution with average
     * avg (1/lambda)
     * 
     * @param avg double @return double
     */
    private double getExp(double avg) {
        /**
         * if (rand == null) { System.out.println("rand is null"); }
         */
        return -avg * Math.log(Test.rand.nextDouble());
    }

    /**
     * Returns a random double within [0 , 1)
     * 
     * @return double
     */
    public double getRand() {
        return Test.rand.nextDouble();
    }

    /**
     * Returns a String version of this Simulation
     * 
     * @return String
     */
    public String toString() {
        String mystring = new String("*******Simulation: Current Time: "
                + curtime + "*******\n");
        Collection values = assemblies.values();
        for (Iterator i = values.iterator(); i.hasNext(); mystring += ((Assembly) (i
                .next()) + "\n\n")) {

        }
        mystring += "*****end******";
        return mystring;
    }

    /**
     * Used for debugging. Gets each Assembly in this Simulation and calls
     * relaxAssemblyLots().
     */
    public void relaxAssembliesLots() {
        Iterator it = assemblies.values().iterator();
        while (it.hasNext()) {
            Assembly temp = (Assembly) it.next();
            temp.relaxAssemblyLots();
        }
    }

    /**
     * Used for debugging. Gets each Assembly in this Simulation and calls
     * forxeRelaxAssembly() to force_relax them.
     */
    public void forceRelaxAssemblies() {
        Iterator it = assemblies.values().iterator();
        while (it.hasNext()) {
            Assembly temp = (Assembly) it.next();
            temp.forceRelaxAssembly();
        }
    }

    /**
     * Relaxes each Assembly in this Simulation
     */
    public void relaxAssemblies() {
        Iterator it = assemblies.values().iterator();
        while (it.hasNext()) {
            Assembly temp = (Assembly) it.next();
            temp.relaxAssembly();
        }

    }

    /**
     * todo future never used Returns a Vector of all the Assemblies in this
     * Simulation
     * 
     * @return Vector of Assemblies
     */
    public Vector getAssemblies() {
        Iterator it = assemblies.values().iterator();
        Vector v = new Vector();

        while (it.hasNext()) {
            Assembly temp = (Assembly) it.next();
            v.add(temp);
        }
        return v;
    }

    /**
     * 
     * Creates a SimulatorGraphic based on this Simulation and returns it.
     * 
     * @return SimulatorGraphic
     */
    public SimulatorGraphic startGraphic() {
        graphic = new SimulatorGraphic(this);
        return graphic;
    }

    /*
     * prints the current pq to standard out by find min and copy it to new
     * priorityQueue, after all elements are displayed, the temportary priority
     * queue is copied back to pq
     */
    public void printQ() {
        int i = 1;
        Vector tempv = new Vector();
        while (!pq.isEmpty()) {
            Event ev = (Event) pq.remove();
            if (ev instanceof FormBondEvent) {
                System.out.println(i+"Q: "+(FormBondEvent)ev);
                
            } else if (ev instanceof BreakBondEvent){
                System.out.println(i+"Q: "+(BreakBondEvent)ev);
            } else {
                System.out.println("what is wrong");
            }
            
           // double diff = ev.getEndTime() - ev.getPostTime();
            //Debug.print(5, "" + diff);
            i++;
            tempv.add(ev);
        }
        for (int j = 0; j < tempv.size(); j++) {
            pq.add((Event) tempv.get(j));
        }
    }

    /**
     * Prints the size of each Assembly in current Simulation by Walking through
     * HashMap assemblies and geting the size. The result is saved in string
     * fileName
     * 
     * @param fileName
     *            String the name of file to which the result is saved
     */
    private void printAssemblies(String fileName) {

        Iterator it = assemblies.values().iterator();
        int i = 0;
        int assembliesSize = assemblies.values().size();
        PrintWriter fileOut = null;

        try {
            fileOut = new PrintWriter(new FileWriter(fileName));

            while (i < assembliesSize) {
                i++;
                Assembly tem = (Assembly) it.next();
                fileOut.println(tem.numSubunits());
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        if (fileOut != null)
            fileOut.close();
    }
    private int myprintAssemblies(String fileName) {

        Iterator it = assemblies.values().iterator();
        int i = 0;
        int total=0;
        int assembliesSize = assemblies.values().size();
        //PrintWriter fileOut = null;

        //try {
          //  fileOut = new PrintWriter(new FileWriter(fileName));

            while (i < assembliesSize) {
                i++;
                Assembly tem = (Assembly) it.next();
                int k=tem.numSubunits();
                if (k==1) {
                    total+=1;
                }
          //      fileOut.println(tem.numSubunits());
            }
//        } catch (IOException e) {
  //          e.printStackTrace();
    //    }
      //  if (fileOut != null)
        //    fileOut.close();
            return total;
    }

    /**
     * CheckPairSeen use a private Vector of int[2] to hold pairs of Integer,
     * user can add Integer pair by using addPair(int i, int j) and check if
     * some Inter pair has been added by using marked(int i, int j), the order
     * of Inter in any pairs will not affect the returned value.
     */
    private class CheckPairSeen {

        private Vector seen; //vector of double[2], which are the seen pairs

        public CheckPairSeen() {
            seen = new Vector();
        }

        public void addPair(int i, int j) {
            seen.add(new double[] { i, j });
        }

        public boolean marked(int i, int j) {
            double[] tmp;
            for (int k = 0; k < seen.size(); ++k) {
                tmp = (double[]) (seen.get(k));
                if ((tmp[0] == i && tmp[1] == j)
                        || (tmp[0] == j && tmp[1] == i)) {
                    return true;
                }
            }
            return false;
        }
    }

    /**
     * This class is used in method SampleUnique to record the two BindingSite
     * Vector indexes that point to two BindingSites involved in a FormBondEvent
     * and the duration of this FormBondEvent.
     */
    private class PairTime {
        int first;

        int second;

        double minTime=Double.MAX_VALUE;
        FormBondEvent formBE;

        public PairTime() {
        }

        public PairTime(int f, int s, FormBondEvent tem) {
            first = f;
            second = s;
           // eventTime = time;
            formBE=tem;
        }
    }
    /**
     * 
     * @param allfreebss, Vector, For initialization, it holds all free BindingSites in inital monomers
     * During the run, it holds all free BindingSites of two Assemblies that will be sampled for new Event(s)
     * @param option, int, 0 is for initialization of simulation Events, 1 is for FormBondEvent(s) samping during the run between two parent Assembly(s)
     * @return Vector, It makes sense During the run, it returns possible FormBondEvents sampled two Assembly(s)
     *
     */
   
    /**
     * Sample new Event(s) from Assmeblies whose names are in assems
     * In the case of two Assemblies, it is possible only one FormBondEvent is sampled
     * if two FormBondEvent from two Assemblies involved the same pair of BindingSite(s)
     * @param assems, the name(s) of Assemblie(s) that will be sampled Event
     *
     */
    private void getNewEvents(String[] assems) {
//      Vector of free bindingsites in current Assembly(s) whose name is in assems
        //Debug.print(11,curtime+" getnew "+ assems[0]);

        Vector freeBss = new Vector(); 
//      Vector of all free bindingSites in Simulation except those free BindingSite(s) in Assembly(s) whose
//      names are in array assems
        Vector otherFreeBss = new Vector();
        Vector otherMonomerBss=new Vector();
        Vector boundBss = new Vector(); //Vector of bound BindingSite(s) in
        // current Assembly(s) from assems

        /**
         * Walks through all Assembly(s) in this Simulation, finds and saves all
         * the other free BindingSite(s) by checking if each one is bound and is
         * in Assembly(s) specified by assems
         */

        Iterator it = assemblies.values().iterator();
        Assembly temAssembly;
        Vector tmpsubs;
        Vector tmpbsv;
        BindingSite tmpbs;
        while (it.hasNext()) {
            temAssembly = (Assembly) it.next();
            Debug.checkFalse(temAssembly != null, "error 1 in getNewEvents.");
            boolean found = false;
            for (int i = 0; ((i < assems.length) && (assems[i] != null)); i++) {
                if ((temAssembly.getName()).equals(assems[i])) {
                    found = true;
                    break;
                }
            }
            if (found)
                continue;
            boolean isMonomer=false;
            tmpsubs = temAssembly.getSubunits();
            if (tmpsubs.size()==1) {
             isMonomer=true;
            }
            
            for (int i = 0; i < tmpsubs.size(); ++i) {
                tmpbsv = ((Subunit) tmpsubs.get(i)).getBindSites();
                Debug.print(7, tmpbsv.size()
                        + "is the number of Subunit(s) in assemlbly"
                        + temAssembly.getName());
                for (int j = 0; j < tmpbsv.size(); ++j) {
                    tmpbs = (BindingSite) (tmpbsv.get(j));
                    if (!tmpbs.isBound()) {
                        otherFreeBss.add(tmpbs);
                        if (isMonomer) {
                            otherMonomerBss.add(tmpbs);
                        }
                    }
                }
            }
        }
        Debug.print(6, "freebsssize" + freeBss.size());
        Debug.print(6, "otherFreeBsssize" + otherFreeBss.size());
        Debug.print(6, "boundbsssize" + boundBss.size());

        /**
         * Find all other free bss in the system except all the assemblies
         * represented by string [] assems, For each assembly, find both free
         * and bound bss The following scheme apply when we don't allow a self
         * loop in a assmebly If we have only one assembly to be processed,
         * compare min bound Event from its free bss and all other free bss and
         * min breakbound Event among all bound bss in this assembly If we have
         * two assemblies to be processed, for each assembly, sample min
         * BreakBoundEvent, sample min FormBoundEvent from its free bss and all
         * other free bss, sample min Form Bound Event, find the min Event from
         * 3 events mentioned above then we get two events, if both are
         * FormBound and involve the same pair of bindingSite from two
         * assemblies, only put either noe of them into priority queue, or else
         * put both into priority queue.
         * 
         *  
         */
        Vector myfreebss = new Vector();
        Vector myMinEvent = new Vector();
        for (int i = 0; i < assems.length; ++i) {
            if (assems[i] == null) {
                System.out.println("mynull assembly here: " + i);
                myMinEvent.add(i, null);
            } else {
                //size of temFreeBss could be 0, such as in self-looped
                // assembly
                Vector temFreeBss = getFreeBss(assems[i]);
                if (temFreeBss.size() != 0)
                    myfreebss.addAll(temFreeBss);
                Assembly assem = (Assembly) assemblies.get(assems[i]);
                Debug.checkFalse((assemblies.get(assems[i])) != null,
                        "error2 in getNewEvents");
                
                //If assem could not produce next event, shoudl I still update
                // the time?
                assem.setValidTime(curtime);
                Debug.print(9, "finding an event for assembly: " + assems[i]
                        + "at time: " + curtime);
                boolean isSingle=false;
                if (assem.numSubunits()==1){
                    isSingle=true;
                }
                //size of Vector from getBoundBss(assems[i]) could be 0
                Event minBreakBondEvent = sampleBoundbss(getBoundBss(assems[i]));
                Event minFormBondEventWithOther;                
                if (isSingle) {
                    minFormBondEventWithOther = sampleFreebssWithOther(
                            temFreeBss, otherFreeBss);
                } else {
                    minFormBondEventWithOther = sampleFreebssWithOther(
                            temFreeBss, otherMonomerBss);
                }
                
                
            /**    Event minFormBondEventWithOther = sampleFreebssWithOther(
                        temFreeBss, otherFreeBss);*/
                        
                if ((minBreakBondEvent == null)
                        && (minFormBondEventWithOther == null)) {
                    myMinEvent.add(i, null);
                } else if ((minBreakBondEvent != null)
                        && (minFormBondEventWithOther == null)) {
                    myMinEvent.add(i, minBreakBondEvent);
                } else if ((minBreakBondEvent == null)
                        && (minFormBondEventWithOther != null)) {
                    myMinEvent.add(i, minFormBondEventWithOther);
                } else if (minBreakBondEvent
                        .compareTo(minFormBondEventWithOther) == 1) {
                    myMinEvent.add(i, minBreakBondEvent);
                } else {
                    myMinEvent.add(i, minFormBondEventWithOther);
                }

            }
        }
        // Debug.print(9,"my boundssize "+myMinEvent.size());
        Vector formBondEvents = new Vector();
        if (assems.length==1) {
            formBondEvents.add(null);
        } else if (assems.length==2) {
            Assembly a=(Assembly) assemblies.get(assems[0]);
            Assembly b=(Assembly) assemblies.get(assems[1]);
            FormBondEvent t=sampleTwoAssems(a,b);
            formBondEvents.add(t);
            formBondEvents.add(t);
        }
        
        for (int i = 0; i < formBondEvents.size(); i++) {
            FormBondEvent a = (FormBondEvent) (formBondEvents.get(i));
            if (a == null)
                continue;
            String[] assemInvolved = a.getAssemNamesInvolved();
            for (int j = 0; j < myMinEvent.size(); j++) {
                if (assems[j] == null)
                    continue;
                if ((assems[j].equals(assemInvolved[0]))
                        || (assems[j].equals(assemInvolved[1]))) {
                    Event b = (Event) (myMinEvent.get(j));
                    if (a.compareTo(b) == 1) {
                        myMinEvent.set(j, a);
                    }
                }

            }
        }
        //consider only the maxmimum number of Assembly(s) involved in an Event
        // is 2
        Event minEvent0 = (Event) myMinEvent.get(0);
        Event minEvent1 = null;
        if (myMinEvent.size() == 2) {
            minEvent1 = (Event) myMinEvent.get(1);
        }
        if ((minEvent0 != null) && (minEvent1 == null)) {
            sendEvent(minEvent0);
        } else if ((minEvent0 == null) && (minEvent1 != null)) {
            sendEvent(minEvent1);
        } else if ((minEvent0 != null) && (minEvent1 != null)) {
            if (minEvent0 != minEvent1) {
                sendEvent(minEvent0);
                sendEvent(minEvent1);
            } else {
                sendEvent(minEvent0);
            }
        }
    }

   

    /**
     * Gets free BindingSites from Assemblie whose name is assemName
     * @param assemName
     * @return Vector, size could be 0 such as self-loop
     *  
     */
    private Vector getFreeBss(String assemName) {
        Debug.checkFalse(assemName != null, "error 0 in getFreeBss");
        Debug.checkFalse(assemblies.containsKey(assemName),
                "error 1No assembly in getFreeBss.");
        Assembly assem = (Assembly) assemblies.get(assemName);
        Vector subs = assem.getSubunits();
        Vector freeBss = new Vector();

        for (int j = 0; j < subs.size(); ++j) {
            Subunit sub = (Subunit) subs.get(j);
            //add all the binding sites in this subunit into freeBss
            Vector bindsites = sub.getBindSites();
            for (int k = 0; k < bindsites.size(); ++k) {
                BindingSite bs = (BindingSite) bindsites.get(k);
                if (!bs.isBound())
                    freeBss.add(bs);
            }
        }

        //freeBss size could be 0
        return freeBss;
    }

    /**
     * Gets bound BindingSites from Assemblie whose name is assemName
     * @param assemName
     * @return Vector, the size could be 0
     *  
     */
    private Vector getBoundBss(String assemName) {
        Debug.checkFalse(assemName != null, "error 0 in getBoudnBss");
        Debug.checkFalse(assemblies.containsKey(assemName),
                "error 1No assembly in getBoundBss.");
        Assembly assem = (Assembly) assemblies.get(assemName);
        Vector subs = assem.getSubunits();
        Vector BoundBss = new Vector();

        for (int j = 0; j < subs.size(); ++j) {
            
            Subunit sub = (Subunit) subs.get(j);
            //foraction: adds the following two lines to find the Subunits on both ends of an Assembly, 
            if ((sub.getBoundSubunits()).size()!=1)
                continue;
            Vector bindsites = sub.getBindSites();
            for (int k = 0; k < bindsites.size(); ++k) {
                BindingSite bs = (BindingSite) bindsites.get(k);
                if (bs.isBound())
                    BoundBss.add(bs);
            }
        }

        //size could be 0
        return BoundBss;
    }

    /**
     * From a Vector of bound BindingSites that are in the same Assembly, find an BreakBondEvent with the
     * minimum duration. Before calling this method, Vector boundbss should be
     * checked to make sure it is not empty.
     * 
     * @param boundBss,
     *            non-empty Vector of BindingSites
     * @return BreakBondEvent
     *  
     */

    private BreakBondEvent sampleBoundbss(Vector boundBss) {
        if (boundBss.size() == 0) {
            return null;
        }
        double duration = 0;
        double minTime = Double.MAX_VALUE;
        double[] bTimes;
        BindingSite temBs, temPartner;
        BindingSite minBs = new BindingSite();
        BindingSite minPartner = new BindingSite();
        CheckPairSeen cps = new CheckPairSeen();
        //go thru boundsubs, looking at all possible bond breaking events
        for (int j = 0; j < boundBss.size(); j++) {
            // Debug.print(5, "boundBss " + boundBss.size() + "is :" + j);
            temBs = (BindingSite) boundBss.get(j);
            temPartner = temBs.getPartner();
            if (cps.marked(temBs.getid(), temPartner.getid()))
                continue;
            //else mark it seen now
            cps.addPair(temBs.getid(), temPartner.getid());
            bTimes = (double[]) (((HashMap) (bondTimes.get(temBs.getBST()
                    .getName()))).get(temPartner.getBST().getName()));
            duration = getExp(bTimes[1]);
            //Debug.print(6, "bTimes[1] is: " + bTimes[1]);
            //if this is the fastest Event so far, store it
            if (minTime >= duration) {
                minTime = duration;
                minBs = temBs;
                minPartner = temPartner;
            }
        }
        Debug
                .checkFalse(minTime != Double.MAX_VALUE,
                        "error in sampleBoundbss");
        String[] assemNames = { minBs.getAssemName(), null };
        return new BreakBondEvent(curtime, minTime + curtime, assemNames,
                minBs, minPartner);
    }

    /**
     * Before use this method, check if freeBss is empty( a self-loop) or Dimer
     * and otherFreeBss is empty
     * 
     * @param freeBss, Vector of free BindingSite(s) in one or two Assembly(s) being sampled
     * @param otherFreeBss, Vector of free BingingSite(s) in other Assembly(s)
     * @return FormBondEvent or a null event
     *  
     */
    //TODO consider self loop in the future
    private FormBondEvent sampleFreebssWithOther(Vector freeBss,
            Vector otherFreeBss) {
        if ((freeBss.size() == 0) || (otherFreeBss.size() == 0))
            return null;
        double duration = 0;
        double minTime = Double.MAX_VALUE;
        double[] bTimes;
        BindingSite minBs = new BindingSite();
        BindingSite minPartner = new BindingSite();
        for (int i = 0; i < freeBss.size(); i++) {
            // Debug.print(5, "boundBss " + boundBss.size() + "is :" + i);

            BindingSite temBs = (BindingSite) freeBss.get(i);
            for (int j = 0; j < otherFreeBss.size(); j++) {
                BindingSite temPartner = (BindingSite) otherFreeBss.get(j);

                if (!temBs.canBindTo(temPartner)) //check for compatable
                    // bindingsiteTypes
                    continue;

                bTimes = (double[]) (((HashMap) (bondTimes.get(temBs.getBST()
                        .getName()))).get(temPartner.getBST().getName()));
                duration = getExp(bTimes[0]);
                //Debug.print(6, "bTimes[1] is: " + bTimes[1]);
                //if this is the fastest Event so far, store it
                if (minTime >= duration) {
                    minTime = duration;
                    minBs = temBs;
                    minPartner = temPartner;
                }
            }
        }
        Debug.checkFalse(minTime != Double.MAX_VALUE,
                "error2 in sampleFreebssWithOther");
        String[] assemNames = { minBs.getAssemName(), minPartner.getAssemName() };
        return new FormBondEvent(curtime, curtime + minTime, assemNames, minBs,
                minPartner);

    }
    /**
     * update the information of Assembly(s) involved an Event e to be sent to pq, 
     * @param e, Event
     *
     */
  private void sendEvent(Event e) {
        //for different bstypes, null is ok, consider it later
        Debug.checkFalse(e != null, "error0 in sendEvent");
        //e.getEndTime >=0 ?
        Debug.checkFalse(e.getEndTime() != Double.MAX_VALUE,
                "error1 in sendEvent.");
        Debug.checkFalse(e.getEndTime() >= curtime, "error2 in sendEvent.");
        String[] asms = e.getAssemNamesInvolved();
        ((Assembly) assemblies.get(asms[0])).setNextEvent(e);
        if (asms[1] != null){
            ((Assembly) assemblies.get(asms[1])).setNextEvent(e);
        
        }
        if (e instanceof FormBondEvent){
            Assembly a0=(Assembly) assemblies.get(asms[0]);
            Assembly a1=(Assembly) assemblies.get(asms[1]);
           // Debug.print(16,a0.numSubunits()+"\t"+a1.numSubunits());
        }
        if (e instanceof FormBondEvent) {
            Debug.print(10,"20: "+(FormBondEvent)e);
            
        } else if (e instanceof BreakBondEvent){
            Debug.print(10,"20: "+(BreakBondEvent)e);
        } else {
            System.out.println("what is wrong");
        }
        
        
        pq.add(e);
    }
  private FormBondEvent sampleTwoAssems(Assembly A1, Assembly A2) {
      //if (A1==A2) {
      if(A1.equals(A2)) {
          return null;
      }
      Vector bss1=getFreeBss(A1.getName());
      Debug.checkFalse(bss1.size()==2,"error1 in sampleTwoAssems");
      Vector bss2=getFreeBss(A2.getName());
      Debug.checkFalse(bss2.size()==2,"error2 in sampleTwoAssems");
      
      Debug.print(10,((BindingSite)bss1.get(0)).getid()+"sampletwo"+A1.getName()+" and "+A2.getName());
      Debug.print(10,((BindingSite)bss1.get(1)).getid()+"sampletwo"+A1.getName()+" and "+A2.getName());
      Debug.print(10,((BindingSite)bss2.get(0)).getid()+"sampletwo"+A1.getName()+" and "+A2.getName());
      Debug.print(10,((BindingSite)bss2.get(1)).getid()+"sampletwo"+A1.getName()+" and "+A2.getName());
      
      
     int primary=-1;
     int partner=-1;
     double[] bTimes;
     double minTime=Double.MAX_VALUE;
     double duration=0;
    
          for (int i = 0; i < bss1.size(); i++) {
              BindingSite temBs = (BindingSite) bss1.get(i);
              for (int j = 0; j < bss2.size(); j++) {
                  BindingSite temPartner = (BindingSite) bss2.get(j);
              if (!temBs.canBindTo(temPartner)) //check for compatable
                  // bindingsiteTypes
                  continue;

              bTimes = (double[]) (((HashMap) (bondTimes.get(temBs.getBST()
                      .getName()))).get(temPartner.getBST().getName()));
              duration = getExp(bTimes[0]);
              //Debug.print(6, "bTimes[1] is: " + bTimes[1]);
              //if this is the fastest Event so far, store it
              if (minTime >= duration) {
                  minTime = duration;
                  primary = i;
                  partner = j;
              }
          }
      }
          Debug.checkFalse(minTime!=Double.MAX_VALUE,"error3 in sampleTwoAssems");
              String[] assemNamesInvolved={A1.getName(),A2.getName()};
      return new FormBondEvent(curtime, curtime+duration,assemNamesInvolved, (BindingSite) bss1.get(primary),(BindingSite) bss2.get(partner));
      
  }
  private void initialize(Vector allAsems) {
//allfreebss=allAssembly
      int size=allAsems.size();
      if ( size== 0)
          return ;
      FormBondEvent[] formBondArray=new FormBondEvent[size];
//This Array can be thought as mapping from BindingSites to int, it also include information about two BindingSite in FormBondEvent and duration time
   //   PairTime[] temPairTimes = new PairTime[allAsems.size()];
//This block samples possible FormBondEvent(s) among BingingSite(s), The time of Event involved the same pair of BindingSites is sampled only once,
      //For each BindingSite, the mimimum sampled time will be used 
//It is memory-efficient
      for (int i = 0; i < size; i++) {
          Assembly assem_i = (Assembly) allAsems.get(i);
          
          Debug.checkFalse(assem_i != null, "error 0 in sampleUnique1");
          for (int j = 0; j < i; j++) {
              Assembly assem_j = (Assembly) allAsems.get(j);
              Debug.checkFalse(assem_j != null, "error 1 in sampleUnique1");

              //This condition will not work for the binding within the same
              // assembly, fix it later
              Debug.checkFalse(!(assem_i.equals(assem_j)),"error 2 in sampUnique1");
             
              FormBondEvent tem=sampleTwoAssems(assem_i,assem_j);
                  double eventTime=tem.getEndTime();
                  
                  if (formBondArray[i]==null) {
                      formBondArray[i]=tem;
                  } 
                  if (formBondArray[j]==null) {
                      formBondArray[j]=tem;
                  } 
                  if (eventTime <formBondArray[i].getEndTime()) {
                      formBondArray[i]=tem;
                  }                      
                  if (eventTime < formBondArray[j].getEndTime()) {
                      
                     formBondArray[j]=tem;
                  }

              }
          }
      
      /**
       * Walk through the list of possible FormBondEvent for all free
       * BindingSites, for each event, if no other event involve the same two
       * BindingSites as that event, it will be put into the priority queue 
       * for further processing, or else, onle the second copy of the duplicated event is
       * chosen and send to the priority queue in the case of initialization,
       * For sampling during the run, the unique FormBoundEvent will be saved to Vector FormBoundEvents for future comparison with other 
       * Events sampled form the same pair of Assembly(s) 
       *  
       */
    //  Vector FormBoundEvents = new Vector();
      for (int k = 0; k < size; k++) {
         // int first = temPairTimes[k].first;
          //int second = temPairTimes[k].second;
          //double temDuration = temPairTimes[k].eventTime;
          //if (temPairTimes[k].eventTime == Double.MAX_VALUE) {
            /**  if (option == 0) {
                  //for virus assmbly, there will be different bs, so
                  // consider it later
                  System.out.println("error3 in sameUnique");
                  System.exit(-1);
              } else {
                  continue;
              }
          }*/
          Debug.checkFalse(formBondArray[k].getEndTime()!=Double.MAX_VALUE,"error 3 in sampleUnique1");
boolean repeat=false;
          for (int m=k+1;m<size;m++)
          {
              Debug.checkFalse(formBondArray[m].getEndTime()!=Double.MAX_VALUE,"error 4 in sampleUnique1");

              if((formBondArray[k])==(formBondArray[m])) {
                  repeat=true;
                  break;
              }
                 
          }
          if (repeat==false) {
              sendEvent(formBondArray[k]);
              Debug.print(10,"init:  "+formBondArray[k]);
          }
      }
  }
          //Since first < second, when we meet the first duplicated pair, ignore it
          

}
