
import java.io.*;
import java.beans.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 * @author Sue Yi Chew
 * @version 1.0
 * 
 * TODO update in the future
 *  
 */
public class NewSubunitDialog extends JDialog implements ActionListener,
        ListSelectionListener, PropertyChangeListener {

    private int numDomains; // number of domains in this subunit

    JOptionPane optionPane;

    //JPanel mainPanel; //main panel for subunit questions
    JTextField filename; //stores the name of the file to read from, if the
                         // subunit is to be read from a file

    JTextField subunittype; //stores subunittype if it is to be entered
                            // manually

    JTextField subunitmass; //stores subunitmass if it is to be entered
                            // manually

    Object[] options;

    JRadioButton fromFile, notFromFile;

    JButton toRead;

    /** start -- for domainsPanel* */
    private JPanel domainsPanel;

    private DefaultListModel dListModel;

    private JList dList;

    private JLabel numDomainsLabel;

    private JButton displayDomainDetailsB, addNewDomainB;

    /** end -- for domainsPanel* */

    public NewSubunitDialog(JDialog aComp) {
        super(aComp, true);

        setSize(500, 450);

        /** ******start -- Setting up JPanel for new subunit questions******* */
        JPanel mainPanel = new JPanel();

        fromFile = new JRadioButton("Read from File");
        fromFile.addActionListener(this);
        fromFile.setSelected(true);
        notFromFile = new JRadioButton("Enter subunit properties");
        notFromFile.addActionListener(this);

        //Group the radio buttons
        ButtonGroup group = new ButtonGroup();
        group.add(fromFile);
        group.add(notFromFile);

        /** JPanel for reading from file* */
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, BoxLayout.Y_AXIS));
        filename = new JTextField(15);
        toRead = new JButton("Browse");
        toRead.addActionListener(this);
        top.add(fromFile);
        top.add(new JLabel("Filename:"));
        top.add(filename);
        top.add(toRead);

        /** JPanel for manually specifying properties* */
        JPanel mid = new JPanel();
        mid.setLayout(new BoxLayout(mid, BoxLayout.Y_AXIS));
        subunittype = new JTextField(10);
        subunittype.setEnabled(false);
        subunitmass = new JTextField(10);
        subunitmass.setEnabled(false);

        //Domain List
        initDomainsPanel();

        mid.add(notFromFile);
        mid.add(new JLabel("Name of Subunit Type:"));
        mid.add(subunittype);
        mid.add(domainsPanel);
        mid.add(new JLabel("Subunit mass:"));
        mid.add(subunitmass);

        mainPanel.add(top, BorderLayout.NORTH);
        mainPanel.add(mid, BorderLayout.CENTER);
        /** *****end -- Setting up JPanel for new subunit questions******* */

        //Create an array specifying the number of dialog buttons and their
        // text.
        options = new Object[1];
        options[0] = "OK";

        //Create the JOptionPane.
        optionPane = new JOptionPane(mainPanel, JOptionPane.QUESTION_MESSAGE,
                JOptionPane.YES_OPTION, null, options);

        //Make this dialog display it.
        setContentPane(optionPane);

        //Handle window closing correctly.
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent we) {
                /*
                 * Instead of directly closing the window, we're going to change
                 * the JOptionPane's value property.
                 */
                optionPane.setValue(new Integer(JOptionPane.CLOSED_OPTION));
            }
        });

        //Register an event handler that puts the text into the option pane.
        //textField.addActionListener(this);

        //Register an event handler that reacts to option pane state changes.
        optionPane.addPropertyChangeListener(this);

    }

    private void initDomainsPanel() {
        //setting up panel
        domainsPanel = new JPanel();
        domainsPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        domainsPanel.setLayout(new BoxLayout(domainsPanel, BoxLayout.Y_AXIS));

        //number of domains display
        numDomainsLabel = new JLabel("Number of domains: " + numDomains);

        //Create the list and put it in a scroll pane.
        dListModel = new DefaultListModel();
        dList = new JList(dListModel);
        dList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        dList.addListSelectionListener(this);
        dList.setVisibleRowCount(4);
        dList.setEnabled(false);
        JScrollPane dListScrollPane = new JScrollPane(dList);

        //initializing the 2 buttons
        displayDomainDetailsB = new JButton(
                "Display/Edit chosen domain details");
        displayDomainDetailsB.addActionListener(this);
        displayDomainDetailsB.setEnabled(false); //should not be enabled unless
                                                 // notFromFile is selected, and
                                                 // a domain is selected from
                                                 // list
        addNewDomainB = new JButton("Add new domain");
        addNewDomainB.addActionListener(this);
        addNewDomainB.setEnabled(false);

        //local JPanel for buttons -- layout only
        JPanel bPanel = new JPanel();
        bPanel.setLayout(new BoxLayout(bPanel, BoxLayout.Y_AXIS));
        bPanel.add(displayDomainDetailsB);
        bPanel.add(addNewDomainB);

        //adding the components to the panel
        domainsPanel.add(dListScrollPane);
        domainsPanel.add(bPanel);

    }

    public void actionPerformed(ActionEvent e) {

        if (e.getSource().equals(fromFile)) {

            filename.setEnabled(true);
            toRead.setEnabled(true);
            subunittype.setEnabled(false);
            subunitmass.setEnabled(false);
            displayDomainDetailsB.setEnabled(false);
            addNewDomainB.setEnabled(false);
            dList.setEnabled(false);

        } else if (e.getSource().equals(notFromFile)) {

            filename.setEnabled(false);
            toRead.setEnabled(false);
            subunittype.setEnabled(true);
            subunitmass.setEnabled(true);
            displayDomainDetailsB.setEnabled(true);
            addNewDomainB.setEnabled(true);
            dList.setEnabled(true);

        } else if (e.getSource().equals(toRead)) { //choosen to read Subunit
                                                   // details from file
            JFileChooser fc = new JFileChooser();

            int returnVal = fc.showOpenDialog(this);

            if (returnVal == JFileChooser.APPROVE_OPTION) {
                File file = fc.getSelectedFile();

                //Insert code to open file here

                //update textfield
                filename.setText(file.getName());

                System.out.println("Subunit file to open: " + file.getName());
            } else {
                System.out.println("Open command cancelled by user.");
            }
        } else if (e.getSource().equals(displayDomainDetailsB)) { //display
                                                                  // domain
                                                                  // details

            //debug
            System.out.println("clicked to display domain details");

            int chosenSubunitIndex = dList.getSelectedIndex();
            if (chosenSubunitIndex == -1) {
                System.out
                        .println("Error, you must choose a domain from the list first.");
            } else {
                System.out.println("(display the domain properties)");
            }

        } else if (e.getSource().equals(addNewDomainB)) { //add new domain
            System.out.println("clicked to add new domain");

            //update numDomains
            numDomains++;

            //insert code to open a new window and obtain details required

            //add new bond to the list
            dListModel.addElement("Domain #" + (numDomains - 1)); //some
                                                                  // description
                                                                  // of the
                                                                  // subunit
                                                                  // bond e.g.
                                                                  // between 1
                                                                  // and 3

        }

    }

    //This method is required by ListSelectionListener.
    public void valueChanged(ListSelectionEvent e) {

        if (e.getSource() == dList) { //from domain list

            if (e.getValueIsAdjusting() == false) {

                if (dList.getSelectedIndex() == -1) {
                    //No selection, disable show domain properties button
                    displayDomainDetailsB.setEnabled(false);

                } else {
                    //Selection, enable show domain properties button
                    displayDomainDetailsB.setEnabled(true);
                }
            }
        }

    }

    /** This method clears the dialog and hides it. */
    public void clearAndHide() {
        setVisible(false);
    }

    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();

        if (isVisible()
                && (e.getSource() == optionPane)
                && (JOptionPane.VALUE_PROPERTY.equals(prop) || JOptionPane.INPUT_VALUE_PROPERTY
                        .equals(prop))) {
            Object value = optionPane.getValue();

            if (value == JOptionPane.UNINITIALIZED_VALUE) {
                //ignore reset
                return;
            }

            //Reset the JOptionPane's value.
            //If you don't do this, then if the user
            //presses the same button next time, no
            //property change event will be fired.
            optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);

            clearAndHide();
        }

    }

}