
import java.util.Vector;
import java.util.HashMap;
import javax.vecmath.*;

/**
 * Dimer class sets up a dimer formation scenerio, where each Subunit has a 
 * single BindingSite and all BindingSites are compatable
 * 
 * @author Rori Rohlfs
 *  
 */
public class Dimer {
    private static Simulation sim;

    private static Solution soln;

    private static Vector assemblies;

    private static String[] bstData; //BindingSiteType data

    private static int bsID = 0; //BindingSite ID

    private static int domainID = 0; //Domain ID

    private static int stID = 0; //SubunitType ID

    private static int suID = 0; //SubunitID

    //binding and breaking rates are set here:
    private double bindTime = 1.0;    //average time for a binding event

    private double breakTime = 1.0;      //average time for a breaking event

    private double fastbindtime = 0.01;

    /**
     * Constructs a Dimer Simulation with default parameters, implements the binding and unbinding rate 
     */

    public Dimer() {
        soln = new Solution();
        initAssembly();

        
        double[] bindbreak1 = new double[3];
        bindbreak1[0] = bindTime;
        bindbreak1[1] = breakTime;
        bindbreak1[2] = fastbindtime;
  
        HashMap bst1HashMap = new HashMap();
        bst1HashMap.put(new String("bsta"), bindbreak1);

        HashMap bondtimes = new HashMap();
        bondtimes.put(new String("bsta"), bst1HashMap);

        HashMap conftimes = new HashMap();

        sim = new Simulation(soln, assemblies, 0.0, bondtimes, conftimes);
    }

    /**
     * static method Returns Simulation of Actin
     * 
     * @return Simulation
     *  
     */
    public static Simulation getSim() {
        return sim;
    }

    /**
     * 
     * Sets the initial number of actin subunits, creates all Subunits with
     * increasing bsID,domainID,ConformationID and stID, each Assembly only
     * contains one Subunit, at this time,Adds all Assembly to Vector Assemblies
     *  
     */
    private static void initAssembly() {
        //Initial number of Subunits are set here.
        int numSubunits = 2;

        assemblies = new Vector();

        //Creates a BindingSiteType objects
        double[] tolerances = { 0.2, 0.1, 0.1 };
        Vector partners1 = new Vector();
        Vector partners2 = new Vector();
        partners1.add("bsta");
        BindingSiteType bsta = new BindingSiteType(tolerances, "bsta", partners1);



        //make pos and rot arrays for binding sites
        Vector3d bspos = new Vector3d(0.0, 0.08, 0.0);    //hardcoded from radius
        Quat4d bsor = new Quat4d(0.0, 0.0, 0.0, 1.0);  //points up

        //loop for making subunittypes
        Vector subts = new Vector();
        for (int i = 0; i < numSubunits; i++) {
            String asmname = "assem" + i;
            BindingSite bsa = new BindingSite(bsta, bsID++, domainID, suID,
                    asmname, bspos, bsor, new Vector3d(1.0, 0.0, 0.0));

           // System.out.println(bsa);
            //System.out.println("in Dimer bindsite bsa");
            /**
             * Add BindingSite to Vector bss to create Conformation
             */
            Vector bss = new Vector();
            bss.add(bsa);

            /**
             * Add Conformation of a Subunit to Vector confs to create Domain
             */
            Vector confs = new Vector();
            Conformation conf = new Conformation(bss, 6.6, "subt1only");
            confs.add(conf);

            /**
             * Add Domain of a Subunit to Vector Confsets to create SubunitType
             */
            Domain dom = new Domain("only", confs, new Vector3d(), domainID, conf);
            Vector doms = new Vector();
            doms.add(dom);

            SubunitType subt = new SubunitType(doms, "only", soln, 3.4, 0.08);

            subts.add(subt);

	    //initialize position/rotation and velocities for the subunit
            Vector3d sPos = new Vector3d();
            Quat4d sRot = new Quat4d(0.0, 0.0, 0.0, 1.0);
            Vector3d sVel = new Vector3d();
            Quat4d srVel = new Quat4d(0.0, 0.0, 0.0, 1.0);

            Subunit subunit = new Subunit(subt, doms, soln, suID++, sPos,
                    sRot, sVel, srVel);

	    //add the subunit to an assembly
            Vector asmsubs = new Vector();
            asmsubs.add(subunit);
            Assembly asm = new Assembly(asmsubs, asmname);

	    //add assembly to assembly list
            assemblies.add(asm);
        }

    }

}
