/**
 * ConfChangeEvent extends Event and is specified with Subunit, ID of Domain and
 * Conformation involved in Conformation change event
 * 
 * @author Sue Yi Chew
 * @version 1.0
 */
public class ConfChangeEvent extends Event {

    private Subunit subunit; //the subunit that this ConfChangeEvent occurs in;

    private int dmid; // Domain id

    private Conformation myConformation;

    /**
     * Constructs ConfChangeEvent which extends Event, with the specified Curent
     * time, end time and names of Assemblies and Subunit involved, int domainID
     * and Conformation conf
     * 
     * @param curTime
     *            double, Event post time TODO explain endTime
     * @param endTime
     *            double, used for priority
     * @param assemNamesInvolved
     *            String[]
     * @param sub
     *            Subunit
     * @param domainID
     *            int
     * @param conf
     *            Conformation
     */
    public ConfChangeEvent(double curTime, double endTime,
            String[] assemNamesInvolved, Subunit sub, int domainID,
            Conformation conf) {
        super(curTime, endTime, assemNamesInvolved);
        subunit = sub;
        dmid = domainID;
        myConformation = conf;
    }

    /**
     * Gets the subunit involved in ConfChangeEvent
     * 
     * @return subunit
     */
    public Subunit getSubunit() {
        return subunit;
    }

    /**
     * Gets the ID of Domain involved in ConfChangeEvent
     * 
     * @return int ID of Domain
     */

    public int getDomainID() {
        return dmid;
    }

    /**
     * Gets the Conformationt involved in ConfChangeEvent
     * 
     * @return Conformation
     */
    public Conformation getNewConf() {
        return myConformation;
    }

    /**
     * Prints the information of Assembly names, posting time, end time related
     * to this ConfChangeEvent
     * 
     * @return String
     */

    public String toString() {
        String assemNames = "";
        String[] assemNamesInvolved = super.getAssemNamesInvolved();
        for (int i = 0; i < assemNamesInvolved.length; ++i) {
            assemNames += assemNamesInvolved[i] + " ";
        }

        return ("ConfChangeEvent: (Assemblies: " + assemNames + ", PostTime: "
                + super.getPostTime() + ", EndTime: " + super.getEndTime() + ")");

    }

}