
/**
 * 
 * BreakBondEvent and is specified with two BindingSites involved in bond break event
 * @author Rori Rohlfs
 * @version 1.0
 *
 * TODO 
 *
 */

public class BreakBondEvent extends Event {

    private BindingSite bs;
    private BindingSite partner;

    /**
     * Constructs a subclass of Event, First three parameters are used for
     * Event Construction. BindingSite bs and partner are involved in the
     * break of a bond
     * 
     * @param curTime
     *            double, Event post time
     * @param endTime
     *            double, used for priority
     * @param assemNamesInvolved
     *            String[]
     * @param bs
     *            BindingSite
     * @param partner
     *            BindingSite
     */
    public BreakBondEvent(double curTime, double endTime, String[] assemNamesInvolved, 
                          BindingSite bs, BindingSite partner) {
        super(curTime, endTime, assemNamesInvolved);
        this.bs = bs;
        this.partner = partner;

    }
    /**
     * Returns BindingSite involved in this BreakBondEvent
     * 
     * @return BindingSite
     *  
     */
    
    public BindingSite getBS() {
        return bs;
    }
    /**
     * Returns BindingSite to be involved in this BreakBondEvent
     * 
     * @return BindingSite
     *  
     */
    public BindingSite getPartner() {
        return partner;
    }
    /**
     * Prints the information of Assemblies, BindingSite and Subunit involved in
     * this BreakBondEvent
     * 
     * @return String
     */
    
    public String toString() {
        String assemNames = "";
        String[] assemNamesInvolved = super.getAssemNamesInvolved();
        for(int i=0; i<assemNamesInvolved.length; ++i) {
            assemNames += assemNamesInvolved[i] + " ";
        }
        double duration=super.getEndTime()-  super.getPostTime();
        return ("BreakBondEvent " + assemNames  + bs.getid() +  " " + partner.getid()+" "+ super.getPostTime() 
                + " " + super.getEndTime() + " "+duration );
     /** 
        return ("BreakBondEvent: (Assemblies: " + assemNames + ", PostTime: " + super.getPostTime() 
                + ", EndTime: " + super.getEndTime() + ", bs id " + bs.getid() + " on subunit: " + bs.getSubunitID() 
                + ", bs's partner id " + partner.getid() + " on subunit: " + partner.getSubunitID() + ")");
*/
    }

    
}
