
import javax.media.j3d.*;
import javax.vecmath.*;
import java.util.Vector;
/** done
 * remove old Random(), use static Random() rand in Test.java
 * 
 *
 */

/**
 * Extends branchGroup to make a complete Assembly graphic.
 *  		AssemblyGraphic
 *  			| 
 *                TransformGroup      
 *                    /  |  \ ...
 *        SubunitGraphics ........
 * 
 * @author Rori Rohlfs
 * @version 1.0
 *
 *
 */
public class AssemblyGraphic extends BranchGroup {
   // Random gen = new Random();

    TransformGroup tg;

    /**
     * Constructs a default AssemblyGraphic with a default detachable BranchGroup 
     */
    public AssemblyGraphic() {
        super();
        this.setCapability(BranchGroup.ALLOW_DETACH);
        this.setCapability(Group.ALLOW_CHILDREN_WRITE);

        tg = new TransformGroup();
        tg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        tg.setCapability(Group.ALLOW_CHILDREN_WRITE);

        this.addChild(tg);
    }

    /**
     * Constructs a AssemblyGraphic with a detachable childWritable BranchGroup.
     * The SubunitGraphics for each Subunit in Assembly asm are added as children.  
     * The graphic is given a "random" orientation and the identity position.
     */
    public AssemblyGraphic(Assembly asm) {
        super();
        this.setCapability(BranchGroup.ALLOW_DETACH);
        this.setCapability(Group.ALLOW_CHILDREN_WRITE);

	Transform3D tr = new Transform3D(new Quat4d(Test.rand.nextDouble(), Test.rand.nextDouble(), Test.rand.nextDouble(), Test.rand.nextDouble()),
			    new Vector3d(), 1.0);

        tg = new TransformGroup(tr);
        tg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        tg.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        tg.setCapability(Group.ALLOW_CHILDREN_WRITE);
        tg.setCapability(Group.ALLOW_CHILDREN_READ);
        tg.setCapability(Group.ALLOW_CHILDREN_EXTEND);

        /**
         * Draws every Subunit of Assembly asm
         */
        Vector s = asm.getSubunits();
        for (int i = 0; i < s.size(); i++) {
            SubunitGraphic cursub = ((Subunit) s.elementAt(i))
                    .getSubunitGraphic();
            cursub.detach();
            tg.addChild(cursub);
        }
        this.addChild(tg);

    }

    /**
     * Updates the whole assembly graphic's new location specificed by rot and
     * pos
     * 
     * @param rot
     *            Quat4d the rotation of new location
     * @param pos
     *            Vector3d the position of new location
     */

    public void updateLocation(Quat4d rot, Vector3d pos) {
        Transform3D trans = new Transform3D(rot, pos, 1.0);
        tg.setTransform(trans);
    }

    /**
     * Updates the whole assembly graphic's new location specificed Transform3D tr
     * 
     * @param tr
     *            Transform3D
     */
    public void updateLocation(Transform3D tr) {
    	tg.setTransform(tr);
    }

    /**
     * Adds the graphic of Subunit sub to the assembly graphic
     * 
     * @param sub 
     *            Subunit to be added to Assembly
     */
    public void addSubunit(Subunit sub) {
        SubunitGraphic sg = sub.getSubunitGraphic();
        sg.detach();
        tg.addChild(sg);
    }

    /**
     * Return AssemblyGraphic as a BranchGroup
     * 
     * @return BranchGroup
     */
    public BranchGroup branchGroup() {
        return (BranchGroup) this;
    }

    /**
     * Returns position of the binding site in relation to the real axis
     * 
     * @param sub
     *            Subunit
     * @param bs
     *            BindingSite of sub
     * @return Vector3d 
     *  
     */
    public Vector3d getBindingSitePos(Subunit sub, BindingSite bs) {
	//get the translation of this AssemblyGraphic
        Transform3D asmtranst = new Transform3D();
        tg.getTransform(asmtranst);
        Vector3d asmtrans = new Vector3d();
        asmtranst.get(asmtrans);

        //get the position of the bindingsite in relation to the subunit
        Vector3d subtrans = sub.getBSPos(bs);//getBindingSitePos(bs);

        Vector3d sum = new Vector3d();
        sum.add(asmtrans, subtrans);

        return sum;
    }

    /**
     * Returns the rotation of bs in relation to the real axis
     * 
     * @param sub
     *            Subunit
     * @param bs
     *            BindingSite of sub
     * @return Quat4d
     */
    public Quat4d getBindingSiteRot(Subunit sub, BindingSite bs) {
	//get the rotation of this AssemblyGraphic
	Transform3D asmtranst = new Transform3D();
        tg.getTransform(asmtranst);
        Quat4d asmrot = new Quat4d();
        asmtranst.get(asmrot);
        asmrot=Debug.checkQ4d(asmrot,asmtranst);

	//get the rotation of bs in relation to sub
        Quat4d subrot = sub.getBSRot(bs);//getBindingSiteRot(bs);

        Quat4d prod = new Quat4d();
        prod.mul(subrot, asmrot);

        return prod;
    }

    /**
     * Gets the rotation component of this AssemblyGraphic
     * 
     * @return Quat4d
     */
    public Quat4d getRot() {
        Transform3D asmtranst = new Transform3D();
        tg.getTransform(asmtranst);
        Quat4d asmrot = new Quat4d();
        asmtranst.get(asmrot);
        asmrot=Debug.checkQ4d(asmrot,asmtranst);
        return asmrot;
    }

    /**
     * Gets the translation component(position) of this AssemblyGraphic
     * 
     * @return Vector3d
     */
    public Vector3d getPos() {
        Transform3D asmtranst = new Transform3D();
        tg.getTransform(asmtranst);
        Vector3d asmpos = new Vector3d();
        asmtranst.get(asmpos);
        return asmpos;
    }

    /**
     * Sets position of this AssemblyGraphic to newpos
     * 
     * @param newpos
     *            Vector3d
     */
    public void setPos(Vector3d newpos) {
        //get Transform3d of tg
        Transform3D asmtranst = new Transform3D();
        tg.getTransform(asmtranst);

        //sets transform3d to newpos, keeps all else the same
        asmtranst.setTranslation(newpos);
        tg.setTransform(asmtranst);
    }

    /**
     * Sets rotation of this AssemblyGraphic to newrot
     * 
     * @param newrot
     *            Quat4d
     */
    public void setRot(Quat4d newrot) {
        //gets Transform3d of tg
        Transform3D asmtranst = new Transform3D();
        tg.getTransform(asmtranst);

        //sets Transform3d (and tg) to newrot, keeps all else the same
        asmtranst.setRotation(newrot);
        tg.setTransform(asmtranst);
    }

    /**
     * Rotates this AssemblyGraphic by rot
     * 
     * @param rot
     *            Quat4d
     */
    public void rotate(Quat4d rot) {
        //get transform3d of tg
        Transform3D asmtranst = new Transform3D();
        tg.getTransform(asmtranst);

        //gets current rotation component
        Quat4d asmrotq = new Quat4d();
        asmtranst.get(asmrotq);
        asmrotq=Debug.checkQ4d(asmrotq,asmtranst);

        Quat4d prod = new Quat4d();
        prod.mul(rot, asmrotq);

        //sets Transform3d (and tg) to prod
        asmtranst.setRotation(prod);
        tg.setTransform(asmtranst);
    }

    /**
     * Gets the Transform3D of this AssemblyGraphic
     * 
     * @return Transform3D
     */
    public Transform3D getTransform() {
        Transform3D t = new Transform3D();
        tg.getTransform(t);
        return t;
    }
}
