
import java.util.Vector;
import java.util.HashMap;
import javax.vecmath.*;

/**
 * Tubulin sets up a filament-like scenerio, where there is one type of Subunit
 * with a single Conformation and Domain and two binding sites. The initial
 * number of Subunits, and the binding and breaking times control the assembly
 * of Actin
 * 
 * @author Tiequan Zhang
 * @version 1.2
 *  
 */
public class Tubulin {
    private static Simulation sim;

    private static Solution soln;

    private static Vector assemblies;

    private static int bsID = 0; //BindingSite ID

    private static int domainID = 0; //Domain ID

    private static int stID = 0; //SubunitType ID

    private static int suID = 0; //SubunitID

    //binding and breaking rates are set here:
    private double bindTime = Test.bindTime; //average time for a binding event

    private double breakTime = Test.breakTime; //average time for a breaking

    // event

    private double fastbindtime = Test.fastbindtime; //not applicable in an

    // this simulation

    private static double radius = Test.subunitRadius;

    //Initial number of Subunits are set here.
    private static int numSubunits = Test.numSubunits;

    private static HashMap bindingPartner = new HashMap();

    /**
     * Constructs an Tubulin Simulation.
     *  
     */
    public Tubulin() {
        soln = new Solution();
        initAssembly();

        double[] bindbreak1 = new double[3];
        bindbreak1[0] = bindTime;
        bindbreak1[1] = breakTime;
        bindbreak1[2] = fastbindtime;
        double[] bindbreak2 = new double[3];
        bindbreak2[0] = bindTime;
        bindbreak2[1] = breakTime;
        bindbreak2[2] = fastbindtime;

        double[] nobindbreak = new double[3];
        nobindbreak[0] = 99999999999999.0;
        nobindbreak[1] = 0.00000000000001;
        nobindbreak[2] = 99999999999999.0;

        HashMap bst1HashMap = new HashMap();
        bst1HashMap.put(new String("bsta"), nobindbreak);
        bst1HashMap.put(new String("bstb"), bindbreak1);

        HashMap bst2HashMap = new HashMap();
        bst2HashMap.put(new String("bsta"), bindbreak2);
        bst2HashMap.put(new String("bstb"), (double[]) nobindbreak.clone());

        HashMap bondtimes = new HashMap();
        bondtimes.put(new String("bsta"), bst1HashMap);
        bondtimes.put(new String("bstb"), bst2HashMap);

        HashMap conftimes = new HashMap();

        sim = new Simulation(soln, assemblies, 0.0, bondtimes, conftimes,
                bindingPartner);
    }

    /**
     * Returns Simulation of Tubulin
     * 
     * @return Simulation
     */
    public static Simulation getSim() {
        return sim;
    }

    /**
     * 
     * Creates all Subunits with appropriate bsID, domainID, ConformationID and
     * stID. Adds all Assembly to Vector Assemblies
     *  
     */
    private static void initAssembly() {
        assemblies = new Vector();

        //Creates two BindingSiteType objects with ID 0 and 1
        double[] tolerances = { 0.2, 0.1, 0.1 };
        Vector partnersa = new Vector();
        Vector partnersb = new Vector();
        partnersa.add("bstb");
        BindingSiteType bsta = new BindingSiteType(tolerances, "bsta",
                partnersa);
        partnersb.add("bsta");
        BindingSiteType bstb = new BindingSiteType(tolerances, "bstb",
                partnersb);
        bindingPartner.put("bsta", partnersa);
        bindingPartner.put("bstb", partnersb);

        //The radius of a sphere is 0.08, and the center( half of the distance
        // from tip to base)
        //of a cone is 0.05, 13 subunit will form a turn
        Vector3d posD1 = new Vector3d(-0.12624512 * 0.08 / 0.13,
                0.03101886 * 0.08 / 0.13, 0);//get from radius

        Quat4d orD1 = new Quat4d(0, 0, 0.6170062, 0.7869583);
        Vector3d bsUp1 = new Vector3d(0, 0.0, 1);

        Vector3d posD2 = new Vector3d(0.12624512 * 0.08 / 0.13,
                0.03101886 * 0.08 / 0.13, 0);
        Quat4d orD2 = new Quat4d(0, 0, -0.6170062, 0.7869583);
        Vector3d bsUp2 = new Vector3d(0, 0.0, -1);

        //loop for making subunittypes
        Vector subts = new Vector();
        for (int i = 0; i < numSubunits; i++) {
            String asmname = "assem" + i;
            BindingSite bsa = new BindingSite(bsta, bsID++, domainID, suID,
                    asmname, posD1, orD1, bsUp1);
            BindingSite bsb = new BindingSite(bstb, bsID++, domainID, suID,
                    asmname, posD2, orD2, bsUp2);
            bsa.colorYellow();
            bsb.colorGreen();
            /**
             * Adds two BindingSites of one Subunit to Vector bss to create
             * Conformation
             */
            Vector bss = new Vector();
            bss.add(bsa);
            bss.add(bsb);

            /**
             * Adds one Conformation of a Subunit to Vector confs to create
             * Domain
             */
            Vector confs = new Vector();
            Conformation conf = new Conformation(bss, 6.6, "subt1only");
            confs.add(conf);

            /**
             * Adds one Domain of a Subunit to Vector Confsets to create
             * SubunitType
             */
            Domain dom = new Domain("only", confs, new Vector3d(), domainID,
                    conf);
            Vector doms = new Vector();
            doms.add(dom);
            SubunitType subt = new SubunitType(doms, "only", soln, 3.4, 0.08);
            subts.add(subt);

            /**
             * set initial position, rotation, velocity, and rotational velocity
             */
            Vector3d sPos = new Vector3d(0, 0, 0);
            Quat4d sRot = new Quat4d(0.0, 0.0, 0.0, 1.0);
            Vector3d sVel = new Vector3d();
            Quat4d srVel = new Quat4d(0.0, 0.0, 0.0, 1.0);

            Subunit subunit = new Subunit(subt, doms, soln, suID++, sPos, sRot,
                    sVel, srVel);
            Vector asmsubs = new Vector();
            asmsubs.add(subunit);
            Assembly asm = new Assembly(asmsubs, asmname);

            assemblies.add(asm);
        }

    }

}