
import java.util.Vector;
import java.util.*;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Collection;
import java.io.*;
import javax.vecmath.*;

/**
 * Simulation holds all Assembly information and actually runs the queue-based
 * discrete-assembly algorightm
 * 
 * @author Sue Yi Chew
 * @author Rori Rohlfs
 * @author Tiequan Zhang
 * @version 1.2 log for conf switching: for filament: only free monomer has
 *          confchange event,
 *  
 */

public class Simulation {

	int asnum;

	int maxLength = Test.maxLength;

	static int currentStep = 0;

	double curtime;
	

	Solution mysoln;

	private HashMap assemblies;

	private HashMap bstPartner;

	private int[] freeBSs;

	private int[] monomerBSs;

	//static int[] distribution = new int[5];

	private PriorityQueue pq;

	private HashMap bstIndex = new HashMap();

	private SimulatorGraphic graphic;

	/* To store average time for different events */
	private HashMap bondTimes; /*
							    * HashMap of HashMap String bstNames | | | | | | | | |
							    * |-> double times[3]. (times[0]-->bindingTime, | |
							    * times[1]-->breakingTime, | |
							    * times[2]-->intraAssemblyBindingTime) | | | |
							    * |__| (Another HashMap, keys are also String
							    * bstNames)
							    */

	private HashMap confTimes; /*
							    * HashMap of HashMap String confNames | | | | | | | | |
							    * |-> double times[1].
							    * (times[0]-->confChangeTime) | | | | | | | |
							    * |__| (Another HashMap, keys are also String
							    * confNames)
							    */

	/**
	 * Creates a Simulation with specified Solution s, Vector of Assemblies a,
	 * double current time, and HashMap of bonding times (detailed in private
	 * variable definitions), and HashMap of conformation changing times
	 * (detailed in private variable definitions)
	 * 
	 * @param s
	 *            Solution the properities of environment in which the
	 *            simulation occurs
	 * @param initial_Assemblies
	 *            Vector of Assemblies to be assembled
	 * @param ct
	 *            double current time
	 * @param bondTimes
	 *            HashMap of HashMaps String bstNames | | | | | | | | | |->
	 *            double times[3]. (times[0]-->bindingTime, | |
	 *            times[1]-->breakingTime, | |
	 *            times[2]-->intraAssemblyBindingTime) | | | | |__| (Another
	 *            HashMap, keys are also String bstNames)
	 * 
	 * @param confTimes
	 *            HashMap of HashMaps String confNames | | | | | | | | | |->
	 *            double times[1]. (times[0]-->confChangeTime) | | | | | | | |
	 *            |__| (Another HashMap, keys are also String confNames)
	 * @param bindingPartner
	 *            HashMap of BindingSite type and corresponding compatable
	 *            BindingSite types
	 */
	public Simulation(Solution s, Vector initial_Assemblies, double ct,
			HashMap bondTimes, HashMap confTimes, HashMap bindingPartner) {
		asnum = 0;
		
		mysoln = s;
		 
		assemblies = new HashMap();
		bstPartner = bindingPartner;
		initializeBstIndex();
		freeBSs = new int[3];
		monomerBSs = new int[3];
		for (int i = 0; i < initial_Assemblies.size(); ++i) {

			Assembly tem = (Assembly) (initial_Assemblies.get(i));
			assemblies.put(tem.getName(), tem);
			int[] a = tem.getBSCounts();

			if (tem.numSubunits() == 1) {
				updateCounts(monomerBSs, a, true);
			}

			updateCounts(freeBSs, a, true);
		}

		curtime = ct;
		/*System.out.println(currentStep + " " + curtime + " "
				+ getDistribution());*/
		this.bondTimes = bondTimes;
		this.confTimes = confTimes;

		/*
		 * confTimes is an empty HashMap bondTimes:"bsta"->HashMap1 HashMap1:
		 * "bsta"->Double [3] array:bindTime, breaktime, fastbindtime
		 */
		pq = new BinaryHeap();

		//Places initial events in Priority Queue pq based on the end time of
		// an Event,
		//The Priority Queue is implemented using BinaryHeap
		Vector assems = new Vector(assemblies.values());
		if (Test.csAllowed) {

			initConfChange(assems);
		} else {
			initialize(assems);
		}
	}

	private void initializeBstIndex() {
	
		bstIndex.put("bsta", new Integer(0));
		bstIndex.put("bstb", new Integer(1));
		bstIndex.put("bstc", new Integer(2));
	
	}

	private void initialize(Vector allAssems) {
		int size = allAssems.size();
		if (size == 0)
			return;
		FormBondEvent[] formBondArray = new FormBondEvent[size];
		//This Array will hold FormBondEvent with min duration for each
		// Assembly
		//Two Assembly(s) could have the same FormBondEvent, which will be
		// processed in next block
		// The time of FormBondEvent involvingthe same pair of Assembly(s) is
		// sampled
		// only once,
		//It is memory-efficient
		for (int i = 0; i < size; i++) {
			Assembly assem_i = (Assembly) allAssems.get(i);
	
			Debug.checkFalse(assem_i != null, "error 0 in sampleUnique1");
			for (int j = 0; j < i; j++) {
				Assembly assem_j = (Assembly) allAssems.get(j);
				Debug.checkFalse(assem_j != null, "error 1 in sampleUnique1");
	
				//This condition will not work for the binding within the same
				// assembly, fix it later
				Debug.checkFalse(!(assem_i.equals(assem_j)),
						"error 2 in sampUnique1");
				//sampleTwoAssems samples the possible FormBondEvent(s) between
				// two bindingSite(s) from two assembly(s)
				//The event with min duration will be returned
				//for subunit with two BindingSite(s), The total number of
				// sampling is 2 between two Assembly(s)
				FormBondEvent tem = sampleTwoAssems(assem_i, assem_j);
				double eventTime = tem.getEndTime();
	
				if (formBondArray[i] == null) {
					formBondArray[i] = tem;
				}
				if (formBondArray[j] == null) {
					formBondArray[j] = tem;
				}
				if (eventTime < formBondArray[i].getEndTime()) {
					formBondArray[i] = tem;
				}
				if (eventTime < formBondArray[j].getEndTime()) {
	
					formBondArray[j] = tem;
				}
	
			}
		}
	
		/**
		 * Walk through the list of possible FormBondEvent for all free
		 * BindingSites, for each event, if no other event involve the same two
		 * BindingSites as that event, it will be put into the priority queue
		 * for further processing, or else, onle the second copy of the
		 * duplicated event is chosen and send to the priority queue in the case
		 * of initialization, For sampling during the run, the unique
		 * FormBoundEvent will be saved to Vector FormBoundEvents for future
		 * comparison with other Events sampled form the same pair of
		 * Assembly(s)
		 *  
		 */
		/**
		 * find duplicated event for formBondArray, walk through the event
		 * array, if two identical events are found, only the one with a larger
		 * array index number will be sent to the queue.
		 */
	
		for (int k = 0; k < size; k++) {
	
			/**
			 * for virus shell assmbly, there will be different bs, consider it
			 * later
			 */
	
			Debug.checkFalse(formBondArray[k].getEndTime() != Double.MAX_VALUE,
					"error 3 in sampleUnique1");
			boolean repeat = false;
			for (int m = k + 1; m < size; m++) {
				Debug.checkFalse(
						formBondArray[m].getEndTime() != Double.MAX_VALUE,
						"error 4 in sampleUnique1");
	
				if ((formBondArray[k]) == (formBondArray[m])) {
					repeat = true;
					break;
				}
	
			}
			if (repeat == false) {
			    ((Assembly)allAssems.get(k)).setValidTime(curtime);
				sendEvent(formBondArray[k]);
			}
		}
	}

	private void initConfChange(Vector allAssems) {
		int size = allAssems.size();
		if (size == 0)
			return;
		/**
		 * sample conchange event for each assembly send to queue
		 */
		for (int i = 0; i < size; i++) {
			Assembly assem = (Assembly) allAssems.get(i);
	ConfChangeEvent cs=getConfChangeEvent(assem);
	assem.setValidTime(curtime);
			sendEvent(cs);
		}
	}

	/**
	 * Runs this simulation by calling step() repeatedly until a certain number
	 * of events have been processed. User can hardcode his number here and
	 * print the intermediate result to files
	 */
	public void run() {
		int iterations_per_run = Test.iterations_per_run; //USER SHOULD MODIFY
		// IF DESIRED
		int events_per_printout = Test.events_per_printout; //USER SHOULD
		// MODIFY IF DESIRED
		int i = 0;
		long oldTime = System.currentTimeMillis();
	
		while (!pq.isEmpty() && i < iterations_per_run) {
	
			if ((Test.stepPrint) && (i % events_per_printout == 0)) {
				 printAssembliesToFile("tem");
			}
			/*long currentTime = System.currentTimeMillis();
			long stepTime = currentTime - oldTime;
			oldTime = currentTime;
		System.out.println(i+"\t"+stepTime/1000);*/
			step();
			i++;
		}
	}

	public void step() {
	   
		currentStep++;
	
		Event ev = (Event) pq.remove();
		curtime=ev.getEndTime();
		
		//validTime of an Assembly is used to find if it is involved in a new
		// Event between
		//the post time and end time of an Event involved it
		double[] validTimes = { -1, -1 };
	
		//todo what array size will be best for capsid
		//assemNames is a String Array of size 2
		String[] assemNames;
		assemNames = ev.getAssemNamesInvolved();
	
		//check if one or both Assemblies no longer exist, If existing event
		// has a valid time,
		// new Event will be sampled from it
		Assembly asm1 = (Assembly) assemblies.get(assemNames[0]);
		if (assemNames[1] == null) {
			//only one Assembly involved and it no longer exists
			if (asm1 == null) {
				if (ev instanceof BreakBondEvent) {
					Debug.print(11, (BreakBondEvent) ev + " i");
				} else if (ev instanceof ConfChangeEvent) {
					Debug.print(11, (ConfChangeEvent) ev + " i");
				} else {
					System.out.print("bug in setpasm1");
				}
				return;
			}
		} else if (assemNames[1] != null) { //two Assemblies involved
			Assembly asm2 = (Assembly) assemblies.get(assemNames[1]);
			//both Assemblies no longer exist
			if (asm1 == null && asm2 == null) {
				Debug.print(11, (FormBondEvent) ev + " i");
				return;
			}
			//only asm1 no longer exists
			if (asm1 == null && asm2 != null) {
				String a = "bad";
				//sample new events for asm2 before returning
				String[] tmp = { assemNames[1] };
				validTimes[1] = asm2.validTime();
				if (ev.isValid(validTimes)) {
					getNewEvents(tmp);
					a = "good";
				}
				Debug.print(11, (FormBondEvent) ev + " i");
				return;
			}
			//only asm2 no longer exists
			if (asm1 != null && asm2 == null) {
				String a = "bad";
				//sample new events for asm1 before returning
				String[] tmp = { assemNames[0] };
				validTimes[0] = asm1.validTime();
				if (ev.isValid(validTimes)) {
					getNewEvents(tmp);
					a = "good";
				}
				Debug.print(11, (FormBondEvent) ev + " i");
				return;
			}
		}
	
		//track validTimes
		validTimes[0] = asm1.validTime();
		if (assemNames[1] != null)
			validTimes[1] = ((Assembly) assemblies.get(assemNames[1]))
					.validTime();
	
		/**
		 * In the case that Assmebly(s) involved in one Event exist, If event is
		 * valid, processes it, generates new events for next iteration. else
		 * picks another event for an Assembly that is valid(try again)
		 *  
		 */
	
		if (ev.isValid(validTimes)) {
			if (ev instanceof FormBondEvent) {
				Debug.print(11, (FormBondEvent) ev + " v");
			} else if (ev instanceof ConfChangeEvent) {
				Debug.print(11, (ConfChangeEvent) ev + " v");
			} else if (ev instanceof BreakBondEvent) {
				Debug.print(11, (BreakBondEvent) ev + " v");
			} else {
				System.out.println("buginvalidtime");
			}
			//If one assembly binds with another assembly and any hindrance is
			// detected,
			//,update time, and sample new events
			//curtime = ev.getEndTime();
			processEvent(ev);
	
			//  Assembly(s) names in Event ev are update afterprocessEvent
	
		}
		//It is tested when only at most two Assemblie(s) are involved
		//One Assembly is invalid, consider the other one in case of
		// FormBondEvent
		else {
	
			//Consider only maximum two Assmebley(s) in any event
			if (ev instanceof FormBondEvent) {
				if (ev.getPostTime() >= validTimes[0]) {
					String[] tmp = { assemNames[0] };
	
					
					getNewEvents(tmp);
					Debug.print(11, (FormBondEvent) ev + " i");
					
	
				} else if (ev.getPostTime() >= validTimes[1]) {
					String[] tmp = { assemNames[1] };
					getNewEvents(tmp);
					Debug.print(11, (FormBondEvent) ev + " i");
					
					
				} else {
					Debug.print(11, (FormBondEvent) ev + " i");
					
				}
	
			} else if (ev instanceof BreakBondEvent) {
				Debug.print(11, (BreakBondEvent) ev + " i");
				
	
			} else if (ev instanceof ConfChangeEvent) {
				Debug.print(11, (ConfChangeEvent) ev + " i");
				
			}
	
			else {
				//Change when future Conformation Event is added
				System.out.println("buginvalidtime");
				System.exit(-1);
			}
			//ev = null;
	
		}
		updateMonomerCount();
		/*String dis = getDistribution();
		if (dis != null) {
			System.out.println(currentStep + " " + curtime + " " + dis);
		} else {
		}*/
	}

	/**
	 * Processes the given valid event. That is, all changes on the Simulation
	 * caused by ev are carried out and new events are sampled before call
	 * processEvent,curTime should be updated
	 * 
	 * @param ev
	 *            Event
	 */
	private void processEvent(Event ev) {

		
		if (ev instanceof ConfChangeEvent) {
			ConfChangeEvent e = (ConfChangeEvent) ev;
			// Todo remove next block
			{
				Subunit tem = e.getSubunit();
				Debug.checkFalse(tem.isUnbound(),
						"in processEvent, to be used for virus");
			}
			Assembly assem = (Assembly) assemblies.get(e
					.getAssemNamesInvolved()[0]);
			updateCounts(freeBSs, assem.getBSCounts(), false);
			if (assem.numSubunits() == 1) {
				updateCounts(monomerBSs, assem.getBSCounts(), false);
			}
			assem.setValidTime(curtime);
			e.getSubunit().changeConf(e.getDomainID(), e.getNewConf());
			e
					.setAssemNamesInvolved(new String[] { e
							.getAssemNamesInvolved()[0] });
			updateCounts(freeBSs, assem.getBSCounts(), true);
			if (assem.numSubunits() == 1) {
				updateCounts(monomerBSs, assem.getBSCounts(), true);
			}

			//should add in relax when relavent
		} else if (ev instanceof BreakBondEvent) {

			BreakBondEvent e = (BreakBondEvent) ev;
			Assembly oldasm = (Assembly) assemblies.get((e.getBS())
					.getAssemName());
			BindingSite bs = e.getBS();
			BindingSite partner = e.getPartner();
			simpleUpdateCountsAll(bs, true);
			simpleUpdateCountsAll(partner, true);

			//In general, splitAssembly will produce a new Assembly with new
			// name method: adding a #
			Assembly newasm = oldasm.splitAssembly(e, asnum);
			
			
			//if the splitAssembly makes a new assembly
			if (newasm != null) {
				assemblies.put(newasm.getName(), newasm);
				graphic.addAssemblytoGraphic(newasm);

				// update event's assembly list to reflect what changed i.e.
				// which assemblies to sample from next

				e.setAssemNamesInvolved(new String[] { oldasm.getName(),
						newasm.getName() });
				asnum++;
				if (newasm.numSubunits() == 1) {

					updateCounts(monomerBSs, newasm.getBSCounts(), true);

				}
				if (oldasm.numSubunits() == 1) {

					updateCounts(monomerBSs, oldasm.getBSCounts(), true);

				}
				newasm.setValidTime(curtime);
				oldasm.setValidTime(curtime);

			} else {
				double fastBindingInterval = 0.0;
				oldasm.setValidTime(curtime);
				String[] sameAssembly = { e.getAssemNamesInvolved()[0],
						e.getAssemNamesInvolved()[0] };
				FormBondEvent fastBindingEvent = new FormBondEvent(curtime,
						curtime + fastBindingInterval, sameAssembly, e.getBS(),
						e.getPartner());
				sendEvent(fastBindingEvent);

				return;

			}
		} else if (ev instanceof FormBondEvent) {

			//FormBondEvent could be normal two-assembly binding or binding
			// within a loop in one assembly
			//in normal two-assembly binding, the result could be one larger
			// assembly or nothind due to hindrance

			FormBondEvent e = (FormBondEvent) ev;
			Assembly asm1 = (Assembly) assemblies.get((e.getBS())
					.getAssemName());
			BindingSite bs = e.getBS();
			BindingSite partner = e.getPartner();
			Assembly asm2 = (Assembly) assemblies.get((e.getPartner())
					.getAssemName());
			Debug.checkFalse((asm1 != null) && (asm2 != null),
					"error_in_processEvent_formbond");
			Subunit bsSub = asm1.getSubunit(e.getBS());
			Subunit partnerSub = asm2.getSubunit(e.getPartner());
			//binding within a loop

			if (asm1 == asm2) {
				simpleUpdateCountsAll(bs, false);
				simpleUpdateCountsAll(partner, false);
				asm1.setValidTime(curtime);
				asm1.fastBind(e);
				ev.setAssemNamesInvolved(new String[] { asm1.getName() });
			} else if ((asm1.numSubunits() + asm2.numSubunits()) <= Test.maxLength) {

				updateCounts(freeBSs, asm1.getBSCounts(), false);
				updateCounts(freeBSs, asm2.getBSCounts(), false);

				if (asm1.numSubunits() == 1) {

					updateCounts(monomerBSs, asm1.getBSCounts(), false);
				}

				if (asm2.numSubunits() == 1) {
					updateCounts(monomerBSs, asm2.getBSCounts(), false);

				}

				Assembly tmp = asm1.bindAssemblies(asm2, e, bsSub, partnerSub);
				if (tmp != null) {

					assemblies.remove((String) asm2.getName());
					ev.setAssemNamesInvolved(new String[] { asm1.getName() });
					asm1.setValidTime(curtime);
					updateCounts(freeBSs, asm1.getBSCounts(), true);

				} else {
					//hindrance found
					asm1.setValidTime(curtime);
					asm2.setValidTime(curtime);
					updateCounts(freeBSs, asm1.getBSCounts(), true);
					updateCounts(freeBSs, asm2.getBSCounts(), true);
					if (asm1.numSubunits() == 1) {
						updateCounts(monomerBSs, asm1.getBSCounts(), true);
					}
					if (asm2.numSubunits() == 1) {
						updateCounts(monomerBSs, asm2.getBSCounts(), true);
					}
				}

			} else {
				asm1.setValidTime(curtime);
				asm2.setValidTime(curtime);
			}
		}

		/**
		 * generates new events for queue based on new current state, only need
		 * to update nextEvent for assemblies that were involved in "ev".if only
		 * one assembly is involved, second element is null.
		 */

		getNewEvents(ev.getAssemNamesInvolved());

	}

	/**
	 * Returns true if a and b are "close" to each other
	 * 
	 * @param a
	 *            Vector3d
	 * @param b
	 *            Vector3d
	 * @return boolean
	 */
	private boolean withinTranslationalBounds(Vector3d a, Vector3d b) {
		Vector3d diff = new Vector3d();
		diff.sub(a, b);

		if (diff.length() < 0.6) {//used 0.6 for icos
			return true;
		}
		return false;
	}

	/**
	 * Returns true if a and b are reasonably anti-parallel to each other
	 * 
	 * @param a
	 *            Vector3d
	 * @param b
	 *            Vector3d
	 * @return boolean
	 */
	private boolean withinAngularBounds(Vector3d a, Vector3d b) {
		double angle = a.angle(b); //in radians 0 to pi

		if (angle > (4.0 * Math.PI / 5.0)) {
			return true;
		}
		return false;
	}

	/**
	 * Returns true if Vector3d a and Vector3d b's up vectors are reasonably
	 * parallel
	 * 
	 * @param a
	 *            Vector3d
	 * @param b
	 *            Vector3d
	 * @return boolean
	 */
	private boolean withinTorsionalBounds(Vector3d a, Vector3d b) {
		double angle = a.angle(b); //within 0 to pi

		if (angle < (Math.PI / 5.0)) {
			return true;
		}
		return false;
	}

	private void simpleUpdateCountsAll(BindingSite b, boolean add) {
		String s = b.getBST().getName();
		int index = ((Integer) bstIndex.get(s)).intValue();
		if (add)
			freeBSs[index] += 1;
		else
			freeBSs[index] -= 1;

	}

	private void printArray(int[] anArray) {
		for (int i = 0; i < anArray.length; i++) {

			System.out.print(anArray[i] + " ");
		}
		System.out.println();

	}

	/*
	 * Returns an random number from the exponential distribution with average
	 * avg (1/lambda)
	 * 
	 * @param avg double @return double
	 */
	private double getExp(double avg) {
		/**
		 * if (rand == null) { System.out.println("rand is null"); }
		 */
	    double t=-avg * Math.log(Test.rand.nextDouble());
		return t;
	}

	/**
	 * Returns a random double within [0 , 1)
	 * 
	 * @return double
	 */
	public double getRand() {
		return Test.rand.nextDouble();
	}

	/**
	 * Returns a String version of this Simulation
	 * 
	 * @return String
	 */
	public String toString() {
		String mystring = new String("*******Simulation: Current Time: "
				+ curtime + "*******\n");
		Collection values = assemblies.values();
		for (Iterator i = values.iterator(); i.hasNext(); mystring += ((Assembly) (i
				.next()) + "\n\n")) {

		}
		mystring += "*****end******";
		return mystring;
	}


	/**
	 * todo future never used Returns a Vector of all the Assemblies in this
	 * Simulation
	 * 
	 * @return Vector of Assemblies
	 */
	public Vector getAssemblies() {
		Iterator it = assemblies.values().iterator();
		Vector v = new Vector();

		while (it.hasNext()) {
			Assembly temp = (Assembly) it.next();
			v.add(temp);
		}
		return v;
	}

	/**
	 * 
	 * Creates a SimulatorGraphic based on this Simulation and returns it.
	 * 
	 * @return SimulatorGraphic
	 */
	public SimulatorGraphic startGraphic() {
		graphic = new SimulatorGraphic(this);
		return graphic;
	}

	/*
	 * prints the current pq to standard out by find min and copy it to new
	 * priorityQueue, after all elements are displayed, the temportary priority
	 * queue is copied back to pq
	 */
	public void printQ() {
		int i = 1;
		Vector tempv = new Vector();
		while (!pq.isEmpty()) {
			Event ev = (Event) pq.remove();
			if (ev instanceof FormBondEvent) {
				System.out.println(ev);
			} else if (ev instanceof BreakBondEvent) {
				System.out.println(ev);
			} else if (ev instanceof ConfChangeEvent) {
				System.out.println((ConfChangeEvent) ev);
			} else {
				System.out.println("what is wrong");
			}
			i++;
			tempv.add(ev);
		}
		for (int j = 0; j < tempv.size(); j++) {
			pq.add((Event) tempv.get(j));
		}
	}

	/**
	 * Prints the size of each Assembly in current Simulation by Walking through
	 * HashMap assemblies and geting the size. The result is saved in string
	 * fileName
	 * 
	 * @param fileName
	 *            String the name of file to which the result is saved
	 */
	private void printAssembliesToFile(String fileName) {

		Iterator it = assemblies.values().iterator();
		int i = 0;
		int assembliesSize = assemblies.values().size();
		PrintWriter fileOut = null;

		try {
			fileOut = new PrintWriter(new FileWriter(fileName));

			while (i < assembliesSize) {
				i++;
				Assembly tem = (Assembly) it.next();
				fileOut.println(tem.numSubunits());
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
		if (fileOut != null)
			fileOut.close();
	}

	private String printfreeAmount() {
		Iterator it = assemblies.values().iterator();
		int i = 0;
		int totala = 0, totalb = 0, totalc = 0;
		int assembliesSize = assemblies.values().size();
		while (i < assembliesSize) {
			i++;
			Assembly tem = (Assembly) it.next();

			Vector subs = tem.getSubunits();

			for (int j = 0; j < subs.size(); ++j) {
				Subunit sub = (Subunit) subs.get(j);
				Vector bindsites = sub.getBindSites();
				for (int k = 0; k < bindsites.size(); ++k) {
					BindingSite bs = (BindingSite) bindsites.get(k);
					if (!bs.isBound())
						if (bs.getBST().getName() == "bsta") {
							totala++;
						} else if (bs.getBST().getName() == "bstb") {
							totalb++;
						} else if (bs.getBST().getName() == "bstc") {
							totalc++;
						} else {
							System.out
									.println("errorinprintfreebssamountinsimulation");
							System.exit(1);
						}
				}
			}
		}
		return totala + " " + totalb + " " + totalc;

	}

	
	/*
     * private String getDistribution() { int size = distribution.length; String
     * s = ""; int[] temArray = new int[size]; Iterator it =
     * assemblies.values().iterator(); int i = 0;
     * 
     * 
     * int assembliesSize = assemblies.values().size(); while (i <
     * assembliesSize) { i++; Assembly tem = (Assembly) it.next(); int k =
     * tem.numSubunits();
     * 
     * if (k == 1) { Subunit sub = (Subunit) (tem.getSubunits().get(0)); if
     * (sub.getBindSites().size() == 0) { temArray[0] += 1;
     *  } else { temArray[1] += 1; }
     *  } else if (k == 2) { temArray[2] += 1; } else if (k == 3) { temArray[3] +=
     * 1; } else if (k == 4) { temArray[4] += 1; } } if (Arrays.equals(temArray,
     * distribution)) { return null;
     *  } else { for (int n = 0; n < distribution.length; n++) { distribution[n] =
     * temArray[n]; s = s + distribution[n] + " ";
     *  } return s; }
     *  }
     */
	private String printDistribution() {
		Iterator it = assemblies.values().iterator();
		int i = 0;
		int total = 0;
		int assembliesSize = assemblies.values().size();
		while (i < assembliesSize) {
			i++;
			Assembly tem = (Assembly) it.next();
			int length = tem.numSubunits();
			System.out.println(length);
			total += length;
		}

		return total + " ";

	}

	private String printDistributionToFile(String fileName) {

		Iterator it = assemblies.values().iterator();
		int i = 0;
		int total0 = 0, total1 = 0, total2 = 0, total3 = 0, total4 = 0, total5 = 0;
		int total6 = 0, total7 = 0, total8 = 0, total9 = 0, total10 = 0;
		int assembliesSize = assemblies.values().size();

		while (i < assembliesSize) {
			i++;
			Assembly tem = (Assembly) it.next();
			int k = tem.numSubunits();

			if (k == 1) {
				Subunit s = (Subunit) (tem.getSubunits().get(0));
				if (s.getBindSites().size() == 0) {
					total0 += 1;
				} else {
					total1 += 1;
				}

			} else if (k == 2) {
				total2 += 1;
			} else if (k == 3) {
				total3 += 1;
			} else if (k == 4) {
				total4 += 1;
			} else if (k == 5) {
				total5 += 1;
			} else if (k == 6) {
				total6 += 1;
			} else if (k == 7) {
				total7 += 1;
			} else if (k == 8) {
				total8 += 1;
			} else if (k == 9) {
				total9 += 1;
			} else if (k == 10) {
				total10 += 1;
			} else
				return k + "error";
		}
		return total0 + " " + total1 + " " + total2 + " " + total3 + " "
				+ total4 + " " + total5 + " " + total6 + " " + total7 + " "
				+ total8 + " " + total9 + " " + total10;
	}

	private FormBondEvent getFormBondEvent(Assembly assem, int[] otherFreeBSs,
			int[] otherMonomerBSs, Assembly assem2) {
		
		double duration = Double.MAX_VALUE;
		double tem;
		String bstSelfChoice = null;
		String bstOtherChoice = null;
		int countSelf = -1;
		int countOther = -1;
		int abs[] = assem.getBSCounts();
		int other[] = null;
		boolean monomerOnly = false;

		if ((assem.numSubunits() == 1) || (!Test.bindMonomerOnly)) {
			other = otherFreeBSs;
		} else {
			//current Assembly has more than one monomers and
			// Test.bindMonomerOnly=true
			monomerOnly = true;
			other = otherMonomerBSs;
		}

		Iterator it = bstPartner.keySet().iterator();
		while (it.hasNext()) {
			String bst = (String) it.next();
			//Currently it works only for one type of partner for each bst
			String bstP = (String) ((Vector) bstPartner.get(bst)).elementAt(0);
			int bstSelfIndex = ((Integer) (bstIndex.get(bst))).intValue();
			int bstOtherIndex = ((Integer) (bstIndex.get(bstP))).intValue();
			double product = abs[bstSelfIndex] * other[bstOtherIndex];
			if (product != 0) {
				double[] ave = (double[]) (((HashMap) bondTimes.get(bst))
						.get(bstP));
				tem = getExp(ave[0] / product);
				if (tem < duration) {
					duration = tem;
					countSelf = abs[bstSelfIndex];
					countOther = other[bstOtherIndex];
					bstSelfChoice = bst;
					bstOtherChoice = bstP;
				}

			}

		}
		FormBondEvent minFormBondEvent = null;
		if (duration < Double.MAX_VALUE) {
			minFormBondEvent = sampleFormBondEvent(duration, assem, assem2,
					bstSelfChoice, bstOtherChoice,
					(int) (countSelf * getRand()),
					(int) (countOther * getRand()), monomerOnly);
		}
		return minFormBondEvent;

		//sendevent min event from the above 3 events

	}

	
	private Event screenEvents(Event e0, Event e1) {
		if (e0 == null) {
			return e1;
		} else if (e1 == null) {
			return e0;
		} else if (e0.compareTo(e1) == 1) {
			return e0;
		} else
			return e1;
	}

	private void getNewEvents(String[] assems) {
		//      Vector of free bindingsites in current Assembly(s) whose name is in
		// assems
		//      Vector of all free bindingSites in Simulation except those free
		// BindingSite(s) in Assembly(s) whose
		//      names are in array assems
		int[] otherFreeBSs = new int[freeBSs.length];
		System.arraycopy( freeBSs,0,otherFreeBSs,0,freeBSs.length);
		// int[] otherFreeBSs1 = (int[])freeBSs.clone();
		int[] otherMonomerBSs = new int[monomerBSs.length];
		System.arraycopy( monomerBSs,0,otherMonomerBSs,0,monomerBSs.length);
		int[] selfBSs0 = null;
		int[] selfBSs1 = null;
		Event myMinEvent0 = null;
		Event myMinEvent1 = null;

		/**
		 * Walks through all Assembly(s) in this Simulation, finds and saves all
		 * the other free BindingSite(s) by checking if each one is bound and is
		 * in Assembly(s) specified by assems
		 */
		//<start>remove
		if (assems.length == 1) {
			if ((assems[0] == null) || (assemblies.get(assems[0]) == null)) {
				System.out
						.println("argument_error_1 in Simulation getNewEvents");
				System.exit(1);
			}

		} else if (assems.length == 2) {
		    
			if ((assems[0] == null) || (assemblies.get(assems[0]) == null)
					|| (assems[1] == null)
					|| (assemblies.get(assems[1]) == null)) {
				System.out
						.println("argument_error_1 in Simulation getNewEvents");
				System.exit(1);
			}
			if (assems[0].equals(assems[1])
					|| assemblies.get(assems[0]) == assemblies.get(assems[1])) {
				System.out
						.println("argument_error_3 in Simulation getNewEvents");
				System.exit(1);
			}
		} else {
			System.out.println("argument_error_4 in Simulation getNewEvents");
			System.exit(1);
		}
		//<end>remove

		if (assems.length == 1) {

			Assembly a0 = (Assembly) assemblies.get(assems[0]);
			selfBSs0 = a0.getBSCounts();
			updateCounts(otherFreeBSs, selfBSs0, false);
			a0.setValidTime(curtime);
			myMinEvent0 = getFormBondEvent(a0, otherFreeBSs, otherMonomerBSs,
					null);

			myMinEvent0 = screenEvents(myMinEvent0, getConfChangeEvent(a0));
			BreakBondEvent tbe = sampleBreakBondEvent(a0);
			myMinEvent0 = screenEvents(myMinEvent0, tbe);
			if (a0.numSubunits() == 1) {
				if (tbe != null)
				    System.out.println("errorinsimulation");
			}

		} else {

			Assembly a0 = (Assembly) assemblies.get(assems[0]);
			Assembly a1 = (Assembly) assemblies.get(assems[1]);
			selfBSs0 = a0.getBSCounts();
			selfBSs1 = a1.getBSCounts();
			updateCounts(otherFreeBSs, selfBSs0, false);
			updateCounts(otherFreeBSs, selfBSs1, false);

			if (a0.numSubunits() == 1) {
				updateCounts(otherMonomerBSs, selfBSs0, false);
			}
			if (a1.numSubunits() == 1) {
				updateCounts(otherMonomerBSs, selfBSs1, false);
			}
			a0.setValidTime(curtime);
			a1.setValidTime(curtime);
			FormBondEvent f0 = getFormBondEvent(a0, otherFreeBSs,
					otherMonomerBSs, a1);
			FormBondEvent f1 = getFormBondEvent(a1, otherFreeBSs,
					otherMonomerBSs, a0);
			FormBondEvent c = sampleTwoAssems(a0, a1);
			myMinEvent0 = screenEvents(f0, c);
			myMinEvent0 = screenEvents(myMinEvent0, getConfChangeEvent(a0));
			BreakBondEvent tbe0 = sampleBreakBondEvent(a0);
			myMinEvent0 = screenEvents(myMinEvent0, tbe0);

			if (a0.numSubunits() == 1) {
				if (tbe0 != null)
					System.out.println("errorinsimulation");
			}

			myMinEvent1 = screenEvents(f1, c);
			myMinEvent1 = screenEvents(myMinEvent1, getConfChangeEvent(a1));
			BreakBondEvent tbe1 = sampleBreakBondEvent(a1);
			myMinEvent1 = screenEvents(myMinEvent1, tbe1);

			if (a1.numSubunits() == 1) {
				if (tbe1 != null)
				    System.out.println("errorinsimulation");
			}

		}

		if ((myMinEvent0 != null) && (myMinEvent1 == null)) {
			sendEvent(myMinEvent0);
		} else if ((myMinEvent0 == null) && (myMinEvent1 != null)) {
			sendEvent(myMinEvent1);
		} else if ((myMinEvent0 != null) && (myMinEvent1 != null)) {
			if (myMinEvent0 != myMinEvent1) {
				sendEvent(myMinEvent0);
				sendEvent(myMinEvent1);
			} else {
				sendEvent(myMinEvent0);
			}
		} else {
		}
	}

	
	/**
	 * From Assembly assem, find an possible BreakBondEvent with the minimum
	 * duration.
	 * 
	 * @param Assembly
	 * 
	 * @return BreakBondEvent or null
	 *  
	 */

	private BreakBondEvent sampleBreakBondEvent(Assembly assem) {
		Vector subs = assem.getSubunits();
		if (subs.size() < 2) {
			return null;
		}
		double duration = 0;
		double minTime = Double.MAX_VALUE;
		double[] aveTimes;
		BindingSite temBs, temPartner;
		BindingSite minBs = null;
		BindingSite minPartner = null;
		CheckPairSeen cps = new CheckPairSeen();
		//go thru boundsubs, looking at all possible bond breaking events
		for (int j = 0; j < subs.size(); j++) {
			Subunit sub = (Subunit) (subs.get(j));
			Vector bindsites = sub.getBindSites();
			if ((sub.getBoundSubunits().size() > 1) && (Test.breakOnlyEnds)) {
				continue;
			}
			for (int k = 0; k < bindsites.size(); ++k) {
				temBs = (BindingSite) bindsites.get(k);
				if (temBs.isBound()) {
					temPartner = temBs.getPartner();
					if (cps.marked(temBs.getid(), temPartner.getid()))
						continue;
					//else mark it seen now
					cps.addPair(temBs.getid(), temPartner.getid());
					aveTimes = (double[]) (((HashMap) (bondTimes.get(temBs
							.getBST().getName()))).get(temPartner.getBST()
							.getName()));
					duration = getExp(aveTimes[1]);
					//if this is the fastest Event so far, store it
					if (minTime >= duration) {
						minTime = duration;
						minBs = temBs;
						minPartner = temPartner;
					}
				}
			}
		}
		Debug.checkFalse(minTime != Double.MAX_VALUE,
				"error in sampleBreakingBondEvent");
		String[] assemNames = { minBs.getAssemName(), null };
		return new BreakBondEvent(curtime, minTime + curtime, assemNames,
				minBs, minPartner);
	}

	private FormBondEvent sampleFormBondEvent(double duration, Assembly assem,
			Assembly assem2, String bstSelf, String bstOther, int indexSelf,
			int indexOther, boolean monomerOnly) {

		/**
		 * Walks through all Assembly(s) in this Simulation, finds and saves all
		 * the other free BindingSite(s) by checking if each one is bound and is
		 * in Assembly(s) specified by assems
		 */
		BindingSite minBs = null;
		BindingSite minPartner = null;
		Vector subs = assem.getSubunits();
		Vector ttttt = assem.getFreebss();
		boolean indexSelfFound = false;
		
		int temIndex = 0;
		for (int i = 0; ((i < subs.size()) && (!indexSelfFound)); i++) {
			Subunit sub = (Subunit) (subs.get(i));
			Vector bss = sub.getBindSites();
			for (int j = 0; j < bss.size(); j++) {
				BindingSite bs = (BindingSite) bss.get(j);
				if ((!bs.isBound()) && (bs.getBST().getName().equals(bstSelf))) {
					if (temIndex == indexSelf) {
						indexSelfFound = true;
						minBs = bs;
					} else {
						temIndex++;
					}
				}
			}
		}

		//find partner BindingSite of type bstOther from all the other
		// Assembly(s) or all the other monomers if argument monomerOnly is true
		boolean indexOtherFound = false;
		temIndex = 0;
		Iterator it = assemblies.values().iterator();
		Assembly temAssembly;
		while (it.hasNext() && !indexOtherFound) {
			temAssembly = (Assembly) it.next();
			//assem2 is the other Assembly to be sampled an event
			if (temAssembly == assem || temAssembly == assem2)
				continue;
			if (temAssembly.numSubunits() > 1 && monomerOnly) {
				continue;
			}
			Vector temSubs = temAssembly.getSubunits();

			for (int j = 0; j < temSubs.size(); j++) {
				Subunit temSub = (Subunit) temSubs.get(j);
				Vector temBss = temSub.getBindSites();

				for (int k = 0; k < temBss.size(); k++) {
					BindingSite temBs = (BindingSite) temBss.get(k);
					if ((!temBs.isBound())
							&& (temBs.getBST().getName().equals(bstOther))) {
						if (temIndex == indexOther) {
							indexOtherFound = true;
							minPartner = temBs;
						} else {
							temIndex++;
						}
					}
				}
			}
		}
		String[] assemNames = { minBs.getAssemName(), minPartner.getAssemName() };
		return new FormBondEvent(curtime, curtime + duration, assemNames,
				minBs, minPartner);
	}

	/**
	 * update the information of Assembly(s) involved in an Event e to be sent
	 * to pq,
	 * 
	 * @param e,
	 *            Event
	 *  
	 */
	private void sendEvent(Event e) {
		Debug.checkFalse(e != null, "error0 in sendEvent");
		Debug.checkFalse(e.getEndTime() != Double.MAX_VALUE,
				"error1 in sendEvent.");
		Debug.checkFalse(e.getEndTime() >= curtime, "error2 in sendEvent.");
		String[] asms = e.getAssemNamesInvolved();
		((Assembly) assemblies.get(asms[0])).setNextEvent(e);
		
		if (asms[1] != null) {
			((Assembly) assemblies.get(asms[1])).setNextEvent(e);
		}
		pq.add(e);
	}

	private FormBondEvent sampleTwoAssems(Assembly A1, Assembly A2) {
		//Assume A1 and A2 should be different Assembly(s)
		if (A1.equals(A2)) {
			return null;
		}
		Vector bss1 = A1.getFreebss();
		Vector bss2 = A2.getFreebss();

		int primary = -1;
		int partner = -1;
		double[] bTimes;
		double minTime = Double.MAX_VALUE;
		double duration = 0;

		for (int i = 0; i < bss1.size(); i++) {
			BindingSite temBs = (BindingSite) bss1.get(i);
			for (int j = 0; j < bss2.size(); j++) {
				BindingSite temPartner = (BindingSite) bss2.get(j);
				//              check for compatable bindingsiteTypes

				if (!temBs.canBindTo(temPartner)) {
					
					continue;
				}

				bTimes = (double[]) (((HashMap) (bondTimes.get(temBs.getBST()
						.getName()))).get(temPartner.getBST().getName()));
				duration = getExp(bTimes[0]);
				
				//if this is the fastest Event so far, store it
				if (minTime >= duration) {
					minTime = duration;
					primary = i;
					partner = j;
				}
			}
		}
//To be removed for new initialize()
		Debug.checkFalse(minTime != Double.MAX_VALUE,
				"error3 in sampleTwoAssems");
		String[] assemNamesInvolved = { A1.getName(), A2.getName() };
		return new FormBondEvent(curtime, curtime + minTime,
				assemNamesInvolved, (BindingSite) bss1.get(primary),
				(BindingSite) bss2.get(partner));

	}

	private ConfChangeEvent getConfChangeEvent(Assembly assem_i) {
		//for each Domain, get ConfChangeEvents, then return the minimum
		// ConChangeEvent or null
		if (!Test.csAllowed) {
			return null;
		}

		Debug.checkFalse(assem_i != null, "error 0 in getConfChangeevent");
		Vector subs = assem_i.getSubunits();
		if (subs.size() != 1) {
			ConfChangeEvent tem = null;
			return null;
		}
		Subunit cur_Sub = (Subunit) subs.get(0);
		double minDuration = Double.MAX_VALUE;
		int newDomainId = -1;
		Vector cur_Domains = cur_Sub.getDomains();
		Conformation newConformation = null;

		for (int j = 0; j < cur_Domains.size(); j++) {
			Domain cur_Domain = (Domain) cur_Domains.get(j);
			int temId = cur_Domain.getDomainId();
			Conformation cur_conf = cur_Domain.getCurConf();
			String curConfName = cur_conf.getName();
			Vector cur_Conformations = cur_Domain.getConfs();
			HashMap nameTimeMaps = (HashMap) confTimes.get(curConfName);
			HashMap nameConfMaps = cur_Domain.getConfMaps();
			Iterator confName = nameTimeMaps.keySet().iterator();
			while (confName.hasNext()) {
				String toConfName = (String) confName.next();
				double cfChangeTime = ((Double) nameTimeMaps.get(toConfName))
						.doubleValue();
				double temDuration = getExp(cfChangeTime);
				if (temDuration < minDuration) {
					minDuration = temDuration;
					newDomainId = temId;
					newConformation = (Conformation) nameConfMaps
							.get(toConfName);
				}
			}
		}

		if (minDuration == Double.MAX_VALUE) {
			ConfChangeEvent tem = null;
			return null;
		} else {
			ConfChangeEvent cfEvent = new ConfChangeEvent(curtime, curtime
					+ minDuration, new String[] { assem_i.getName(), null },
					cur_Sub, newDomainId, newConformation);

			return cfEvent;
		}

	}

	/**
	 * gets the number of assemblies in the simulation of a certain size
	 * 
	 * @param size -
	 *            int
	 * @return num - int
	 */
	public int numberOfSize(int size) {

		Vector allAssemblies = getAssemblies();

		int num = 0;

		for (int i = 0; i < allAssemblies.size(); i++) {

			Assembly temp = (Assembly) allAssemblies.get(i);
			if (temp.numSubunits() == size) {
				num++;
			}
		}
		return (num);
	}

	private void updateCounts(int[] old, int[] tem, boolean add) {
		for (int i = 0; i < tem.length; i++) {
			if (add) {
				old[i] += tem[i];
			} else {
				old[i] -= tem[i];
			}
		}

	}

	/**
	 * Updates the JLabel showing the number of monomers
	 */
	public void updateMonomerCount() {

		MainFrame.displayText.setText("Monomers: " + numberOfSize(1));
		MainFrame.toolbar.paintImmediately(MainFrame.displayText.getBounds());
	}

	/**
	 * CheckPairSeen use a private Vector of int[2] to hold pairs of Integer,
	 * user can add Integer pair by using addPair(int i, int j) and check if
	 * some Inter pair has been added by using marked(int i, int j), the order
	 * of Inter in any pairs will not affect the returned value.
	 */
	private class CheckPairSeen {

		private Vector seen; //vector of double[2], which are the seen pairs

		public CheckPairSeen() {
			seen = new Vector();
		}

		public void addPair(int i, int j) {
			seen.add(new double[] { i, j });
		}

		public boolean marked(int i, int j) {
			double[] tmp;
			for (int k = 0; k < seen.size(); ++k) {
				tmp = (double[]) (seen.get(k));
				if ((tmp[0] == i && tmp[1] == j)
						|| (tmp[0] == j && tmp[1] == i)) {
					return true;
				}
			}
			return false;
		}
	}
}

