
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * MainFrame class extends JFrame which is a container used for interactive
 * demonstration of self-assembly simulation
 * 
 * @see Test
 * @author Sue Yi Chew
 * @author Rori Rohlfs
 * @author Blake Sweeney
 * @version 1.2
 *  
 */

public class MainFrame extends JFrame implements ActionListener {

    private Simulation sim;

    private JPanel simulatorPane;

    private SimulatorGraphic simulatorGraph;

    public static JLabel displayText = new JLabel("Nothing Loaded");

    //Used to show how many monomers are left in the simulation
    //static so that it may be modified in simulation.java

    public static JToolBar toolbar = new JToolBar();

    //toolbar is declared static to enable forced painting in simulation.java
    public MainFrame(String title) {
        super(title);

        simulatorPane = (JPanel) createContentPane();

        //super class method
        setContentPane(simulatorPane);

    }

    /**
     * Creates content pane that will replace default content pane of this
     * JFrame
     * 
     * @return Container
     */
    private Container createContentPane() {
        /*
         * Creates a new buffered JPanel, sets the behavior of JPanel
         */
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setOpaque(true);
        contentPane.setLayout(new BorderLayout());
        contentPane.setPreferredSize(new Dimension(600, 600));

        //Initializes the Simulation that will be run here
        //Uses static method getSim(), returns Simulation

        String simChoice = Test.simChoice;
        if (simChoice.equals("actin")) {
            //         Creates Actin for actin self-assembly simulation
            Actin t = new Actin();
            sim = Actin.getSim();

        } else if (simChoice.equals("tubulin")) {
            // Creates Tubulin for tubulin self-assembly simulation
            Tubulin t = new Tubulin();
            sim = Tubulin.getSim();
        } else if (simChoice.equals("virus")) {
            //Creates Icosahedral for virus self-assembly simulation
            Icosahedral t = new Icosahedral();
            sim = Icosahedral.getSim();

        } else if (simChoice.equals("cube")) {
            //Creates Cube for cube self-assembly simulation

            Cube t = new Cube();
            sim = Cube.getSim();

        } else if (simChoice.equals("tetrahedron")) {
            //Creates Cube for cube self-assembly simulation

            Tetrahedron t = new Tetrahedron();
            sim = Tetrahedron.getSim();

        }

        /**
         * returns SimulatorGraphic which extends JPanel
         */
        simulatorGraph = sim.startGraphic();//new SimulatorGraphic(sim);

        if (!Test.displaySim) {
            sim.run();
            System.exit(1);
        }

        JButton runB = new JButton("Run");
        runB.addActionListener(this);
        runB.setActionCommand("run");
        toolbar.add(runB);

        /**
         * creates the "Step" button for debugging , adds it to toolbar, sets
         * the action command for this button
         */
        JButton stepB = new JButton("Step");
        stepB.addActionListener(this);
        stepB.setActionCommand("step");
        toolbar.add(stepB);
        /**
         * Creates a label to show the number of monomers left
         */
        displayText.setText("Monomers: " + sim.numberOfSize(1));
        toolbar.addSeparator();
        toolbar.add(displayText);

        //add components(simulatorGraph and toolbar) to contentpane container
        contentPane.add(simulatorGraph, BorderLayout.CENTER);
        contentPane.add(toolbar, BorderLayout.SOUTH);

        return contentPane;

    }

    /**
     * Listens to user-input events and execute those events. for example, runs
     * the simulation when the run button is pressed
     * 
     * @param e
     *            ActionEvent, executed by choosing menu items or buttons
     */

    public void actionPerformed(ActionEvent e) {

        if (e.getActionCommand().equals("run")) {
            sim.run();
        } else if (e.getActionCommand().equals("step")) {
            sim.step();
        } else if (e.getActionCommand().equals("printq")) {
            sim.printQ();
        }
    }
}

