
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.*;
import java.awt.*;
import java.util.Random;

/**
 * A class that creates the loading dialog for the simulation. This allows the
 * user to configure the majority of the variables that control the simulation.
 * The user may input values for: maxLength, numSubunit, bindTime, breakTime,
 * bsToNoneTime, noneToBsTime, bindMonomerOnly, breakOnlyEnds,
 * iterations_per_run, events_per_printout, simChoice, csAllowed, showBorder,
 * grey, and the number of runs to perform. Creates the simulation by loading
 * MainFrame
 * 
 * @see Test.java
 * @author Blake Sweeney
 * @version 1.2
 */

public class LoadDialog implements ActionListener {

    //JFrame and JPanel
    private static JFrame dialog = new JFrame("Load Simulation");

    private JPanel loadPanel;

    //combo box
    private JComboBox simTypeChoice;

    //text feilds
    private JTextField subCount;

    private JTextField stepCount;

    private JTextField maxLength;

    private JTextField breakTime;

    private JTextField bindTime;

    private JTextField bsNTime;

    private JTextField nBsTime;

    //private JTextField ePrintOut;
    private JTextField randomSeed;

    //private static JTextField numRun;

    //check boxes
    private JCheckBox confSwitch;

    private JCheckBox endBreak;

    private JCheckBox monoBind;

    private JCheckBox border;

    private JCheckBox grey;

    //buttons
    private JButton loadB;

    private JButton defaultsB;

    //a progress bar to show the user something while the simulation is loading
    //not implmented yet
    //private static JProgressBar progressBar;

    /**
     * Creates the loading frame and all the buttons, labels, text boxes for it
     * the values displayed are read in from the Test.java file and those are
     * used as defaults
     */
    public LoadDialog() {

        loadPanel = new JPanel();
        loadPanel.setLayout(new GridLayout(0, 2, 20, 0));

        dialog.setResizable(false);
        dialog.setLocation(new Point(0, 0));

        //adds the menubar
        //should be uncommented when the xml loading is complete
        //may be better to add the option of xml loading in the combo box below
        //dialog.setJMenuBar(createMenuBar());

        /**
         * Creates a combo box for simulation type and the label assoicated with
         * it Adds them to the loadPanel
         */
        JLabel simTypeText = new JLabel("Simulation Type");
        String[] simTypes = { "actin", "tubulin", "virus", "cube",
                "tetrahedron" };
        //a string[] of all posible simulations
        simTypeChoice = new JComboBox(simTypes);
        simTypeChoice.setSelectedItem(Test.simChoice);
        simTypeChoice.addActionListener(this);
        simTypeChoice.setActionCommand("choice");
        loadPanel.add(simTypeText);
        loadPanel.add(simTypeChoice);

        /**
         * Creates a text box for subunit count and the label assoicated with it
         * Adds them to the loadPanel
         */
        JLabel subText = new JLabel("Number of Subunits");
        subCount = new JTextField(Test.numSubunits + "");
        subCount.setColumns(10);
        subCount.setHorizontalAlignment(JTextField.RIGHT);
        loadPanel.add(subText);
        loadPanel.add(subCount);

        /**
         * Creates a text box for the number of steps and the label assoicated
         * with it Adds them to the loadPanel
         */
        JLabel runText = new JLabel("Number of Steps per Run");
        stepCount = new JTextField(Test.iterations_per_run + "");
        stepCount.setColumns(10);
        stepCount.setHorizontalAlignment(JTextField.RIGHT);
        loadPanel.add(runText);
        loadPanel.add(stepCount);

        /**
         * Creates a text box for maxium assembly length and the label
         * assoicated with it Adds them to the loadPanel
         */
        JLabel mlText = new JLabel("Maximum Assembly Length");
        maxLength = new JTextField(Test.maxLength + "");
        maxLength.setColumns(10);
        maxLength.setHorizontalAlignment(JTextField.RIGHT);
        loadPanel.add(mlText);
        loadPanel.add(maxLength);

        /**
         * Creates a text box for average bind time and the label assoicated
         * with it Adds them to the loadPanel
         */
        JLabel bindText = new JLabel("Average Bind Time");
        bindTime = new JTextField(Test.bindTime + "");
        bindTime.setColumns(10);
        bindTime.setHorizontalAlignment(JTextField.RIGHT);
        loadPanel.add(bindText);
        loadPanel.add(bindTime);

        /**
         * Creates a text box for average break time and the label assoicated
         * with it Adds them to the loadPanel
         */
        JLabel breakText = new JLabel("Average Break Time");
        breakTime = new JTextField(Test.breakTime + "");
        breakTime.setColumns(10);
        breakTime.setHorizontalAlignment(JTextField.RIGHT);
        loadPanel.add(breakText);
        loadPanel.add(breakTime);

        /**
         * Creates a text box for binding site to none time and the label
         * assoicated with it Adds them to the loadPanel
         */
        JLabel bsNTText = new JLabel("Binding Site to None Time");
        bsNTime = new JTextField(Test.bsToNoneTime + "");
        bsNTime.setColumns(10);
        bsNTime.setHorizontalAlignment(JTextField.RIGHT);
        loadPanel.add(bsNTText);
        loadPanel.add(bsNTime);

        /**
         * Creates a text box for none to binding site time and the label
         * assoicated with it Adds them to the loadPanel
         */
        JLabel nBsText = new JLabel("None to Binding Site Time");
        nBsTime = new JTextField(Test.noneToBsTime + "");
        nBsTime.setColumns(10);
        nBsTime.setHorizontalAlignment(JTextField.RIGHT);
        loadPanel.add(nBsText);
        loadPanel.add(nBsTime);

        /**
         * Creates a text box for events per printout and the label assoicated
         * with it Adds them to the loadPanel
         */
        /*
         * JLabel ePrintOutText = new JLabel("Events per Printout"); ePrintOut =
         * new JTextField(Test.events_per_printout + "");
         * ePrintOut.setColumns(10);
         * ePrintOut.setHorizontalAlignment(JTextField.RIGHT);
         * loadPanel.add(ePrintOutText); loadPanel.add(ePrintOut);
         */

        /**
         * Creates a text box for random Seed and the label assoicated with it
         * Adds them to the loadPanel
         */
        JLabel rSText = new JLabel("Random Seed");
        randomSeed = new JTextField("");
        randomSeed.setColumns(10);
        randomSeed.setHorizontalAlignment(JTextField.RIGHT);
        randomSeed.setToolTipText("Enter a seed to reproduce results");
        loadPanel.add(rSText);
        loadPanel.add(randomSeed);

        /**
         * Creates a text box for run count and the label assoicated with it
         * Adds them to the loadPanel
         */
        //should be code here to enable or disable this from test.java
        /*
         * JLabel runCountText = new JLabel("Run Count"); numRun = new
         * JTextField(""); numRun.setColumns(10);
         * numRun.setHorizontalAlignment(JTextField.RIGHT);
         * loadPanel.add(runCountText); loadPanel.add(numRun);
         */

        /**
         * Creates a check box for conformation switching and the label
         * assoicated with it Adds them to the loadPanel
         */
        JLabel csText = new JLabel("Conformational Switching");
        confSwitch = new JCheckBox("");
        confSwitch.setSelected(Test.csAllowed);
        loadPanel.add(csText);
        loadPanel.add(confSwitch);

        /**
         * Creates a check box for end only breaking and the label assoicated
         * with it Adds them to the loadPanel
         */
        JLabel edText = new JLabel("End Only Breaking");
        endBreak = new JCheckBox("");
        endBreak.setSelected(Test.breakOnlyEnds);
        endBreak.setToolTipText("Breaks off only monomers ");
        loadPanel.add(edText);
        loadPanel.add(endBreak);
        //check to see if end only breaking should be allowed
        setEndBreak();

        /**
         * Creates a check box for monomer only binding and the label assoicated
         * with it Adds them to the loadPanel
         */
        JLabel monoText = new JLabel("Monomer Only Binding");
        monoBind = new JCheckBox("");
        monoBind.setSelected(Test.bindMonomerOnly);
        monoBind.setToolTipText("Assemblies only bind to monomers");
        loadPanel.add(monoText);
        loadPanel.add(monoBind);

        /**
         * Creates a check box for showing the border cube and the label
         * assoicated with it Adds them to the loadPanel
         */
        JLabel borderText = new JLabel("Show Border");
        border = new JCheckBox();
        border.setSelected(Test.showBorder);
        border.setToolTipText("Shows a cube around the simulation");
        loadPanel.add(borderText);
        loadPanel.add(border);

        /**
         * Creates a check box for making the background grey and the label
         * assoicated with it Adds them to the loadPanel
         */
        JLabel greyText = new JLabel("Grey Background");
        grey = new JCheckBox();
        grey.setSelected(Test.grey);
        grey.setToolTipText("Sets the background to grey");
        loadPanel.add(greyText);
        loadPanel.add(grey);

        /**
         * adds defaults button and associates it with Alt+D, and adds it to
         * loadPanel sets action command for deafults
         */
        defaultsB = new JButton("Deafult");
        defaultsB.addActionListener(this);
        defaultsB.setActionCommand("default");
        defaultsB.setMnemonic(KeyEvent.VK_D);
        loadPanel.add(defaultsB);

        /**
         * adds the loading button and associates it with Alt+L, and adds it to
         * loadPanel sets action command for load
         */
        loadB = new JButton("Load");
        loadB.addActionListener(this);
        loadB.setActionCommand("load");
        loadB.setMnemonic(KeyEvent.VK_L);
        loadPanel.add(loadB);

        //creates the dialog from loadPanel
        dialog.getContentPane().add(loadPanel);
        dialog.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        dialog.pack();
        dialog.setVisible(true);

    }

    /**
     * Listens to user input events, loads the simulation when the load button
     * is pressed and resets the values to defaults when default is presseed
     * 
     * @param e
     *            ActionEvent
     */
    public void actionPerformed(ActionEvent e) {

        boolean good = true; //used to tell if any errors exist in the inputs

        if (e.getActionCommand() == "load") {

            int subCounter = 0;
            int maxLengthNum = 0;
            int runCounter = 0;
            double bindTimer = 0;
            double breakTimer = 0;
            double nBsTimer = 0;
            double bsNTimer = 0;
            //int ePrint = 0;
            int numberofRuns = 1;

            //checks if number of subunits entered is valid
            try {
                subCounter = Integer.parseInt(subCount.getText());
                // monomer count is capped at 2000 to prevent memory issues
                if (subCounter < 2 || subCounter > 2000) {
                    good = false;
                    subCount.setText("Enter a number from 2 to 2000.");
                }
            } catch (Exception execpt) {
                subCount.setText("Enter a number from 2 to 2000.");
                good = false;
            }

            //checks if the maximum length entered is valid
            try {
                maxLengthNum = Integer.parseInt(maxLength.getText());
                if (maxLengthNum <= 0) {
                    good = false;
                    maxLength.setText("Enter a postive number.");
                }
            } catch (Exception execpt) {
                maxLength.setText("Enter a postive number.");
                good = false;
            }

            //checks if number of steps entered is valid
            try {
                runCounter = Integer.parseInt(stepCount.getText());
                if (runCounter <= 0) {
                    stepCount.setText("Enter a postive number.");
                    good = false;
                }
            } catch (Exception execpt) {
                stepCount.setText("Enter a postive number.");
                good = false;
            }

            //checks if average binding time entered is valid
            try {
                bindTimer = Double.parseDouble(bindTime.getText());
                if (bindTimer <= 0) {
                    bindTime.setText("Enter a postive number.");
                    good = false;
                }
            } catch (Exception execpt) {
                bindTime.setText("Enter a postive number.");
                good = false;
            }

            //checks if average break time entered is valid
            try {
                breakTimer = Double.parseDouble(breakTime.getText());
                if (breakTimer <= 0) {
                    breakTime.setText("Enter a postive number.");
                    good = false;
                }
            } catch (Exception execpt) {
                breakTime.setText("Enter a postive number.");
                good = false;
            }

            //checks if none to binding site time entered is valid
            try {
                nBsTimer = Double.parseDouble(nBsTime.getText());
                if (nBsTimer <= 0) {
                    nBsTime.setText("Enter a postive number.");
                    good = false;
                }
            } catch (Exception execpt) {
                nBsTime.setText("Enter a postive number.");
                good = false;
            }

            //checks if binding site to none time entered is valid
            try {
                bsNTimer = Double.parseDouble(bsNTime.getText());
                if (bsNTimer <= 0) {
                    bsNTime.setText("Enter a postive number.");
                    good = false;
                }
            } catch (Exception execpt) {
                bsNTime.setText("Enter a postive number.");
                good = false;
            }

            //checks if events per printout entered is valid
            /*
             * try { ePrint = Integer.parseInt(ePrintOut.getText()); if (ePrint <=
             * 0) { ePrintOut.setText("Enter a postive number."); good = false; } }
             * catch (Exception execpt) { ePrintOut.setText("Enter a postive
             * number."); good = false; }
             */

            //sets random seed
            try {
                Test.rand = new Random(Integer.parseInt(randomSeed.getText()));
            } catch (Exception execpt) {
                randomSeed.setText("");
                Test.rand = new Random();
            }

            /*
             * try { numberofRuns = Integer.parseInt(numRun.getText()); if
             * (numberofRuns < 1) { good = false; numRun.setText("Enter a number
             * greater than 1."); } } catch (Exception execpt) {
             * numRun.setText("Enter a number greater than 1."); good = false; }
             */

            //if all values entered are error free the simulation is loaded
            if (good) {

                //set all values
                Test.simChoice = (String) simTypeChoice.getSelectedItem();
                Test.numSubunits = subCounter;
                Test.maxLength = maxLengthNum;
                Test.iterations_per_run = runCounter;
                Test.bindTime = bindTimer;
                Test.breakTime = breakTimer;
                Test.noneToBsTime = nBsTimer;
                Test.bsToNoneTime = bsNTimer;
                //Test.events_per_printout = ePrint;

                Test.breakOnlyEnds = endBreak.isSelected();
                Test.bindMonomerOnly = monoBind.isSelected();
                Test.csAllowed = confSwitch.isSelected();
                Test.showBorder = border.isSelected();
                Test.grey = grey.isSelected();

                stopEdit(); //stops all feilds from being edited again
                //allows user to hide window without closing simulation
                dialog.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);

                //looping because of the option of allowing multiple runs
                //only used for testing, diabled for release version.
                for (int i = 0; i < numberofRuns; i++) {

                    if (numberofRuns == 1) {
                        //creates the main frame for the simulation
                        MainFrame m = new MainFrame("Self-assembly Simulation");
                        m.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                        m.pack();
                        m.setVisible(true);

                    } else {
                        //put code here to handle multiple runs
                    }
                }
            }
        } else if (e.getActionCommand() == "default") {
            //resets all the values to the values in Test.java as defaults

            simTypeChoice.setSelectedItem(Test.simChoice);
            subCount.setText(Test.numSubunits + "");
            stepCount.setText(Test.iterations_per_run + "");
            maxLength.setText(Test.maxLength + "");
            bindTime.setText(Test.bindTime + "");
            breakTime.setText(Test.breakTime + "");
            bsNTime.setText(Test.bsToNoneTime + "");
            nBsTime.setText(Test.noneToBsTime + "");
            //ePrintOut.setText(Test.events_per_printout + "");
            randomSeed.setText("");
            //numRun.setText("1");
            confSwitch.setSelected(Test.csAllowed);
            endBreak.setSelected(Test.breakOnlyEnds);
            setEndBreak(); //only matters if breakOnlyEnds is incorrectly set
                           // in Test.java
            monoBind.setSelected(Test.bindMonomerOnly);
            border.setSelected(Test.showBorder);
            grey.setSelected(Test.grey);

        } else if (e.getActionCommand() == "choice") {

            //if a choice is made where end breaking is not allowed, it is
            // disabled
            setEndBreak();
        }
    }

    /**
     * Creates the menu for this frame
     * 
     * @return JMenuBar
     */
    private JMenuBar createMenuBar() {
        JMenuBar menuBar;
        JMenu menu;
        JMenuItem menuItem;

        //create the menu bar
        menuBar = new JMenuBar();

        /**
         * creates the "File" menu, associates it with Alt+F
         */
        menu = new JMenu("File");
        menu.setMnemonic(KeyEvent.VK_F);
        menuBar.add(menu);

        /**
         * creates the "New Simulation" menu item, associates it with Alt+N,
         * adds it to "File" menu, sets the action command for this button
         */
        menuItem = new JMenuItem("New Simulation", KeyEvent.VK_N);
        menuItem.addActionListener(this);
        menuItem.setActionCommand("newSimulation");
        menu.add(menuItem);

        /**
         * creates the "Load Simulation" menu item, associates it with Alt+L,
         * adds it to "File" menu, sets the action command for this button
         */
        menuItem = new JMenuItem("Load Simulation", KeyEvent.VK_L);
        menuItem.addActionListener(this);
        menuItem.setActionCommand("loadSimulation");
        menu.add(menuItem);

        /**
         * creates the "Save" menu item, associates it with Alt+S, adds it to
         * "File" menu, sets the action command for this button
         */
        menuItem = new JMenuItem("Save", KeyEvent.VK_S);
        menuItem.addActionListener(this);
        menuItem.setActionCommand("save");
        menu.add(menuItem);

        //adds separator for "Quit" menu item
        menu.addSeparator();

        /**
         * creates the "Quit" menu item, associates it with Alt+Q, adds it to
         * "File" menu, sets the action command for this button
         */
        menuItem = new JMenuItem("Quit", KeyEvent.VK_Q);
        menuItem.addActionListener(this);
        menuItem.setActionCommand("quit");
        menu.add(menuItem);

        /**
         * creates the "Assembly" menu, associates it with Alt+A
         */
        menu = new JMenu("Assembly");
        menu.setMnemonic(KeyEvent.VK_A);
        menuBar.add(menu);

        /**
         * creates the "Add new assembly" menu item, associates it with Alt+S,
         * adds it to "Assembly" menu, sets the action command for this button
         */
        menuItem = new JMenuItem("Add new assembly", KeyEvent.VK_S);
        menuItem.addActionListener(this);
        menuItem.setActionCommand("addAssembly");
        menu.add(menuItem);

        return menuBar;
    }

    /**
     * Hides the loading window
     *  
     */
    public static void hide() {
        dialog.setVisible(false);
    }

    /**
     * Disables all fields in the Load Dialog, to stop the user from trying to
     * load another simulation, but leaves the window open for reference to what
     * values were input.
     *  
     */
    private void stopEdit() {

        //dialog.setEnabled(false);
        //above is commented out because it behaves poorly
        //ie makes it look like it can be edited, but does disable it.

        simTypeChoice.setEnabled(false);
        subCount.setEditable(false);
        stepCount.setEditable(false);
        maxLength.setEditable(false);
        breakTime.setEditable(false);
        bindTime.setEditable(false);
        bsNTime.setEditable(false);
        nBsTime.setEditable(false);
        randomSeed.setEditable(false);
        //ePrintOut.setEditable(false);
        //numRun.setEditable(false);
        confSwitch.setEnabled(false);
        endBreak.setEnabled(false);
        monoBind.setEnabled(false);
        border.setEnabled(false);
        grey.setEnabled(false);

        loadB.hide(); //stops the user from loading another simulation
        defaultsB.hide();
    }

    /**
     * Checks to see what simulation type is choosen and disables end only
     * breaking if necessary, because in simulations other than actin and
     * tubulin it is unnecessary.
     *  
     */
    private void setEndBreak() {
        if ((String) simTypeChoice.getSelectedItem() != "actin"
                && (String) simTypeChoice.getSelectedItem() != "tubulin") {

            endBreak.setEnabled(false);
            endBreak.setSelected(false);
            //done to insure this is always false if actin or tubulin are not
            // chosen
        } else {
            endBreak.setEnabled(true);
        }
    }

}