
import java.util.Vector;
import java.util.HashMap;
import javax.vecmath.*;

/**
 * Actin sets up a filament-like scenerio, where there is one type of Subunit
 * with a single Conformation and Domain and two binding sites on opposite ends.
 * The initial number of Subunits, and the binding and breaking times control
 * the assembly of Actin
 * 
 * @author Rori Rohlfs
 * @author Tiequan Zhang
 * @version 1.2
 *  
 */
public class Actin {

    //  Initial number of Subunits are set here.
    private static int numSubunits = Test.numSubunits;

    private static Simulation sim;

    private static Vector assemblies;//all assemblies in simulation

    private static int bsID = 0; //BindingSite ID

    private static int domainID = 0; //Domain ID

    private static int suID = 0; //SubunitID

    //binding and breaking rates are set here:
    //  average time for a binding event
    private double bindTime = Test.bindTime;

    //average time for a breaking event
    private double breakTime = Test.breakTime;

    //not applicable in an Actin simulation
    private double fastbindtime = Test.fastbindtime;

    //  average time for enabling binding ability
    private double bsToNoneTime = Test.bsToNoneTime;

    //  average time for disabling binding ability
    private double noneToBsTime = Test.noneToBsTime;

    //To do
    private static double[] tolerances = { 0.2, 0.1, 0.1 };

    private static Solution soln;

    private static int stID = 0; //SubunitType ID

    private double energy = 6.6;

    private static double subRadius = Test.subunitRadius;

    private static double bsHeight = Test.bindSiteHeight;

    private static HashMap bindingPartner = new HashMap();

    /**
     * Constructs an Actin Simulation.
     *  
     */
    public Actin() {
        soln = new Solution();
        initAssembly();

        double[] bindbreak1 = new double[3];
        bindbreak1[0] = bindTime;
        bindbreak1[1] = breakTime;
        bindbreak1[2] = fastbindtime;
        double[] bindbreak2 = new double[4];
        bindbreak2[0] = bindTime;
        bindbreak2[1] = breakTime;
        bindbreak2[2] = fastbindtime;

        double[] nobindbreak = new double[4];
        nobindbreak[0] = 99999999999999.0;
        nobindbreak[1] = 0.00000000000001;
        nobindbreak[2] = 99999999999999.0;

        HashMap bst1HashMap = new HashMap();
        bst1HashMap.put(new String("bsta"), nobindbreak);
        bst1HashMap.put(new String("bstb"), bindbreak1);

        HashMap bst2HashMap = new HashMap();
        bst2HashMap.put(new String("bsta"), bindbreak2);
        bst2HashMap.put(new String("bstb"), (double[]) nobindbreak.clone());

        HashMap bondtimes = new HashMap();
        bondtimes.put(new String("bsta"), bst1HashMap);
        bondtimes.put(new String("bstb"), bst2HashMap);

        HashMap bsMap = new HashMap(), noneMap = new HashMap();
        bsMap.put("none", new Double(bsToNoneTime));
        noneMap.put("bs", new Double(noneToBsTime));

        HashMap conftimes = new HashMap();
        conftimes.put("bs", bsMap);
        conftimes.put("none", noneMap);

        sim = new Simulation(soln, assemblies, 0.0, bondtimes, conftimes,
                bindingPartner);
    }

    /**
     * Returns Simulation of Actin
     * 
     * @return Simulation
     */
    public static Simulation getSim() {
        return sim;
    }

    /**
     * 
     * Creates all Subunits with appropriate bsID, domainID, ConformationID and
     * stID. Adds all Assembly to Vector Assemblies
     *  
     */
    private static void initAssembly() {
        assemblies = new Vector();

        //Creates BindingSiteType objects for BindingSite a and b

        Vector partnersa = new Vector();
        Vector partnersb = new Vector();
        partnersa.add("bstb");
        partnersb.add("bsta");
        bindingPartner.put("bsta", partnersa);
        bindingPartner.put("bstb", partnersb);

        BindingSiteType bsta = new BindingSiteType(tolerances, "bsta",
                partnersa);
        BindingSiteType bstb = new BindingSiteType(tolerances, "bstb",
                partnersb);

        Vector3d upbsa = new Vector3d(0, 0, 1);
        //Position of binding site a
        Vector3d posDa = new Vector3d(-subRadius, 0.0, 0.0);
        //Rotates binding site to point to left
        Quat4d orDa = new Quat4d(0.0, 0.0, -1.0 / Math.pow(2, 1 / 2), -1.0
                / Math.pow(2, 1 / 2));

        Vector3d upbsb = new Vector3d(0, 0, 1);
        //Position of binding site b
        Vector3d posDb = new Vector3d(subRadius, 0.0, 0.0);
        //Rotates binding site to point to right
        Quat4d orDb = new Quat4d(0.0, 0.0, 1.0 / Math.pow(2, 1 / 2), -1.0
                / Math.pow(2, 1 / 2)); //points right

        //loop for making subunittypes; bsID starts with 0;
        for (int i = 0; i < numSubunits; i++) {
            String asmname = "" + i;

            BindingSite bsa = new BindingSite(bsta, bsID++, domainID, suID,
                    asmname, posDa, orDa, upbsa);
            BindingSite bsb = new BindingSite(bstb, bsID++, domainID, suID,
                    asmname, posDb, orDb, upbsb);
            bsa.colorBlue();
            bsb.colorGreen();
            /**
             * Adds two BindingSites of one Subunit to Vector bss to create
             * Conformation
             */
            Vector bss = new Vector();
            bss.add(bsa);
            bss.add(bsb);

            Conformation bsConf = new Conformation(bss, 6.6, "bs");
            Conformation nonBsConf = new Conformation(new Vector(), 6.6, "none");

            Vector actinConfs = new Vector();
            actinConfs.add(bsConf);
            actinConfs.add(nonBsConf);

            // Domain actinDomain= new Domain("Actin_Domain", actinConfs, new
            // Vector3d(), domainID, bsConf);
            Domain actinDomain = new Domain("Actin_Domain", actinConfs,
                    new Vector3d(), domainID, bsConf);
            if (Test.csAllowed) {
                actinDomain = new Domain("Actin_Domain", actinConfs,
                        new Vector3d(), domainID, nonBsConf);
            }

            Vector actinDomains = new Vector();
            actinDomains.add(actinDomain);

            SubunitType subt = new SubunitType(actinDomains, "only", soln, 3.4,
                    0.08);

            //      subts.add(subt);

            /**
             * set initial position, rotation, velocity, and rotational velocity
             */
            Vector3d sPos = new Vector3d();
            Quat4d sRot = new Quat4d(0.0, 0.0, 0.0, 1.0);
            Vector3d sVel = new Vector3d();
            Quat4d srVel = new Quat4d(0.0, 0.0, 0.0, 1.0);

            Subunit subunit = new Subunit(subt, actinDomains, soln, suID++,
                    sPos, sRot, sVel, srVel);

            Vector asmsubs = new Vector();
            asmsubs.add(subunit);
            Assembly asm = new Assembly(asmsubs, asmname);

            assemblies.add(asm);
        }

    }

}