import javax.media.j3d.*;
import javax.vecmath.*;

import com.sun.j3d.utils.geometry.*;
import com.sun.j3d.utils.picking.PickTool;

import java.util.*;

public class TriangleData {

	private Point3d centerPoint;
	private SubunitType[] subts;
	private BranchGroup worldBG;
	private Point3d[] verticies = new Point3d[3];
	private int maxSubts = 7;
	private Sphere[][] sphereSameType = new Sphere[maxSubts][3];
	private int currentSubt = 0;
	private Vector3d[] twoFoldAxis;
	
	private Vector3d xDirection;
	private Vector3d yDirection;
	private Vector3d zDirection;
	
	public TriangleData()
	{
		centerPoint = null;
		subts = new SubunitType[maxSubts];
		worldBG = null;
		twoFoldAxis = new Vector3d[3];
	}
	
	public TriangleData(BranchGroup world)
	{
		centerPoint = null;
		subts = new SubunitType[maxSubts];
		worldBG = world;
		twoFoldAxis = new Vector3d[3];
		createSubtSpheres();
	}
	
	public TriangleData(Point3d[] thisVerticies)
	{
		verticies = thisVerticies;
		
        Point3d p1 = new Point3d(verticies[0]);
        Point3d p2 = new Point3d(verticies[1]);
        Point3d p3 = new Point3d(verticies[2]);
        
        p1.add(p2);		        
        p1.scale(0.5);

        p3.sub(p1);
        p3.scale(1.0/3.0);
        p1.add(p3);

        twoFoldAxis = new Vector3d[3];

        Vector3d twoFold = new Vector3d(verticies[0]);
        twoFold.add(verticies[1]);
        twoFold.scale(0.5);        
        twoFoldAxis[0] = twoFold;
        
        twoFold = new Vector3d(verticies[1]);
        twoFold.add(verticies[2]);
        twoFold.scale(0.5);
        twoFoldAxis[1] = twoFold;
        
        twoFold = new Vector3d(verticies[2]);
        twoFold.add(verticies[0]);
        twoFold.scale(0.5);
        twoFoldAxis[2] = twoFold;

        
		centerPoint = new Point3d(p1);
		subts = new SubunitType[maxSubts];
		worldBG = null;
		createSubtSpheres();
		setDirections();

	}
	
	private void createSubtSpheres()
	{
			    	  
		Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
		Color3f white = new Color3f(1.0f, 1.0f, 1.0f);
		Color3f grey = new Color3f (0.7f, 0.7f, 0.7f);
	  
		Appearance bluelook = new Appearance();
		Color3f objColor = new Color3f(0.0f, 0.0f, 0.8f);
		bluelook.setMaterial(new Material(objColor, black, objColor, white, 50.0f));

		objColor = new Color3f(1.0f, 0.0f, 0.0f);
		Appearance redlook = new Appearance();
		redlook.setMaterial(new Material(objColor, black, objColor, white, 50.0f));

	    Appearance greenlook = new Appearance();
	    objColor = new Color3f(0.0f, 0.8f, 0.0f);
	    greenlook.setMaterial(new Material(objColor, black, objColor, white, 50.0f));

	    Appearance purplelook = new Appearance();
	    objColor = new Color3f(1.0f, 0.0f, 1.0f);
	    purplelook.setMaterial(new Material(objColor, black, objColor, white, 50.0f));
	    
	    Appearance yellowlook = new Appearance();
	    objColor = new Color3f(1.0f, 1.0f, 0.0f);
	    yellowlook.setMaterial(new Material(objColor, black, objColor, white, 50.0f));

	    Appearance lightGreenlook = new Appearance();
	    objColor = new Color3f(0.0f, 1.0f, 1.0f);
	    lightGreenlook.setMaterial(new Material(objColor, black, objColor, white, 50.0f));

	    Appearance whitelook = new Appearance();
	    objColor = new Color3f(1.0f, 1.0f, 1.0f);
	    whitelook.setMaterial(new Material(objColor, black, objColor, white, 50.0f));

		for(int i = 0; i < maxSubts; i++)
		{
			for(int j = 0; j < 3; j++)
			{
				Sphere sp = null;;
				if(i == 0)
					sp = new Sphere(0.007f * 1.15f, bluelook);
				else if(i == 1)
					sp = new Sphere(0.007f * 1.15f, redlook);
				else if(i == 2)
					sp = new Sphere(0.007f * 1.15f, greenlook);
				else if(i == 3)
					sp = new Sphere(0.007f * 1.15f, purplelook);
				else if(i == 4)
					sp = new Sphere(0.007f * 1.15f, yellowlook);
				else if(i == 5)
					sp = new Sphere(0.007f * 1.15f, lightGreenlook);
				else if(i == 6)
					sp = new Sphere(0.007f * 1.15f, whitelook);

				
				else
				{
					System.out.println("Currently there can be only 3 subunit types");
					System.exit(-1);
				}
				
				sp.setPickable(true);
	    		Shape3D shape = sp.getShape();
	    		shape.setCapability(Shape3D.ALLOW_GEOMETRY_WRITE);
	    		shape.setCapability(Shape3D.ALLOW_APPEARANCE_OVERRIDE_WRITE);
    		  
	    		shape.setCapability(Shape3D.ALLOW_APPEARANCE_READ);
	    		shape.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
	    		shape.setCapability(Shape3D.ENABLE_PICK_REPORTING);	    		  	    		  
	    		PickTool.setCapabilities(shape, PickTool.INTERSECT_FULL);
	    		
				sphereSameType[i][j] = sp;	
			}
		}
	}
	private void setDirections()
	{
		xDirection = new Vector3d(verticies[1]);
  	  	xDirection.sub(verticies[0]);
  	  	xDirection.normalize();
  	  	
  	  	yDirection = new Vector3d(verticies[2]);
  	  	Vector3d midPoint = new Vector3d(verticies[0]);
  	  	midPoint.add(verticies[1]);
  	  	midPoint.scale(0.5);	    	  
  	  	yDirection.sub(midPoint);
  	  	yDirection.normalize();
	  
  	  	zDirection = new Vector3d(centerPoint);
  	  	zDirection.normalize();
	}
	
	public void addSubunits(double xPos, double yPos, double zPos, BranchGroup bg, int counter)
	{
		if(currentSubt < maxSubts)
		{
			subts[currentSubt] = new SubunitType();
			subts[currentSubt].setName("only"+ counter);
			
			Vector3d xDir= new Vector3d(xDirection);
			xDir.scale(xPos);

			Vector3d yDir= new Vector3d(yDirection);
			yDir.scale(yPos);

			Vector3d zDir= new Vector3d(zDirection);
			zDir.scale(zPos);

			Vector3d pos = new Vector3d(centerPoint);
			pos.add(xDir);
			pos.add(yDir);
			pos.add(zDir);
			
			subts[currentSubt].addSub(pos);
			
			TransformGroup tg = new TransformGroup();
			tg.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
			Transform3D tr = new Transform3D();
			tr.setTranslation(pos);
			tg.setTransform(tr);
			tg.addChild(sphereSameType[currentSubt][0]);
			bg.addChild(tg);
			
			Vector3d axis = new Vector3d(centerPoint);		  
			AxisAngle4d rotAxis = new AxisAngle4d(axis, 2.0 * Math.PI/3.0);
			tg = new TransformGroup();
			tg.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
			tr = new Transform3D();
			Vector3d pos2 = rotateByAxis(pos, rotAxis);
			tr.setTranslation(pos2);
			tg.setTransform(tr);
			tg.addChild(sphereSameType[currentSubt][1]);
			bg.addChild(tg);

			subts[currentSubt].addSub(pos2);
			
			tg = new TransformGroup();
			tg.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
			tr = new Transform3D();
			Vector3d pos3 = rotateByAxis(pos2, rotAxis);
			tr.setTranslation(pos3);
			tg.setTransform(tr);
			tg.addChild(sphereSameType[currentSubt][2]);
			bg.addChild(tg);
		
			subts[currentSubt].addSub(pos3);
			
			currentSubt++;
		}
		else
		{
			System.out.println("Current tool can support only "+ maxSubts +" subunit types");			
		}
	}
	
	private Vector3d rotateByAxis(Vector3d v, AxisAngle4d a) 
	{
		Matrix4d m=new Matrix4d();
	    m.set(a);
	    Vector3d rv=new Vector3d();
	    m.transform(v,rv);
	    return rv;
	}
	
	public void setVerticies(Point3d[] vert)
	{
		verticies = vert;

        Point3d p1 = new Point3d(verticies[0]);
        Point3d p2 = new Point3d(verticies[1]);
        Point3d p3 = new Point3d(verticies[2]);
        
        p1.add(p2);		        
        p1.scale(0.5);

        p3.sub(p1);
        p3.scale(1.0/3.0);
        p1.add(p3);
        
		centerPoint = new Point3d(p1);
		
        twoFoldAxis = new Vector3d[3];

        Vector3d twoFold = new Vector3d(verticies[0]);
        twoFold.add(verticies[1]);
        twoFold.scale(0.5);        
        twoFoldAxis[0] = twoFold;
        
        twoFold = new Vector3d(verticies[1]);
        twoFold.add(verticies[2]);
        twoFold.scale(0.5);
        twoFoldAxis[1] = twoFold;
        
        twoFold = new Vector3d(verticies[2]);
        twoFold.add(verticies[0]);
        twoFold.scale(0.5);
        twoFoldAxis[2] = twoFold;

        
		setDirections();

	}
	
	public Vector3d getTwoFoldAxis(int id)
	{
		return twoFoldAxis[id];
	}
	public SubunitType getSubt(int id)
	{
		return subts[id];
	}
	
	public Point3d getCenterPoint()
	{
		return centerPoint;
	}
	
	public Point3d getVertex(int id)
	{
		return verticies[id];
	}
	
	public int getMaxSubts()
	{
		return maxSubts;
	}
}
