/*
 *	@(#)IcosahedronTSA.java 1.8 02/04/01 15:03:41
 *
 * Copyright (c) 1996-2002 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Redistribution in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the
 *   distribution.
 *
 * Neither the name of Sun Microsystems, Inc. or the names of
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * This software is provided "AS IS," without a warranty of any
 * kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
 * EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
 * OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
 * FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
 * PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
 * LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
 * EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * You acknowledge that Software is not designed,licensed or intended
 * for use in the design, construction, operation or maintenance of
 * any nuclear facility.
 */

import javax.media.j3d.*;
import javax.vecmath.*;
import java.util.*;
class IcosahedronTSA extends LineArray {
  private static final int[] sVertCnt = {
    3, 11, 5, 4, 5, 4
  };

  Vector triangles;
  IcosahedronTSA() {
    super(120, GeometryArray.COORDINATES | GeometryArray.COLOR_3);//, sVertCnt);  
    
    Point3d verts[] = new Point3d[12];
    Color3f colors[] = new Color3f[12];
    double s = 1.0;
    double t2 = Math.PI/10.0;
    double t4 = Math.PI/5.0;
    double r = (s/2.0) /Math.sin(t4);
    double h = Math.cos(t4) * r;
    double cx = r * Math.cos(t2);
    double cy = r * Math.sin(t2);
    double h1 = Math.sqrt(s * s - r * r);
    double h2 = Math.sqrt( (h+r) * (h+r) - h*h );
    double z2 = (h2 - h1) / 2.0;
    double z1 = z2 + h1;
    
    
    verts[0] = new Point3d(0, 0, z1);
    verts[1] = new Point3d(0, r, z2);
    verts[2] = new Point3d(cx, cy, z2);
    verts[3] = new Point3d(s/2.0, -h, z2);
    verts[4] = new Point3d(-s/2.0, -h, z2);
    verts[5] = new Point3d(-cx, cy, z2);
    verts[6] = new Point3d(0, -r, -z2);
    verts[7] = new Point3d(-cx, -cy, -z2);
    verts[8] = new Point3d(-s/2.0, h, -z2);
    verts[9] = new Point3d(s/2.0, h, -z2);
    verts[10] = new Point3d(cx, -cy, -z2);
    verts[11] = new Point3d(0, 0, -z1);
    /*
    verts[0] = new Point3d(0.0,     1.4,      0.8652);
    verts[1] = new Point3d(0.0,     1.4,     -0.8652);
    verts[2] = new Point3d(1.4,     0.8652,    0.0);
    
    verts[3] = new Point3d(1.4,    -0.8652,    0.0);
    verts[4] = new Point3d(0.0,    -1.4,     -0.8652);
    verts[5] = new Point3d(0.0f,    -1.4,      0.8652);
    
    verts[6] = new Point3d(0.8652,   0.0,      1.4);
    verts[7] = new Point3d(-0.8652,  0.0,      1.4);
    verts[8] = new Point3d(0.8652,   0.0,     -1.4);
    verts[9] = new Point3d(-0.8652,  0.0,     -1.4);
    verts[10] = new Point3d(-1.4,   0.8652,    0.0);
    verts[11] = new Point3d(-1.4,  -0.8652,    0.0);
*/
    colors[0] = new Color3f(1.0f, 0.0f, 0.0f);
    colors[1] = new Color3f(0.0f, 1.0f, 0.0f);
    colors[2] = new Color3f(0.0f, 0.0f, 1.0f);
    colors[3] = new Color3f(1.0f, 1.0f, 0.0f);
    colors[4] = new Color3f(0.0f, 1.0f, 1.0f);
    colors[5] = new Color3f(1.0f, 0.0f, 1.0f);
    colors[6] = new Color3f(0.0f, 0.5f, 0.0f);
    colors[7] = new Color3f(0.0f, 0.0f, 0.5f);
    colors[8] = new Color3f(0.5f, 0.5f, 0.0f);
    colors[9] = new Color3f(0.0f, 0.5f, 0.5f);
    colors[10] = new Color3f(0.5f, 0.0f, 0.5f);
    colors[11] = new Color3f(0.5f, 0.5f, 0.5f);
    
    /*
    for(int i = 0; i < 12; i++)
    {
    	Vector3d v = new Vector3d(verts[i]);
    	v.scale(1.0/v.length());
    	verts[i] = new Point3d(v);
    	
    }
    */
    Point3d pnts[] = new Point3d[60];
    Color3f clrs[] = new Color3f[60];
    
    pnts[0] = verts[0];
    clrs[0] = colors[0];
    pnts[1] = verts[1];
    clrs[1] = colors[1];

    pnts[2] = verts[0];
    clrs[2] = colors[0];
    pnts[3] = verts[2];
    clrs[3] = colors[2];

    pnts[4] = verts[0];
    clrs[4] = colors[0];
    pnts[5] = verts[3];
    clrs[5] = colors[3];

    pnts[6] = verts[0];
    clrs[6] = colors[0];
    pnts[7] = verts[4];
    clrs[7] = colors[4];

    pnts[8] = verts[0];
    clrs[8] = colors[0];
    pnts[9] = verts[5];
    clrs[9] = colors[5];

    pnts[10] = verts[1];
    clrs[10] = colors[1];
    pnts[11] = verts[8];
    clrs[11] = colors[8];

    pnts[12] = verts[1];
    clrs[12] = colors[1];
    pnts[13] = verts[9];
    clrs[13] = colors[9];

    pnts[14] = verts[1];
    clrs[14] = colors[1];
    pnts[15] = verts[2];
    clrs[15] = colors[2];

    pnts[16] = verts[2];
    clrs[16] = colors[2];
    pnts[17] = verts[9];
    clrs[17] = colors[9];

    pnts[18] = verts[2];
    clrs[18] = colors[2];
    pnts[19] = verts[10];
    clrs[19] = colors[10];

    pnts[20] = verts[2];
    clrs[20] = colors[2];
    pnts[21] = verts[3];
    clrs[21] = colors[3];

    pnts[22] = verts[3];
    clrs[22] = colors[3];
    pnts[23] = verts[10];
    clrs[23] = colors[10];

    pnts[24] = verts[3];
    clrs[24] = colors[3];
    pnts[25] = verts[6];
    clrs[25] = colors[6];

    pnts[26] = verts[3];
    clrs[26] = colors[3];
    pnts[27] = verts[4];
    clrs[27] = colors[4];

    pnts[28] = verts[4];
    clrs[28] = colors[4];
    pnts[29] = verts[6];
    clrs[29] = colors[6];

    pnts[30] = verts[4];
    clrs[30] = colors[4];
    pnts[31] = verts[7];
    clrs[31] = colors[7];

    pnts[32] = verts[4];
    clrs[32] = colors[4];
    pnts[33] = verts[5];
    clrs[33] = colors[5];

    pnts[34] = verts[5];
    clrs[34] = colors[5];
    pnts[35] = verts[7];
    clrs[35] = colors[7];

    pnts[36] = verts[5];
    clrs[36] = colors[5];
    pnts[37] = verts[8];
    clrs[37] = colors[8];

    pnts[38] = verts[5];
    clrs[38] = colors[5];
    pnts[39] = verts[1];
    clrs[39] = colors[1];

    pnts[40] = verts[11];
    clrs[40] = colors[11];
    pnts[41] = verts[6];
    clrs[41] = colors[6];

    pnts[42] = verts[11];
    clrs[42] = colors[11];
    pnts[43] = verts[7];
    clrs[43] = colors[7];

    pnts[44] = verts[11];
    clrs[44] = colors[11];
    pnts[45] = verts[8];
    clrs[45] = colors[8];

    pnts[46] = verts[11];
    clrs[46] = colors[11];
    pnts[47] = verts[9];
    clrs[47] = colors[9];

    pnts[48] = verts[11];
    clrs[48] = colors[11];
    pnts[49] = verts[10];
    clrs[49] = colors[10];

    pnts[50] = verts[6];
    clrs[50] = colors[6];
    pnts[51] = verts[7];
    clrs[51] = colors[7];

    pnts[52] = verts[7];
    clrs[52] = colors[7];
    pnts[53] = verts[8];
    clrs[53] = colors[8];

    pnts[54] = verts[8];
    clrs[54] = colors[8];
    pnts[55] = verts[9];
    clrs[55] = colors[9];

    pnts[56] = verts[9];
    clrs[56] = colors[9];
    pnts[57] = verts[10];
    clrs[57] = colors[10];

    pnts[58] = verts[10];
    clrs[58] = colors[10];
    pnts[59] = verts[6];
    clrs[59] = colors[6];

    setCoordinates(0, pnts);
    setColors(0, clrs);
  

    triangles = new Vector();
    Point3d[] triangle  = new Point3d[3];
    triangle[0] = verts[0];
    triangle[1] = verts[1];
    triangle[2] = verts[2];    
    triangles.add(triangle);
    
    triangle  = new Point3d[3];
    triangle[0] = verts[0];
    triangle[1] = verts[2];
    triangle[2] = verts[3];    
    triangles.add(triangle);

    triangle  = new Point3d[3];
    triangle[0] = verts[0];
    triangle[1] = verts[3];
    triangle[2] = verts[4];    
    triangles.add(triangle);

    triangle  = new Point3d[3];
    triangle[0] = verts[0];
    triangle[1] = verts[4];
    triangle[2] = verts[5];    
    triangles.add(triangle);

    triangle  = new Point3d[3];
    triangle[0] = verts[0];
    triangle[1] = verts[5];
    triangle[2] = verts[1];    
    triangles.add(triangle);

    triangle  = new Point3d[3];
    triangle[0] = verts[1];
    triangle[1] = verts[8];
    triangle[2] = verts[9];    
    triangles.add(triangle);

    triangle  = new Point3d[3];
    triangle[0] = verts[2];
    triangle[1] = verts[9];
    triangle[2] = verts[10];    
    triangles.add(triangle);

    /*****************/
    triangle  = new Point3d[3];
    triangle[0] = verts[3];
    triangle[1] = verts[10];
    triangle[2] = verts[6];    
    triangles.add(triangle);

    triangle  = new Point3d[3];
    triangle[0] = verts[4];
    triangle[1] = verts[6];
    triangle[2] = verts[7];    
    triangles.add(triangle);

    triangle  = new Point3d[3];
    triangle[0] = verts[5];
    triangle[1] = verts[7];
    triangle[2] = verts[8];    
    triangles.add(triangle);

    triangle  = new Point3d[3];
    triangle[1] = verts[6];
    triangle[0] = verts[3];
    triangle[2] = verts[4];    
    triangles.add(triangle);

    triangle  = new Point3d[3];
    triangle[1] = verts[7];
    triangle[0] = verts[4];
    triangle[2] = verts[5];    
    triangles.add(triangle);

    triangle  = new Point3d[3];
    triangle[1] = verts[8];
    triangle[0] = verts[5];
    triangle[2] = verts[1];    
    triangles.add(triangle);

    /****************************/
    
    triangle  = new Point3d[3];
    triangle[1] = verts[9];
    triangle[0] = verts[1];
    triangle[2] = verts[2];    
    triangles.add(triangle);

    triangle  = new Point3d[3];
    triangle[1] = verts[10];
    triangle[0] = verts[2];
    triangle[2] = verts[3];    
    triangles.add(triangle);

    triangle  = new Point3d[3];
    triangle[1] = verts[11];
    triangle[0] = verts[6];
    triangle[2] = verts[7];    
    triangles.add(triangle);

    triangle  = new Point3d[3];
    triangle[1] = verts[11];
    triangle[0] = verts[7];
    triangle[2] = verts[8];    
    triangles.add(triangle);

    triangle  = new Point3d[3];
    triangle[1] = verts[11];
    triangle[0] = verts[8];
    triangle[2] = verts[9];    
    triangles.add(triangle);

    triangle  = new Point3d[3];
    triangle[1] = verts[11];
    triangle[0] = verts[9];
    triangle[2] = verts[10];    
    triangles.add(triangle);

    triangle  = new Point3d[3];
    triangle[1] = verts[11];
    triangle[0] = verts[10];
    triangle[2] = verts[6];    
    triangles.add(triangle);
  }
  
}
