import javax.vecmath.*;

public class BindingSiteType {

	private Vector3d pos;
	private Vector3d orientation;
	private String name;
	private String partnerName;
	private Subunit primarySubunit;
	private Subunit connectSubunit;
	private double length;
	
	public BindingSiteType()
	{
		pos = null;
		orientation = null;
		name = null;
		partnerName = null;
	}
	
	public void setPos(Tuple3d bspos)
	{
		pos = new Vector3d(bspos);
	}
	
	public void setName(String bsName)
	{
		name = bsName;
	}
	
	public void setPartnerName(String partName)
	{
		partnerName = partName;
	}
	
	public Vector3d getPos()
	{
		return pos;
	}
	
	public String getName()
	{
		return name;
	}
	
	public String getPartnerName()
	{
		return partnerName;
	}
	
	public void setPrimaryReference(Subunit prim)
	{
		primarySubunit = prim;
	}
	
	public void setConnectReference(Subunit connect)
	{
		connectSubunit = connect;
	}
	
	public Subunit getPrimaryReference()
	{
		return primarySubunit;
	}
	
	public Subunit getConnectReferece()
	{
		return connectSubunit;
	}
	
	public void setLength(double myLength)
	{
		length = myLength;
	}
	
	public double getLength()
	{
		return length;
	}
}
