
import java.applet.Applet;
import javax.swing.*;
import java.util.Random;
import java.util.*;

/**
 * Test class starts self-simulation simulation and lists important parameters.
 * 
 * @author Rori Rohlfs
 * @author Tiequan Zhang
 * @author Blake Sweeney
 * @version 1.2
 */
public class Test extends Applet {
    static Random rand;

    //  actin,tubulin,tetrahedron,cube or virus
    static String simChoice = "virus";

    //Kinetics parameters
    static int numSubunits = 10;

    //Number of steps run in a simulation
    static int iterations_per_run = 100;

    static int maxLength = 100000;

    static double bindTime = 1; //average time for a binding event

    static double breakTime = 0.1; //average time for a breaking event

    static double bindTimeC = 100;//average time for binding pentamer and

    // pentamer in virus assembly

    static double breakTimeC = 100;//average time for breaking bond between

    // pentamer and pentamer in virus assembly

    //  average time for a binging event when unbinding breaks a loop
    //not in use right now
    static double fastbindtime = 1e-10;

    //  The conformational switching is allowed in this simulation
    static boolean csAllowed = false;

    //Conformation switching rate
    static double bsToNoneTime = 1.0;

    static double noneToBsTime = 1.0;

    //Allow multimers bind with monomers only
    static boolean bindMonomerOnly = false;

    //  For filament assembly, allow mutlimers break off only monomer
    static boolean breakOnlyEnds = false;

    //not in use
    static int events_per_printout = 2000;

    //For virus,tetrahedron,cube assembly, when an FormbondEvent is processed
    // and other possible bindings could occur, those new formed bonds will
    // become pink-colored
    static boolean displayFastBinding = false;

    //Show the box on the border of the simulation panel
    static boolean showBorder = true;

    //simulator panel background color option, for better print
    static boolean grey = false;

    static boolean stepPrint = true;

    static boolean displaySim = true;

    static double binSize = 0.05 * 0.1;

    static double tipScale = 0.13 / 0.08;

    static double distanceTolerance = 0.005;

    static double subunitRadius = 0.08;

    static float bindSiteHeight = 0.10f;

    //Default debugging level
    static int debuggingLevel = 1000;

    /**
     * main method to start the simulator
     */
    public static void main(String args[]) {

        /**
         * If user doesn't specify any parameter , program will not give any
         * debugging information by default. The larger the debuggingLevel is ,
         * the less important the debugging information will be. DebuggingLevel
         * will be used in Debug.java
         */
        // rand.setSeed((long) 10);
        if (args.length != 0) {
            debuggingLevel = Integer.parseInt(args[0]);

        }

        LoadDialog load = new LoadDialog();
    }
}