
import java.util.Vector;

/**
 * BindingSiteType hold information that is common to every BindingSite of a
 * certain type (compatibility with other BindingSites and tolerences).
 * 
 * @author Rori Rohlfs
 * @version 1.2
 *  
 */
public class BindingSiteType {
    //in the order of distance, angle, torsional rotation
    //NOTE: tolerances are not used at this time, but will be later
    private double[] tolerances = new double[3];

    //Conformation id in which this BindingSiteType exists
    private String myconfname;

    private String myname;

    //Vector of String which represents names of compatible BindingSiteTypes
    private Vector mypartners;

    /**
     * Constructs a BindingSiteType using default parameters, sets tolerance to
     * 0, ID and Conformation ID to -1.
     */
    public BindingSiteType() {
        tolerances[0] = 0.0;
        tolerances[1] = 0.0;
        tolerances[2] = 0.0;
        myconfname = new String();
        myname = new String();
        mypartners = new Vector();
    }

    /**
     * Constructs a BindingSiteType with the given tolerances, id, name, and
     * compatible partners. Sets Conformation ID to -1.
     * 
     * @param t
     *            array of 3 doubles as the tolerences
     * @param n
     *            String the name BindingSiteType
     * @param p
     *            Vector of String, the names of compatible BindingSiteTypes
     */
    public BindingSiteType(double[] t, String n, Vector p) {

        for (int j = 0; j < 3; j++) {
            tolerances[j] = t[j];
        }
        myconfname = new String();
        myname = n;
        mypartners = p;
    }

    /**
     * Checks whether this BindingSiteType is compatible with the specified
     * BindingSiteType bst
     * 
     * @param bst
     *            BindingSiteType, which is checked for compatibility
     * @return boolean, true if compatible, otherwise false
     */
    public boolean isCompat(BindingSiteType bst) {

        /**
         * by Tiequan: replace old version return
         * mypartners.contains(bst.getName());
         *  
         */

        for (int i = 0; i < mypartners.size(); i++) {
            if (((String) mypartners.elementAt(i)).equals(bst.getName()))
                return true;
        }
        return false;
    }

    /**
     * Sets this BindingSiteType's Conformation name
     * 
     * @param cname
     *            String, the new conformation name
     */
    public void setConf(String cname) {
        myconfname = cname;
    }

    /**
     * Gets the vector of names of compatible BindingSiteTypes (Strings)
     * 
     * @return Vector of Strings, names of compatible BindingSiteTypes
     */
    public Vector getPartners() {
        return mypartners;
    }

    /**
     * Adds the name of a new BindingSiteType to the list of compatible
     * BindingSiteTypes
     * 
     * @param pn
     *            String the name of a BindingSiteType to add
     */
    public void addPartner(String pn) {
        mypartners.add(pn);
    }

    /**
     * Returns name of this BindingSiteType
     * 
     * @return String
     */
    public String getName() {
        return myname;
    }

    /**
     * Returns a String version of this BindingSiteType
     * 
     * @return String
     */
    public String toString() {
        String mystring = new String("BindingSiteType Name: " + myname
                + "\nBindingSiteType Tolerances: " + "\n\tdistance: "
                + tolerances[0] + "\n\tangle: " + tolerances[1]
                + "\n\trotation: " + tolerances[2]
                + "\nCompatable BindingSiteTypes: ");
        for (int i = 0; i < mypartners.size(); i++)
            mystring = mystring + mypartners.elementAt(i) + " ";

        return mystring;
    }

}